/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileStorageWrapper;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileContentMerger;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IMetadataChangeTracker;
import com.ibm.team.filesystem.client.internal.LocalFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.RestoreVersionableOperation;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreManager;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.load.LocalFileSystemUpdateMutator;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.NoOpChange;
import com.ibm.team.filesystem.client.internal.magic.LocalContentExaminer;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharingManager
implements ISharingManager {
    public static final int NONE = 0;
    public static final int OVERWRITE = 1;
    public static final int UPDATE = 2;
    public static final int LOAD_CHANGES = 4;
    private static final ThreadLocal changeMonitoring = new ThreadLocal(){

        protected Object initialValue() {
            return new Integer(0);
        }
    };
    protected static volatile SharingManager instance;
    public static final String PT_SHARING_MANAGER = "sharingManager";
    public static final String PT_CONTENT_EXAMINER = "contentExaminer";
    private IContentExaminer contentExaminer;

    private static SharingManager doGetInstance() {
        IConfigurationElement[] configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client", PT_SHARING_MANAGER);
        if (configs.length > 1) {
            throw new IllegalStateException("Only one sharing manager implementation can be registered");
        }
        if (configs.length == 1) {
            try {
                return (SharingManager)configs[0].createExecutableExtension("class");
            }
            catch (CoreException e) {
                LoggingHelper.log(e);
            }
        }
        return new SharingManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SharingManager getInstance() {
        SharingManager sm = instance;
        if (sm != null) return sm;
        Class<SharingManager> clazz = SharingManager.class;
        synchronized (SharingManager.class) {
            sm = instance;
            if (sm != null) return sm;
            instance = sm = SharingManager.doGetInstance();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sm;
        }
    }

    protected SharingManager() {
    }

    @Override
    public void addListener(ICopyFileAreaListener listener) {
        ICopyFileAreaManager.instance.addListener(listener);
    }

    @Override
    public void removeListener(ICopyFileAreaListener listener) {
        ICopyFileAreaManager.instance.removeListener(listener);
    }

    public FileSystemOperation getLoadMutator(int options, IConnection connection, IComponent component, ISandbox sandbox, List<LoadLocation> itemsToLoad, LoadTree loadTree, LoadDilemmaHandler loadProblemHandler, IDownloadListener downloadMonitor) {
        return new MergeLoadMutator(connection, component, sandbox, itemsToLoad, loadTree, loadProblemHandler, downloadMonitor);
    }

    public IShare[] allShares(IPath copyFileAreaRoot, IProgressMonitor monitor) throws FileSystemClientException {
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (cfaMgr.copyFileAreaExists(copyFileAreaRoot, 1)) {
            AbstractLock lock = CFALockUtil.createAndLockForReading(copyFileAreaRoot, true, (IProgressMonitor)progress.newChild(1));
            try {
                Collection<IShare> shares = cfaMgr.getExistingCopyFileArea(copyFileAreaRoot).allShares();
                IShare[] iShareArray = shares.toArray(new IShare[shares.size()]);
                return iShareArray;
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                progress.done();
            }
        }
        progress.done();
        return new IShare[0];
    }

    @Override
    public IShare[] allShares(IProgressMonitor monitor) throws FileSystemClientException {
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        Collection<ICopyFileArea> copyFileAreas = cfaMgr.getAllCopyFileAreas();
        ArrayList<IShare> shares = new ArrayList<IShare>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            SubMonitor subProgress = progress.newChild(1);
            subProgress.setWorkRemaining(2);
            AbstractLock lock = CFALockUtil.lockExistingForRead(cfa.getRoot(), (IProgressMonitor)subProgress.newChild(1));
            if (lock == null) continue;
            try {
                shares.addAll(ICopyFileAreaManager.instance.getExistingCopyFileArea(cfa.getRoot()).allShares());
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)subProgress.newChild(1));
            }
        }
        return shares.toArray(new IShare[shares.size()]);
    }

    public IShare[] allShares(IPath copyFileAreaRoot, IContextHandle context, IComponentHandle component, IProgressMonitor monitor) throws FileSystemClientException {
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (cfaMgr.copyFileAreaExists(copyFileAreaRoot, 1)) {
            AbstractLock lock = CFALockUtil.createAndLockForReading(copyFileAreaRoot, true, (IProgressMonitor)progress.newChild(1));
            try {
                Collection<IShare> shares = cfaMgr.getExistingCopyFileArea(copyFileAreaRoot).allShares(context, component, (IProgressMonitor)progress.newChild(98));
                IShare[] iShareArray = shares.toArray(new IShare[shares.size()]);
                return iShareArray;
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                progress.done();
            }
        }
        progress.done();
        return new IShare[0];
    }

    public Shareable findShareable(ISandbox sandbox, IPath path, ResourceType resourceTypeHint) {
        return new Shareable(sandbox, path, resourceTypeHint);
    }

    public IShareable findShareable(IPath copyFileAreaRoot, IContextHandle connection, IComponentHandle component, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemClientException {
        if (versionable == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (copyFileAreaRoot == null) {
            throw new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (cfaMgr.copyFileAreaExists(copyFileAreaRoot, 1)) {
            AbstractLock lock = CFALockUtil.createAndLockForUpdate(copyFileAreaRoot, connection, component, (IProgressMonitor)progress.newChild(1));
            try {
                ICopyFileArea cfa = cfaMgr.getExistingCopyFileArea(copyFileAreaRoot);
                IPath path = cfa.getLocalPathFor(connection, component, versionable, (IProgressMonitor)progress.newChild(98));
                if (path != null) {
                    Shareable shareable = new Shareable(copyFileAreaRoot, path, ResourceType.getResourceType(versionable));
                    return shareable;
                }
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
                progress.done();
            }
        }
        progress.done();
        return null;
    }

    @Override
    public Collection<IShareable> findShareables(IContextHandle connection, IComponentHandle component, IVersionableHandle versionable, IProgressMonitor progress) throws FileSystemClientException {
        if (versionable == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        ArrayList<IShareable> result = new ArrayList<IShareable>();
        Collection<ICopyFileArea> allCopyFileAreas = ICopyFileAreaManager.instance.getAllCopyFileAreas();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)allCopyFileAreas.size());
        for (ICopyFileArea cfa : allCopyFileAreas) {
            SubMonitor subProgress = monitor.newChild(1);
            subProgress.setWorkRemaining(100);
            AbstractLock lock = CFALockUtil.lockExistingForUpdate(cfa.getRoot(), connection, component, (IProgressMonitor)subProgress.newChild(1));
            if (lock == null) continue;
            try {
                cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfa.getRoot());
                IPath path = cfa.getLocalPathFor(connection, component, versionable, (IProgressMonitor)subProgress.newChild(98));
                if (path == null) continue;
                result.add(new Shareable(cfa.getRoot(), path, ResourceType.getResourceType(versionable)));
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)subProgress.newChild(1));
            }
        }
        return result;
    }

    @Override
    public IShareable findShareable(IPath fullPath, ResourceType resourceTypeHint) {
        if (!fullPath.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute");
        }
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getCopyFileAreaForPath(fullPath);
        if (cfa != null) {
            IPath cfaPath = cfa.getRoot();
            IPath relativePath = fullPath.removeFirstSegments(cfaPath.segmentCount()).setDevice(null).makeUNC(false).makeAbsolute();
            return new Shareable(cfaPath, relativePath, resourceTypeHint);
        }
        return null;
    }

    public IShare getShare(IPath cfaRoot, IPath path, IProgressMonitor monitor) throws FileSystemClientException {
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForRead(cfaRoot, (IProgressMonitor)progress.newChild(1));
        if (lock == null) {
            progress.done();
            return null;
        }
        try {
            ICopyFileArea cfa = cfaMgr.getExistingCopyFileArea(cfaRoot);
            IShare result = cfa.getShare(path);
            progress.worked(98);
            IShare iShare = result;
            return iShare;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public IShare share(Shareable shareable, ISharingDescriptor descriptor, FileItemInfo fileItemInfo, int options, IProgressMonitor monitor) throws FileSystemClientException {
        IFileStorage fileStorage;
        boolean caseSensitive;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IPath sharePath = shareable.getLocalPath();
        if (!descriptor.getRootVersionable().hasStateId()) {
            throw new IllegalArgumentException(sharePath + " cannot be shared. Root has no state id");
        }
        int cfaOptions = 0;
        if ((options & 1) == 1) {
            cfaOptions |= 1;
        } else if ((options & 2) == 2) {
            cfaOptions |= 2;
        }
        IPath cfaRoot = shareable.getCopyFileAreaRoot();
        AbstractLock lock = CFALockUtil.createAndLockForReading(cfaRoot, true, (IProgressMonitor)progress.newChild(1));
        try {
            ICopyFileArea copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
            cfaRoot = copyFileArea.getRoot();
            copyFileArea.share(shareable.getLocalPath(), descriptor, fileItemInfo, cfaOptions, (IProgressMonitor)progress.newChild(13));
            caseSensitive = copyFileArea.isCaseSensitive();
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
        }
        Share share = new Share(cfaRoot, sharePath, caseSensitive, descriptor);
        if ((options & 4) == 4 && this.isChangeMonitoringEnabled()) {
            LocalChangeManager.getInstance().loadChanges(share, (IProgressMonitor)progress.newChild(70));
        }
        if ((fileStorage = shareable.getFileStorage()) != null) {
            fileStorage.registerRepositorProvider((IProgressMonitor)progress.newChild(15));
        }
        progress.done();
        return share;
    }

    protected void shutDown() throws FileSystemClientException {
    }

    public static void conditionalShutDown() throws FileSystemClientException {
        SharingManager sm = instance;
        if (sm != null) {
            sm.shutDown();
        }
    }

    public void forget(Shareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        boolean unshare;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.createAndLockForUpdate(shareable.getCopyFileAreaRoot(), shareable.getLocalPath(), true, (IProgressMonitor)progress.newChild(1));
        if (lock == null) {
            return;
        }
        try {
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getCopyFileAreaRoot());
            unshare = cfa.forget(shareable.getLocalPath(), (IProgressMonitor)progress.newChild(74));
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
        }
        if (unshare) {
            IFileStorage fileStorage = shareable.getFileStorage();
            fileStorage.deregisterRepositoryProvider((IProgressMonitor)progress.newChild(25));
        }
        progress.done();
    }

    public boolean isConnectionShared(IPath copyFileAreaRoot, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForRead(copyFileAreaRoot, (IProgressMonitor)progress.newChild(1));
        if (lock == null) {
            progress.done();
            return false;
        }
        try {
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(copyFileAreaRoot);
            boolean result = cfa.isConnectionShared(connection);
            progress.worked(98);
            boolean bl = result;
            return bl;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public ITeamRepository getRepository(IShare share) {
        ISharingDescriptor desc = share.getSharingDescriptor();
        return RepositoryUtils.getTeamRepository(desc.getRepositoryUri(), desc.getRepositoryId());
    }

    public void disableChangeMonitoring() {
        changeMonitoring.set(new Integer((Integer)changeMonitoring.get() + 1));
    }

    public void enableChangeMonitoring() {
        int level = (Integer)changeMonitoring.get();
        if (level == 0) {
            throw new IllegalStateException();
        }
        changeMonitoring.set(new Integer(level - 1));
    }

    public boolean isChangeMonitoringEnabled() {
        return (Integer)changeMonitoring.get() == 0;
    }

    IMetadataChangeTracker getChangeTracker(CopyFileArea cfa) {
        return (IMetadataChangeTracker)((Object)cfa.internalGetMetadata());
    }

    @Override
    public ILocalChangeManager getLocalChangeManager() {
        return LocalChangeManager.getInstance();
    }

    public ILocalChange getChange(Shareable shareable, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        if (shareable.shouldBeIgnored((IProgressMonitor)monitor.newChild(1))) {
            monitor.done();
            return null;
        }
        ILocalChange pendingChange = LocalChangeManager.getInstance().getPendingChange(shareable, (IProgressMonitor)monitor.newChild(1));
        return pendingChange == null ? NoOpChange.NO_OP : pendingChange;
    }

    public final void doSilentChange(CoreRunnable runnable) throws CoreException {
        SharingManager.getInstance().disableChangeMonitoring();
        try {
            runnable.run();
        }
        finally {
            SharingManager.getInstance().enableChangeMonitoring();
        }
    }

    @Override
    public Collection<IShareable> findShareables(IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemClientException {
        if (versionable == null) {
            throw new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        ArrayList<IShareable> shareables = new ArrayList<IShareable>();
        Collection<ICopyFileArea> copyFileAreas = ICopyFileAreaManager.instance.getAllCopyFileAreas();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            SubMonitor subProgress = progress.newChild(1);
            subProgress.setWorkRemaining(100);
            AbstractLock lock = CFALockUtil.lockExistingForGlobalUpdate(cfa.getRoot(), (IProgressMonitor)subProgress.newChild(1));
            if (lock == null) continue;
            try {
                cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfa.getRoot());
                Collection<IPath> paths = cfa.getLocalPathsFor(versionable, (IProgressMonitor)progress.newChild(97));
                shareables.addAll(this.getShareablesForPaths(cfa.getRoot(), paths, versionable, (IProgressMonitor)progress.newChild(1)));
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)subProgress.newChild(1));
            }
        }
        progress.done();
        return shareables;
    }

    @Override
    public Collection<IShareable> findShareables(IComponentHandle component, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemClientException {
        if (versionable == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        ThreadCheck.checkLongOpsAllowed();
        ArrayList<IShareable> shareables = new ArrayList<IShareable>();
        Collection<ICopyFileArea> copyFileAreas = ICopyFileAreaManager.instance.getAllCopyFileAreas();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)copyFileAreas.size());
        for (ICopyFileArea cfa : copyFileAreas) {
            SubMonitor subProgress = progress.newChild(1);
            subProgress.setWorkRemaining(100);
            AbstractLock lock = CFALockUtil.lockExistingForGlobalUpdate(cfa.getRoot(), (IProgressMonitor)subProgress.newChild(1));
            if (lock == null) continue;
            try {
                cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfa.getRoot());
                Collection<IPath> paths = cfa.getLocalPathsFor(component, versionable, (IProgressMonitor)subProgress.newChild(97));
                shareables.addAll(this.getShareablesForPaths(cfa.getRoot(), paths, versionable, (IProgressMonitor)progress.newChild(1)));
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)subProgress.newChild(1));
            }
        }
        progress.done();
        return shareables;
    }

    protected List getShareablesForPaths(IPath copyFileAreaRoot, Collection<IPath> paths, IVersionableHandle item, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)paths.size());
        ArrayList<Shareable> shareables = new ArrayList<Shareable>(paths.size());
        copyFileAreaRoot.toFile();
        ResourceType type = ResourceType.getResourceType(item);
        for (IPath path : paths) {
            Shareable shareable = new Shareable(copyFileAreaRoot, path, type);
            IFileStorage storage = shareable.getFileStorage();
            if (storage.getResourceType((IProgressMonitor)progress.newChild(1)) != type) continue;
            shareables.add(shareable);
        }
        return shareables;
    }

    public UpdateMutator getUpdateMutator(IConnection connection, Collection<IComponentStateSummary> componentStatesBefore, Collection<IComponentStateSummary> componentStatesAfter, FileAreaUpdateReport updates, Collection<ICopyFileArea> copyFileAreasToUpdate, UpdateDilemmaHandler dilemmaHandler, IDownloadListener downloadMonitor) {
        return new LocalFileSystemUpdateMutator(connection, componentStatesBefore, componentStatesAfter, updates, copyFileAreasToUpdate, dilemmaHandler, downloadMonitor);
    }

    public IIgnoreManager getIgnoreManager() {
        return IgnoreManager.getInstance();
    }

    public void addListener(ICorruptCopyFileAreaListener listener) {
        ICopyFileAreaManager.instance.addCorruptionListener(listener);
    }

    public void removeListener(ICorruptCopyFileAreaListener listener) {
        ICopyFileAreaManager.instance.removeCorruptionListener(listener);
    }

    public List<IShareable> getRootShareables(IPath copyFileAreaRoot, IProgressMonitor progress) throws FileSystemClientException {
        File rootFile = copyFileAreaRoot.toFile();
        File[] children = rootFile.listFiles();
        if (children == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IShareable> shareables = new ArrayList<IShareable>();
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            shareables.add(new Shareable(copyFileAreaRoot, (IPath)new Path(child.getName()), PathUtils.getResourceType((IPath)new Path(child.getAbsolutePath()), progress)));
            ++n2;
        }
        return shareables;
    }

    public ISchedulingRule getTrackingRule(IPath path) {
        return null;
    }

    public void runWithinFileSystemLock(IRunnableWithProgress runnableWithProgress, ISchedulingRule IDErule, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        runnableWithProgress.run(monitor);
    }

    public List<IPath> getPathRelativeToShares(IPath copyFileAreaRoot, IContextHandle context, IComponentHandle component, List<List<INameItemPair>> ancestorReports, IProgressMonitor progress) throws FileSystemClientException {
        Collection<IShare> shares;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ArrayList<IPath> result = new ArrayList<IPath>(ancestorReports.size());
        AbstractLock lock = CFALockUtil.lockExistingForRead(copyFileAreaRoot, (IProgressMonitor)monitor.newChild(1));
        if (lock == null) {
            monitor.done();
            Iterator<List<INameItemPair>> iterator = ancestorReports.iterator();
            while (iterator.hasNext()) {
                iterator.next();
                result.add(null);
            }
            return result;
        }
        try {
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(copyFileAreaRoot);
            shares = cfa.allShares();
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)monitor.newChild(1));
        }
        HashMap<UUID, IPath> shareRoots = new HashMap<UUID, IPath>();
        for (IShare iShare : shares) {
            ISharingDescriptor descriptor = iShare.getSharingDescriptor();
            if (!descriptor.getConnectionHandle().sameItemId((IItemHandle)context) || !descriptor.getComponent().sameItemId((IItemHandle)component)) continue;
            IPath sharePath = iShare.getPath();
            shareRoots.put(descriptor.getRootVersionable().getItemId(), sharePath);
        }
        for (List list : ancestorReports) {
            boolean shareRootFound = false;
            IPath path = null;
            if (!shareRoots.isEmpty()) {
                for (INameItemPair pair : list) {
                    if (shareRootFound) {
                        path = path.append(pair.getName());
                        continue;
                    }
                    IPath sharePath = (IPath)shareRoots.get(pair.getItem().getItemId());
                    if (sharePath == null) continue;
                    shareRootFound = true;
                    path = sharePath;
                }
            }
            result.add(path);
        }
        monitor.done();
        return result;
    }

    @Override
    public void restoreFile(IShareable file, InputStream in, IVersionableHandle handle, IProgressMonitor monitor) throws FileSystemClientException, IOException {
        RestoreVersionableOperation.restoreFile(file, in, handle, monitor);
    }

    @Override
    public void restoreFolder(IShareable folder, IFolderHandle handle, IProgressMonitor monitor) throws FileSystemClientException {
        RestoreVersionableOperation.restoreFolder(folder, handle, monitor);
    }

    @Override
    public void restoreLink(IShareable shareable, String target, ISymbolicLinkHandle handle, IProgressMonitor monitor) throws FileSystemClientException {
        RestoreVersionableOperation.restoreLink(shareable, target, handle, monitor);
    }

    public IPath getIDEWorkAreaRoot() {
        return null;
    }

    @Override
    public Collection<ISandbox> getRegisteredSandboxes() {
        Collection<ICopyFileArea> allCFA = ICopyFileAreaManager.instance.getAllCopyFileAreas();
        ArrayList<ISandbox> result = new ArrayList<ISandbox>(allCFA.size());
        for (ICopyFileArea cfa : allCFA) {
            result.add(new Sandbox(cfa));
        }
        return result;
    }

    @Override
    public boolean isConnectionShared(IContextHandle connection) throws FileSystemClientException {
        return ICopyFileAreaManager.instance.isConnectionShared(connection);
    }

    public boolean isConfigurationShared(ISandbox sandbox, ConfigurationDescriptor configuration, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForRead(sandbox.getRoot(), (IProgressMonitor)progress.newChild(1));
        if (lock == null) {
            return false;
        }
        try {
            ICopyFileArea copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(sandbox.getRoot());
            boolean bl = copyFileArea.isConfigurationShared(configuration.connectionHandle, configuration.componentHandle, (IProgressMonitor)progress.newChild(98));
            return bl;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
        }
    }

    public void resolveFileStorage(FileStorageWrapper storage, ResourceType resourceTypeHint) {
        this.resolveLocalFileStorage(storage, resourceTypeHint);
    }

    public void resolveLocalFileStorage(FileStorageWrapper storage, ResourceType type) {
        storage.setUnderlyingStorage(new LocalFileStorage(storage));
    }

    public final IFileStorage getLocalFileStorage(ISandbox sandbox, IPath localPath, ResourceType resourceTypeHint) {
        Shareable shareable = new Shareable(sandbox, localPath, resourceTypeHint);
        IFileStorage storage = shareable.getFileStorage();
        LocalFileStorage localFileStorage = new LocalFileStorage(shareable.getFileStorage());
        ((FileStorageWrapper)storage).setUnderlyingStorage(localFileStorage);
        return storage;
    }

    public void forget(IPath copyFileAreaRoot, IContextHandle connectionHandle, IComponentHandle component, IVersionableHandle item, IProgressMonitor progress) throws FileSystemClientException {
        IFileStorage fileStorage;
        boolean unshared;
        IShareable shareable;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        AbstractLock lock = CFALockUtil.createAndLockForUpdate(copyFileAreaRoot, connectionHandle, component, (IProgressMonitor)monitor.newChild(1));
        try {
            ICopyFileArea copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(copyFileAreaRoot);
            shareable = this.findShareable(copyFileAreaRoot, connectionHandle, component, item, (IProgressMonitor)monitor.newChild(93));
            unshared = copyFileArea.forget(connectionHandle, component, item, (IProgressMonitor)monitor);
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)monitor.newChild(1));
        }
        if (unshared & shareable != null && (fileStorage = ((Shareable)shareable).getFileStorage()) != null) {
            fileStorage.deregisterRepositoryProvider((IProgressMonitor)monitor.newChild(5));
        }
    }

    @Override
    public int getNumShares(IContextHandle workspace, IComponentHandle component, IProgressMonitor progress) throws FileSystemClientException {
        return ICopyFileAreaManager.instance.getNumShares(workspace, component, progress);
    }

    @Override
    public ISandbox getSandbox(IPath copyFileAreaRoot, boolean registered) {
        if (registered && !ICopyFileAreaManager.instance.copyFileAreaExists(copyFileAreaRoot, 0)) {
            return null;
        }
        return new Sandbox(copyFileAreaRoot);
    }

    @Override
    public Collection<ISandbox> getSandboxes(ConfigurationDescriptor configuration, IProgressMonitor monitor) throws FileSystemClientException {
        ArrayList<ISandbox> result = new ArrayList<ISandbox>();
        Collection<ICopyFileArea> copyFileAreas = ICopyFileAreaManager.instance.getCopyFileAreasForConfiguration(configuration, monitor);
        for (ICopyFileArea cfa : copyFileAreas) {
            result.add(new Sandbox(cfa));
        }
        return result;
    }

    @Override
    public void register(ISandbox sandbox, boolean mustExist, IProgressMonitor monitor) throws FileSystemClientException {
        IPath root = sandbox.getRoot();
        if (mustExist && !ICopyFileAreaManager.instance.copyFileAreaExists(root, 1)) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, 210, NLS.bind((String)Messages.SharingManager_InvalidSandbox, (Object)root.toOSString(), (Object[])new Object[0]), null));
        }
        ICopyFileAreaManager.instance.createCopyFileArea(root, monitor);
    }

    @Override
    public void deregister(ISandbox sandbox, IProgressMonitor monitor) throws FileSystemClientException {
        ICopyFileAreaManager.instance.deregister(sandbox.getRoot(), false, monitor);
    }

    @Override
    public ISchedulingRule makeSchedulingRuleForIDE(Collection<IShareable> shareables) {
        return null;
    }

    @Override
    public ISchedulingRule makeSchedulingRuleForIDE(Collection<IShareable> shareables, ISharingManager.RuleKind kind) {
        return null;
    }

    public boolean isExistingCopyFileArea(IPath copyFileAreaRoot, boolean known) {
        int options = known ? 0 : 1;
        return ICopyFileAreaManager.instance.copyFileAreaExists(copyFileAreaRoot, options);
    }

    @Override
    public final synchronized IContentExaminer getContentExaminer() {
        if (this.contentExaminer == null) {
            IConfigurationElement[] configs = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client", PT_CONTENT_EXAMINER);
            if (configs.length > 1) {
                throw new IllegalStateException("Only one content examiner implementation can be registered");
            }
            if (configs.length == 1) {
                try {
                    this.contentExaminer = (IContentExaminer)configs[0].createExecutableExtension("class");
                }
                catch (CoreException e) {
                    this.contentExaminer = LocalContentExaminer.getInstance();
                    LoggingHelper.log(e);
                }
            } else {
                this.contentExaminer = LocalContentExaminer.getInstance();
            }
        }
        return this.contentExaminer;
    }

    public IFileContentMerger getFileContentMerger() {
        return new IFileContentMerger(){

            public IStatus performAutoMerge(ITeamRepository repository, IFileItem commonAncestorItem, IFileItem proposedItem, IShareable shareable, String contentTypeForMerge, Shed backupShed, IProgressMonitor progress) throws FileSystemClientException, IOException, TeamRepositoryException {
                return new FileSystemStatus(4, 1001, Messages.SharingManager_0);
            }
        };
    }

    public Collection<IShare> getShares(IConnection connection, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ArrayList<IShare> shares = new ArrayList<IShare>();
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        Collection<ICopyFileArea> copyFileAreas = cfaMgr.getCopyFileAreasForConnection(connection, (IProgressMonitor)monitor.newChild(1));
        monitor.setWorkRemaining(copyFileAreas.size() + 1);
        for (ICopyFileArea cfa : copyFileAreas) {
            AbstractLock lock = CFALockUtil.lockExistingForRead(cfa.getRoot(), (IProgressMonitor)monitor.newChild(1));
            if (lock == null) continue;
            try {
                Collection<IShare> allShares = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfa.getRoot()).allShares();
                for (IShare share : allShares) {
                    if (!share.getSharingDescriptor().isAssociatedWithConnection(connection)) continue;
                    shares.add(share);
                }
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)monitor.newChild(1));
            }
        }
        return shares;
    }

    public Collection<IShare> getShares(ConfigurationDescriptor configuration, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ArrayList<IShare> shares = new ArrayList<IShare>();
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        Collection<ICopyFileArea> copyFileAreas = cfaMgr.getCopyFileAreasForConfiguration(configuration, (IProgressMonitor)monitor.newChild(1));
        monitor.setWorkRemaining(copyFileAreas.size() + 1);
        for (ICopyFileArea cfa : copyFileAreas) {
            AbstractLock lock = CFALockUtil.lockExistingForRead(cfa.getRoot(), (IProgressMonitor)monitor.newChild(1));
            if (lock == null) continue;
            try {
                Collection<IShare> allShares = ICopyFileAreaManager.instance.getExistingCopyFileArea(cfa.getRoot()).allShares();
                for (IShare share : allShares) {
                    ISharingDescriptor descriptor = share.getSharingDescriptor();
                    if (!descriptor.getConnectionHandle().sameItemId((IItemHandle)configuration.connectionHandle) || !descriptor.getComponent().sameItemId((IItemHandle)configuration.componentHandle)) continue;
                    shares.add(share);
                }
            }
            finally {
                CFALockUtil.endBatching(lock, (IProgressMonitor)monitor.newChild(1));
            }
        }
        return shares;
    }

    public boolean isCorruptedCopyFileArea(IPath copyFileAreaRoot, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForRead(copyFileAreaRoot, (IProgressMonitor)progress.newChild(1));
        if (lock == null) {
            return false;
        }
        try {
            ICopyFileArea copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(copyFileAreaRoot);
            boolean bl = copyFileArea.isCorrupted();
            return bl;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
        }
    }

    public Collection<LoadedConfigurationDescriptor> allLoadedConfigurations(IPath copyFileAreaRoot, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock lock = CFALockUtil.lockExistingForRead(copyFileAreaRoot, (IProgressMonitor)progress.newChild(1));
        if (lock == null) {
            return Collections.EMPTY_LIST;
        }
        try {
            ICopyFileArea copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(copyFileAreaRoot);
            Collection<LoadedConfigurationDescriptor> collection = copyFileArea.allLoadedConfigurations((IProgressMonitor)progress.newChild(98));
            return collection;
        }
        finally {
            CFALockUtil.endBatching(lock, (IProgressMonitor)progress.newChild(1));
        }
    }

    public static interface CoreRunnable {
        public void run() throws CoreException;
    }
}

