/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.ItemHandleHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.core.runtime.Assert;

public class SharingDescriptor
implements ISharingDescriptor,
Serializable {
    private static final int METADATA_VERSION3 = 3;
    private static final int METADATA_VERSION4 = 4;
    private static final UUID UNKNOWN_CONFIGURATION_STATE_UUID = UUID.valueOf((String)"_R9t0ULhfEduBzK-rvZth-A");
    private static final UUID NEW_CONFIGURATION_STATE_UUID = UUID.valueOf((String)"_EHcPcCUoEdyQ476u2X18-Q");
    private static final long serialVersionUID = 7918534741066530000L;
    private String repositoryUri;
    private UUID repoId;
    private transient IContextHandle connectionHandle;
    private transient IComponentHandle component;
    private transient IVersionableHandle rootFolder;
    private String connectionName;
    private String componentName;
    private ISyncTime configurationState;
    private int flags;
    private static final int UNKNOWN_CONFIG_STATE = 1;
    private static final int FILE_ROOT = 2;
    private static final int LINK_ROOT = 4;

    public SharingDescriptor(String repositoryUri, UUID repoId, IContextHandle connectionHandle, String connectionName, IComponentHandle component, String componentName, IVersionableHandle rootItem) {
        this(repositoryUri, repoId, connectionHandle, connectionName, component, componentName, rootItem, ISyncTime.TIME_NONE);
    }

    private SharingDescriptor(String repositoryUri, UUID repoId, IContextHandle connectionHandle, String connectionName, IComponentHandle component, String componentName, IVersionableHandle rootItem, ISyncTime configurationState) {
        Assert.isNotNull((Object)repositoryUri);
        Assert.isNotNull((Object)repoId);
        Assert.isNotNull((Object)component);
        Assert.isNotNull((Object)componentName);
        Assert.isNotNull((Object)rootItem);
        Assert.isNotNull((Object)connectionName);
        Assert.isNotNull((Object)connectionHandle);
        Assert.isNotNull((Object)configurationState);
        Assert.isLegal((connectionHandle instanceof IWorkspaceHandle || connectionHandle instanceof IBaselineHandle ? 1 : 0) != 0);
        this.repositoryUri = repositoryUri;
        this.repoId = repoId;
        this.connectionHandle = connectionHandle.hasFullState() ? (IContextHandle)connectionHandle.getItemType().createItemHandle(connectionHandle.getItemId(), connectionHandle.getStateId()) : connectionHandle;
        this.connectionName = connectionName;
        this.component = component.hasFullState() ? (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(component.getItemId(), component.getStateId()) : component;
        this.componentName = componentName;
        this.rootFolder = rootItem.hasFullState() ? (IVersionableHandle)rootItem.getItemType().createItemHandle(rootItem.getItemId(), rootItem.getStateId()) : rootItem;
        this.flags = 0;
        this.configurationState = configurationState;
        if (configurationState.equals(ISyncTime.TIME_NONE)) {
            this.flags |= 1;
        }
        if (rootItem instanceof IFileItemHandle) {
            this.flags |= 2;
        } else if (rootItem instanceof ISymbolicLinkHandle) {
            this.flags |= 4;
        }
    }

    public SharingDescriptor(String repositoryUri, UUID repoId, IConnection connection, IComponentHandle component, String componentName, IVersionableHandle rootItem) {
        this(repositoryUri, repoId, connection.getContextHandle(), connection.getName(), component, componentName, rootItem, ISyncTime.TIME_NONE);
    }

    public SharingDescriptor(String repositoryUri, UUID repoId, IConnection connection, IComponentHandle component, String componentName, IVersionableHandle rootItem, ISyncTime configurationState) throws TeamRepositoryException {
        Assert.isNotNull((Object)repositoryUri);
        Assert.isNotNull((Object)repoId);
        Assert.isNotNull((Object)component);
        Assert.isNotNull((Object)componentName);
        Assert.isNotNull((Object)rootItem);
        Assert.isNotNull((Object)connection);
        Assert.isNotNull((Object)configurationState);
        Assert.isLegal((connection instanceof IWorkspaceConnection || connection instanceof IBaselineConnection ? 1 : 0) != 0);
        this.repositoryUri = repositoryUri;
        this.repoId = repoId;
        this.component = component.hasFullState() ? (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle(component.getItemId(), component.getStateId()) : component;
        this.componentName = componentName;
        this.connectionName = connection.getName();
        this.connectionHandle = connection instanceof IBaselineConnection ? ((IBaselineConnection)connection).getBaseline() : ((IWorkspaceConnection)connection).getResolvedWorkspace();
        this.flags = 0;
        this.rootFolder = rootItem.hasFullState() ? (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(rootItem.getItemId(), rootItem.getStateId()) : rootItem;
        if (this.rootFolder instanceof IFileItemHandle) {
            this.flags |= 2;
        } else if (this.rootFolder instanceof ISymbolicLinkHandle) {
            this.flags |= 4;
        }
        this.setConfigurationState(configurationState);
    }

    public SharingDescriptor(ISharingDescriptor descriptor, ISyncTime newConfigurationState) {
        if (descriptor == null) {
            throw new IllegalArgumentException();
        }
        if (newConfigurationState == null) {
            throw new IllegalArgumentException();
        }
        this.component = descriptor.getComponent();
        this.componentName = descriptor.getComponentName();
        this.configurationState = newConfigurationState;
        this.connectionHandle = descriptor.getConnectionHandle();
        this.connectionName = descriptor.getConnectionName();
        this.repoId = descriptor.getRepositoryId();
        this.repositoryUri = descriptor.getRepositoryUri();
        this.rootFolder = descriptor.getRootVersionable();
        if (this.rootFolder instanceof IFileItemHandle) {
            this.flags = 2;
        } else if (this.rootFolder instanceof ISymbolicLinkHandle) {
            this.flags = 4;
        }
        this.setConfigurationState(newConfigurationState);
    }

    private void setConfigurationState(ISyncTime newConfigurationState) {
        this.flags = newConfigurationState.equals(ISyncTime.TIME_NONE) ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        this.configurationState = newConfigurationState;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 4 && version != 3) {
            throw new ClassNotFoundException(NLS.bind((String)Messages.SharingDescriptor_0, (Object[])new Object[]{version, 4}, (Object[])new Object[0]));
        }
        this.repositoryUri = in.readUTF();
        this.repoId = UUID.valueOf((String)in.readUTF());
        this.component = (IComponentHandle)ItemHandleHelper.fromString(IComponent.ITEM_TYPE, in.readUTF());
        this.componentName = in.readUTF();
        IItemType connectionType = in.readBoolean() ? IBaseline.ITEM_TYPE : IWorkspace.ITEM_TYPE;
        this.connectionHandle = (IContextHandle)ItemHandleHelper.fromString(connectionType, in.readUTF());
        this.connectionName = in.readUTF();
        String rootItemId = null;
        rootItemId = in.readUTF();
        if (version == 3) {
            this.configurationState = this.getConfigState(in.readUTF());
        } else {
            this.configurationState = ISyncTime.FACTORY.createFrom(in.readUTF());
            this.flags = in.readInt();
        }
        this.rootFolder = (this.flags & 2) == 2 ? (IFileItemHandle)ItemHandleHelper.fromString(IFileItem.ITEM_TYPE, rootItemId) : ((this.flags & 4) == 4 ? (ISymbolicLinkHandle)ItemHandleHelper.fromString(ISymbolicLink.ITEM_TYPE, rootItemId) : (IFolderHandle)ItemHandleHelper.fromString(IFolder.ITEM_TYPE, rootItemId));
    }

    private ISyncTime getConfigState(String uuidStr) {
        if (uuidStr.equals(NEW_CONFIGURATION_STATE_UUID.getUuidValue())) {
            this.flags = 1;
            this.configurationState = ISyncTime.TIME_NONE;
        } else if (uuidStr.equals(UNKNOWN_CONFIGURATION_STATE_UUID.getUuidValue())) {
            this.flags = 1;
            this.configurationState = ISyncTime.TIME_NONE;
        }
        return ISyncTime.FACTORY.convertFromUUID(UUID.valueOf((String)uuidStr));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(4);
        out.writeUTF(this.repositoryUri);
        out.writeUTF(this.repoId.getUuidValue());
        out.writeUTF(ItemHandleHelper.toString((IItemHandle)this.component));
        out.writeUTF(this.componentName);
        out.writeBoolean(this.connectionHandle.getItemType() == IBaseline.ITEM_TYPE);
        out.writeUTF(ItemHandleHelper.toString((IItemHandle)this.connectionHandle));
        out.writeUTF(this.connectionName);
        out.writeUTF(ItemHandleHelper.toString((IItemHandle)this.rootFolder));
        out.writeUTF(this.configurationState.toString());
        out.writeInt(this.flags);
    }

    public IComponentHandle getComponent() {
        return this.component;
    }

    public IVersionableHandle getRootVersionable() {
        return this.rootFolder;
    }

    public IContextHandle getConnectionHandle() {
        return this.connectionHandle;
    }

    public String getRepositoryUri() {
        return this.repositoryUri;
    }

    public UUID getRepositoryId() {
        return this.repoId;
    }

    public boolean associatedWithWorkspace() {
        return this.connectionHandle instanceof IWorkspaceHandle;
    }

    public boolean isAssociatedWithConnection(IConnection connection) {
        if (connection instanceof IWorkspaceConnection) {
            return ((IWorkspaceConnection)connection).getResolvedWorkspace().sameItemId((IItemHandle)this.getConnectionHandle());
        }
        return ((IBaselineConnection)connection).getBaseline().sameItemId((IItemHandle)this.getConnectionHandle());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SharingDescriptor)) {
            return false;
        }
        SharingDescriptor another = (SharingDescriptor)obj;
        return this.repoId.equals((Object)another.repoId) && this.rootFolder.sameItemId((IItemHandle)another.rootFolder) && this.component.sameItemId((IItemHandle)another.component) && this.connectionHandle.sameItemId((IItemHandle)another.connectionHandle);
    }

    public int hashCode() {
        return this.rootFolder.getItemId().hashCode() ^ this.connectionHandle.getItemId().hashCode() ^ this.component.getItemId().hashCode() ^ this.repoId.hashCode();
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public ISyncTime getConfigurationState() {
        return this.configurationState;
    }

    public boolean isUnknownState() {
        return (this.flags & 1) == 1;
    }
}

