/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sandbox
implements ISandbox {
    private final IPath copyFileAreaRoot;
    private final boolean isCaseSensitive;

    public Sandbox(ICopyFileArea copyFileArea) {
        this.copyFileAreaRoot = copyFileArea.getRoot();
        this.isCaseSensitive = copyFileArea.isCaseSensitive();
    }

    public Sandbox(IPath copyFileAreaRoot) {
        this.copyFileAreaRoot = copyFileAreaRoot;
        this.isCaseSensitive = !copyFileAreaRoot.append("a").toFile().equals(copyFileAreaRoot.append("A").toFile());
    }

    @Override
    public IShare[] allShares(IProgressMonitor monitor) throws FileSystemClientException {
        return SharingManager.getInstance().allShares(this.copyFileAreaRoot, monitor);
    }

    @Override
    public IShareable findShareable(IContextHandle connection, IComponentHandle component, IVersionableHandle versionable, IProgressMonitor monitor) throws FileSystemClientException {
        return SharingManager.getInstance().findShareable(this.copyFileAreaRoot, connection, component, versionable, monitor);
    }

    @Override
    public IShareable findShareable(IPath path, ResourceType typeHint) {
        return SharingManager.getInstance().findShareable(this, path, typeHint);
    }

    @Override
    public List<IPath> getPathRelativeToShares(IContextHandle context, IComponentHandle component, List<List<INameItemPair>> ancestorReports, IProgressMonitor progress) throws FileSystemClientException {
        return SharingManager.getInstance().getPathRelativeToShares(this.copyFileAreaRoot, context, component, ancestorReports, progress);
    }

    @Override
    public IPath getRoot() {
        return this.copyFileAreaRoot;
    }

    public int hashCode() {
        return this.copyFileAreaRoot == null ? 0 : this.copyFileAreaRoot.segmentCount();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sandbox other = (Sandbox)obj;
        return PathUtils.samePath(this.copyFileAreaRoot, this.isCaseSensitive, other.copyFileAreaRoot, other.isCaseSensitive);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public boolean isExistingSandbox() {
        return SharingManager.getInstance().isExistingCopyFileArea(this.copyFileAreaRoot, false);
    }

    @Override
    public boolean isRegistered() {
        return SharingManager.getInstance().isExistingCopyFileArea(this.copyFileAreaRoot, true);
    }

    @Override
    public boolean isCorrupted(IProgressMonitor monitor) throws FileSystemClientException {
        return SharingManager.getInstance().isCorruptedCopyFileArea(this.copyFileAreaRoot, monitor);
    }

    @Override
    public Collection<LoadedConfigurationDescriptor> allLoadedConfigurations(IProgressMonitor monitor) throws FileSystemClientException {
        return SharingManager.getInstance().allLoadedConfigurations(this.copyFileAreaRoot, monitor);
    }

    public String toString() {
        return this.getRoot().toString();
    }
}

