/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.DiskBackedMapManager;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.ICorruptible;
import com.ibm.team.filesystem.client.internal.IMetadataChangeTracker;
import com.ibm.team.filesystem.client.internal.IRemoteVisitor;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.IVisitor;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LockableMap;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PersistentHeapManager;
import com.ibm.team.filesystem.client.internal.ReadWriteLock;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Store;
import com.ibm.team.filesystem.client.internal.StringWrapper;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.PersistentBusyFlag;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataChangeTracker
implements ISharingMetadata,
IMetadataChangeTracker {
    private static final String SCM_CHANGED_INFOS_PREFIX = ".changedinfos";
    private static final String SCM_CHANGED_INFOS_SUFFIX = ".dat";
    protected ISharingMetadata delegate;
    protected IPath cfaRoot;
    protected IPath basePath;
    protected PersistentHeapManager heapMgr;
    protected ChangeDiskBackedMapManager mapMgr;
    protected ReadWriteLock globalLock;

    private void setCorrupt(DBHMException e) {
        this.setCorrupt(true, e.getMessage(), e.getCause());
    }

    public MetadataChangeTracker(ISharingMetadata delegate, IPath copyFileAreaRoot, IPath metadataRoot) {
        this.delegate = delegate;
        this.cfaRoot = copyFileAreaRoot;
        this.basePath = metadataRoot;
        this.heapMgr = new PersistentHeapManager();
        this.globalLock = new ReadWriteLock();
        this.mapMgr = new ChangeDiskBackedMapManager(this.globalLock, delegate.getPersistentMetadataFlag(), this);
    }

    @Override
    public void accept(IVisitor visitor, IPath base, int depth, boolean mutable, IProgressMonitor monitor) throws FileSystemClientException {
        if (mutable) {
            this.globalLock.acquireWrite();
        } else {
            this.globalLock.acquireRead();
        }
        try {
            this.delegate.accept(visitor, base, depth, mutable, monitor);
        }
        finally {
            this.globalLock.release();
        }
    }

    @Override
    public void accept(IRemoteVisitor visitor, IVersionableHandle base, IComponentHandle component, IContextHandle connection, int depth, boolean mutable, IProgressMonitor monitor) throws FileSystemClientException {
        if (mutable) {
            this.globalLock.acquireWrite();
        } else {
            this.globalLock.acquireRead();
        }
        try {
            this.delegate.accept(visitor, base, component, connection, depth, mutable, monitor);
        }
        finally {
            this.globalLock.release();
        }
    }

    @Override
    public IPath[] allShares() throws FileSystemClientException {
        return this.delegate.allShares();
    }

    @Override
    public Collection<IPath> allShares(IPath parent) throws FileSystemClientException {
        return this.delegate.allShares(parent);
    }

    @Override
    public void clear() throws FileSystemClientException {
        this.globalLock.acquireWrite();
        try {
            this.mapMgr.closeAll();
            this.delegate.clear();
        }
        finally {
            this.globalLock.release();
        }
    }

    @Override
    public void close() throws FileSystemClientException {
        this.delegate.close();
        this.globalLock.acquireWrite();
        try {
            this.mapMgr.closeAll();
        }
        finally {
            this.globalLock.release();
        }
    }

    private void notifyTracker(IComponentHandle component, IContextHandle connection) {
        LocalChangeTracker tracker = LocalChangeManager.getInstance().findTracker(connection, component, this.cfaRoot);
        if (tracker != null) {
            tracker.metadataChanged();
        }
    }

    @Override
    public FileItemInfo deleteFileItemInfo(IPath path, IProgressMonitor monitor) throws FileSystemClientException {
        return this.delegate.deleteFileItemInfo(path, monitor);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.delegate.isCaseSensitive();
    }

    @Override
    public Map<StringWrapper, FileItemInfo> getChildInfos(IPath path) throws FileSystemClientException {
        return this.delegate.getChildInfos(path);
    }

    @Override
    public FileItemInfo getFileItemInfo(IPath path) throws FileSystemClientException {
        return this.delegate.getFileItemInfo(path);
    }

    @Override
    public InverseFileItemInfo getFileItemInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        return this.delegate.getFileItemInfo(item, component, connection);
    }

    @Override
    public Collection<ISharingMetadata.IConnectionComponent> getLocations(IVersionableHandle item) throws FileSystemClientException {
        return this.delegate.getLocations(item);
    }

    @Override
    public IPath getPathForShareRoot(IVersionableHandle root, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        return this.delegate.getPathForShareRoot(root, component, connection);
    }

    @Override
    public ISharingDescriptor getSharingDescriptor(IPath sharePath) throws FileSystemClientException {
        return this.delegate.getSharingDescriptor(sharePath);
    }

    @Override
    public ISharingDescriptor findSharingDescriptor(IPath path) throws FileSystemClientException {
        return this.delegate.findSharingDescriptor(path);
    }

    @Override
    public ISharingMetadata.ISharingDescriptorPath findSharingDescriptorPath(IPath path) throws FileSystemClientException {
        return this.delegate.findSharingDescriptorPath(path);
    }

    @Override
    public IPath findConflictingShare(IPath sharePath) throws FileSystemClientException {
        return this.delegate.findConflictingShare(sharePath);
    }

    @Override
    public FileItemInfo moveFileItemInfo(IPath sourcePath, IPath destinationPath) throws FileSystemClientException {
        return this.delegate.moveFileItemInfo(sourcePath, destinationPath);
    }

    @Override
    public void run(ISharingMetadata.ITransaction transaction) throws FileSystemClientException {
        this.globalLock.acquireWrite();
        try {
            this.delegate.run(transaction);
        }
        finally {
            this.globalLock.release();
        }
    }

    private boolean isIgnored(IPath path, SubMonitor monitor) throws FileSystemClientException {
        SharingManager mgr = SharingManager.getInstance();
        Shareable shareable = new Shareable(this.cfaRoot, path, ResourceType.FILE);
        mgr.disableChangeMonitoring();
        try {
            boolean bl = shareable.shouldBeIgnored((IProgressMonitor)monitor);
            return bl;
        }
        finally {
            mgr.enableChangeMonitoring();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<IMetadataChangeTracker.IChangeType> getLocalChanges(IComponentHandle component, IContextHandle connection, IProgressMonitor progress) throws FileSystemClientException {
        LockableMap<UUID, IItemType> map = this.getMapFor(component, connection, false);
        HashMap<UUID, InverseFileItemInfo> infoMap = new HashMap<UUID, InverseFileItemInfo>();
        try {
            ArrayList<IMetadataChangeTracker.IChangeType> infos;
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
            Map<UUID, IItemType> map2 = map.entries();
            synchronized (map2) {
                int mapSize = map.entries().size();
                infos = new ArrayList<IMetadataChangeTracker.IChangeType>(mapSize);
                monitor.beginTask(Messages.MetadataChangeTracker_LOADING_CHANGES, mapSize);
                block15: for (Map.Entry<UUID, IItemType> e : map.entries().entrySet()) {
                    boolean isFlagChange;
                    IPath currentMovedFromPath;
                    IPath originalPath;
                    IPath currentPath;
                    InverseFileItemInfo parentInfo;
                    IVersionableHandle item = (IVersionableHandle)e.getValue().createItemHandle(e.getKey(), null);
                    InverseFileItemInfo itemInfo = this.getInverseInfo(item, component, connection, infoMap);
                    if (itemInfo == null) {
                        FileSystemClientException ex = new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.MetadataChangeTracker_8, (Object)item.getItemId().toString()), null));
                        ex.fillInStackTrace();
                        this.setCorrupt(true, ex.getMessage(), (Throwable)((Object)ex));
                        throw ex;
                    }
                    int changeType = itemInfo.getVersionableHandle().getStateId() == null ? 4 : (itemInfo.getLocalName() == null ? (this.getPathForShareRoot(itemInfo.getVersionableHandle(), component, connection) == null ? ((parentInfo = this.getInverseInfo((IVersionableHandle)itemInfo.getParent(), component, connection, infoMap)).getLocalName() == null ? 2 : 1) : 1) : (this.noPathChange(itemInfo) ? 0 : 3));
                    switch (changeType) {
                        case 2: {
                            currentPath = null;
                            originalPath = null;
                            currentMovedFromPath = null;
                            break;
                        }
                        case 1: {
                            currentPath = this.computeDeletionPath(item, component, connection, infoMap);
                            if (this.isIgnored(currentPath, monitor.newChild(1))) continue block15;
                            originalPath = this.computeRemotePath(item, component, connection, infoMap);
                            currentMovedFromPath = null;
                            break;
                        }
                        case 0: {
                            currentPath = this.computeLocalPath(item, component, connection, infoMap);
                            if (this.isIgnored(currentPath, monitor.newChild(1))) continue block15;
                            originalPath = this.computeRemotePath(item, component, connection, infoMap);
                            currentMovedFromPath = null;
                            break;
                        }
                        case 4: {
                            currentPath = this.computeLocalPath(item, component, connection, infoMap);
                            if (this.isIgnored(currentPath, monitor.newChild(1))) continue block15;
                            originalPath = null;
                            currentMovedFromPath = null;
                            break;
                        }
                        case 3: {
                            currentPath = this.computeLocalPath(item, component, connection, infoMap);
                            IPath rootPath = this.getPathForShareRoot(item, component, connection);
                            currentMovedFromPath = rootPath != null ? rootPath.removeLastSegments(1).append(itemInfo.getName()) : this.computeDeletionPath((IVersionableHandle)itemInfo.getParent(), component, connection, infoMap).append(itemInfo.getName());
                            SubMonitor moveMon = monitor.newChild(1);
                            moveMon.setWorkRemaining(2);
                            boolean targetIgnored = this.isIgnored(currentPath, moveMon.newChild(1));
                            boolean sourceIgnored = this.isIgnored(currentMovedFromPath, moveMon.newChild(1));
                            if (sourceIgnored && targetIgnored) continue block15;
                            if (sourceIgnored && !targetIgnored) {
                                changeType = 4;
                                originalPath = null;
                                currentMovedFromPath = null;
                                break;
                            }
                            if (!sourceIgnored && targetIgnored) {
                                changeType = 1;
                                originalPath = this.computeRemotePath(item, component, connection, infoMap);
                                currentPath = currentMovedFromPath;
                                currentMovedFromPath = null;
                                break;
                            }
                            Assert.isTrue((!sourceIgnored && !targetIgnored ? 1 : 0) != 0);
                            originalPath = this.computeRemotePath(item, component, connection, infoMap);
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    IFolderHandle localParent = itemInfo.getLocalParent();
                    IFolderHandle remoteParent = itemInfo.getParent();
                    boolean isContentChanged = !itemInfo.isFolder() && (itemInfo.isContentChanged() || itemInfo.getOriginalLineDelimiter() != itemInfo.getLineDelimiter());
                    boolean bl = isFlagChange = itemInfo.isExecutable() != itemInfo.isOriginalExecutable() || itemInfo.getOriginalContentType() == null && itemInfo.getContentType() != null || itemInfo.getOriginalContentType() != null && !itemInfo.getOriginalContentType().equals(itemInfo.getContentType());
                    if (changeType == 0 && !isContentChanged && !isFlagChange) {
                        throw new IllegalStateException();
                    }
                    infos.add(new ChangeType(itemInfo.getVersionableHandle(), changeType, localParent, remoteParent, currentPath, originalPath, currentMovedFromPath, isContentChanged, isFlagChange));
                }
            }
            ArrayList<IMetadataChangeTracker.IChangeType> arrayList = infos;
            return arrayList;
        }
        catch (DBHMException e) {
            this.setCorrupt(true, "Failure during getLocalChanges()", e.getCause());
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.MetadataChangeTracker_4, e.getCause()));
        }
        finally {
            this.releaseMap(map);
        }
    }

    private IPath computeLocalPath(IVersionableHandle item, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache) throws FileSystemClientException {
        ArrayList<String> segments = null;
        int pathlen = 0;
        while (true) {
            IPath rootPath;
            if ((rootPath = this.delegate.getPathForShareRoot(item, component, connection)) != null) {
                if (segments == null) {
                    return rootPath;
                }
                int max = segments.size() - 1;
                if (max == 0) {
                    return rootPath.append((String)segments.get(0));
                }
                StringBuffer buf = new StringBuffer(pathlen + max);
                buf.append((String)segments.get(max));
                int i = max - 1;
                while (i >= 0) {
                    buf.append('/');
                    buf.append((String)segments.get(i));
                    --i;
                }
                return rootPath.append(buf.toString());
            }
            InverseFileItemInfo info = this.getInverseInfo(item, component, connection, cache);
            if (info == null) {
                this.setCorrupt(true, "Could not resolve path via getInverseInfo() for " + (item == null ? "null item" : item.getItemId().getUuidValue()), null);
                throw new IllegalStateException("Path to " + info.getVersionableHandle() + " does not resolve");
            }
            String name = info.getLocalName();
            if (name == null) {
                this.setCorrupt(true, "Could not resolve path via getInverseInfo() for " + (item == null ? "null item" : item.getItemId().getUuidValue()), null);
                throw new IllegalStateException("Path to " + info.getVersionableHandle() + " does not resolve");
            }
            if (segments == null) {
                segments = new ArrayList<String>();
            }
            pathlen += name.length();
            segments.add(name);
            item = info.getLocalParent();
        }
    }

    private IPath computeRemotePath(IVersionableHandle item, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache) throws FileSystemClientException {
        ArrayList<String> segments = null;
        int pathlen = 0;
        while (true) {
            InverseFileItemInfo info = this.getInverseInfo(item, component, connection, cache);
            String name = info.getName();
            IPath rootPath = this.delegate.getPathForShareRoot(item, component, connection);
            if (rootPath != null) {
                if (name != null && !name.equals(info.getLocalName())) {
                    rootPath = rootPath.removeLastSegments(1);
                    if (segments == null) {
                        return rootPath.append(name);
                    }
                    segments.add(name);
                } else if (segments == null) {
                    return rootPath;
                }
                int max = segments.size() - 1;
                if (max == 0) {
                    return rootPath.append((String)segments.get(0));
                }
                StringBuffer buf = new StringBuffer(pathlen + max);
                buf.append((String)segments.get(max));
                int i = max - 1;
                while (i >= 0) {
                    buf.append('/');
                    buf.append((String)segments.get(i));
                    --i;
                }
                return rootPath.append(buf.toString());
            }
            if (name == null) {
                throw new IllegalStateException("Path to " + info.getVersionableHandle() + " does not resolve");
            }
            if (segments == null) {
                segments = new ArrayList<String>();
            }
            pathlen += name.length();
            segments.add(name);
            item = info.getParent();
        }
    }

    private IPath computeDeletionPath(IVersionableHandle item, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache) throws FileSystemClientException {
        ArrayList<String> segments = null;
        int pathlen = 0;
        boolean computingRemote = true;
        while (true) {
            String name;
            InverseFileItemInfo info;
            IPath rootPath;
            if ((rootPath = this.delegate.getPathForShareRoot(item, component, connection)) != null) {
                if (computingRemote) {
                    info = this.getInverseInfo(item, component, connection, cache);
                    name = info.getName();
                    if (name != null && info.getLocalName() == null && !name.equals(rootPath.lastSegment())) {
                        rootPath = rootPath.removeLastSegments(1);
                        if (segments == null) {
                            return rootPath.append(name);
                        }
                        segments.add(name);
                    } else if (segments == null) {
                        return rootPath;
                    }
                } else if (segments == null) {
                    return rootPath;
                }
                int max = segments.size() - 1;
                if (max == 0) {
                    return rootPath.append((String)segments.get(0));
                }
                StringBuffer buf = new StringBuffer(pathlen + max);
                buf.append((String)segments.get(max));
                int i = max - 1;
                while (i >= 0) {
                    buf.append('/');
                    buf.append((String)segments.get(i));
                    --i;
                }
                return rootPath.append(buf.toString());
            }
            info = this.getInverseInfo(item, component, connection, cache);
            name = info.getLocalName();
            if (computingRemote) {
                if (name != null) {
                    computingRemote = false;
                } else {
                    name = info.getName();
                }
            }
            if (name == null) {
                throw new IllegalStateException("Path to " + info.getVersionableHandle() + " does not resolve");
            }
            if (segments == null) {
                segments = new ArrayList<String>();
            }
            pathlen += name.length();
            segments.add(name);
            item = computingRemote ? info.getParent() : info.getLocalParent();
        }
    }

    private InverseFileItemInfo getInverseInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache) throws FileSystemClientException {
        InverseFileItemInfo info = cache.get(item.getItemId());
        if (info != null) {
            return info;
        }
        info = this.delegate.getFileItemInfo(item, component, connection);
        cache.put(item.getItemId(), info);
        return info;
    }

    @Override
    public FileItemInfo setFileItemInfo(IPath path, FileItemInfo itemInfo) throws FileSystemClientException {
        return this.delegate.setFileItemInfo(path, itemInfo);
    }

    private static boolean isUnchanged(String oldStr, String newStr) {
        if (oldStr == newStr) {
            return true;
        }
        if (oldStr == null || newStr == null) {
            return false;
        }
        return oldStr.equals(newStr);
    }

    private static boolean isUnchanged(IVersionableHandle oldHandle, IVersionableHandle newHandle, boolean compareState) {
        if (oldHandle == newHandle) {
            return true;
        }
        if (oldHandle == null || newHandle == null) {
            return false;
        }
        if (compareState && !MetadataChangeTracker.isUnchanged(oldHandle.getStateId(), newHandle.getStateId())) {
            return false;
        }
        return oldHandle.sameItemId((IItemHandle)newHandle);
    }

    private static boolean isUnchanged(UUID oldState, UUID newState) {
        if (oldState == newState) {
            return true;
        }
        if (oldState == null || newState == null) {
            return false;
        }
        return oldState.equals((Object)newState);
    }

    private boolean itemUnchanged(InverseFileItemInfo info1, InverseFileItemInfo info2) {
        if (info1 == info2) {
            return true;
        }
        if (info1 == null || info2 == null) {
            return false;
        }
        return MetadataChangeTracker.isUnchanged((IVersionableHandle)info1.getParent(), (IVersionableHandle)info2.getParent(), false) && MetadataChangeTracker.isUnchanged(info1.getName(), info2.getName()) && MetadataChangeTracker.isUnchanged((IVersionableHandle)info1.getLocalParent(), (IVersionableHandle)info2.getLocalParent(), false) && (MetadataChangeTracker.isUnchanged(info1.getLocalName(), info2.getLocalName()) || info1.isLoadedWithAnotherName() && info2.isLoadedWithAnotherName()) && info1.isContentChanged() == info2.isContentChanged() && MetadataChangeTracker.isUnchanged(info1.getContentType(), info2.getContentType()) && info1.getLineDelimiter() == info2.getLineDelimiter() && MetadataChangeTracker.isUnchanged(info1.getOriginalContentType(), info2.getOriginalContentType()) && info1.getOriginalLineDelimiter() == info2.getOriginalLineDelimiter() && info1.isExecutable() == info2.isExecutable() && info1.isOriginalExecutable() == info2.isOriginalExecutable();
    }

    private boolean noChange(InverseFileItemInfo info) throws FileSystemClientException {
        if (info == null) {
            return true;
        }
        return info.getVersionableHandle().hasStateId() && info.getOriginalLineDelimiter() == info.getLineDelimiter() && info.isExecutable() == info.isOriginalExecutable() && !info.isContentChanged() && MetadataChangeTracker.isUnchanged(info.getOriginalContentType(), info.getContentType()) && this.noPathChange(info);
    }

    private boolean noPathChange(InverseFileItemInfo info) throws FileSystemClientException {
        if (info == null) {
            return true;
        }
        return (MetadataChangeTracker.isUnchanged(info.getLocalName(), info.getName()) || info.isLoadedWithAnotherName()) && MetadataChangeTracker.isUnchanged((IVersionableHandle)info.getLocalParent(), (IVersionableHandle)info.getParent(), false);
    }

    private LockableMap<UUID, IItemType> getMapFor(IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        return this.getMapFor(component, connection, true);
    }

    private LockableMap<UUID, IItemType> getMapFor(IComponentHandle component, IContextHandle connection, boolean exclusive) throws FileSystemClientException {
        Path path = new Path(SCM_CHANGED_INFOS_PREFIX + component.getItemId().getUuidValue() + "_" + connection.getItemId().getUuidValue() + SCM_CHANGED_INFOS_SUFFIX);
        try {
            return this.mapMgr.loadMap((IPath)path, exclusive, (IPath)path);
        }
        catch (DBHMException e) {
            this.setCorrupt(true, "Failed to get map for " + path.toString(), e.getCause());
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.DiskBackedMapManager_0, e.getCause()));
        }
    }

    private void releaseMap(LockableMap<UUID, IItemType> map) throws FileSystemClientException {
        this.mapMgr.releaseMap(map);
    }

    @Override
    public InverseFileItemInfo setFileItemInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection, InverseFileItemInfo newInfo) throws FileSystemClientException {
        if (newInfo != null && !item.sameItemId((IItemHandle)newInfo.getVersionableHandle())) {
            throw new IllegalArgumentException();
        }
        InverseFileItemInfo oldInfo = this.delegate.setFileItemInfo(item, component, connection, newInfo);
        boolean noChangeNewInfo = this.noChange(newInfo);
        if (this.noChange(oldInfo) != noChangeNewInfo) {
            try {
                LockableMap<UUID, IItemType> map = this.getMapFor(component, connection);
                try {
                    if (noChangeNewInfo) {
                        map.entries().remove(item.getItemId());
                    } else {
                        map.entries().put(item.getItemId(), item.getItemType());
                    }
                }
                finally {
                    this.releaseMap(map);
                }
            }
            catch (DBHMException e) {
                this.setCorrupt(true, "Failure when setting item info", e.getCause());
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.MetadataChangeTracker_6, e.getCause()));
            }
            this.notifyTracker(component, connection);
        } else if (!this.itemUnchanged(newInfo, oldInfo)) {
            this.notifyTracker(component, connection);
        }
        return oldInfo;
    }

    @Override
    public ISharingDescriptor setSharingDescriptor(IPath sharePath, ISharingDescriptor descriptor, IProgressMonitor monitor) throws FileSystemClientException {
        return this.delegate.setSharingDescriptor(sharePath, descriptor, monitor);
    }

    @Override
    public String toDebugString() {
        return this.delegate.toDebugString();
    }

    @Override
    public Map<IPath, ISharingDescriptor> getSharingDescriptors(IComponentHandle component, IContextHandle connectionHandle) throws FileSystemClientException {
        return this.delegate.getSharingDescriptors(component, connectionHandle);
    }

    @Override
    public Map<IPath, ISharingDescriptor> getSharingDescriptors() throws FileSystemClientException {
        return this.delegate.getSharingDescriptors();
    }

    @Override
    public Collection<LoadedConfigurationDescriptor> allLoadedComponents(IProgressMonitor monitor) throws FileSystemClientException {
        return this.delegate.allLoadedComponents(monitor);
    }

    @Override
    public Collection<ConnectionDescriptor> allLoadedContexts(IProgressMonitor monitor) throws FileSystemClientException {
        return this.delegate.allLoadedContexts(monitor);
    }

    @Override
    public LoadedConfigurationDescriptor componentLoaded(LoadedConfigurationDescriptor desc, IProgressMonitor monitor) throws FileSystemClientException {
        return this.delegate.componentLoaded(desc, monitor);
    }

    @Override
    public LoadedConfigurationDescriptor componentUnloaded(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        return this.delegate.componentUnloaded(component, connection, monitor);
    }

    @Override
    public boolean hasShares(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        return this.delegate.hasShares(component, connection, monitor);
    }

    @Override
    public boolean isLoaded(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        return this.delegate.isLoaded(component, connection, monitor);
    }

    @Override
    public PersistentBusyFlag getPersistentMetadataFlag() {
        return this.delegate.getPersistentMetadataFlag();
    }

    @Override
    public void addCorruptionListener(ICorruptCopyFileAreaListener listener) {
        this.delegate.addCorruptionListener(listener);
    }

    @Override
    public void removeCorruptionListener(ICorruptCopyFileAreaListener listener) {
        this.delegate.removeCorruptionListener(listener);
    }

    @Override
    public void setCorrupt(boolean value, String debugText, Throwable reason) {
        this.delegate.setCorrupt(value, debugText, reason);
    }

    @Override
    public boolean isCorrupted() {
        return this.delegate.isCorrupted();
    }

    @Override
    public IPath getCanonicalPath(IPath path, boolean convertCase) {
        return this.delegate.getCanonicalPath(path, convertCase);
    }

    @Override
    public boolean isSamePath(IPath path1, IPath path2) {
        return this.delegate.isSamePath(path1, path2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChangeDiskBackedMapManager
    extends DiskBackedMapManager<UUID, IItemType> {
        public ChangeDiskBackedMapManager(ReadWriteLock lock, PersistentBusyFlag flag, ICorruptible corruptible) {
            super(lock, flag, corruptible);
        }

        @Override
        protected LockableMap<UUID, IItemType> getLockableMap(IPath path, IPath realPath) {
            return new ChangeMap(path);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ChangeMap
    extends LockableMap<UUID, IItemType> {
        public ChangeMap(IPath path) {
            super(path, MetadataChangeTracker.this.basePath.append(path).toFile());
        }

        @Override
        protected void initEntries() {
            try {
                this.entries = new ChangedDescriptorsStore(MetadataChangeTracker.this.basePath.append(this.getPath()).toFile(), MetadataChangeTracker.this.heapMgr);
            }
            catch (DBHMException e) {
                MetadataChangeTracker.this.setCorrupt(e);
                throw e;
            }
        }
    }

    protected static class ChangeType
    implements IMetadataChangeTracker.IChangeType {
        private IVersionableHandle item;
        private int changeType;
        private IFolderHandle currentParent;
        private IFolderHandle previousParent;
        private IPath currentPath;
        private IPath originalPath;
        private IPath currentMovedFromPath;
        private boolean isContentChange;
        private boolean isFlagChange;

        public ChangeType(IVersionableHandle item, int changeType, IFolderHandle currentParent, IFolderHandle previousParent, IPath currentPath, IPath originalpath, IPath currentMovedFromPath, boolean isContentChange, boolean isFlagChange) {
            this.item = item;
            this.changeType = changeType;
            this.currentParent = currentParent;
            this.previousParent = previousParent;
            this.currentPath = currentPath;
            this.originalPath = originalpath;
            this.currentMovedFromPath = currentMovedFromPath;
            this.isContentChange = isContentChange;
            this.isFlagChange = isFlagChange;
        }

        public IFolderHandle getCurrentParent() {
            return this.currentParent;
        }

        public IPath getCurrentPath() {
            return this.currentPath;
        }

        public IPath getOriginalPath() {
            return this.originalPath;
        }

        public IVersionableHandle getItem() {
            return this.item;
        }

        public IFolderHandle getPreviousParent() {
            return this.previousParent;
        }

        public int getType() {
            return this.changeType;
        }

        public boolean isContentChange() {
            return this.isContentChange;
        }

        public boolean isFlagChange() {
            return this.isFlagChange;
        }

        public IPath getCurrentMovedFromPath() {
            return this.currentMovedFromPath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ChangedDescriptorsStore
    extends Store<UUID, IItemType> {
        private static final int METADATA_VERSION = 0;

        public ChangedDescriptorsStore(File file, PersistentHeapManager mgr) {
            super(file, mgr);
        }

        protected void writeCustomMetadata(DataOutputStream out) throws IOException {
            super.writeCustomMetadata(out);
            out.writeInt(0);
        }

        protected void readCustomMetadata(DataInputStream in) throws IOException {
            super.readCustomMetadata(in);
            int v = in.readInt();
            if (v != 0) {
                throw new IllegalArgumentException("Metadata version mismatch " + v + " != " + 0);
            }
        }

        private long persistStream(ByteArrayOutputStream out) throws IOException {
            long offset = this.heap.allocate((long)out.size());
            out.writeTo(this.heap.getOutputStream(offset));
            return offset;
        }

        protected long writeObject(Object o, int flags) throws IOException {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(out);
            if ((flags & 1) != 0) {
                UUID id = (UUID)o;
                dos.writeUTF(id.getUuidValue());
                return this.persistStream(out);
            }
            return o == IFolder.ITEM_TYPE ? 1 : 0;
        }

        protected void freeObject(long offset, int flags) throws IOException {
            if ((flags & 1) != 0) {
                super.freeObject(offset, flags);
            }
        }

        protected Object readObject(long offset, int flags) throws IOException, ClassNotFoundException {
            if ((flags & 1) != 0) {
                return super.readObject(offset, flags);
            }
            return offset == 0L ? IFileItem.ITEM_TYPE : IFolder.ITEM_TYPE;
        }

        protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
            DataInputStream dis = new DataInputStream(in);
            return UUID.valueOf((String)dis.readUTF());
        }
    }
}

