/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ManagedFileSystem
extends FileSystem {
    private static final IFileStore NULL_ROOT = EFS.getNullFileSystem().getStore((IPath)Path.ROOT);
    private static final boolean caseSensitive = EFS.getLocalFileSystem().isCaseSensitive();
    private static ManagedFileSystem instance;
    public static final String SCHEME_MANAGED = "sourcecontrol";
    public static final String DEFAULT_CFA = "default";

    public static ManagedFileSystem getInstance() {
        ManagedFileSystem tmpInstance = instance;
        if (tmpInstance != null) {
            return tmpInstance;
        }
        instance = new ManagedFileSystem();
        return instance;
    }

    public ManagedFileSystem() {
        instance = this;
    }

    public IFileStore getStore(URI uri) {
        try {
            ManagedLocation loc = ManagedFileSystem.expandUri(uri);
            if (loc == null) {
                return NULL_ROOT;
            }
            IFileStore baseStore = EFS.getStore((URI)loc.getBaseStoreURI());
            return new ManagedFileStore(loc.getCfaRoot(), loc.getSharePath(), baseStore);
        }
        catch (CoreException e) {
            LoggingHelper.error("com.ibm.team.filesystem.client", "Could not find base file system implementation for " + uri, e);
            return NULL_ROOT;
        }
    }

    public static ManagedLocation expandUri(URI uri) {
        URI baseStoreURI;
        IPath cfaPath;
        int numSegments;
        Path fullPath;
        block8: {
            Assert.isLegal((boolean)SCHEME_MANAGED.equals(uri.getScheme()));
            try {
                fullPath = new Path(uri.getPath());
                if (fullPath.segmentCount() >= 1) break block8;
                LoggingHelper.error("com.ibm.team.filesystem.client", "Invalid URI: " + uri, new Exception().fillInStackTrace());
                return null;
            }
            catch (URISyntaxException e) {
                LoggingHelper.error("com.ibm.team.filesystem.client", "Could not find base file system implementation for " + uri, e);
                return null;
            }
        }
        SharingManager mgr = null;
        if (fullPath.segment(0).equals(DEFAULT_CFA)) {
            numSegments = 0;
            mgr = SharingManager.getInstance();
            cfaPath = mgr.getIDEWorkAreaRoot();
        } else {
            numSegments = Integer.parseInt(fullPath.segment(0));
            cfaPath = fullPath.removeLastSegments(fullPath.segmentCount() - numSegments - 1).removeFirstSegments(1).makeUNC(fullPath.isUNC());
        }
        IPath sharePath = fullPath.removeFirstSegments(numSegments + 1).setDevice(null).makeUNC(false).makeAbsolute();
        if (uri.getQuery() != null) {
            baseStoreURI = new URI(uri.getQuery());
        } else {
            if (mgr == null) {
                mgr = SharingManager.getInstance();
            }
            baseStoreURI = URIUtil.toURI((IPath)mgr.getIDEWorkAreaRoot().append(sharePath));
        }
        return new ManagedLocation(cfaPath.makeAbsolute(), sharePath, baseStoreURI);
    }

    public static URI getManagedURI(IPath cfaPath, IPath sharePath, URI baseStoreURI) {
        String path = cfaPath == null ? new Path(null, "/default").append(sharePath).makeUNC(false).makeAbsolute().toString() : new Path(cfaPath.getDevice(), Integer.toString(cfaPath.segmentCount())).append(cfaPath).append(sharePath).makeUNC(cfaPath.isUNC()).makeAbsolute().toString();
        if (path.charAt(0) != '/') {
            path = String.valueOf('/') + path;
        }
        try {
            return new URI(SCHEME_MANAGED, null, "jazz", -1, path, baseStoreURI == null ? null : baseStoreURI.toString(), null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URI getCanonicalManagedURI(IPath cfaPath, IPath sharePath, URI baseStoreURI) {
        IPath defaultRoot = SharingManager.getInstance().getIDEWorkAreaRoot();
        if (cfaPath != null && cfaPath.equals((Object)defaultRoot)) {
            cfaPath = null;
        }
        if (baseStoreURI != null && defaultRoot != null && defaultRoot.append(sharePath).equals((Object)URIUtil.toPath((URI)baseStoreURI))) {
            baseStoreURI = null;
        }
        return ManagedFileSystem.getManagedURI(cfaPath, sharePath, baseStoreURI);
    }

    public static URI getBasicURI(URI managedURI) {
        ManagedLocation location;
        block4: {
            Assert.isLegal((boolean)SCHEME_MANAGED.equals(managedURI.getScheme()));
            try {
                if (managedURI.getQuery() != null) {
                    return new URI(managedURI.getQuery());
                }
                location = ManagedFileSystem.expandUri(managedURI);
                IPath fullPath = location.getCfaRoot().append(location.sharePath);
                IPath defaultRoot = SharingManager.getInstance().getIDEWorkAreaRoot();
                if (!PathUtils.isPrefixOf(defaultRoot, caseSensitive, fullPath) || fullPath.segmentCount() != defaultRoot.segmentCount() + 1) break block4;
                return null;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Could not find base file system implementation for " + managedURI, e);
            }
        }
        return location.getBaseStoreURI();
    }

    public boolean isCaseSensitive() {
        return caseSensitive;
    }

    public static class ManagedLocation {
        private final IPath cfaRoot;
        private final IPath sharePath;
        private final URI baseStore;

        public ManagedLocation(IPath cfaRoot, IPath sharePath, URI baseStore) {
            this.cfaRoot = cfaRoot;
            this.sharePath = sharePath;
            this.baseStore = baseStore;
        }

        public IPath getCfaRoot() {
            return this.cfaRoot;
        }

        public IPath getSharePath() {
            return this.sharePath;
        }

        public URI getBaseStoreURI() {
            return this.baseStore;
        }
    }
}

