/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.repository.common.LogFactory;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

public class LoggingHelper {
    public static void log(IStatus status) {
        Log logger = LogFactory.getLog((String)status.getPlugin());
        switch (status.getSeverity()) {
            case 4: {
                logger.error((Object)status, status.getException());
                break;
            }
            case 2: {
                logger.warn((Object)status, status.getException());
                break;
            }
            case 1: {
                logger.info((Object)status, status.getException());
                break;
            }
            default: {
                logger.error((Object)status, status.getException());
            }
        }
    }

    public static void error(String namespace, String message, Throwable exception) {
        Log logger = LogFactory.getLog((String)namespace);
        logger.error((Object)message, exception);
        if (exception instanceof CoreException) {
            IStatus status = ((CoreException)exception).getStatus();
            MultiStatus multi = new MultiStatus(status.getPlugin(), status.getCode(), new IStatus[]{status}, message, exception);
            logger.error((Object)multi, exception);
        } else {
            logger.error((Object)message, exception);
        }
    }

    public static void log(CoreException exception) {
        IStatus status = exception.getStatus();
        MultiStatus multi = new MultiStatus(status.getPlugin(), status.getCode(), new IStatus[]{status}, status.getMessage(), (Throwable)exception);
        LoggingHelper.log((IStatus)multi);
    }
}

