/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.IWorkspaceCompareReport;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.LogicalConflictReport;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemView
implements IFileSystemView {
    private final IConnection connection;
    private final boolean isWorkspaceConnection;
    private final FileSystemServiceProxy fileSystemService;

    public FileSystemView(FileSystemServiceProxy fileSystemServiceProxy, IConnection connection) {
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (connection instanceof IWorkspaceConnection) {
            this.isWorkspaceConnection = true;
        } else {
            this.isWorkspaceConnection = false;
            if (!(connection instanceof IBaselineConnection)) {
                throw new IllegalArgumentException();
            }
        }
        this.connection = connection;
        this.fileSystemService = fileSystemServiceProxy;
    }

    @Override
    public IConnection connection() {
        return this.connection;
    }

    @Override
    public List getBlame(IComponentHandle component, IFileItemHandle fileItemHandle, IChangeSetHandle changeSetHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fileSystemService.getBlame(this.connection, component, fileItemHandle, changeSetHandle, null, monitor);
    }

    public ILogicalConflictReport interpretConflicts(Collection itemUpdateReports, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.isWorkspaceConnection) {
            throw new TeamRepositoryException((Object)this.connection().teamRepository(), Messages.FileSystemView_2);
        }
        if (itemUpdateReports.isEmpty()) {
            LogicalConflictReport result = FilesystemDTOFactory.eINSTANCE.createLogicalConflictReport();
            return result;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        return this.fileSystemService.interpretConflicts((IWorkspaceConnection)this.connection, itemUpdateReports, null, (IProgressMonitor)progress.newChild(99));
    }

    @Override
    public List interpretChanges(List changeSets, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        return this.fileSystemService.interpretChanges(this.connection, changeSets, null, (IProgressMonitor)monitor.newChild(99));
    }

    @Override
    public ILogicalConflictReport conflictReport(IProgressMonitor progress) throws TeamRepositoryException {
        if (!this.isWorkspaceConnection) {
            throw new TeamRepositoryException((Object)this.connection().teamRepository(), Messages.FileSystemView_5);
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IUpdateReport rawConflictReport = ((IWorkspaceConnection)this.connection).conflictReport();
        if (rawConflictReport.conflicts().isEmpty()) {
            LogicalConflictReport result = FilesystemDTOFactory.eINSTANCE.createLogicalConflictReport();
            result.setConflictReport(rawConflictReport);
            return result;
        }
        return this.fileSystemService.conflictReport((IWorkspaceConnection)this.connection, null, (IProgressMonitor)monitor.newChild(99));
    }

    @Override
    public IWorkspaceCompareReport compareAsWorkspaces(IWorkspaceConnection other, int compareFlags, List<IComponentHandle> componentFilter, IProgressMonitor monitor) throws TeamRepositoryException {
        if (!this.isWorkspaceConnection) {
            throw new TeamRepositoryException((Object)this.connection().teamRepository(), Messages.FileSystemView_5);
        }
        if (other == null) {
            throw new IllegalArgumentException();
        }
        if (!WorkspaceComparisonFlags.isValid((int)compareFlags)) {
            throw new IllegalArgumentException();
        }
        if (componentFilter == null) {
            throw new IllegalArgumentException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        return this.fileSystemService.compareAsWorkspaces((IWorkspaceConnection)this.connection, other, compareFlags, componentFilter, (IProgressMonitor)progress.newChild(99));
    }
}

