/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.common.IChangeSetSummary;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.IFilesystemService;
import com.ibm.team.filesystem.common.ILogicalChange;
import com.ibm.team.filesystem.common.ILogicalConflictReport;
import com.ibm.team.filesystem.common.IWorkspaceCompareReport;
import com.ibm.team.filesystem.common.internal.dto.ConflictResolution;
import com.ibm.team.filesystem.common.internal.dto.ConflictResolutionReport;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.filesystem.common.internal.dto.OverlapRequest;
import com.ibm.team.filesystem.common.internal.dto.OverlapResponse;
import com.ibm.team.filesystem.common.internal.dto.Resolution;
import com.ibm.team.filesystem.common.internal.dto.SharePoint;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.internal.RemoteRepoDescriptorUtils;
import com.ibm.team.scm.client.internal.WorkspaceConnection;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.InvalidAuthenticationTokenException;
import com.ibm.team.scm.common.WorkspaceComparisonFlags;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemConflictReport;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.ISynchronizationTimes;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.dto.ComponentStateSummary;
import com.ibm.team.scm.common.internal.dto.RemoteRepoDescriptor;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.SyncTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemServiceProxy {
    private IClientLibraryContext clientLibraryContext;
    private int cachedCompatabilityLevel;
    private static final int MAX_CHANGESETS_TO_INTERPRET = 1024;

    public FileSystemServiceProxy(IClientLibraryContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.clientLibraryContext = context;
        this.cachedCompatabilityLevel = -1;
    }

    private IFilesystemService getServerFilesystemService() throws TeamRepositoryException {
        IFilesystemService service = (IFilesystemService)this.clientLibraryContext.getServiceInterface(IFilesystemService.class);
        if (service == null) {
            NotLoggedInException e = new NotLoggedInException();
            e.setOrigin((Object)this.clientLibraryContext.teamRepository());
            throw e;
        }
        return service;
    }

    public List getBlame(IConnection connection, IComponentHandle component, IFileItemHandle fileItemHandle, IChangeSetHandle changeSetHandle, ISynchronizationInfo synchronizationInfo, IProgressMonitor progress) throws TeamRepositoryException {
        IChangeSetHandle[] results;
        ThreadCheck.checkLongOpsAllowed();
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        boolean isWorkspaceContext = connection instanceof IWorkspaceConnection;
        if (component == null && isWorkspaceContext) {
            throw new IllegalArgumentException();
        }
        if (fileItemHandle == null) {
            throw new IllegalArgumentException();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        try {
            try {
                ISynchronizationTimes[] syncTimes = synchronizationInfo == null ? null : synchronizationInfo.getSyncTimes();
                IRepositoryProgressMonitor progressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)monitor);
                results = isWorkspaceContext ? this.getServerFilesystemService().getBlameWS((IWorkspaceHandle)((IWorkspaceConnection)connection).getResolvedWorkspace(), component, fileItemHandle, changeSetHandle, syncTimes, progressMonitor) : this.getServerFilesystemService().getBlame(((IBaselineConnection)connection).getBaseline(), fileItemHandle, changeSetHandle, syncTimes, progressMonitor);
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(connection, e);
            }
        }
        finally {
            monitor.done();
        }
        return Collections.unmodifiableList(Arrays.asList(results));
    }

    public FileAreaUpdateReport incrementalFileLoadStream(IWorkspaceConnection workspaceConnection, IUpdateReport delta, Collection<IComponentHandle> excludedComponents, Collection<SharePoint> currentSharePoints, boolean includeFileContents, int updatesToProcess, ISynchronizationInfo synchronizationInfo, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        ThreadCheck.checkLongOpsAllowed();
        if (delta == null) {
            throw new IllegalArgumentException();
        }
        if (excludedComponents == null) {
            throw new IllegalArgumentException();
        }
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        if (currentSharePoints == null) {
            throw new IllegalArgumentException();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)1000);
        IComponentHandle[] exclusions = excludedComponents.toArray(new IComponentHandle[excludedComponents.size()]);
        SharePoint[] sharePoints = currentSharePoints.toArray(new SharePoint[currentSharePoints.size()]);
        ISynchronizationTimes[] syncTimes = synchronizationInfo == null ? null : synchronizationInfo.getSyncTimes();
        int serverLevel = this.getCompatabilityLevel(false, (IProgressMonitor)monitor.newChild(1));
        IRepositoryProgressMonitor progressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)monitor);
        try {
            FileAreaUpdateReport result = serverLevel == 2 ? this.getServerFilesystemService().incrementalFileLoadStream2((IWorkspaceHandle)workspaceConnection.getResolvedWorkspace(), delta, exclusions, sharePoints, includeFileContents, updatesToProcess, syncTimes, progressMonitor) : this.getServerFilesystemService().incrementalFileLoadStream((IWorkspaceHandle)workspaceConnection.getResolvedWorkspace(), delta, exclusions, sharePoints, includeFileContents, updatesToProcess, syncTimes, progressMonitor);
            FileAreaUpdateReport fileAreaUpdateReport = result;
            return fileAreaUpdateReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails((IConnection)workspaceConnection, e);
        }
        finally {
            monitor.done();
        }
    }

    public ILogicalConflictReport interpretConflicts(IWorkspaceConnection workspaceConnection, Collection itemUpdateReports, ISynchronizationInfo synchronizationInfo, IProgressMonitor progress) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        if (itemUpdateReports == null) {
            throw new IllegalArgumentException();
        }
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        for (Object next : itemUpdateReports) {
            if (!(next instanceof IItemConflictReport)) {
                throw new IllegalArgumentException();
            }
            IItemConflictReport updateReport = (IItemConflictReport)next;
            if (updateReport.getComponent() != null) continue;
            throw new IllegalArgumentException();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        ISynchronizationTimes[] syncTimes = synchronizationInfo == null ? null : synchronizationInfo.getSyncTimes();
        IRepositoryProgressMonitor progressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)monitor);
        try {
            ILogicalConflictReport iLogicalConflictReport = this.getServerFilesystemService().interpretConflicts((IWorkspaceHandle)workspaceConnection.getResolvedWorkspace(), itemUpdateReports.toArray(new IItemConflictReport[itemUpdateReports.size()]), syncTimes, progressMonitor);
            return iLogicalConflictReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails((IConnection)workspaceConnection, e);
        }
        finally {
            monitor.done();
        }
    }

    public LoadTree getFileTreeByVersionable(IConnection connection, IComponentHandle root, IVersionableHandle[] versionableHandles, int depth, boolean includeFileContents, ISynchronizationInfo synchronizationInfo, IProgressMonitor progress) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (root == null) {
            throw new IllegalArgumentException();
        }
        if (versionableHandles == null) {
            throw new IllegalArgumentException();
        }
        HashMap<UUID, IVersionableHandle> handles = new HashMap<UUID, IVersionableHandle>();
        IVersionableHandle[] iVersionableHandleArray = versionableHandles;
        int n = versionableHandles.length;
        int n2 = 0;
        while (n2 < n) {
            IVersionableHandle handle = iVersionableHandleArray[n2];
            if (handle == null) {
                throw new IllegalArgumentException();
            }
            handles.put(handle.getItemId(), handle);
            ++n2;
        }
        IVersionableHandle[] toRetrieve = handles.values().toArray(new IVersionableHandle[handles.size()]);
        if (depth < -1 || depth > 1) {
            throw new IllegalArgumentException();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)1000);
        try {
            ISynchronizationTimes[] syncTimes = synchronizationInfo == null ? null : synchronizationInfo.getSyncTimes();
            int serverLevel = this.getCompatabilityLevel(false, (IProgressMonitor)monitor.newChild(1));
            IRepositoryProgressMonitor progressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)monitor);
            LoadTree result = serverLevel == 2 ? this.getServerFilesystemService().getFileTreeByVersionable2(connection.getContextHandle(), root, toRetrieve, depth, includeFileContents, syncTimes, progressMonitor) : this.getServerFilesystemService().getFileTreeByVersionable(connection.getContextHandle(), root, toRetrieve, depth, includeFileContents, syncTimes, progressMonitor);
            LoadTree loadTree = result;
            return loadTree;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(connection, e);
        }
        finally {
            monitor.done();
        }
    }

    public List applyAccepted(IWorkspaceConnection workspaceConnection, Collection conflicts, Collection conflictResolutions, IProgressMonitor progress) throws TeamRepositoryException {
        if (conflicts == null) {
            throw new IllegalArgumentException();
        }
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
        ConflictResolutionReport report = null;
        List updateReports = null;
        try {
            try {
                IRepositoryProgressMonitor progressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)monitor.newChild(95));
                report = this.getServerFilesystemService().applyAccepted((IWorkspaceHandle)workspaceConnection.getResolvedWorkspace(), conflicts.toArray(new ILogicalChange[conflicts.size()]), conflictResolutions.toArray(new ConflictResolution[conflictResolutions.size()]), null, progressMonitor);
                updateReports = this.notifyCommitsPerformed(workspaceConnection, report, (IProgressMonitor)monitor.newChild(5));
            }
            catch (TeamRepositoryException e2) {
                ItemNotFoundException e2;
                if (e2.getData() instanceof ConflictResolutionReport) {
                    report = (ConflictResolutionReport)e2.getData();
                    this.notifyCommitsPerformed(workspaceConnection, report, (IProgressMonitor)monitor.newChild(5));
                } else if (e2 instanceof ItemNotFoundException) {
                    e2 = this.expandItemNotFoundDetails((IConnection)workspaceConnection, (ItemNotFoundException)((Object)e2));
                }
                throw e2;
            }
        }
        finally {
            monitor.done();
        }
        return Collections.unmodifiableList(updateReports);
    }

    public List markAsMerged(IWorkspaceConnection workspaceConnection, Collection logicalConflicts, IProgressMonitor monitor) throws TeamRepositoryException {
        if (logicalConflicts == null) {
            throw new IllegalArgumentException();
        }
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ConflictResolutionReport report = null;
        List updateReports = null;
        try {
            try {
                IRepositoryProgressMonitor progressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)progress.newChild(95));
                report = this.getServerFilesystemService().markAsMerged((IWorkspaceHandle)workspaceConnection.getResolvedWorkspace(), logicalConflicts.toArray(new ILogicalChange[logicalConflicts.size()]), null, progressMonitor);
                updateReports = this.notifyCommitsPerformed(workspaceConnection, report, (IProgressMonitor)progress.newChild(5));
            }
            catch (TeamRepositoryException e2) {
                ItemNotFoundException e2;
                if (e2.getData() instanceof ConflictResolutionReport) {
                    report = (ConflictResolutionReport)e2.getData();
                    this.notifyCommitsPerformed(workspaceConnection, report, (IProgressMonitor)progress.newChild(5));
                } else if (e2 instanceof ItemNotFoundException) {
                    e2 = this.expandItemNotFoundDetails((IConnection)workspaceConnection, (ItemNotFoundException)((Object)e2));
                }
                throw e2;
            }
        }
        finally {
            progress.done();
        }
        return Collections.unmodifiableList(updateReports);
    }

    private List notifyCommitsPerformed(IWorkspaceConnection workspaceConnection, ConflictResolutionReport report, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IUpdateReport> updateReports = new ArrayList<IUpdateReport>(report.getResolutions().size());
        ArrayList changeSets = new ArrayList(report.getResolutions().size());
        for (Resolution resolution : report.getResolutions()) {
            updateReports.add(resolution.getUpdateReport());
            changeSets.addAll(resolution.getChangeSet());
        }
        ((WorkspaceConnection)workspaceConnection).committedWork(changeSets, updateReports.toArray(new IUpdateReport[updateReports.size()]), monitor);
        return updateReports;
    }

    public List interpretChanges(IConnection connection, List changeSets, ISynchronizationInfo synchronizationInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        if (changeSets == null) {
            throw new IllegalArgumentException();
        }
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)changeSets.size());
        try {
            if (changeSets.isEmpty()) {
                List list = Collections.emptyList();
                return list;
            }
            ISynchronizationTimes[] syncTimes = synchronizationInfo == null ? null : synchronizationInfo.getSyncTimes();
            IRepositoryProgressMonitor progressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor);
            IChangeSetHandle[] changeSetsToInterpret = new IChangeSetHandle[Math.min(1024, changeSets.size())];
            int j = 0;
            ArrayList<IChangeSetSummary> result = null;
            ListIterator i = changeSets.listIterator();
            while (i.hasNext()) {
                Object next = i.next();
                if (next == null) {
                    throw new IllegalArgumentException();
                }
                if (!(next instanceof IChangeSetHandle)) {
                    throw new IllegalArgumentException();
                }
                changeSetsToInterpret[j] = (IChangeSetHandle)next;
                if (++j != changeSetsToInterpret.length) continue;
                IChangeSetSummary[] summaries = this.getServerFilesystemService().interpretChanges(connection.getContextHandle(), changeSetsToInterpret, syncTimes, progressMonitor);
                if (result == null) {
                    if (!i.hasNext()) {
                        List<IChangeSetSummary> list = Collections.unmodifiableList(Arrays.asList(summaries));
                        return list;
                    }
                    result = new ArrayList<IChangeSetSummary>(changeSets.size());
                }
                result.addAll(Arrays.asList(summaries));
                progress.worked(j);
                int numRemaining = changeSets.size() - i.nextIndex();
                if (numRemaining < j) {
                    changeSetsToInterpret = new IChangeSetHandle[numRemaining];
                }
                j = 0;
            }
            List list = Collections.unmodifiableList(result);
            return list;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails(connection, e);
        }
        finally {
            progress.done();
        }
    }

    public ILogicalConflictReport conflictReport(IWorkspaceConnection workspaceConnection, ISynchronizationInfo synchronizationInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        try {
            ISynchronizationTimes[] syncTimes = synchronizationInfo == null ? null : synchronizationInfo.getSyncTimes();
            IRepositoryProgressMonitor progressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)progress);
            ILogicalConflictReport iLogicalConflictReport = this.getServerFilesystemService().conflictReport((IWorkspaceHandle)workspaceConnection.getResolvedWorkspace(), syncTimes, progressMonitor);
            return iLogicalConflictReport;
        }
        catch (ItemNotFoundException e) {
            throw this.expandItemNotFoundDetails((IConnection)workspaceConnection, e);
        }
        finally {
            progress.done();
        }
    }

    public List<OverlapResponse> detectOverlap(List<OverlapRequest> overlapRequests, ISynchronizationInfo synchronizationInfo, IProgressMonitor monitor) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        if (overlapRequests == null) {
            throw new IllegalArgumentException();
        }
        for (OverlapRequest request : overlapRequests) {
            if (request != null) continue;
            throw new IllegalArgumentException();
        }
        if (overlapRequests.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        try {
            ISynchronizationTimes[] syncTimes = synchronizationInfo == null ? null : synchronizationInfo.getSyncTimes();
            IRepositoryProgressMonitor progressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)progress);
            OverlapRequest[] request = new OverlapRequest[overlapRequests.size()];
            request = overlapRequests.toArray(request);
            OverlapResponse[] response = this.getServerFilesystemService().detectOverlap(request, syncTimes, progressMonitor);
            List<OverlapResponse> list = Collections.unmodifiableList(Arrays.asList(response));
            return list;
        }
        finally {
            progress.done();
        }
    }

    public List<IComponentStateSummary> getComponentStateSummaries(IConnection connection, IProgressMonitor monitor) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (connection instanceof IWorkspaceConnection) {
            try {
                IRepositoryProgressMonitor progressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)progress);
                IComponentStateSummary[] response = this.getServerFilesystemService().getComponentStateSummaries(connection.getContextHandle(), progressMonitor);
                List<IComponentStateSummary> list = Collections.unmodifiableList(Arrays.asList(response));
                return list;
            }
            catch (ItemNotFoundException e) {
                throw this.expandItemNotFoundDetails(connection, e);
            }
            finally {
                progress.done();
            }
        }
        if (connection instanceof IBaselineConnection) {
            IBaselineConnection baselineConnection = (IBaselineConnection)connection;
            ComponentStateSummary summary = ScmDtoFactory.eINSTANCE.createComponentStateSummary();
            summary.setComponent(baselineConnection.getComponent());
            ISyncTime syncTime = ISyncTime.FACTORY.getConfigTimeFor((IBaselineHandle)baselineConnection.getResolvedBaseline(), null);
            long value = ((SyncTime)syncTime).getValue();
            summary.setConfigurationState(value);
            summary.setChangeHistoryState(value);
            return Collections.singletonList(summary);
        }
        throw new IllegalArgumentException();
    }

    private ItemNotFoundException expandItemNotFoundDetails(IConnection connection, ItemNotFoundException e) {
        if (e.getData() instanceof IItemHandle && ((IItemHandle)e.getData()).sameItemId((IItemHandle)connection.getContextHandle())) {
            String improvedMessage = null;
            if (connection instanceof IWorkspaceConnection) {
                improvedMessage = NLS.bind((String)Messages.FileSystemServiceProxy_0, (Object)((IWorkspaceConnection)connection).getResolvedWorkspace().getName(), (Object[])new Object[0]);
            } else if (connection instanceof IBaselineConnection) {
                improvedMessage = NLS.bind((String)Messages.FileSystemServiceProxy_1, (Object)((IBaselineConnection)connection).getResolvedBaseline().getComment(), (Object[])new Object[]{((IBaselineConnection)connection).getResolvedBaseline().getCreationDate()});
            }
            if (improvedMessage != null) {
                ItemNotFoundException newException = new ItemNotFoundException(improvedMessage, (IItemHandle)e.getData());
                if (e.getStackTrace() != null) {
                    newException.setStackTrace(e.getStackTrace());
                }
                e = newException;
            }
        }
        return e;
    }

    public IWorkspaceCompareReport compareAsWorkspaces(IWorkspaceConnection local, IWorkspaceConnection remote, int compareFlags, List<IComponentHandle> componentFilter, IProgressMonitor monitor) throws TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (local == null) {
            throw new IllegalArgumentException();
        }
        if (remote == null) {
            throw new IllegalArgumentException();
        }
        if (!WorkspaceComparisonFlags.isValid((int)compareFlags)) {
            throw new IllegalArgumentException();
        }
        if (componentFilter == null) {
            throw new IllegalArgumentException();
        }
        IComponentHandle[] filter = null;
        for (IComponentHandle comp : componentFilter) {
            if (comp != null) continue;
            throw new IllegalArgumentException();
        }
        filter = componentFilter.toArray(new IComponentHandle[componentFilter.size()]);
        boolean retry = true;
        while (true) {
            RemoteRepoDescriptor remoteDescriptor = null;
            if (!local.sameRepository((IConnection)remote)) {
                ITeamRepository remoteRepo = remote.teamRepository();
                remoteDescriptor = RemoteRepoDescriptorUtils.getRemoteDescriptor((ITeamRepository)remoteRepo, (IProgressMonitor)progress.newChild(20));
            }
            IRepositoryProgressMonitor progressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)progress);
            try {
                IWorkspaceCompareReport r = this.getServerFilesystemService().compareWorkspaces((IWorkspaceHandle)local.getResolvedWorkspace(), (IWorkspaceHandle)remote.getResolvedWorkspace(), remoteDescriptor, filter, compareFlags, progressMonitor);
                progress.done();
                return r;
            }
            catch (ItemNotFoundException e) {
                e = this.expandItemNotFoundDetails((IConnection)local, e);
                e = this.expandItemNotFoundDetails((IConnection)remote, e);
                throw e;
            }
            catch (InvalidAuthenticationTokenException e) {
                if (!retry) {
                    throw e;
                }
                retry = false;
                RemoteRepoDescriptorUtils.resetRemoteDescriptor((ITeamRepository)remote.teamRepository());
                progress.setWorkRemaining(100);
                continue;
            }
            break;
        }
    }

    int getCompatabilityLevel(boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.cachedCompatabilityLevel < 0 || refresh) {
            ThreadCheck.checkLongOpsAllowed();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
            IRepositoryProgressMonitor progressMonitor = IRepositoryProgressMonitor.ITEM_FACTORY.createItem((IProgressMonitor)progress);
            this.cachedCompatabilityLevel = this.getServerFilesystemService().getCompatabilityLevel(progressMonitor);
        }
        return this.cachedCompatabilityLevel;
    }

    public boolean serverSupportsSymbolicLinks(IProgressMonitor progress) throws TeamRepositoryException {
        return this.getCompatabilityLevel(false, progress) >= 2;
    }
}

