/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.client.IFileSystemManager;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemView;
import com.ibm.team.filesystem.client.internal.content.FileContentManager;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.internal.ScmClientLibraryContext;
import org.eclipse.core.runtime.IProgressMonitor;

public class FileSystemManager
implements IFileSystemManager {
    private final IClientLibraryContext context;
    private final FileContentManager cm;

    public FileSystemManager(IClientLibraryContext context) {
        this.context = new ScmClientLibraryContext(context);
        this.cm = new FileContentManager(context);
    }

    public FileSystemServiceProxy getFileSystemService() {
        return new FileSystemServiceProxy(this.context);
    }

    public IFileSystemView getFileSystemView(IConnection connection) {
        return new FileSystemView(new FileSystemServiceProxy(this.context), connection);
    }

    public int getFileSystemServiceCompatabilityLevel(IProgressMonitor progress) throws TeamRepositoryException {
        return this.getFileSystemService().getCompatabilityLevel(false, progress);
    }

    public IFileContentManager getContentManager() {
        return this.cm;
    }

    public boolean serverSupportsSymbolicLinks(IProgressMonitor progress) throws TeamRepositoryException {
        return this.getFileSystemService().serverSupportsSymbolicLinks(progress);
    }
}

