/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileStorage;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IFileStorageVisitor;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.operations.BackupDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileStorageWrapper
implements IFileStorage {
    private final Shareable shareable;
    private final ResourceType resourceTypeHint;
    private FileStorage underlyingStorage = null;
    protected IFileStorage parent;

    public FileStorageWrapper(Shareable shareable, ResourceType resourceTypeHint) {
        this.shareable = shareable;
        this.resourceTypeHint = resourceTypeHint;
        shareable.setFileStorage(this);
        this.parent = null;
    }

    public FileStorageWrapper(Shareable shareable, IFileStorage parent, ResourceType resourceTypeHint) {
        this.shareable = shareable;
        this.resourceTypeHint = resourceTypeHint;
        this.parent = parent;
        shareable.setFileStorage(this);
    }

    public FileStorageWrapper(ISandbox sandbox, IPath localPath, ResourceType resourceTypeHint) {
        this.shareable = new Shareable(sandbox, localPath, resourceTypeHint);
        this.shareable.setFileStorage(this);
        this.resourceTypeHint = resourceTypeHint;
    }

    private FileStorage getUnderlyingStorage() {
        if (this.underlyingStorage == null) {
            if (this.parent == null || ((FileStorageWrapper)this.parent).underlyingStorage == null) {
                SharingManager.getInstance().resolveFileStorage(this, this.resourceTypeHint);
            } else {
                ((FileStorageWrapper)this.parent).underlyingStorage.resolveChildStorage(this, this.shareable.getLocalPath().lastSegment(), this.resourceTypeHint);
            }
        }
        return this.underlyingStorage;
    }

    @Override
    public final boolean isContentChangedFrom(FileItemInfo info, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.beginTask(Messages.FileStorage_0, 100);
        if (info.getContentLength() != this.getSize((IProgressMonitor)progress.newChild(50))) {
            progress.done();
            return true;
        }
        if (info.getLastContentChangeCheckStamp() != -1L && info.getLastContentChangeCheckStamp() == this.getModificationStamp()) {
            progress.done();
            return info.isContentChanged();
        }
        InputStream in = this.getContents(true);
        try {
            ContentHash newHash = ContentHash.valueOf((InputStream)in);
            in.close();
            in = null;
            boolean isSame = info.getHash().equals((Object)newHash);
            progress.done();
            boolean bl = !isSame;
            return bl;
        }
        catch (ContentHashAlgorithmException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.FileStorage_1, (Throwable)e));
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.FileStorage_1, (Throwable)e));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LoggingHelper.error("com.ibm.team.filesystem.client", Messages.FileStorage_2, e);
                }
                catch (RuntimeException e) {
                    LoggingHelper.error("com.ibm.team.filesystem.client", Messages.FileStorage_2, e);
                }
            }
        }
    }

    @Override
    public final IFileStorage getParent() {
        if (this.parent == null) {
            if (this.shareable.getLocalPath().segmentCount() < 2) {
                return null;
            }
            if (this.underlyingStorage != null) {
                this.parent = this.underlyingStorage.getParent();
            } else {
                IPath parentPath = this.shareable.getLocalPath().removeLastSegments(1);
                Shareable parentShareable = new Shareable(this.shareable.getSandbox(), parentPath, ResourceType.FOLDER);
                this.parent = parentShareable.getFileStorage();
            }
        }
        return this.parent;
    }

    @Override
    public boolean supportsExecBit() {
        return this.getUnderlyingStorage().supportsExecBit();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean setExecutable(boolean exec, IProgressMonitor monitor) {
        if (this.getUnderlyingStorage().supportsExecBit()) {
            return this.getUnderlyingStorage().setExecutable(exec, monitor);
        }
        Shareable shareable = this.getShareable();
        ICopyFileAreaLockRequest request = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(Collections.singleton(shareable));
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            ICopyFileAreasLock lock = ICopyFileAreaManager.instance.lock(Collections.singleton(request), (IProgressMonitor)progress.newChild(15));
            try {
                if (shareable.getShare((IProgressMonitor)progress.newChild(10)) == null) {
                    return false;
                }
                ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(shareable.getSandbox().getRoot());
                FileItemInfo info = cfa.getItemInfo(shareable.getLocalPath());
                if (info == null) {
                    return false;
                }
                if (exec == info.isExecutable()) return true;
                FileItemInfoProxy proxy = new FileItemInfoProxy(info);
                proxy.setExecutable(info.isOriginalExecutable(), exec);
                info = proxy.getFileItemInfo();
                cfa.setItemMetaData(shareable.getLocalPath(), info, (IProgressMonitor)progress.newChild(50));
                return true;
            }
            finally {
                lock.release((IProgressMonitor)progress.newChild(25));
            }
        }
        catch (Exception e) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(e));
            return false;
        }
    }

    @Override
    public boolean isExecutable(IProgressMonitor monitor) throws FileSystemClientException {
        if (this.getUnderlyingStorage().supportsExecBit()) {
            return this.getUnderlyingStorage().isExecutable(monitor);
        }
        FileItemInfo info = this.getShareable().getFileItemInfo(monitor);
        return info == null ? false : info.isExecutable();
    }

    @Override
    public boolean shouldBeIgnored(IProgressMonitor monitor) throws FileSystemClientException {
        return this.getUnderlyingStorage().shouldBeIgnored(monitor);
    }

    @Override
    public final Shareable getShareable() {
        return this.shareable;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void accept(IFileStorageVisitor visitor, int depth, IProgressMonitor progress) throws FileSystemClientException {
        mon = SubMonitor.convert((IProgressMonitor)progress, (int)20);
        this.getUnderlyingStorage().lock((IProgressMonitor)mon.newChild(1));
        try {
            block9: {
                if (depth == 0) {
                    visitor.visit(this, (IProgressMonitor)mon);
lbl7:
                    // 3 sources

                    return;
                }
                if (depth != 1) break block9;
                if (!visitor.visit(this, (IProgressMonitor)mon.newChild(1)) || (children = this.getChildren((IProgressMonitor)mon.newChild(1))) == null) ** GOTO lbl7
                mon.setWorkRemaining(children.size());
                var7_7 = children.iterator();
                while (true) {
                    if (var7_7.hasNext()) ** break;
                    ** continue;
                    child = var7_7.next();
                    child.accept(visitor, 0, (IProgressMonitor)mon.newChild(1));
                }
            }
            toVisit = new LinkedList<IFileStorage>();
            toVisit.add(this);
            while ((storage = (IFileStorage)toVisit.poll()) != null) {
                descend = visitor.visit(storage, (IProgressMonitor)mon);
                if (!descend || (children = storage.getChildren((IProgressMonitor)mon.newChild(1))) == null) continue;
                toVisit.addAll(children);
            }
        }
        finally {
            this.getUnderlyingStorage().unlock();
        }
    }

    @Override
    public boolean requiresBackup(IProgressMonitor monitor) throws FileSystemClientException {
        return this.getUnderlyingStorage().requiresBackup(monitor);
    }

    @Override
    public final String getName() {
        return this.shareable.getLocalPath().lastSegment();
    }

    private final ManagedFileStore getFileStore() {
        return new ManagedFileStore(this.shareable.getCopyFileAreaRoot(), this.shareable.getLocalPath(), EFS.getLocalFileSystem().getStore(this.shareable.getFullPath()));
    }

    @Override
    public void create(String target, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        if (ManagedFileStore.supportsSymLinks()) {
            try {
                this.getFileStore().symlink(target, (IProgressMonitor)monitor.newChild(80));
                this.refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(20));
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_7, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{target.toString()}), (Throwable)e));
            }
        }
    }

    @Override
    public boolean exists(IProgressMonitor progress) throws FileSystemClientException {
        ManagedFileStore fileStorage = this.getFileStore();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        try {
            File localFile = fileStorage.toLocalFile(0, (IProgressMonitor)monitor.newChild(1));
            if (localFile != null && localFile.exists()) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            IFileInfo fileInfo = fileStorage.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
            boolean bl = fileInfo.getAttribute(32) || fileInfo.exists();
            return bl;
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_0, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e));
        }
        finally {
            sm.enableChangeMonitoring();
        }
    }

    @Override
    public long getSize(IProgressMonitor progress) throws FileSystemClientException {
        ManagedFileStore fileStorage = this.getFileStore();
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            IFileInfo fileInfo = fileStorage.fetchInfo(0, progress);
            if (!fileInfo.exists() || fileInfo.isDirectory() || fileInfo.getAttribute(32)) {
                return -1L;
            }
            long l = fileInfo.getLength();
            return l;
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_1, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e));
        }
        finally {
            sm.enableChangeMonitoring();
        }
    }

    @Override
    public boolean isFile(IProgressMonitor progress) throws FileSystemClientException {
        ManagedFileStore fileStorage = this.getFileStore();
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            IFileInfo fileInfo = fileStorage.fetchInfo(0, progress);
            boolean bl = fileInfo.exists() && !fileInfo.isDirectory() && !fileInfo.getAttribute(32);
            return bl;
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_2, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e));
        }
        finally {
            sm.enableChangeMonitoring();
        }
    }

    @Override
    public boolean isFolder(IProgressMonitor progress) throws FileSystemClientException {
        ManagedFileStore fileStorage = this.getFileStore();
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            IFileInfo fileInfo = fileStorage.fetchInfo(0, progress);
            boolean bl = fileInfo.isDirectory() && !fileInfo.getAttribute(32);
            return bl;
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_3, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e));
        }
        finally {
            sm.enableChangeMonitoring();
        }
    }

    @Override
    public final boolean isSymbolicLink(IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ManagedFileStore fileStorage = this.getFileStore();
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            IFileInfo fileInfo = fileStorage.fetchInfo(0, (IProgressMonitor)progress.newChild(100));
            boolean bl = fileInfo.getAttribute(32);
            return bl;
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_4, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e));
        }
        finally {
            sm.enableChangeMonitoring();
        }
    }

    @Override
    public final ResourceType getResourceType(IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ManagedFileStore fileStorage = this.getFileStore();
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            IFileInfo fileInfo = fileStorage.fetchInfo(0, (IProgressMonitor)monitor.newChild(100));
            if (fileInfo.getAttribute(32)) {
                ResourceType resourceType = ResourceType.SYMBOLIC_LINK;
                return resourceType;
            }
            if (fileInfo.isDirectory()) {
                ResourceType resourceType = ResourceType.FOLDER;
                return resourceType;
            }
            if (fileInfo.exists()) {
                ResourceType resourceType = ResourceType.FILE;
                return resourceType;
            }
            return null;
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_13, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e));
        }
        finally {
            sm.enableChangeMonitoring();
        }
    }

    @Override
    public boolean isReadOnly(IProgressMonitor progress) throws FileSystemClientException {
        ManagedFileStore fileStorage = this.getFileStore();
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            IFileInfo fileInfo = fileStorage.fetchInfo(0, progress);
            boolean bl = fileInfo.getAttribute(2);
            return bl;
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_5, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e));
        }
        finally {
            sm.enableChangeMonitoring();
        }
    }

    @Override
    public void setTarget(Shed backupShed, String targetPath, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        IFileInfo info;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        this.getParent();
        ManagedFileStore fileStorage = this.getFileStore();
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            try {
                info = fileStorage.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_8, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{targetPath.toString()}), (Throwable)e));
            }
        }
        finally {
            sm.enableChangeMonitoring();
        }
        if (!info.getAttribute(32)) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_11, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{targetPath.toString()}), null));
        }
        backupShed.backupIfDirty(this.shareable, (IProgressMonitor)monitor.newChild(9));
        try {
            fileStorage.delete(0, (IProgressMonitor)monitor.newChild(35));
            fileStorage.symlink(targetPath, (IProgressMonitor)monitor.newChild(35));
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_8, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[]{targetPath.toString()}), (Throwable)e));
        }
        this.refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(20));
    }

    @Override
    public String getTarget(IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ManagedFileStore fileStorage = this.getFileStore();
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            IFileInfo info = fileStorage.fetchInfo(0, (IProgressMonitor)monitor.newChild(10));
            if (!info.getAttribute(32)) {
                return null;
            }
            String string = info.getStringAttribute(64);
            return string;
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_12, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e));
        }
        finally {
            sm.enableChangeMonitoring();
        }
    }

    @Override
    public void backup(Shed shed, BackupDilemmaHandler dilemmaHandler, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        this.getUnderlyingStorage().backup(shed, dilemmaHandler, monitor);
    }

    @Override
    public void create(InputStream in, IProgressMonitor monitor) throws FileSystemClientException {
        this.getUnderlyingStorage().create(in, monitor);
    }

    @Override
    public void create(boolean createParents, IProgressMonitor progress) throws FileSystemClientException {
        this.getUnderlyingStorage().create(createParents, progress);
    }

    @Override
    public void delete(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        IFileInfo fileInfo;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ManagedFileStore fileStorage = this.getFileStore();
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            try {
                fileInfo = fileStorage.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_9, (Object)this.shareable.getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e));
            }
        }
        finally {
            sm.enableChangeMonitoring();
        }
        if (fileInfo.getAttribute(32)) {
            this.getUnderlyingStorage().delete((IProgressMonitor)progress.newChild(99));
        } else if (fileInfo.isDirectory()) {
            Collection<IFileStorage> children = this.getChildren((IProgressMonitor)progress.newChild(1));
            progress.setWorkRemaining(children.size() * 10 + 10);
            for (IFileStorage child : children) {
                child.delete((IProgressMonitor)progress.newChild(10));
            }
            this.getUnderlyingStorage().delete((IProgressMonitor)progress.newChild(10));
        } else {
            this.getUnderlyingStorage().delete((IProgressMonitor)progress.newChild(99));
        }
    }

    @Override
    public void delete(Shed backupShed, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        backupShed.backupIfDirty(this.shareable, (IProgressMonitor)progress.newChild(10));
        this.delete((IProgressMonitor)progress.newChild(90));
    }

    @Override
    public void deregisterRepositoryProvider(IProgressMonitor monitor) throws FileSystemClientException {
        this.getUnderlyingStorage().deregisterRepositoryProvider(monitor);
    }

    @Override
    public String getActualName() {
        return this.getUnderlyingStorage().getActualName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IFileStorage getChild(String name, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ManagedFileStore fileStorage = this.getFileStore();
        SharingManager sm = SharingManager.getInstance();
        sm.disableChangeMonitoring();
        try {
            ResourceType childType;
            IFileInfo fileInfo = fileStorage.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
            if (!fileInfo.isDirectory()) return null;
            if (fileInfo.getAttribute(32)) {
                return null;
            }
            IFileInfo childInfo = null;
            if (this.shareable.getSandbox().isCaseSensitive()) {
                IFileStore potentialChild = fileStorage.getChild(name);
                childInfo = potentialChild.fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
            } else {
                String[] potentialChildren;
                String caseInsensitiveName = name.toUpperCase().toLowerCase();
                String[] stringArray = potentialChildren = fileStorage.childNames(0, (IProgressMonitor)monitor.newChild(1));
                int n = potentialChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    String potentialChild = stringArray[n2];
                    if (potentialChild.length() == caseInsensitiveName.length() && potentialChild.toUpperCase().toLowerCase().equals(caseInsensitiveName)) {
                        childInfo = fileStorage.getChild(potentialChild).fetchInfo(0, (IProgressMonitor)monitor.newChild(1));
                        break;
                    }
                    ++n2;
                }
            }
            if (childInfo == null) {
                return null;
            }
            IPath childPath = this.shareable.getLocalPath().append(childInfo.getName());
            if (childInfo.getAttribute(32)) {
                childType = ResourceType.SYMBOLIC_LINK;
            } else {
                if (!childInfo.exists()) {
                    return null;
                }
                childType = childInfo.isDirectory() ? ResourceType.FOLDER : ResourceType.FILE;
            }
            Shareable childShareable = new Shareable(this.shareable.getSandbox(), childPath, childType);
            FileStorageWrapper fileStorageWrapper = new FileStorageWrapper(childShareable, this, childType);
            return fileStorageWrapper;
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_6, (Object)name, (Object[])new Object[]{this.shareable.getLocalPath().toString()}), (Throwable)e));
        }
        finally {
            sm.enableChangeMonitoring();
        }
    }

    @Override
    public Collection<IFileStorage> getChildren(IProgressMonitor progress) throws FileSystemClientException {
        return this.getUnderlyingStorage().getChildren(progress);
    }

    @Override
    public InputStream getContents() throws FileSystemClientException {
        return this.getUnderlyingStorage().getContents();
    }

    @Override
    public InputStream getContents(boolean force) throws FileSystemClientException {
        return this.getUnderlyingStorage().getContents(force);
    }

    @Override
    public IPath getIDEPath() {
        return this.getUnderlyingStorage().getIDEPath();
    }

    @Override
    public long getLocalTimeStamp() {
        return this.getUnderlyingStorage().getLocalTimeStamp();
    }

    @Override
    public URI getLocationURI() {
        return this.getUnderlyingStorage().getLocationURI();
    }

    @Override
    public long getModificationStamp() {
        return this.getUnderlyingStorage().getModificationStamp();
    }

    @Override
    public ISchedulingRule getResourceRuleForIDE(ISharingManager.RuleKind kind) {
        return this.getUnderlyingStorage().getResourceRuleForIDE(kind);
    }

    @Override
    public boolean isRepositoryProviderRegistered(IProgressMonitor monitor) throws FileSystemClientException {
        return this.getUnderlyingStorage().isRepositoryProviderRegistered(monitor);
    }

    @Override
    public void move(ISandbox sandbox, IPath relativeDestination, IProgressMonitor monitor) throws FileSystemClientException {
        if (!sandbox.equals(this.getShareable().getSandbox())) {
            throw new IllegalArgumentException();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ResourceType resourceType = this.getResourceType((IProgressMonitor)progress.newChild(1));
        if (resourceType == null) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.FileStorageWrapper_14, (Object)this.getShareable().getLocalPath().toOSString(), (Object[])new Object[0]), null));
        }
        FileStorage source = this.getUnderlyingStorage();
        ResourceType targetHint = resourceType;
        if (resourceType == ResourceType.SYMBOLIC_LINK) {
            targetHint = this.getShareable().getFullPath().toFile().isDirectory() ? ResourceType.FOLDER : ResourceType.FILE;
        }
        Shareable targetShareable = new Shareable(sandbox, relativeDestination, targetHint);
        FileStorageWrapper targetStorage = new FileStorageWrapper(targetShareable, targetHint);
        SharingManager.getInstance().resolveFileStorage(targetStorage, targetHint);
        FileStorage target = targetStorage.underlyingStorage;
        source.move(target, monitor);
    }

    @Override
    public void preserveHistory(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.isFile((IProgressMonitor)progress.newChild(1))) {
            this.getUnderlyingStorage().preserveHistory((IProgressMonitor)progress.newChild(99));
        }
    }

    @Override
    public void refreshCachedSubTree(int depth, IProgressMonitor monitor) throws FileSystemClientException {
        this.getUnderlyingStorage().refreshCachedSubTree(depth, monitor);
    }

    @Override
    public void registerRepositorProvider(IProgressMonitor monitor) throws FileSystemClientException {
        this.getUnderlyingStorage().registerRepositorProvider(monitor);
    }

    @Override
    public void setContents(InputStream in, boolean force, IProgressMonitor monitor) throws FileSystemClientException {
        this.getUnderlyingStorage().setContents(in, force, monitor);
    }

    @Override
    public void setContents(InputStream in, Shed backupShed, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        this.getUnderlyingStorage().setContents(in, backupShed, monitor);
    }

    @Override
    public boolean storageExists(IProgressMonitor progress) throws FileSystemClientException {
        return this.getUnderlyingStorage().storageExists(progress);
    }

    public boolean contains(ISchedulingRule rule) {
        return this.getUnderlyingStorage().contains(rule);
    }

    public boolean isConflicting(ISchedulingRule rule) {
        return this.getUnderlyingStorage().isConflicting(rule);
    }

    public Object getAdapter(Class adapter) {
        return this.getUnderlyingStorage().getAdapter(adapter);
    }

    public final void setUnderlyingStorage(FileStorage underlyingStorage) {
        this.underlyingStorage = underlyingStorage;
    }

    @Override
    public boolean setWritable(boolean writable, IProgressMonitor progress) {
        return this.getUnderlyingStorage().setWritable(writable, progress);
    }
}

