/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class FileStorageInputStreamProvider
implements IInputStreamProvider {
    private IFileStorage fileStorage;

    private FileStorageInputStreamProvider(IFileStorage fileStorage) {
        this.fileStorage = fileStorage;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fileStorage == null ? 0 : this.fileStorage.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileStorageInputStreamProvider other = (FileStorageInputStreamProvider)obj;
        return !(this.fileStorage == null ? other.fileStorage != null : !this.fileStorage.equals(other.fileStorage));
    }

    public static FileStorageInputStreamProvider create(IFileStorage fileStorage) {
        return new FileStorageInputStreamProvider(fileStorage);
    }

    public InputStream getInputStream(IProgressMonitor monitor) throws IOException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            if (this.fileStorage.getResourceType((IProgressMonitor)progress.newChild(1)) == ResourceType.SYMBOLIC_LINK) {
                return new ByteArrayInputStream(this.fileStorage.getTarget((IProgressMonitor)progress.newChild(1)).getBytes());
            }
            return this.fileStorage.getContents(true);
        }
        catch (FileSystemClientException fileSystemClientException) {
            throw new IOException();
        }
    }
}

