/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.operations;

import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.filesystem.client.operations.IRefreshingOperation;

public class OperationOptions {
    private final boolean refresh;
    private final boolean nonAtomicCommitIsAnOption;
    private final int nonAtomicCommitFileUploadLimit;

    public OperationOptions() {
        this.refresh = false;
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = 200;
    }

    public OperationOptions(boolean refresh, boolean nonAtomicCommitIsAnOption, int nonAtomicCommitFileUploadLimit) {
        this.refresh = refresh;
        this.nonAtomicCommitIsAnOption = nonAtomicCommitIsAnOption;
        this.nonAtomicCommitFileUploadLimit = nonAtomicCommitFileUploadLimit;
    }

    public void configureOperation(IFileSystemOperation operation) {
        if (operation instanceof IRefreshingOperation) {
            ((IRefreshingOperation)((Object)operation)).setRefreshBeforeRun(this.refresh);
        }
        if (operation instanceof ICheckinOptions) {
            if (this.nonAtomicCommitIsAnOption) {
                ((ICheckinOptions)((Object)operation)).enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
            } else {
                ((ICheckinOptions)((Object)operation)).disableNonAtomicCommit();
            }
        }
    }
}

