/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.operations.IEncodingUploadFailure;
import com.ibm.team.filesystem.client.operations.ILineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.scm.client.IWorkspaceConnection;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitDilemmaHandler
extends UpdateDilemmaHandler {
    private static CommitDilemmaHandler instance;

    public static CommitDilemmaHandler getDefault() {
        if (instance == null) {
            instance = new CommitDilemmaHandler();
        }
        return instance;
    }

    protected CommitDilemmaHandler() {
    }

    public int lineDelimiterErrors(Collection<? extends ILineDelimiterUploadFailure> failedFiles, IProgressMonitor monitor) throws FileSystemClientException {
        int failuresSkipped = 0;
        for (ILineDelimiterUploadFailure iLineDelimiterUploadFailure : failedFiles) {
            if (iLineDelimiterUploadFailure.isAtomicCommit()) continue;
            iLineDelimiterUploadFailure.setSkipFailure(true);
            ++failuresSkipped;
        }
        if (failuresSkipped > 0) {
            return 0;
        }
        return 2;
    }

    public int encodingErrors(Collection<? extends IEncodingUploadFailure> failedUploads, IProgressMonitor monitor) {
        int failuresHandled = 0;
        for (IEncodingUploadFailure iEncodingUploadFailure : failedUploads) {
            if (iEncodingUploadFailure.isUnknownEncoding() || iEncodingUploadFailure.isMalformedContent()) {
                if (iEncodingUploadFailure.getOriginalEncoding() == null) {
                    iEncodingUploadFailure.setIgnoreEncoding(true);
                    ++failuresHandled;
                    continue;
                }
                if (!iEncodingUploadFailure.getEncoding().equals(iEncodingUploadFailure.getOriginalEncoding()) && iEncodingUploadFailure.getOriginalEncoding() != null) {
                    try {
                        if (Charset.isSupported(iEncodingUploadFailure.getOriginalEncoding())) {
                            iEncodingUploadFailure.setAlternativeEncoding(iEncodingUploadFailure.getOriginalEncoding());
                            ++failuresHandled;
                            continue;
                        }
                    }
                    catch (IllegalCharsetNameException illegalCharsetNameException) {}
                }
            }
            if (iEncodingUploadFailure.isAtomicCommit()) continue;
            iEncodingUploadFailure.setSkipFailure(true);
            ++failuresHandled;
        }
        if (failuresHandled != 0) {
            return 0;
        }
        return 2;
    }

    public int nonAtomicCommit(IWorkspaceConnection workspace, int numChanges, int numUploads) {
        return 0;
    }

    public static /* bridge */ /* synthetic */ UpdateDilemmaHandler getDefault() {
        return CommitDilemmaHandler.getDefault();
    }
}

