/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathUtils {
    public static IPath getPath(List<String> path) {
        return PathUtils.getPath(path.toArray(new String[path.size()]));
    }

    public static IPath getPath(String[] path) {
        return new Path(PathUtils.getString(path));
    }

    public static File getFile(File root, String[] path) {
        return new File(root, PathUtils.getString(path));
    }

    public static String getString(String[] path) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < path.length) {
            buffer.append('/').append(path[i]);
            ++i;
        }
        return buffer.toString();
    }

    public static IPath getPath(IPath root, String[] pathHint, int offset) {
        StringBuffer buffer = new StringBuffer();
        int i = offset;
        while (i < pathHint.length) {
            buffer.append('/').append(pathHint[i]);
            ++i;
        }
        return root.append(buffer.toString());
    }

    public static IPath getPath(IPath root, String[] pathHint, int startOffset, int endOffset) {
        StringBuffer buffer = new StringBuffer();
        endOffset = Math.min(pathHint.length, endOffset);
        int i = startOffset;
        while (i < endOffset) {
            buffer.append('/').append(pathHint[i]);
            ++i;
        }
        if (root == null) {
            root = new Path("/");
        }
        return root.append(buffer.toString());
    }

    /*
     * Unable to fully structure code
     */
    public static boolean samePath(IPath copyFileAreaRoot1, boolean caseSensitive1, IPath copyFileAreaRoot2, boolean caseSensitive2) {
        caseSensitive = caseSensitive1 & caseSensitive2;
        if (copyFileAreaRoot1 == null ? copyFileAreaRoot2 != null : copyFileAreaRoot2 == null) {
            return false;
        }
        targetSegments = copyFileAreaRoot2.segments();
        segments = copyFileAreaRoot1.segments();
        i = segments.length;
        if (i == targetSegments.length) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            if (!(caseSensitive != false ? segments[i].equals(targetSegments[i]) == false : segments[i].equalsIgnoreCase(targetSegments[i]) == false)) continue;
            return false;
lbl11:
            // 2 sources

            ** while (--i >= 0)
        }
lbl12:
        // 1 sources

        device = copyFileAreaRoot1.getDevice();
        targetDevice = copyFileAreaRoot2.getDevice();
        if (caseSensitive) {
            return device == targetDevice || device != null && device.equals(targetDevice) != false;
        }
        return device == targetDevice || device != null && device.equalsIgnoreCase(targetDevice) != false;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean sameRelativePath(IPath relativePath1, boolean caseSensitive1, IPath relativePath2, boolean caseSensitive2) {
        caseSensitive = caseSensitive1 & caseSensitive2;
        if (relativePath1 == null ? relativePath2 != null : relativePath2 == null) {
            return false;
        }
        targetSegments = relativePath2.segments();
        segments = relativePath1.segments();
        i = segments.length;
        if (i == targetSegments.length) ** GOTO lbl11
        return false;
lbl-1000:
        // 1 sources

        {
            if (!(caseSensitive != false ? segments[i].equals(targetSegments[i]) == false : segments[i].equalsIgnoreCase(targetSegments[i]) == false)) continue;
            return false;
lbl11:
            // 2 sources

            ** while (--i >= 0)
        }
lbl12:
        // 1 sources

        return true;
    }

    public static boolean isPrefixOf(IPath prefix, boolean caseSensitive, IPath path) {
        if (prefix.getDevice() == null || prefix.getDevice().length() == 0 ? path.getDevice() != null && path.getDevice().length() != 0 : !prefix.getDevice().equalsIgnoreCase(path.getDevice())) {
            return false;
        }
        if (prefix.isEmpty() || prefix.isRoot() && path.isAbsolute()) {
            return true;
        }
        int len = prefix.segmentCount();
        if (len > path.segmentCount()) {
            return false;
        }
        int i = 0;
        while (i < len) {
            if (caseSensitive ? !prefix.segment(i).equals(path.segment(i)) : !prefix.segment(i).equalsIgnoreCase(path.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean overlapsButNotEqual(IPath path1, boolean caseSensitive1, IPath path2, boolean caseSensitive2) {
        boolean caseSensitive = caseSensitive1 & caseSensitive2;
        if (path1.getDevice() == null || path1.getDevice().length() == 0 ? path2.getDevice() != null && path2.getDevice().length() != 0 : !path1.getDevice().equalsIgnoreCase(path2.getDevice())) {
            return false;
        }
        if (path1.isEmpty() || path1.isRoot() && path2.isAbsolute()) {
            return true;
        }
        if (path1.segmentCount() == path2.segmentCount()) {
            return false;
        }
        int len = Math.min(path1.segmentCount(), path2.segmentCount());
        int i = 0;
        while (i < len) {
            if (caseSensitive ? !path1.segment(i).equals(path2.segment(i)) : !path1.segment(i).equalsIgnoreCase(path2.segment(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isLoadedWithAnotherName(ISandbox sandbox, IPath path, String remoteName) {
        boolean isLoadedWithAnotherName = sandbox.isCaseSensitive() ? !path.lastSegment().equals(remoteName) : !path.lastSegment().toLowerCase().equals(remoteName.toLowerCase());
        return isLoadedWithAnotherName;
    }

    public static String getRealPath(String path) {
        try {
            return ManagedFileStore.getResolvedPath(path);
        }
        catch (CoreException coreException) {
            return new File(path).getAbsolutePath();
        }
    }

    public static boolean exists(IPath path, IProgressMonitor progress) throws FileSystemClientException {
        IFileInfo fileInfo;
        block3: {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            IFileStore fileStorage = EFS.getLocalFileSystem().getStore(path);
            try {
                fileInfo = fileStorage.fetchInfo(0, (IProgressMonitor)monitor.newChild(100));
                if (!fileInfo.getAttribute(32)) break block3;
                return true;
            }
            catch (CoreException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.PathUtils_0, (Object)path.toString(), (Object[])new Object[0]), (Throwable)e));
            }
        }
        return fileInfo.exists();
    }

    public static ResourceType getResourceType(IPath path, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        IFileStore fileStorage = EFS.getLocalFileSystem().getStore(path);
        try {
            IFileInfo fileInfo = fileStorage.fetchInfo(0, (IProgressMonitor)monitor.newChild(100));
            if (fileInfo.getAttribute(32)) {
                return ResourceType.SYMBOLIC_LINK;
            }
            if (fileInfo.isDirectory()) {
                return ResourceType.FOLDER;
            }
            if (fileInfo.exists()) {
                return ResourceType.FILE;
            }
            return null;
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.PathUtils_1, (Object)path.toString(), (Object[])new Object[0]), (Throwable)e));
        }
    }
}

