/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.utils.ILRUCache;
import com.ibm.team.filesystem.client.internal.utils.ILRUCacheable;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LRUCache<KeyType, ValueType>
implements ILRUCache<KeyType, ValueType> {
    protected int fCurrentSpace = 0;
    protected int fSpaceLimit;
    protected int fTimestampCounter = 0;
    protected HashMap fEntryTable;
    protected LRUCacheEntry fEntryQueue = null;
    protected LRUCacheEntry fEntryQueueTail = null;
    protected static final int DEFAULT_SPACELIMIT = 100;
    ILRUCache.LRUCacheListener listener;

    public LRUCache() {
        this(100);
    }

    public LRUCache(int size) {
        this.fEntryTable = new HashMap(size);
        this.fSpaceLimit = size;
    }

    @Override
    public void setListener(ILRUCache.LRUCacheListener l) {
        if (this.listener != null && l != null) {
            throw new IllegalStateException();
        }
        this.listener = l;
    }

    @Override
    public Object clone() {
        LRUCache newCache = this.newInstance(this.fSpaceLimit);
        LRUCacheEntry qEntry = this.fEntryQueueTail;
        while (qEntry != null) {
            newCache.privateAdd(qEntry._fKey, qEntry._fValue, qEntry._fSpace);
            qEntry = qEntry._fPrevious;
        }
        return newCache;
    }

    public double fillingRatio() {
        return (double)this.fCurrentSpace * 100.0 / (double)this.fSpaceLimit;
    }

    @Override
    public void flush() {
        this.fCurrentSpace = 0;
        LRUCacheEntry entry = this.fEntryQueueTail;
        this.fEntryTable = new HashMap();
        this.fEntryQueueTail = null;
        this.fEntryQueue = null;
        while (entry != null) {
            if (this.listener != null) {
                this.listener.remove(entry._fKey, entry._fValue, false);
            }
            this.privateNotifyDeletionFromCache(entry);
            assert (entry != entry._fPrevious);
            entry = entry._fPrevious;
        }
    }

    public void flush(KeyType key) {
        LRUCacheEntry entry = (LRUCacheEntry)this.fEntryTable.get(key);
        if (entry == null) {
            return;
        }
        this.privateRemoveEntry(entry, false);
    }

    @Override
    public ValueType get(KeyType key) {
        LRUCacheEntry entry = (LRUCacheEntry)this.fEntryTable.get(key);
        if (entry == null) {
            if (this.listener != null) {
                this.listener.miss(key);
            }
            return null;
        }
        if (this.listener != null) {
            this.listener.hit(key, entry._fValue);
        }
        this.updateTimestamp(entry);
        return entry._fValue;
    }

    public boolean containsKey(KeyType key) {
        LRUCacheEntry entry = (LRUCacheEntry)this.fEntryTable.get(key);
        if (entry == null) {
            return false;
        }
        this.updateTimestamp(entry);
        return true;
    }

    public int getCurrentSpace() {
        return this.fCurrentSpace;
    }

    public int getSpaceLimit() {
        return this.fSpaceLimit;
    }

    @Override
    public Iterator<KeyType> keys() {
        final LinkedList keys = new LinkedList();
        keys.addAll(this.fEntryTable.keySet());
        return new Iterator<KeyType>(){
            KeyType current;

            @Override
            public boolean hasNext() {
                return keys.size() > 0;
            }

            @Override
            public KeyType next() {
                this.current = keys.remove();
                return this.current;
            }

            @Override
            public void remove() {
                LRUCache.this.removeKey(this.current);
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    protected boolean makeSpace(int space) {
        limit = this.getSpaceLimit();
        if (this.fCurrentSpace + space <= limit) {
            return true;
        }
        if (space <= limit) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            this.privateRemoveEntry(this.fEntryQueueTail, false);
lbl7:
            // 2 sources

            ** while (this.fCurrentSpace + space > limit && this.fEntryQueueTail != null)
        }
lbl8:
        // 1 sources

        return true;
    }

    protected LRUCache newInstance(int size) {
        return new LRUCache<KeyType, ValueType>(size);
    }

    public ValueType peek(KeyType key) {
        LRUCacheEntry entry = (LRUCacheEntry)this.fEntryTable.get(key);
        if (entry == null) {
            return null;
        }
        return entry._fValue;
    }

    protected void privateAdd(KeyType key, ValueType value, int space) {
        LRUCacheEntry<KeyType, ValueType> entry = new LRUCacheEntry<KeyType, ValueType>(key, value, space);
        this.privateAddEntry(entry, false);
    }

    protected void privateAddEntry(LRUCacheEntry<KeyType, ValueType> entry, boolean shuffle) {
        if (this.listener != null) {
            this.listener.add(entry._fKey, entry._fValue, shuffle);
        }
        if (!shuffle) {
            this.fEntryTable.put(entry._fKey, entry);
            this.fCurrentSpace += entry._fSpace;
        }
        entry._fTimestamp = this.fTimestampCounter++;
        entry._fNext = this.fEntryQueue;
        entry._fPrevious = null;
        if (this.fEntryQueue == null) {
            this.fEntryQueueTail = entry;
        } else {
            this.fEntryQueue._fPrevious = entry;
        }
        this.fEntryQueue = entry;
    }

    protected void privateNotifyDeletionFromCache(LRUCacheEntry entry) {
    }

    protected void privateRemoveEntry(LRUCacheEntry<KeyType, ValueType> entry, boolean shuffle) {
        LRUCacheEntry previous = entry._fPrevious;
        LRUCacheEntry next = entry._fNext;
        if (this.listener != null) {
            this.listener.remove(entry._fKey, entry._fValue, shuffle);
        }
        if (!shuffle) {
            this.fEntryTable.remove(entry._fKey);
            this.fCurrentSpace -= entry._fSpace;
            this.privateNotifyDeletionFromCache(entry);
        }
        if (previous == null) {
            this.fEntryQueue = next;
        } else {
            previous._fNext = next;
        }
        if (next == null) {
            this.fEntryQueueTail = previous;
        } else {
            next._fPrevious = previous;
        }
    }

    @Override
    public ValueType put(KeyType key, ValueType value) {
        int newSpace = this.spaceFor(value);
        LRUCacheEntry entry = (LRUCacheEntry)this.fEntryTable.get(key);
        if (entry != null) {
            int oldSpace = entry._fSpace;
            int newTotal = this.getCurrentSpace() - oldSpace + newSpace;
            if (newTotal <= this.getSpaceLimit()) {
                this.updateTimestamp(entry);
                entry._fValue = value;
                entry._fSpace = newSpace;
                this.fCurrentSpace = newTotal;
                return value;
            }
            this.privateRemoveEntry(entry, false);
        }
        if (this.makeSpace(newSpace)) {
            this.privateAdd(key, value, newSpace);
        }
        return value;
    }

    public ValueType removeKey(KeyType key) {
        LRUCacheEntry entry = (LRUCacheEntry)this.fEntryTable.get(key);
        if (entry == null) {
            return null;
        }
        Object value = entry._fValue;
        this.privateRemoveEntry(entry, false);
        return value;
    }

    public void setSpaceLimit(int limit) {
        if (limit < this.fSpaceLimit) {
            this.makeSpace(this.fSpaceLimit - limit);
        }
        this.fSpaceLimit = limit;
    }

    protected int spaceFor(Object value) {
        if (value instanceof ILRUCacheable) {
            return ((ILRUCacheable)value).getCacheFootprint();
        }
        return 1;
    }

    public String toString() {
        return this.toStringFillingRation("LRUCache");
    }

    public String toStringFillingRation(String cacheName) {
        StringBuffer buffer = new StringBuffer(cacheName);
        buffer.append('[');
        buffer.append(this.getSpaceLimit());
        buffer.append("]: ");
        buffer.append(NumberFormat.getInstance().format(this.fillingRatio()));
        buffer.append("% full");
        return buffer.toString();
    }

    protected void updateTimestamp(LRUCacheEntry entry) {
        entry._fTimestamp = this.fTimestampCounter++;
        if (this.fEntryQueue != entry) {
            this.privateRemoveEntry(entry, true);
            this.privateAddEntry(entry, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class LRUCacheEntry<KeyType, ValueType> {
        public KeyType _fKey;
        public ValueType _fValue;
        public int _fTimestamp;
        public int _fSpace;
        public LRUCacheEntry _fPrevious;
        public LRUCacheEntry _fNext;

        public LRUCacheEntry(KeyType key, ValueType value, int space) {
            this._fKey = key;
            this._fValue = value;
            this._fSpace = space;
        }

        public String toString() {
            return "LRUCacheEntry [" + this._fKey + "-->" + this._fValue + "]";
        }
    }
}

