/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.util.LineDelimiterUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProgressMonitor;

public class FileContentInputStream
extends InputStream {
    private InputStream underlyingInputStream = null;
    private ITeamRepository repository;
    private IFileItemHandle item;
    private IFileContent content;
    private FileLineDelimiter desiredLineDelimiter;
    private final IProgressMonitor monitor;

    public FileContentInputStream(ITeamRepository repository, IFileItemHandle item, IFileContent content, IProgressMonitor monitor) {
        this(repository, item, content, content.getLineDelimiter(), monitor);
    }

    public FileContentInputStream(ITeamRepository repository, IFileItemHandle item, IFileContent content, FileLineDelimiter desiredLineDelimiter, IProgressMonitor monitor) {
        this.repository = repository;
        this.content = content;
        this.desiredLineDelimiter = desiredLineDelimiter;
        this.monitor = monitor;
        this.item = item;
    }

    public int available() throws IOException {
        if (this.underlyingInputStream == null) {
            return 0;
        }
        return this.underlyingInputStream.available();
    }

    public int read() throws IOException {
        InputStream underlyingStream = this.getUnderlyingStream();
        return underlyingStream.read();
    }

    private InputStream getUnderlyingStream() throws IOException {
        if (this.underlyingInputStream == null) {
            try {
                this.underlyingInputStream = FileSystemCore.getContentManager(this.repository).retrieveContentStream(this.item, this.content, this.monitor);
            }
            catch (TeamRepositoryException e) {
                IOException ex = new IOException(e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            if (!(this.content.getLineDelimiter() == this.desiredLineDelimiter || this.content.getLineDelimiter() == FileLineDelimiter.LINE_DELIMITER_PLATFORM && FileLineDelimiter.getPlatformDelimiter() == this.desiredLineDelimiter || this.desiredLineDelimiter == FileLineDelimiter.LINE_DELIMITER_PLATFORM && this.content.getLineDelimiter() == FileLineDelimiter.getPlatformDelimiter() || this.desiredLineDelimiter == FileLineDelimiter.LINE_DELIMITER_NONE)) {
                this.underlyingInputStream = new ReaderToInputStream((InputStreamReader)LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)this.underlyingInputStream, (String)this.content.getCharacterEncoding(), (FileLineDelimiter)this.desiredLineDelimiter));
            }
        }
        InputStream underlyingStream = this.underlyingInputStream;
        return underlyingStream;
    }

    public int read(byte[] b) throws IOException {
        return this.getUnderlyingStream().read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.getUnderlyingStream().read(b, off, len);
    }

    public synchronized void reset() throws IOException {
        this.getUnderlyingStream().reset();
    }

    public long skip(long n) throws IOException {
        return this.getUnderlyingStream().skip(n);
    }

    public void close() throws IOException {
        if (this.underlyingInputStream != null) {
            this.underlyingInputStream.close();
            this.underlyingInputStream = null;
        }
        super.close();
    }
}

