/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.snapshot;

import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.namespace.EmptyNamespace;
import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.snapshot.AbstractSnapshot;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceSetContext
extends AbstractSnapshot {
    private Set<ItemNamespace> namespaces;
    private ITeamRepository repo;
    private IItemContext onlyContext;
    private String name;

    private NamespaceSetContext(ITeamRepository repo, Set<ItemNamespace> namespaces, String name, IItemContext onlyContext) {
        this.namespaces = namespaces;
        this.onlyContext = onlyContext;
        this.repo = repo;
        this.name = name;
        if (repo == null) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public ItemNamespace getNamespaceFor(ItemId<IComponent> component, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.namespaces.size());
        for (ItemNamespace next : this.namespaces) {
            ItemId<IComponent> nextComponent = next.fetchComponentId((IProgressMonitor)progress.newChild(10));
            if (!nextComponent.equals(component)) continue;
            return next;
        }
        return EmptyNamespace.create(this.repo, component);
    }

    @Override
    public ITeamRepository getRepository() {
        return this.repo;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.onlyContext != null) {
            return this.onlyContext.getName();
        }
        return Messages.NamespaceSetContext_0;
    }

    public static NamespaceSetContext create(ITeamRepository repo, Set<ItemNamespace> namespace, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemContext context = null;
        if (namespace.size() == 1) {
            context = namespace.iterator().next().getContext(monitor);
        }
        return new NamespaceSetContext(repo, namespace, null, context);
    }

    public static NamespaceSetContext create(ITeamRepository repo, Set<ItemNamespace> namespace, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        IItemContext context = null;
        if (namespace.size() == 1) {
            context = namespace.iterator().next().getContext(monitor);
        }
        return new NamespaceSetContext(repo, namespace, name, context);
    }

    @Override
    public Map<ItemId<IComponent>, IItemContext> getContexts(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)this.namespaces.size());
        HashMap result = NewCollection.hashMap();
        for (ItemNamespace next : this.namespaces) {
            IItemContext nextContext = next.getContext((IProgressMonitor)progress.newChild(1));
            result.put(nextContext.getComponent(), nextContext);
        }
        return result;
    }

    @Override
    public Set<ItemNamespace> getNamespaces(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.namespaces;
    }

    @Override
    public void refresh(IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.namespaces.size() * 2));
        for (ItemNamespace next : this.namespaces) {
            IItemContext nextContext = next.getContext((IProgressMonitor)progress.newChild(1));
            nextContext.refresh((IProgressMonitor)progress.newChild(1));
        }
    }
}

