/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.share;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.operations.IUnshareOperation;
import com.ibm.team.filesystem.client.operations.UnshareDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnshareOperation
extends FileSystemOperation
implements IUnshareOperation {
    private ArrayList<IShare> sharesToUnshare;
    private boolean deleteContent;
    private Collection<Shareable> shareablesToUnshare;
    private ArrayList<ConfigurationDescriptor> configurationsToUnshare;
    private UnshareDilemmaHandler unshareDilemmaHandler;

    public UnshareOperation(UnshareDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? UnshareDilemmaHandler.getDefault() : dilemmaHandler);
        this.unshareDilemmaHandler = dilemmaHandler == null ? UnshareDilemmaHandler.getDefault() : dilemmaHandler;
        this.deleteContent = false;
        this.configurationsToUnshare = new ArrayList();
        this.sharesToUnshare = new ArrayList();
        this.shareablesToUnshare = new ArrayList<Shareable>();
    }

    @Override
    public void requestUnshareShares(Collection<IShare> sharesToUnshare) {
        this.sharesToUnshare.addAll(sharesToUnshare);
    }

    @Override
    public void requestUnshare(IConnection connection, Collection<? extends IComponentHandle> components) {
        if (connection == null) {
            throw new IllegalArgumentException();
        }
        if (components == null) {
            throw new IllegalArgumentException();
        }
        this.configurationsToUnshare = new ArrayList();
        for (IComponentHandle iComponentHandle : components) {
            this.configurationsToUnshare.add(new ConfigurationDescriptor(connection, iComponentHandle));
        }
    }

    @Override
    public void requestUnshare(Collection<ConfigurationDescriptor> configurationsToUnshare) {
        if (configurationsToUnshare == null) {
            throw new IllegalArgumentException();
        }
        this.configurationsToUnshare = new ArrayList();
        this.configurationsToUnshare.addAll(configurationsToUnshare);
    }

    @Override
    public void setDeleteContent(boolean deleteContentOnUnshare) {
        this.deleteContent = deleteContentOnUnshare;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        final Set<ConfigurationDescriptor> affected = this.getAffectedConfigurations();
        IRunnableWithProgress workspaceOp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor progress;
                block30: {
                    progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"", (int)100);
                    ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
                    try {
                        ICopyFileAreaLockRequest lockRequest = cfaMgr.lockRequestFactory().getLockRequest(affected, false);
                        ICopyFileAreasLock cfaLock = cfaMgr.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
                        HashMap<IPath, Sandbox> emptyCFAs = new HashMap<IPath, Sandbox>();
                        int direction = 3;
                        try {
                            HashSet<ICopyFileArea> interestingCopyFileAreas = new HashSet<ICopyFileArea>();
                            HashMap<ConfigurationDescriptor, Collection<ICopyFileArea>> componentsToUnload = new HashMap<ConfigurationDescriptor, Collection<ICopyFileArea>>();
                            if (UnshareOperation.this.configurationsToUnshare != null) {
                                for (ConfigurationDescriptor configuration : UnshareOperation.this.configurationsToUnshare) {
                                    Collection<ICopyFileArea> collection = cfaMgr.getCopyFileAreasForConfiguration(configuration, monitor);
                                    interestingCopyFileAreas.addAll(collection);
                                    componentsToUnload.put(configuration, collection);
                                }
                                for (ICopyFileArea cfa : interestingCopyFileAreas) {
                                    Collection<IShare> collection = cfa.allShares();
                                    for (IShare share : collection) {
                                        ISharingDescriptor descriptor = share.getSharingDescriptor();
                                        ConfigurationDescriptor configuration = new ConfigurationDescriptor(descriptor.getRepositoryId(), descriptor.getRepositoryUri(), descriptor.getConnectionHandle(), descriptor.getComponent());
                                        if (!affected.contains(configuration)) continue;
                                        UnshareOperation.this.shareablesToUnshare.add((Shareable)share.getShareable());
                                    }
                                }
                            }
                            int work = (UnshareOperation.this.deleteContent ? 2 : 1) * UnshareOperation.this.shareablesToUnshare.size();
                            progress.setWorkRemaining((work += UnshareOperation.this.configurationsToUnshare == null ? 0 : UnshareOperation.this.configurationsToUnshare.size()) + 10);
                            int i = 1;
                            for (Shareable shareable : UnshareOperation.this.shareablesToUnshare) {
                                if (progress.isCanceled()) {
                                    throw new OperationCanceledException();
                                }
                                try {
                                    progress.subTask(NLS.bind((String)Messages.UnshareProjectsOperation_ProgressMessage, (Object)shareable.getLocalPath(), (Object[])new Object[]{i, UnshareOperation.this.shareablesToUnshare.size()}));
                                    shareable.unshare((IProgressMonitor)progress.newChild(1));
                                    interestingCopyFileAreas.add(cfaMgr.getCopyFileAreaForPath(shareable.getCopyFileAreaRoot()));
                                }
                                catch (FileSystemClientException e) {
                                    UnshareOperation.this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)e)));
                                }
                                ++i;
                            }
                            for (Map.Entry entry : componentsToUnload.entrySet()) {
                                ConfigurationDescriptor descriptor = (ConfigurationDescriptor)entry.getKey();
                                for (ICopyFileArea cfa : (Collection)entry.getValue()) {
                                    ((CopyFileAreaStore)((Object)cfa)).componentUnloaded(descriptor.componentHandle, descriptor.connectionHandle, (IProgressMonitor)progress.newChild(1));
                                }
                            }
                            for (ICopyFileArea iCopyFileArea : interestingCopyFileAreas) {
                                if (!iCopyFileArea.allShares().isEmpty()) continue;
                                emptyCFAs.put(iCopyFileArea.getRoot(), new Sandbox(iCopyFileArea));
                            }
                            if (!emptyCFAs.isEmpty()) {
                                direction = UnshareOperation.this.unshareDilemmaHandler.emptySandbox(Collections.unmodifiableCollection(emptyCFAs.values()));
                            }
                        }
                        finally {
                            cfaLock.release((IProgressMonitor)progress.newChild(1));
                        }
                        if (!emptyCFAs.isEmpty() && direction == 0) {
                            ICopyFileAreaLockRequest removCFAlockRequest = cfaMgr.lockRequestFactory().getLockRequestForRemoval(emptyCFAs.keySet());
                            ICopyFileAreasLock removeCFALock = cfaMgr.lock(Collections.singleton(removCFAlockRequest), (IProgressMonitor)progress.newChild(1));
                            try {
                                for (ISandbox sandbox : emptyCFAs.values()) {
                                    if (sandbox == null || sandbox.allShares((IProgressMonitor)progress.newChild(1)).length != 0) continue;
                                    cfaMgr.deregister(sandbox.getRoot(), true, (IProgressMonitor)progress.newChild(1));
                                }
                                break block30;
                            }
                            finally {
                                removeCFALock.release((IProgressMonitor)progress.newChild(1));
                            }
                        }
                        if (direction == 1) {
                            throw new OperationCanceledException();
                        }
                    }
                    catch (FileSystemClientException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                }
                if (UnshareOperation.this.deleteContent) {
                    int i = 1;
                    for (Shareable shareable : UnshareOperation.this.shareablesToUnshare) {
                        progress.subTask(NLS.bind((String)Messages.UnshareProjectsOperation_ProgressMessage, (Object)shareable.getLocalPath(), (Object[])new Object[]{i + 1, UnshareOperation.this.shareablesToUnshare.size()}));
                        try {
                            shareable.getFileStorage().delete((IProgressMonitor)progress.newChild(1));
                        }
                        catch (TeamRepositoryException e) {
                            UnshareOperation.this.collectStatus(FileSystemStatus.getStatusFor(e));
                        }
                        catch (FileSystemClientException e) {
                            UnshareOperation.this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)e)));
                        }
                        if (progress.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        ++i;
                    }
                }
            }
        };
        this.runWithinFileSystemLock(workspaceOp, Messages.UnshareProjectsOperation_0, monitor);
    }

    private Set<ConfigurationDescriptor> getAffectedConfigurations() {
        this.shareablesToUnshare = new ArrayList<Shareable>();
        HashSet<ConfigurationDescriptor> configurations = new HashSet<ConfigurationDescriptor>();
        if (this.configurationsToUnshare != null) {
            for (ConfigurationDescriptor configurationToUnshare : this.configurationsToUnshare) {
                if (configurationToUnshare.getClass() != ConfigurationDescriptor.class) {
                    configurations.add(new ConfigurationDescriptor(configurationToUnshare.id, configurationToUnshare.uri, configurationToUnshare.connectionHandle, configurationToUnshare.componentHandle));
                    continue;
                }
                configurations.add(configurationToUnshare);
            }
        }
        if (this.sharesToUnshare != null) {
            for (IShare share : this.sharesToUnshare) {
                IShareable shareable = share.getShareable();
                this.shareablesToUnshare.add((Shareable)shareable);
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                configurations.add(new ConfigurationDescriptor(descriptor.getRepositoryId(), descriptor.getRepositoryUri(), descriptor.getConnectionHandle(), descriptor.getComponent()));
            }
        }
        return configurations;
    }
}

