/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.share;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShareVersionables {
    final IWorkspaceConnection workspace;
    final IChangeSetHandle changeSet;
    final IComponent component;
    final IFolderHandle parentFolder;
    final String[] newFolderUnderParent;
    final boolean overwrite;
    private final List<IShareable> shareables;
    private CommitDilemmaHandler problemHandler;
    private Map<UUID, IChangeSetHandle> changeSetsCommitted;
    private boolean newProjectContentsToBeCommitted;

    public ShareVersionables(IWorkspaceConnection workspace, IChangeSetHandle changeSet, IComponent component, IFolderHandle parentFolder, String[] newFolderUnderParent, boolean overwrite, CommitDilemmaHandler problemHandler) {
        this.workspace = workspace;
        this.changeSet = changeSet;
        this.component = component;
        this.parentFolder = parentFolder;
        this.newFolderUnderParent = newFolderUnderParent;
        this.shareables = new ArrayList<IShareable>();
        this.overwrite = overwrite;
        this.problemHandler = problemHandler;
        this.changeSetsCommitted = new HashMap<UUID, IChangeSetHandle>();
    }

    public void addShareable(IShareable shareableRoot) {
        this.shareables.add(shareableRoot);
    }

    public Collection<IShareable> getShareables() {
        return this.shareables;
    }

    public int getShareableCount() {
        return this.shareables.size();
    }

    public void share(Map<String, IFolder> foldersCreated, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        this.changeSetsCommitted = new HashMap<UUID, IChangeSetHandle>();
        if (this.shareables.isEmpty()) {
            return;
        }
        int numProjects = this.shareables.size();
        SubMonitor reporter = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ArrayList<IWorkspaceConnection.ISaveOp> newFolderChanges = new ArrayList<IWorkspaceConnection.ISaveOp>();
        IFolderHandle folderToShareUnder = this.createNewFolderToShareUnder(this.parentFolder, foldersCreated, newFolderChanges);
        reporter.setTaskName(NLS.bind((String)Messages.ShareProjects_0, (Object)numProjects, (Object[])new Object[0]));
        Map<UUID, ShareableVersionablePair> changes = this.mapProjectsToVersionablesToBeCommitted(folderToShareUnder, this.component.getName(), (IProgressMonitor)reporter.newChild(5));
        if (!changes.isEmpty() || !newFolderChanges.isEmpty()) {
            this.commitNewProjects(this.component.getName(), folderToShareUnder, newFolderChanges, changes, reporter.newChild(15));
            if (!changes.isEmpty()) {
                this.newProjectContentsToBeCommitted = true;
            }
        }
    }

    private IFolderHandle createNewFolderToShareUnder(IFolderHandle folderToShareUnder, Map<String, IFolder> foldersCreated, ArrayList<IWorkspaceConnection.ISaveOp> newFolderChanges) {
        if (this.newFolderUnderParent.length > 0) {
            IWorkspaceConnection.IConfigurationOpFactory opFactory = this.workspace.configurationOpFactory();
            String relativePath = "";
            String[] stringArray = this.newFolderUnderParent;
            int n = this.newFolderUnderParent.length;
            int n2 = 0;
            while (n2 < n) {
                String folderToCreate = stringArray[n2];
                IFolder folder = foldersCreated.get(relativePath = String.valueOf(relativePath) + "/" + folderToCreate);
                if (folder == null) {
                    folder = (IFolder)IFolder.ITEM_TYPE.createItem();
                    folder.setName(folderToCreate);
                    folder.setParent(folderToShareUnder);
                    newFolderChanges.add(opFactory.save((IVersionable)folder));
                    foldersCreated.put(relativePath, folder);
                }
                folderToShareUnder = folder;
                ++n2;
            }
        }
        return folderToShareUnder;
    }

    public void commitNewProjectContents(IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        if (this.newProjectContentsToBeCommitted) {
            ICheckinOperation commit = IOperationFactory.instance.getCheckinOperation(this.problemHandler);
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            commit.requestCheckin(this.shareables.toArray(new IShareable[this.shareables.size()]), this.changeSet, Messages.ShareProjects_1, (IProgressMonitor)monitor.newChild(1));
            commit.enableNonAtomicCommit(1);
            commit.run((IProgressMonitor)monitor.newChild(99));
            for (IChangeSetHandle changeSet : commit.getCommittedChangeSets()) {
                this.changeSetsCommitted.put(changeSet.getItemId(), changeSet);
            }
        }
    }

    public Collection<IChangeSetHandle> getCommittedChangeSets() {
        return this.changeSetsCommitted.values();
    }

    private void commitNewProjects(String componentName, IFolderHandle parentFolderForShare, ArrayList<IWorkspaceConnection.ISaveOp> newFolderChanges, Map<UUID, ShareableVersionablePair> changes, SubMonitor reporter) throws TeamRepositoryException, FileSystemClientException {
        IWorkspaceConnection.IConfigurationOpFactory opFactory = this.workspace.configurationOpFactory();
        ArrayList<IWorkspaceConnection.ISaveOp> allOps = new ArrayList<IWorkspaceConnection.ISaveOp>(changes.size() + newFolderChanges.size());
        allOps.addAll(newFolderChanges);
        for (ShareableVersionablePair pair : changes.values()) {
            allOps.add(opFactory.save(pair.getVersionable()));
        }
        IChangeSetHandle changeSetCommitted = this.changeSet;
        if (changeSetCommitted == null && (changeSetCommitted = this.workspace.getCurrentChangeSet((IComponentHandle)this.component)) == null) {
            changeSetCommitted = this.workspace.createChangeSet((IComponentHandle)this.component, Messages.ShareProjects_2, true, (IProgressMonitor)reporter.newChild(1));
        }
        reporter.setTaskName(Messages.ShareProjects_3);
        IUpdateReport outcome = this.workspace.commit(changeSetCommitted, allOps, (IProgressMonitor)reporter.newChild(4));
        this.changeSetsCommitted.put(changeSetCommitted.getItemId(), changeSetCommitted);
        SubMonitor subProgress = reporter.newChild(10);
        ArrayList allUpdates = new ArrayList(outcome.updates().size() + outcome.incidentalResolutionUpdates().size());
        allUpdates.addAll(outcome.updates());
        allUpdates.addAll(outcome.incidentalResolutionUpdates());
        int cnt = 0;
        int total = allUpdates.size();
        subProgress.setWorkRemaining(total);
        ISyncTime beforeConfigurationState = this.getConfigurationState(outcome.getComponentStatesBefore());
        ISyncTime configurationState = this.getConfigurationState(outcome.getComponentStatesAfter());
        for (IItemUpdateReport current : allUpdates) {
            ShareableVersionablePair toUpdate = changes.get(current.getNewCurrentState().getItemId());
            if (toUpdate != null) {
                FileItemInfo info;
                subProgress.setTaskName(NLS.bind((String)Messages.ShareProjects_4, (Object)cnt, (Object[])new Object[]{total, toUpdate.getShareable().getLocalPath()}));
                SharingDescriptor descriptor = new SharingDescriptor(this.workspace.teamRepository().getRepositoryURI(), this.workspace.teamRepository().getId(), (IConnection)this.workspace, (IComponentHandle)this.component, componentName, current.getNewCurrentState(), configurationState);
                if (current.getNewCurrentState() instanceof IFolderHandle) {
                    info = new FileItemInfo((IFolderHandle)current.getNewCurrentState(), toUpdate.versionable.getParent(), toUpdate.shareable.getLocalPath().lastSegment(), false);
                } else if (current.getNewCurrentState() instanceof ISymbolicLinkHandle) {
                    ISymbolicLink link = (ISymbolicLink)toUpdate.versionable;
                    FileItemInfoProxy proxy = new FileItemInfoProxy(current.getNewCurrentState(), toUpdate.versionable.getParent(), toUpdate.shareable.getLocalPath().lastSegment(), false);
                    proxy.setTarget(((Shareable)toUpdate.getShareable()).getFileStorage().getModificationStamp(), link.getTarget());
                    info = proxy.getFileItemInfo();
                } else {
                    throw new IllegalStateException("Share file not supported");
                }
                ((Shareable)toUpdate.getShareable()).share(descriptor, info, this.overwrite, true, (IProgressMonitor)subProgress.newChild(1));
            } else {
                subProgress.worked(1);
            }
            ++cnt;
        }
        HashSet<ISandbox> sandboxes = new HashSet<ISandbox>();
        for (IShareable shareable : this.shareables) {
            sandboxes.add(shareable.getSandbox());
        }
        ICopyFileAreaManager cfaMgr = ICopyFileAreaManager.instance;
        for (ISandbox sandbox : sandboxes) {
            ICopyFileArea cfa = cfaMgr.getExistingCopyFileArea(sandbox.getRoot());
            cfa.setConfigurationState((IContextHandle)this.workspace.getResolvedWorkspace(), (IComponentHandle)this.component, beforeConfigurationState, configurationState, (IProgressMonitor)subProgress.newChild(1));
        }
        subProgress.done();
    }

    private ISyncTime getConfigurationState(Collection<IComponentStateSummary> configurationStates) {
        ISyncTime configurationState = null;
        for (IComponentStateSummary summary : configurationStates) {
            if (!summary.getComponent().sameItemId((IItemHandle)this.component)) continue;
            configurationState = summary.getConfigurationTime();
            break;
        }
        return configurationState;
    }

    private Map<UUID, ShareableVersionablePair> mapProjectsToVersionablesToBeCommitted(IFolderHandle rootFolder, String componentName, IProgressMonitor reporter) throws FileSystemClientException, TeamRepositoryException {
        int numShareRoots = this.shareables.size();
        SubMonitor shareProgress = SubMonitor.convert((IProgressMonitor)reporter, (int)(numShareRoots * 100));
        HashMap<UUID, ShareableVersionablePair> changes = new HashMap<UUID, ShareableVersionablePair>();
        try {
            int processed = 0;
            for (IShareable shareable : this.shareables) {
                if (shareProgress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                shareProgress.setTaskName(NLS.bind((String)Messages.ShareProjects_5, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{++processed, numShareRoots}));
                ResourceType type = shareable.getResourceType((IProgressMonitor)shareProgress.newChild(1));
                if (type == ResourceType.FOLDER) {
                    IFolder folder = (IFolder)IFolder.ITEM_TYPE.createItem();
                    changes.put(folder.getItemId(), new ShareableVersionablePair(shareable, (IVersionable)folder));
                    folder.setName(shareable.getLocalPath().lastSegment());
                    folder.setParent(rootFolder);
                } else if (type == ResourceType.FILE) {
                    IFileItem file = (IFileItem)IFileItem.ITEM_TYPE.createItem();
                    changes.put(file.getItemId(), new ShareableVersionablePair(shareable, (IVersionable)file));
                    file.setName(shareable.getLocalPath().lastSegment());
                    file.setParent(rootFolder);
                } else if (type == ResourceType.SYMBOLIC_LINK) {
                    ISymbolicLink link = (ISymbolicLink)ISymbolicLink.ITEM_TYPE.createItem();
                    changes.put(link.getItemId(), new ShareableVersionablePair(shareable, (IVersionable)link));
                    link.setName(shareable.getLocalPath().lastSegment());
                    link.setParent(rootFolder);
                    IFileStorage storage = ((Shareable)shareable).getFileStorage();
                    link.setTarget(storage.getTarget((IProgressMonitor)shareProgress.newChild(1)));
                    link.setLinkTimestamp(new Date(storage.getLocalTimeStamp()));
                }
                shareProgress.worked(100);
            }
        }
        finally {
            shareProgress.done();
        }
        return changes;
    }

    public void removeProject(IShareable shareRootToRemove) {
        Iterator<IShareable> i = this.shareables.iterator();
        while (i.hasNext()) {
            IShareable shareable = i.next();
            if (!shareable.equals(shareRootToRemove)) continue;
            i.remove();
        }
    }

    private class ShareableVersionablePair {
        private IShareable shareable;
        private IVersionable versionable;

        public IShareable getShareable() {
            return this.shareable;
        }

        public IVersionable getVersionable() {
            return this.versionable;
        }

        public ShareableVersionablePair(IShareable shareable, IVersionable versionable) {
            this.shareable = shareable;
            this.versionable = versionable;
        }
    }
}

