/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.share;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRLFInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToLFInputStream;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.ContentLineDelimiterError;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReshareVersionables {
    private static final int BUFFER_LENGTH = 16384;
    final IConnection connection;
    final IComponent component;
    final Shareable shareableRoot;
    final IFolderHandle parentForShare;
    final IVersionableHandle remoteShare;
    final String remoteName;
    final boolean overwrite;

    public ReshareVersionables(IConnection connection, IComponent component, IFolderHandle parentForShare, IVersionableHandle remoteShare, String remoteName, Shareable itemToReshare, boolean overwrite) {
        this.connection = connection;
        this.component = component;
        this.parentForShare = parentForShare;
        this.remoteShare = remoteShare;
        this.remoteName = remoteName;
        this.shareableRoot = itemToReshare;
        this.overwrite = overwrite;
    }

    public void reShare(IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        FileItemInfo proxy;
        SubMonitor reshareProgress = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        ITeamRepository repo = this.connection.teamRepository();
        FileSystemServiceProxy fileSystemService = ((FileSystemManager)FileSystemCore.getFileSystemManager(repo)).getFileSystemService();
        progress.setTaskName(NLS.bind((String)Messages.ReshareProject_0, (Object)this.shareableRoot.getLocalPath(), (Object[])new Object[0]));
        IVersionableHandle remoteProjectState = this.remoteShare;
        if (!this.remoteShare.hasStateId() || this.remoteShare instanceof IFileItemHandle || this.remoteShare instanceof ISymbolicLinkHandle) {
            remoteProjectState = this.connection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)this.connection).configuration((IComponentHandle)this.component).fetchCompleteItem(this.remoteShare, (IProgressMonitor)reshareProgress.newChild(2)) : ((IBaselineConnection)this.connection).configuration().fetchCompleteItem(this.remoteShare, (IProgressMonitor)reshareProgress.newChild(2));
        }
        if (remoteProjectState instanceof IFolderHandle) {
            proxy = new FileItemInfoProxy(remoteProjectState, this.parentForShare, this.remoteName, PathUtils.isLoadedWithAnotherName(this.shareableRoot.getSandbox(), this.shareableRoot.getLocalPath(), this.remoteName)).getFileItemInfo();
        } else if (remoteProjectState instanceof ISymbolicLink) {
            ISymbolicLink link = (ISymbolicLink)remoteProjectState;
            proxy = ReshareVersionables.sameLinkContents(this.shareableRoot, (ISymbolicLinkHandle)link.getStateHandle(), this.remoteName, this.parentForShare, link.getTarget(), (IProgressMonitor)reshareProgress.newChild(1));
        } else if (remoteProjectState instanceof IFileItem) {
            IFileItem fileItem = (IFileItem)remoteProjectState;
            proxy = ReshareVersionables.sameFileContents(this.shareableRoot, (IFileItemHandle)fileItem.getStateHandle(), this.remoteName, this.parentForShare, fileItem.isExecutable(), fileItem.getContentType(), (FileContent)fileItem.getContent(), new byte[16384], repo, (IProgressMonitor)reshareProgress.newChild(1));
        } else {
            throw new TeamRepositoryException(NLS.bind((String)Messages.ReshareVersionables_0, (Object)this.remoteName, (Object[])new Object[]{remoteProjectState.getItemType().getName()}));
        }
        SharingDescriptor descriptor = new SharingDescriptor(repo.getRepositoryURI(), repo.getId(), this.connection, (IComponentHandle)this.component, this.component.getName(), remoteProjectState);
        SharingManager.getInstance().share(this.shareableRoot, descriptor, proxy, 1, (IProgressMonitor)reshareProgress.newChild(3));
        LoadTree loadTree = fileSystemService.getFileTreeByVersionable(this.connection, (IComponentHandle)this.component, new IVersionableHandle[]{this.remoteShare}, -1, true, null, (IProgressMonitor)reshareProgress.newChild(20));
        progress.setTaskName(NLS.bind((String)Messages.ReshareProject_1, (Object)this.shareableRoot.getLocalPath().toString(), (Object[])new Object[0]));
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(this.shareableRoot.getSandbox().getRoot());
        this.loadMetadata(cfa, loadTree.getFileAreaUpdates(), (IProgressMonitor)reshareProgress.newChild(60));
        cfa.setConfigurationState(this.connection.getContextHandle(), (IComponentHandle)this.component, this.shareableRoot.getLocalPath(), ISyncTime.FACTORY.createFrom(loadTree.getConfigurationState()), (IProgressMonitor)reshareProgress.newChild(5));
        IShare share = this.shareableRoot.getShare((IProgressMonitor)reshareProgress.newChild(1));
        LocalChangeManager.getInstance().refreshChanges(share, null, (IProgressMonitor)reshareProgress.newChild(9));
    }

    private void loadMetadata(ICopyFileArea cfa, List<FileAreaUpdate> additions, IProgressMonitor monitor) throws FileSystemClientException {
        HashMap<UUID, IPath> foldersEncountered = new HashMap<UUID, IPath>();
        byte[] buffer = new byte[16384];
        SharingManager sharingManager = SharingManager.getInstance();
        ISandbox sandbox = this.shareableRoot.getSandbox();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)additions.size());
        try {
            try {
                for (FileAreaUpdate currentAddition : additions) {
                    boolean isLoadedWithAnotherName;
                    IPath resourcePath;
                    SubMonitor subProgress = progress.newChild(1);
                    IPath parentPath = (IPath)foldersEncountered.get(currentAddition.parent().getItemId());
                    if (parentPath == null) {
                        resourcePath = this.shareableRoot.getLocalPath();
                        isLoadedWithAnotherName = PathUtils.isLoadedWithAnotherName(sandbox, resourcePath, currentAddition.getName());
                    } else {
                        resourcePath = parentPath.append(currentAddition.getName());
                        isLoadedWithAnotherName = false;
                    }
                    IVersionableHandle handle = currentAddition.afterState();
                    Assert.isTrue((boolean)handle.hasStateId());
                    ResourceType hint = ResourceType.getResourceType(handle);
                    Shareable resource = sharingManager.findShareable(sandbox, resourcePath, hint);
                    ResourceType type = resource.getResourceType((IProgressMonitor)subProgress.newChild(1));
                    if (hint == ResourceType.FOLDER) {
                        foldersEncountered.put(handle.getItemId(), resourcePath);
                    }
                    IFolderHandle parent = currentAddition.parent();
                    FileItemInfo itemInfo = null;
                    if (type != null) {
                        if (type == ResourceType.FOLDER) {
                            if (hint == ResourceType.FOLDER) {
                                itemInfo = new FileItemInfoProxy((IVersionableHandle)((IFolderHandle)handle), parent, currentAddition.getName(), isLoadedWithAnotherName).getFileItemInfo();
                            }
                        } else if (type == ResourceType.FILE) {
                            if (hint == ResourceType.FILE) {
                                subProgress.setWorkRemaining(2);
                                itemInfo = ReshareVersionables.sameFileContents(resource, (IFileItemHandle)currentAddition.afterState(), currentAddition.getName(), currentAddition.getDestinationParent(), currentAddition.isExecutable(), currentAddition.getContentType(), (FileContent)currentAddition.getOptionalContent(), buffer, this.connection.teamRepository(), (IProgressMonitor)subProgress.newChild(1));
                            }
                        } else if (type == ResourceType.SYMBOLIC_LINK && hint == ResourceType.SYMBOLIC_LINK) {
                            subProgress.setWorkRemaining(2);
                            itemInfo = ReshareVersionables.sameLinkContents(resource, (ISymbolicLinkHandle)currentAddition.afterState(), currentAddition.getName(), currentAddition.getDestinationParent(), currentAddition.getLinkTarget(), (IProgressMonitor)subProgress);
                        }
                    }
                    subProgress.setWorkRemaining(1);
                    if (itemInfo != null) {
                        subProgress.setWorkRemaining(1);
                        cfa.setItemMetaData(resourcePath, itemInfo, (IProgressMonitor)subProgress.newChild(1));
                    } else {
                        long lastCheckStamp;
                        boolean modified;
                        ContentHash hash = null;
                        long size = -1L;
                        FileLineDelimiter lineDelimiter = null;
                        String contentType = null;
                        ContentHash predecessorHintHash = null;
                        long storedSize = -1L;
                        String encoding = null;
                        ContentHash storedHash = null;
                        long storedNumLineDelimiters = -1L;
                        if (currentAddition.getOptionalContent() != null) {
                            FileContent content = (FileContent)currentAddition.getOptionalContent();
                            if (FileSystemCore.getContentManager(this.connection.teamRepository()).convertDelimitersDuringRetrieval((IFileContent)content)) {
                                subProgress.setWorkRemaining(10);
                                InputStream in = FileSystemCore.getContentManager(this.connection.teamRepository()).retrieveContentStream((IFileItemHandle)currentAddition.afterState(), (IFileContent)content, (IProgressMonitor)subProgress.newChild(9));
                                try {
                                    DigestComputingInputStream hin = ContentHash.getDigestComputingStream((InputStream)in);
                                    while (hin.read(buffer) != -1) {
                                    }
                                    hash = ContentHash.valueOf((byte[])hin.getFinalDigest());
                                    size = hin.getContentSize();
                                }
                                finally {
                                    in.close();
                                }
                            } else {
                                hash = content.getHash();
                                size = content.getEstimatedConvertedLength();
                            }
                            lineDelimiter = content.getLineDelimiter();
                            contentType = currentAddition.getContentType();
                            predecessorHintHash = content.getPredecessorHintHash();
                            storedSize = content.getSize();
                            encoding = content.getCharacterEncoding();
                            storedHash = content.getHash();
                            storedNumLineDelimiters = content.getLineDelimiterCount();
                        } else if (currentAddition.afterState() instanceof ISymbolicLinkHandle) {
                            hash = storedHash = FileItemInfoProxy.getLinkTargetHash(currentAddition.getLinkTarget());
                        }
                        subProgress.setWorkRemaining(1);
                        InverseFileItemInfo oldInfo = cfa.getItemInfo(handle, (IComponentHandle)this.component, this.connection.getContextHandle());
                        if (oldInfo == null || handle instanceof IFolderHandle) {
                            modified = false;
                            lastCheckStamp = -1L;
                        } else if (oldInfo.getHash() != null && oldInfo.getHash().equals((Object)hash) && (handle instanceof ISymbolicLinkHandle || handle instanceof IFileItemHandle && oldInfo.getContentLength() == size)) {
                            modified = oldInfo.isContentChanged();
                            lastCheckStamp = oldInfo.getLastContentChangeCheckStamp();
                        } else {
                            modified = true;
                            lastCheckStamp = -1L;
                        }
                        itemInfo = new FileItemInfo(handle, modified, lastCheckStamp, parent, currentAddition.getName(), isLoadedWithAnotherName, hash, size, lineDelimiter, lineDelimiter, contentType, contentType, predecessorHintHash, storedSize, encoding, storedHash, storedNumLineDelimiters, currentAddition.isExecutable(), currentAddition.isExecutable());
                        cfa.setItemMetaData(this.connection.getContextHandle(), (IComponentHandle)this.component, itemInfo, (IProgressMonitor)subProgress.newChild(1));
                    }
                    subProgress.done();
                }
            }
            catch (IOException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
            }
            catch (TeamRepositoryException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
            }
        }
        finally {
            progress.done();
        }
    }

    private static FileItemInfo sameLinkContents(Shareable link, ISymbolicLinkHandle afterState, String name, IFolderHandle parent, String remoteTarget, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ContentHash hashCode = FileItemInfoProxy.getLinkTargetHash(link.getFileStorage().getTarget((IProgressMonitor)progress.newChild(1)));
        ContentHash remoteHashCode = FileItemInfoProxy.getLinkTargetHash(remoteTarget);
        boolean isLoadedWithAnotherName = PathUtils.isLoadedWithAnotherName(link.getSandbox(), link.getLocalPath(), name);
        boolean contentChanged = !hashCode.equals((Object)remoteHashCode);
        return new FileItemInfo(afterState, contentChanged, parent, name, isLoadedWithAnotherName, remoteHashCode, remoteHashCode);
    }

    private static FileItemInfo sameFileContents(Shareable file, IFileItemHandle afterState, String name, IFolderHandle parent, boolean executable, String contentType, FileContent content, byte[] buffer, ITeamRepository repo, IProgressMonitor monitor) throws TeamRepositoryException {
        String actualContentType;
        String originalContentType;
        FileLineDelimiter actualLineDelimiter;
        FileLineDelimiter originalLineDelimiter;
        ContentHash hashCode;
        long contentSize;
        boolean contentChanged;
        long modificationTime;
        SubMonitor progress;
        block32: {
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            modificationTime = -1L;
            contentChanged = true;
            contentSize = content.getEstimatedConvertedLength();
            hashCode = null;
            originalLineDelimiter = content.getLineDelimiter();
            actualLineDelimiter = content.getLineDelimiter();
            originalContentType = contentType;
            actualContentType = contentType;
            IFileStorage fileStorage = file.getFileStorage();
            URI location = fileStorage.getLocationURI();
            if (location != null) {
                try {
                    DigestComputingInputStream localHashedStream;
                    DigestComputingInputStream remoteHashedStream;
                    IFileStore store = EFS.getStore((URI)location);
                    IFileInfo localInfo = store.fetchInfo(0, (IProgressMonitor)progress.newChild(1));
                    modificationTime = fileStorage.getModificationStamp();
                    long localLength = localInfo.getLength();
                    if (localLength != content.getEstimatedConvertedLength()) break block32;
                    InputStream inStream = store.openInputStream(0, (IProgressMonitor)progress.newChild(78));
                    IContentExaminer contentExaminer = SharingManager.getInstance().getContentExaminer();
                    try {
                        block6 : switch (originalLineDelimiter) {
                            case LINE_DELIMITER_CR: {
                                String encoding = contentExaminer.getEncoding(file, (IProgressMonitor)progress.newChild(1));
                                inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(inStream, encoding));
                                localHashedStream = remoteHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                                break;
                            }
                            case LINE_DELIMITER_PLATFORM: {
                                String encoding = contentExaminer.getEncoding(file, (IProgressMonitor)progress.newChild(1));
                                switch (FileLineDelimiter.getPlatformDelimiter()) {
                                    case LINE_DELIMITER_CRLF: {
                                        inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(inStream, encoding));
                                        localHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                                        inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream((InputStream)localHashedStream, encoding));
                                        remoteHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                                        break block6;
                                    }
                                    case LINE_DELIMITER_CR: {
                                        inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(inStream, encoding));
                                        localHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                                        inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream((InputStream)localHashedStream, encoding));
                                        remoteHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                                        break block6;
                                    }
                                }
                                inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(inStream, encoding));
                                localHashedStream = remoteHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                                break;
                            }
                            case LINE_DELIMITER_LF: {
                                String encoding = contentExaminer.getEncoding(file, (IProgressMonitor)progress.newChild(1));
                                inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(inStream, encoding));
                                localHashedStream = remoteHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                                break;
                            }
                            case LINE_DELIMITER_CRLF: {
                                String encoding = contentExaminer.getEncoding(file, (IProgressMonitor)progress.newChild(1));
                                inStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(inStream, encoding));
                                localHashedStream = remoteHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                                break;
                            }
                            default: {
                                localHashedStream = remoteHashedStream = ContentHash.getDigestComputingStream((InputStream)inStream);
                            }
                        }
                        while (remoteHashedStream.read(buffer) != -1) {
                        }
                    }
                    finally {
                        inStream.close();
                    }
                    ContentHash convertedRemoteHashCode = ContentHash.valueOf((byte[])remoteHashedStream.getFinalDigest());
                    if (convertedRemoteHashCode.equals((Object)content.getHash()) && remoteHashedStream.getContentSize() == content.getRawLength() && localHashedStream.getContentSize() == content.getEstimatedConvertedLength()) {
                        hashCode = localHashedStream == remoteHashedStream ? convertedRemoteHashCode : ContentHash.valueOf((byte[])localHashedStream.getFinalDigest());
                        contentSize = localHashedStream.getContentSize();
                        contentChanged = false;
                    }
                }
                catch (ContentLineDelimiterError contentLineDelimiterError) {
                    actualLineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
                }
                catch (CoreException coreException) {
                }
                catch (IOException iOException) {
                    actualLineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
                }
            }
        }
        if (hashCode == null) {
            if (FileSystemCore.getContentManager(repo).convertDelimitersDuringRetrieval((IFileContent)content)) {
                progress.setWorkRemaining(20);
                InputStream in = FileSystemCore.getContentManager(repo).retrieveContentStream(afterState, (IFileContent)content, (IProgressMonitor)progress.newChild(20));
                try {
                    try {
                        DigestComputingInputStream hin = ContentHash.getDigestComputingStream((InputStream)in);
                        while (hin.read(buffer) != -1) {
                        }
                        hashCode = ContentHash.valueOf((byte[])hin.getFinalDigest());
                        contentSize = hin.getContentSize();
                    }
                    catch (IOException e) {
                        throw new TeamRepositoryException((Throwable)e);
                    }
                }
                catch (Throwable throwable) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            } else {
                hashCode = content.getHash();
                contentSize = content.getEstimatedConvertedLength();
            }
        }
        boolean isLoadedWithAnotherName = PathUtils.isLoadedWithAnotherName(file.getSandbox(), file.getLocalPath(), name);
        return new FileItemInfo((IVersionableHandle)afterState, contentChanged, modificationTime, parent, name, isLoadedWithAnotherName, hashCode, contentSize, originalLineDelimiter, actualLineDelimiter, originalContentType, actualContentType, content.getPredecessorHintHash(), content.getSize(), content.getCharacterEncoding(), content.getHash(), content.getLineDelimiterCount(), executable, executable);
    }
}

