/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.rest;

import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.lang.reflect.Array;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ParmValidation {
    public static void requiredValue(Object value, String requestName, Object ... parameterName) {
        if (value == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.ParmValidation_0, (Object)ParmValidation.getParameterName(parameterName), (Object[])new Object[]{requestName}));
        }
        if (value instanceof String && ((String)value).length() == 0) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.ParmValidation_0, (Object)ParmValidation.getParameterName(parameterName), (Object[])new Object[]{requestName}));
        }
    }

    public static void requiredArray(Object[] value, String requestName, Object ... parameterName) {
        ParmValidation.requiredValue(value, requestName, parameterName);
        int i = 0;
        while (i < value.length) {
            if (value[i] == null || value[i] instanceof String && ((String)value[i]).length() == 0) {
                throw new IllegalArgumentException(NLS.bind((String)Messages.ParmValidation_1, (Object)ParmValidation.getParameterName(parameterName), (Object[])new Object[]{i, requestName}));
            }
            ++i;
        }
    }

    public static String getParameterName(Object ... parameterName) {
        StringBuffer name = new StringBuffer();
        Object[] objectArray = parameterName;
        int n = parameterName.length;
        int n2 = 0;
        while (n2 < n) {
            Object segment = objectArray[n2];
            if (segment instanceof String) {
                if (name.length() > 0) {
                    name.append(".");
                }
                name.append(segment);
            } else if (segment instanceof Integer) {
                name.append("[").append(segment).append("]");
            } else if (segment.getClass().isArray()) {
                int i = 0;
                while (i < Array.getLength(segment)) {
                    name.append(ParmValidation.getParameterName(Array.get(segment, i)));
                    ++i;
                }
            }
            ++n2;
        }
        return name.toString();
    }

    public static void inEnum(String value, String requestName, String[] legalValues, Object ... parameterName) {
        String[] stringArray = legalValues;
        int n = legalValues.length;
        int n2 = 0;
        while (n2 < n) {
            String legalValue = stringArray[n2];
            if (legalValue == null ? value == null : legalValue.equals(value)) {
                return;
            }
            ++n2;
        }
        StringBuffer sb = new StringBuffer();
        String[] stringArray2 = legalValues;
        int n3 = legalValues.length;
        n = 0;
        while (n < n3) {
            String legalValue = stringArray2[n];
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(legalValue);
            ++n;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.ParmValidation_2, (Object)value, (Object[])new Object[]{ParmValidation.getParameterName(parameterName), requestName, sb.toString()}));
    }

    public static String validCanonicalPath(String path, String requestName, Object ... parameterName) {
        Path canonicalPath;
        Path originalPath = new Path(path);
        String result = PathUtils.getRealPath(path);
        if (result != null && PathUtils.samePath((IPath)originalPath, false, (IPath)(canonicalPath = new Path(result)), false)) {
            return result;
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.ParmValidation_6, (Object)path, (Object[])new Object[]{ParmValidation.getParameterName(parameterName), requestName}));
    }

    public static String[] validRelativeCanonicalPaths(String validSandboxPath, String[] relativePaths, String requestName, Object ... parameterName) {
        String[] result = new String[relativePaths.length];
        int i = 0;
        while (i < relativePaths.length) {
            result[i] = ParmValidation.validRelativeCanonicalPath(validSandboxPath, relativePaths[i], requestName, parameterName, i);
            ++i;
        }
        return result;
    }

    public static String validRelativeCanonicalPath(String validSandboxPath, String relativePath, String requestName, Object ... parameterName) {
        Path canonicalPath;
        File file = new File(validSandboxPath, relativePath);
        String fullPath = PathUtils.getRealPath(file.getAbsolutePath());
        IPath originalPath = new Path(validSandboxPath).append(relativePath);
        if (PathUtils.samePath(originalPath, false, (IPath)(canonicalPath = new Path(fullPath)), false)) {
            return fullPath.substring(validSandboxPath.length());
        }
        throw new IllegalArgumentException(NLS.bind((String)Messages.ParmValidation_4, (Object)relativePath, (Object[])new Object[]{validSandboxPath, ParmValidation.getParameterName(parameterName), requestName}));
    }

    public static void requireContains(String param, String sequence, String parameterName, String requestName) {
        if (!param.contains(sequence)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.ParmValidation_REQUIRE_CONTAINS, (Object)param, (Object[])new Object[]{sequence, ParmValidation.getParameterName(parameterName), requestName}));
        }
    }
}

