/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.AbstractLockOperation;
import com.ibm.team.filesystem.client.operations.ITransferLockOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LockEntry;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class TransferLockOperation
extends AbstractLockOperation
implements ITransferLockOperation {
    private Map<LockEntry, IContributorHandle> map = new HashMap<LockEntry, IContributorHandle>();

    public TransferLockOperation(LockDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler);
    }

    protected IWorkspaceManager.IVersionableLockOperation getLockOperation(IWorkspaceManager.IVersionableLockOperationFactory lockOperationFactory, LockEntry lockEntry, IWorkspaceConnection connection) {
        return lockOperationFactory.transfer(lockEntry.getVersionable(), connection, lockEntry.getComponent(), this.map.get(lockEntry));
    }

    public void transfer(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IVersionableHandle versionableHandle, IContributorHandle contributorHandle, IContributorHandle targetContributorHandle) {
        LockEntry lockEntry = this.add(workspaceConnection, componentHandle, versionableHandle, contributorHandle);
        this.map.put(lockEntry, targetContributorHandle);
    }

    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        int result = this.checkLockOwners();
        switch (result) {
            case 1: {
                throw new OperationCanceledException();
            }
            case 2: {
                throw new FileSystemClientException(new FileSystemStatus(4, Messages.UnlockOperation_0));
            }
            case 0: {
                break;
            }
        }
        super.execute(monitor);
    }
}

