/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.ISuspendOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.SuspendDilemmaHandler;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuspendOperation
extends ChangeHistoryChangeSetsOperation
implements ISuspendOperation {
    private final SuspendDilemmaHandler problemHandler;
    private Map<IWorkspaceConnection, List<IChangeSetHandle>> suspendRequests;

    public SuspendOperation(SuspendDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? SuspendDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? SuspendDilemmaHandler.getDefault() : dilemmaHandler;
        this.suspendRequests = new HashMap<IWorkspaceConnection, List<IChangeSetHandle>>();
    }

    @Override
    public void suspend(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> changesToSuspend) {
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (changesToSuspend == null) {
            throw new IllegalArgumentException();
        }
        if (changesToSuspend.isEmpty()) {
            throw new IllegalArgumentException();
        }
        HashSet<UUID> duplicateCheck = new HashSet<UUID>();
        for (IChangeSetHandle iChangeSetHandle : changesToSuspend) {
            if (iChangeSetHandle == null) {
                throw new IllegalArgumentException();
            }
            if (duplicateCheck.add(iChangeSetHandle.getItemId())) continue;
            throw new IllegalArgumentException();
        }
        List<IChangeSetHandle> list = this.suspendRequests.get(workspace);
        if (list == null) {
            ArrayList<? extends IChangeSetHandle> changesToSuspendList = new ArrayList<IChangeSetHandle>(changesToSuspend);
            this.suspendRequests.put(workspace, changesToSuspendList);
        } else {
            list.addAll(changesToSuspend);
        }
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.SuspendOperation_ProgressMessage, (int)100);
        final HashSet<ConfigurationDescriptor> affectedConfigurations = new HashSet<ConfigurationDescriptor>();
        ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
        for (IWorkspaceConnection key : this.suspendRequests.keySet()) {
            List<IChangeSetHandle> changeSetHandles = this.suspendRequests.get(key);
            affectedConfigurations.addAll(this.getAffectedConfigurations(determinants, key, changeSetHandles, (IProgressMonitor)progress.newChild(4)));
        }
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, determinants, (IProgressMonitor)progress.newChild(1));
        try {
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ICopyFileAreasLock copyFileAreaLock;
                    ICopyFileAreaLockRequest lockRequest;
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
                    IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(SuspendOperation.this.problemHandler.getOutOfSyncDilemmaHandler());
                    for (Object key : SuspendOperation.this.suspendRequests.keySet()) {
                        if (!SuspendOperation.this.verifyInSyncEnabled() || SuspendOperation.this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) continue;
                        for (ConfigurationDescriptor configurationDescriptor : affectedConfigurations) {
                            verifyOp.addToVerify((IConnection)key, configurationDescriptor.componentHandle);
                        }
                    }
                    try {
                        verifyOp.run((IProgressMonitor)progress.newChild(20));
                    }
                    catch (FileSystemClientException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                    try {
                        lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(affectedConfigurations, true);
                        copyFileAreaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
                        try {
                            SuspendOperation.this.checkinPendingChanges(affectedConfigurations, SuspendOperation.this.problemHandler, true, (IProgressMonitor)progress.newChild(30));
                        }
                        finally {
                            copyFileAreaLock.release((IProgressMonitor)progress);
                        }
                    }
                    catch (FileSystemClientException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                    try {
                        lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(affectedConfigurations, true);
                        copyFileAreaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
                        try {
                            for (Object key : SuspendOperation.this.suspendRequests.keySet()) {
                                List changeSetHandles = (List)SuspendOperation.this.suspendRequests.get(key);
                                SuspendOperation.this.suspend(affectedConfigurations, (IWorkspaceConnection)key, changeSetHandles, monitor);
                            }
                            SuspendOperation.this.suspendRequests.clear();
                        }
                        finally {
                            copyFileAreaLock.release((IProgressMonitor)progress);
                        }
                    }
                    catch (FileSystemClientException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, Messages.SuspendOperation_0, (IProgressMonitor)progress.newChild(95));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
        progress.done();
    }

    private void suspend(Set<ConfigurationDescriptor> affectedConfigurations, IWorkspaceConnection workspaceConnection, Collection changeSetHandles, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)175);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        IUpdateReport report = workspaceConnection.suspend(changeSetHandles, (IProgressMonitor)progress.newChild(75));
        UpdateOperation op = new UpdateOperation(workspaceConnection, Collections.singletonList(report), 3, this.problemHandler, null);
        this.disableVerifyInSync(op);
        op.run((IProgressMonitor)progress.newChild(50));
    }

    private Set<ConfigurationDescriptor> getAffectedConfigurations(Collection<IAuditable> determinants, IWorkspaceConnection workspaceConnection, List<IChangeSetHandle> changeSetHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<ConfigurationDescriptor> affectedConfigurations = new HashSet<ConfigurationDescriptor>();
        List changeSets = workspaceConnection.teamRepository().itemManager().fetchCompleteItems(changeSetHandles, 0, monitor);
        determinants.addAll(determinants);
        for (IChangeSet changeSet : changeSets) {
            affectedConfigurations.add(new ConfigurationDescriptor((IConnection)workspaceConnection, changeSet.getComponent()));
        }
        return affectedConfigurations;
    }

    @Override
    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationDescriptor>> affectedAreas, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        Iterator<IWorkspaceConnection> iterator = this.suspendRequests.keySet().iterator();
        while (iterator.hasNext()) {
            IWorkspaceConnection key;
            IWorkspaceConnection workspaceConnection = key = iterator.next();
            List<IChangeSetHandle> changeSetHandles = this.suspendRequests.get(key);
            ChangeSetRefreshUtils.refreshLocalForRemoval(refresher, affectedAreas, workspaceConnection, changeSetHandles, progress);
        }
    }
}

