/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.ReplaceDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceWithRepositoryOperation
extends FileSystemOperation {
    public static final int DEPTH_INFINITY = -1;
    private final Collection<IShareable> shareablesToReplace;
    private final int depth;
    private ReplaceDilemmaHandler problemHandler;

    public ReplaceWithRepositoryOperation(Collection<IShareable> shareablesToReplace, int depth, ReplaceDilemmaHandler problemHandler) {
        super(problemHandler == null ? ReplaceDilemmaHandler.getDefault() : problemHandler);
        ReplaceDilemmaHandler replaceDilemmaHandler = this.problemHandler = problemHandler == null ? ReplaceDilemmaHandler.getDefault() : problemHandler;
        if (shareablesToReplace == null) {
            throw new IllegalArgumentException("shareables must not be null");
        }
        if (depth < 0 && depth != -1) {
            throw new IllegalArgumentException("depth must be greater than 0");
        }
        this.shareablesToReplace = shareablesToReplace;
        this.depth = depth;
    }

    @Override
    protected void execute(IProgressMonitor reporter) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)reporter, (int)100);
        final HashMap<ConfigurationDescriptor, List<IShareable>> toReload = new HashMap<ConfigurationDescriptor, List<IShareable>>();
        final ArrayList<IShareable> toDelete = new ArrayList<IShareable>();
        HashSet<ConfigurationDescriptor> affectedConfigurations = new HashSet<ConfigurationDescriptor>();
        final HashMap<ISandbox, Set<ConfigurationDescriptor>> affectedSandboxes = new HashMap<ISandbox, Set<ConfigurationDescriptor>>();
        this.getConfigurationsAffected(affectedConfigurations, affectedSandboxes, toReload, toDelete, (IProgressMonitor)progress.newChild(1));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        try {
            IRunnableWithProgress workspaceOp = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        ICopyFileAreaManager cfaManager = ICopyFileAreaManager.instance;
                        ICopyFileAreaManager.ICopyFileAreaLockRequestFactory lockFactory = cfaManager.lockRequestFactory();
                        ArrayList<ICopyFileAreaLockRequest> lockRequests = new ArrayList<ICopyFileAreaLockRequest>();
                        for (Map.Entry entry : affectedSandboxes.entrySet()) {
                            ISandbox sandbox = (ISandbox)entry.getKey();
                            Set configurationsToLock = (Set)entry.getValue();
                            lockRequests.add(lockFactory.getLockRequest(sandbox.getRoot(), configurationsToLock, false));
                        }
                        ICopyFileAreasLock cfaLock = cfaManager.lock(lockRequests, (IProgressMonitor)progress.newChild(1));
                        try {
                            ReplaceWithRepositoryOperation.this.replace(toReload, toDelete, (IProgressMonitor)progress.newChild(98));
                        }
                        finally {
                            cfaLock.release((IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (FileSystemClientException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(workspaceOp, Messages.ReplaceWithRepositoryOperation_0, (IProgressMonitor)progress.newChild(98));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    private void getConfigurationsAffected(Set<ConfigurationDescriptor> affectedConfigurations, Map<ISandbox, Set<ConfigurationDescriptor>> affectedSandboxes, Map<ConfigurationDescriptor, List<IShareable>> toReload, List<IShareable> toDelete, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(this.shareablesToReplace.size() * 2));
        for (IShareable shareable : this.shareablesToReplace) {
            boolean needsToBeLoaded = false;
            IShare share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
            if (share != null) {
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                ConfigurationDescriptor configuration = new ConfigurationDescriptor(descriptor.getRepositoryId(), descriptor.getRepositoryUri(), descriptor.getConnectionHandle(), descriptor.getComponent());
                affectedConfigurations.add(configuration);
                Set<ConfigurationDescriptor> configurations = affectedSandboxes.get(shareable.getSandbox());
                if (configurations == null) {
                    configurations = new HashSet<ConfigurationDescriptor>();
                    affectedSandboxes.put(shareable.getSandbox(), configurations);
                }
                configurations.add(configuration);
                IVersionableHandle remoteHandle = shareable.getRemote((IProgressMonitor)monitor.newChild(1));
                if (remoteHandle != null) {
                    needsToBeLoaded = true;
                    List<IShareable> shareables = toReload.get(configuration);
                    if (shareables == null) {
                        shareables = new ArrayList<IShareable>();
                        toReload.put(configuration, shareables);
                    }
                    shareables.add(shareable);
                }
            }
            if (needsToBeLoaded) continue;
            toDelete.add(shareable);
        }
    }

    protected void replace(Map<ConfigurationDescriptor, List<IShareable>> toReload, List<IShareable> toDelete, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        monitor.subTask(Messages.ReplaceWithRepositoryOperation_ProgressMessage);
        int numShareables = this.shareablesToReplace.size();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(numShareables * 10 + 10));
        int processed = 0;
        HashSet<UUID> ids = new HashSet<UUID>();
        ArrayList<IComponentHandle> componentsToRetrieve = new ArrayList<IComponentHandle>();
        IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler);
        ITeamRepository repo = null;
        for (Map.Entry<ConfigurationDescriptor, List<IShareable>> entry : toReload.entrySet()) {
            ConfigurationDescriptor configuration = entry.getKey();
            List<IShareable> list = entry.getValue();
            if (repo == null) {
                repo = configuration.getTeamRepository();
            }
            for (Object shareable : list) {
                IShare share = shareable.getShare((IProgressMonitor)progress.newChild(1));
                ISharingDescriptor descriptor = share.getSharingDescriptor();
                verifyOp.addToVerify(configuration.getConnection((IProgressMonitor)progress.newChild(1)), share);
                if (!ids.add(descriptor.getComponent().getItemId())) continue;
                componentsToRetrieve.add(descriptor.getComponent());
            }
        }
        HashMap<UUID, IComponent> components = new HashMap<UUID, IComponent>();
        if (!componentsToRetrieve.isEmpty()) {
            List componentsRetrieved = repo.itemManager().fetchCompleteItems(componentsToRetrieve, 0, (IProgressMonitor)progress.newChild(10));
            for (IComponent component : componentsRetrieved) {
                components.put(component.getItemId(), component);
            }
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!toReload.isEmpty() && this.verifyInSyncEnabled() && !this.problemHandler.willIgnoreAllSharesOutOfSync()) {
            verifyOp.run((IProgressMonitor)progress.newChild(1));
        }
        if (!toReload.isEmpty()) {
            FileSystemServiceProxy fileSystemService = ((FileSystemManager)FileSystemCore.getFileSystemManager(repo)).getFileSystemService();
            int retrievalDepth = this.depth == -1 ? -1 : this.depth;
            for (Map.Entry entry : toReload.entrySet()) {
                IConnection connection = ((ConfigurationDescriptor)entry.getKey()).getConnection((IProgressMonitor)progress.newChild(1));
                List shareables = (List)entry.getValue();
                for (IShareable shareable : shareables) {
                    SubMonitor iterationProgress = progress.newChild(5);
                    iterationProgress.setWorkRemaining(100);
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    monitor.setTaskName(NLS.bind((String)Messages.ReplaceWithRepositoryOperation_ProgressSubTaskMessage, (Object)shareable.getLocalPath(), (Object[])new Object[]{++processed, numShareables}));
                    IShare share = shareable.getShare((IProgressMonitor)iterationProgress.newChild(1));
                    IComponentHandle componentHandle = share.getSharingDescriptor().getComponent();
                    IComponent component = (IComponent)components.get(componentHandle.getItemId());
                    IVersionableHandle remote = shareable.getRemote((IProgressMonitor)iterationProgress.newChild(1));
                    LoadTree loadTree = fileSystemService.getFileTreeByVersionable(connection, (IComponentHandle)component, new IVersionableHandle[]{remote}, retrievalDepth, true, null, (IProgressMonitor)iterationProgress.newChild(50));
                    HashMap<ConfigurationDescriptor, Set<IVersionableHandle>> shareRoots = new HashMap<ConfigurationDescriptor, Set<IVersionableHandle>>();
                    Set<IVersionableHandle> roots = Collections.singleton(share.getSharingDescriptor().getRootVersionable());
                    shareRoots.put((ConfigurationDescriptor)entry.getKey(), roots);
                    boolean isLoadWithAnotherName = false;
                    if (shareable.isShare((IProgressMonitor)iterationProgress.newChild(1)) && share.isLoadedWithAnotherName((IProgressMonitor)iterationProgress.newChild(1))) {
                        isLoadWithAnotherName = true;
                    }
                    LoadLocation loadLocation = new LoadLocation(shareable.getSandbox(), shareable.getLocalPath().removeLastSegments(1), shareable.getLocalPath().lastSegment(), connection, component, remote, isLoadWithAnotherName);
                    HashSet<LoadLocation> itemToLoad = new HashSet<LoadLocation>();
                    itemToLoad.add(loadLocation);
                    FileSystemOperation mutator = SharingManager.getInstance().getLoadMutator(4, connection, component, loadLocation.getSandbox(), Collections.singletonList(loadLocation), loadTree, this.problemHandler, null);
                    try {
                        SharingManager.getInstance().disableChangeMonitoring();
                        mutator.run((IProgressMonitor)iterationProgress.newChild(45));
                    }
                    finally {
                        SharingManager.getInstance().enableChangeMonitoring();
                    }
                }
            }
        }
        if (!toDelete.isEmpty()) {
            Shed shed = new Shed(this.problemHandler.getBackupDilemmaHandler());
            for (IShareable shareable : toDelete) {
                SubMonitor iterationProgress = progress.newChild(10);
                iterationProgress.setWorkRemaining(100);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IFileStorage storage = ((Shareable)shareable).getFileStorage();
                if (shareable.exists((IProgressMonitor)iterationProgress.newChild(1))) {
                    storage.delete(shed, (IProgressMonitor)iterationProgress.newChild(75));
                }
                ((Shareable)shareable).forget((IProgressMonitor)iterationProgress.newChild(24));
            }
        }
    }
}

