/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoadedComponentsStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.PersistentHeapManager;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptorsMap;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.StringWrapper;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.migration.MigrationUtil;
import com.ibm.team.filesystem.client.internal.operations.SynchronizeOperation;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.ITeamRepositoryService;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class RebuildCFAOperation {
    private RebuildCFAOperation() {
    }

    /*
     * Unable to fully structure code
     */
    public static void rebuildCFA(IPath cfaRoot, IRepositoryResolver resolver, RebuildOperationParticipant p, IProgressMonitor monitor) throws FileSystemClientException {
        progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RebuildCFAOperation_0, (int)100);
        if (p == null) {
            p = new RebuildOperationParticipant();
        }
        rule = SharingManager.getInstance().getTrackingRule(cfaRoot);
        try {
            Job.getJobManager().beginRule(rule, (IProgressMonitor)progress.newChild(1));
            lock = CFALockUtil.createAndLockSuperExclusive(cfaRoot, (IProgressMonitor)progress.newChild(1));
            try {
                block95: {
                    block94: {
                        block97: {
                            cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(cfaRoot);
                            cfaRoot = cfa.getRoot();
                            sandbox = SharingManager.getInstance().getSandbox(cfaRoot, false);
                            metadata = cfa.internalGetMetadata();
                            progress.setTaskName(Messages.RebuildCFAOperation_1);
                            exceptions = new ArrayList<Object>();
                            if (CopyFileAreaManager.instance.hasOldMetaDataFolder(cfaRoot)) {
                                path = CopyFileAreaManager.getOldMetadataPathForRoot(cfaRoot);
                                try {
                                    sharingDescriptors = MigrationUtil.readOldSharingDescriptors(cfaRoot);
                                    subProgress = progress.newChild(1);
                                    subProgress.setWorkRemaining(sharingDescriptors.length);
                                    var17_19 = sharingDescriptors;
                                    var16_24 = sharingDescriptors.length;
                                    var15_29 = 0;
                                    while (var15_29 < var16_24) {
                                        sharingInfoWrapper = var17_19[var15_29];
                                        sharePath = new Path(sharingInfoWrapper.path);
                                        sharingDescriptor = metadata.getSharingDescriptor((IPath)sharePath);
                                        if (sharingDescriptor == null) {
                                            desc = sharingInfoWrapper.getSharingDescriptor();
                                            shareRoot = sandbox.findShareable((IPath)sharePath, ResourceType.getResourceType(desc.getRootVersionable()));
                                            if (shareRoot.exists((IProgressMonitor)subProgress.newChild(1))) {
                                                if (RebuildCFAOperation.isLoggedInToRepo(resolver, (ISharingDescriptor)desc)) {
                                                    metadata.setSharingDescriptor((IPath)sharePath, (ISharingDescriptor)desc, (IProgressMonitor)subProgress.newChild(1));
                                                } else {
                                                    RebuildCFAOperation.ensureUnshared(cfaRoot, (IPath)sharePath, subProgress.newChild(1));
                                                    exceptions.add((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.RebuildCFAOperation_RepositoryNotLoggedIn, (Object[])new Object[]{sharePath.toString(), cfaRoot.toOSString(), desc.getRepositoryUri()}), null)));
                                                }
                                            } else {
                                                exceptions.add((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.RebuildCFAOperation_FolderNotInSandbox, (Object)sharePath.toString(), (Object)cfaRoot.toOSString()), null)));
                                            }
                                        } else {
                                            exceptions.add((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(2, NLS.bind((String)Messages.RebuildCFAOperation_FolderAlreadySharedInSandbox, (Object)sharePath.toString(), (Object)cfaRoot.toOSString()), null)));
                                        }
                                        ++var15_29;
                                    }
                                    subProgress.done();
                                    RebuildCFAOperation.delete(path.toFile());
                                }
                                catch (IOException e) {
                                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.RebuildCFAOperation_ErrorReadingOldMetadata, (Object)path.toOSString()), (Throwable)e));
                                }
                            }
                            if (!CopyFileAreaManager.instance.hasInterumMetadataFolder(cfaRoot)) break block97;
                            try {
                                block93: {
                                    metadataPath = CopyFileAreaManager.getInterumMetadataPathForRoot(cfaRoot);
                                    descPath = metadataPath.append(".descriptors.dat");
                                    descriptorsMap = new SharingDescriptorsMap(descPath.toFile(), metadata.isCaseSensitive());
                                    subProgress = progress.newChild(1);
                                    subProgress.setWorkRemaining(descriptorsMap.size());
                                    i = descriptorsMap.entrySet().iterator();
                                    while (true) lbl-1000:
                                    // 6 sources

                                    {
                                        try {
                                            e = (Map.Entry)i.next();
                                        }
                                        catch (NoSuchElementException v0) {
                                            break block93;
                                        }
                                        catch (OperationCanceledException ex) {
                                            throw ex;
                                        }
                                        catch (Exception ex) {
                                            exceptions.add(ex);
                                            break block93;
                                        }
                                        try {
                                            path = ((StringWrapper)e.getKey()).toString();
                                            descriptor = (ISharingDescriptor)e.getValue();
                                            sharePath = new Path(path);
                                            sharingDescriptor = metadata.getSharingDescriptor((IPath)sharePath);
                                            if (sharingDescriptor == null) {
                                                shareable = sandbox.findShareable((IPath)sharePath, ResourceType.getResourceType(descriptor.getRootVersionable()));
                                                if (shareable.exists((IProgressMonitor)subProgress.newChild(1))) {
                                                    if (RebuildCFAOperation.isLoggedInToRepo(resolver, descriptor)) {
                                                        metadata.setSharingDescriptor((IPath)sharePath, descriptor, (IProgressMonitor)subProgress.newChild(1));
                                                    }
                                                    RebuildCFAOperation.ensureUnshared(cfaRoot, (IPath)sharePath, subProgress.newChild(1));
                                                    exceptions.add((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.RebuildCFAOperation_RepositoryNotLoggedIn, (Object[])new Object[]{sharePath.toString(), cfaRoot.toOSString(), descriptor.getRepositoryUri()}), null)));
                                                }
                                                exceptions.add((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.RebuildCFAOperation_FolderNotInSandbox, (Object)sharePath.toString(), (Object)cfaRoot.toOSString()), null)));
                                            }
                                            exceptions.add((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(2, NLS.bind((String)Messages.RebuildCFAOperation_FolderAlreadySharedInSandbox, (Object)sharePath.toString(), (Object)cfaRoot.toOSString()), null)));
                                        }
                                        catch (OperationCanceledException ex) {
                                            throw ex;
                                        }
                                        catch (Exception ex) {
                                            exceptions.add(ex);
                                            continue;
                                        }
                                        break;
                                    }
                                    ** GOTO lbl-1000
                                    finally {
                                        descriptorsMap.close();
                                    }
                                }
                                subProgress.done();
                                RebuildCFAOperation.delete(metadataPath.toFile());
                            }
                            catch (OperationCanceledException ex) {
                                throw ex;
                            }
                            catch (Exception ex) {
                                exceptions.add(ex);
                            }
                        }
                        metadata.close();
                        descriptors = new HashMap<RootKey, ISharingDescriptor>();
                        roots = new HashMap<RootKey, String>();
                        try {
                            metadataPath = CopyFileAreaManager.getMetadataPathForRoot(cfaRoot);
                            descPath = metadataPath.append(".descriptors.dat");
                            descriptorsMap = new SharingDescriptorsMap(descPath.toFile(), metadata.isCaseSensitive());
                            subProgress = progress.newChild(1);
                            subProgress.setWorkRemaining(descriptorsMap.size() * 4);
                            i = descriptorsMap.entrySet().iterator();
                            while (true) lbl-1000:
                            // 6 sources

                            {
                                try {
                                    e = (Map.Entry)i.next();
                                }
                                catch (NoSuchElementException v1) {
                                    break block94;
                                }
                                catch (OperationCanceledException ex) {
                                    throw ex;
                                }
                                catch (Exception ex) {
                                    exceptions.add(ex);
                                    break block94;
                                }
                                try {
                                    path = ((StringWrapper)e.getKey()).toString();
                                    descriptor = (ISharingDescriptor)e.getValue();
                                    r = new RootKey(descriptor.getConnectionHandle().getItemId(), descriptor.getComponent().getItemId(), descriptor.getRootVersionable().getItemId());
                                    otherPath = roots.put(r, path);
                                    if (otherPath == null) {
                                        descriptors.put(r, descriptor);
                                    }
                                    SharingManager.getInstance();
                                    otherShareable = sandbox.findShareable((IPath)new Path(null, otherPath), ResourceType.FOLDER);
                                    if (!otherShareable.exists((IProgressMonitor)subProgress.newChild(1)) || otherShareable.getResourceType((IProgressMonitor)subProgress.newChild(1)) != ResourceType.FOLDER) {
                                        newShareable = sandbox.findShareable((IPath)new Path(null, path), ResourceType.FOLDER);
                                        if (newShareable.exists((IProgressMonitor)subProgress.newChild(1)) && newShareable.getResourceType((IProgressMonitor)subProgress.newChild(1)) == ResourceType.FOLDER) {
                                            descriptors.put(r, descriptor);
                                            exceptions.add(new Exception(NLS.bind((String)Messages.RebuildCFAOperation_4, (Object)otherPath, (Object)path)));
                                        }
                                        roots.put(r, otherPath);
                                        exceptions.add(new Exception(NLS.bind((String)Messages.RebuildCFAOperation_4, (Object)path, (Object)otherPath)));
                                    }
                                    roots.put(r, otherPath);
                                    exceptions.add(new Exception(NLS.bind((String)Messages.RebuildCFAOperation_4, (Object)path, (Object)otherPath)));
                                }
                                catch (OperationCanceledException ex) {
                                    throw ex;
                                }
                                catch (Exception ex) {
                                    exceptions.add(ex);
                                    continue;
                                }
                                break;
                            }
                            ** GOTO lbl-1000
                            finally {
                                descriptorsMap.close();
                            }
                        }
                        catch (OperationCanceledException ex) {
                            throw ex;
                        }
                        catch (Exception ex) {
                            exceptions.add(ex);
                        }
                    }
                    loaded = new ArrayList<Object>();
                    try {
                        metadataPath = CopyFileAreaManager.getMetadataPathForRoot(cfaRoot);
                        descPath = metadataPath.append(".components");
                        mgr = new PersistentHeapManager();
                        componentsMap = new LoadedComponentsStore(mgr, descPath.toFile());
                        i = componentsMap.entrySet().iterator();
                        while (true) lbl-1000:
                        // 3 sources

                        {
                            try {
                                e = (Map.Entry)i.next();
                            }
                            catch (NoSuchElementException v2) {
                                break block95;
                            }
                            catch (OperationCanceledException ex) {
                                throw ex;
                            }
                            catch (Exception ex) {
                                exceptions.add(ex);
                                break block95;
                            }
                            try {
                                desc = (LoadedConfigurationDescriptor)e.getValue();
                                loaded.add(desc);
                            }
                            catch (OperationCanceledException ex) {
                                throw ex;
                            }
                            catch (Exception ex) {
                                exceptions.add(ex);
                                continue;
                            }
                            break;
                        }
                        ** GOTO lbl-1000
                        finally {
                            componentsMap.close();
                        }
                    }
                    catch (OperationCanceledException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        exceptions.add(ex);
                    }
                }
                progress.worked(1);
                progress.setTaskName(Messages.RebuildCFAOperation_5);
                if (roots.isEmpty()) {
                    p.noDescriptorsFound();
                }
                metadata.clear();
                corrupt = true;
                try {
                    progress.worked(4);
                    managedRoots = new HashMap<String, Shareable>();
                    mgr = SharingManager.getInstance();
                    subProgress = progress.newChild(1);
                    try {
                        shareables = mgr.getRootShareables(cfaRoot, (IProgressMonitor)progress.newChild(1));
                        subProgress.setWorkRemaining(shareables.size());
                        for (IShareable s : shareables) {
                            sh = (Shareable)s;
                            if (!sh.getFileStorage().isRepositoryProviderRegistered((IProgressMonitor)subProgress.newChild(1))) continue;
                            managedRoots.put(sh.getLocalPath().lastSegment(), sh);
                        }
                    }
                    catch (OperationCanceledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        exceptions.add(e);
                    }
                    subProgress.done();
                    subProgress = progress.newChild(1);
                    subProgress.setWorkRemaining(roots.size() * 2);
                    i = roots.values().iterator();
                    for (Object desc : descriptors.values()) {
                        s = sandbox.findShareable((IPath)new Path(null, (String)i.next()), ResourceType.getResourceType(desc.getRootVersionable()));
                        managedRoots.remove(s.getLocalPath().lastSegment());
                        cfa.setSharingInfo(s.getLocalPath(), (ISharingDescriptor)desc, (IProgressMonitor)subProgress.newChild(1));
                        try {
                            ((Shareable)s).getFileStorage().registerRepositorProvider((IProgressMonitor)subProgress.newChild(1));
                        }
                        catch (OperationCanceledException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            exceptions.add(e);
                        }
                    }
                    subProgress.done();
                    subProgress = progress.newChild(1);
                    subProgress.setWorkRemaining(loaded.size());
                    for (Object desc : loaded) {
                        cfa.componentLoaded((LoadedConfigurationDescriptor)desc, (IProgressMonitor)subProgress.newChild(1));
                    }
                    subProgress.done();
                    subProgress = progress.newChild(2);
                    subProgress.setWorkRemaining(managedRoots.size());
                    for (IShareable s : managedRoots.values()) {
                        try {
                            s.getFileStorage().deregisterRepositoryProvider((IProgressMonitor)subProgress.newChild(1));
                        }
                        catch (OperationCanceledException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            exceptions.add(e);
                        }
                    }
                    subProgress.done();
                    subProgress = progress.newChild(86);
                    subProgress.setWorkRemaining(roots.size());
                    rebuilt = 1;
                    for (String path : roots.values()) {
                        try {
                            subSubProgress = subProgress.newChild(1);
                            subSubProgress.setWorkRemaining(100);
                            share = (Share)mgr.getShare(cfaRoot, (IPath)new Path(path), (IProgressMonitor)subSubProgress.newChild(1));
                            subSubProgress.setTaskName(NLS.bind((String)Messages.RebuildCFAOperation_6, (Object[])new Object[]{share.getPath().toString(), rebuilt++, roots.size()}));
                            desc = share.getSharingDescriptor();
                            info = new InverseFileItemInfo((IVersionableHandle)desc.getRootVersionable().getItemType().createItemHandle(desc.getRootVersionable().getItemId(), null), false, -1L, null, null, false, Collections.EMPTY_MAP, null, share.getPath().lastSegment(), null, -1L, null, null, null, null, null, -1L, null, null, -1L, false, false);
                            metadata.setFileItemInfo(share.getPath(), info);
                            subSubProgress.worked(1);
                            metadata.setFileItemInfo(info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), info);
                            subSubProgress.worked(1);
                            try {
                                SynchronizeOperation.synchronize(share, resolver, null, (IProgressMonitor)subSubProgress.newChild(97));
                            }
                            catch (ComponentNotInWorkspaceException e) {
                                shareable = (Shareable)share.getShareable();
                                shareable.forget((IProgressMonitor)subSubProgress.newChild(1));
                                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, 0, NLS.bind((String)Messages.RebuildCFAOperation_ComponentOfShareNotInWorkspace, (Object)shareable.getFullPath().toOSString()), e));
                            }
                            catch (ItemNotFoundException e) {
                                shareable = (Shareable)share.getShareable();
                                shareable.forget((IProgressMonitor)subSubProgress.newChild(1));
                                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, 0, NLS.bind((String)Messages.RebuildCFAOperation_ItemNotFound, (Object)shareable.getFullPath().toOSString()), e));
                            }
                            subSubProgress.done();
                        }
                        catch (OperationCanceledException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            exceptions.add(e);
                        }
                    }
                    subProgress.done();
                    corrupt = false;
                }
                catch (Throwable var28_72) {
                    debugExplanation = corrupt != false ? NLS.bind((String)"Repair sandbox failed {0} ", (Object)new Date(System.currentTimeMillis()).toString()) : NLS.bind((String)"Rebuilt sandbox {0}", (Object)new Date(System.currentTimeMillis()).toString());
                    metadata.setCorrupt(corrupt, debugExplanation, null);
                    throw var28_72;
                }
                debugExplanation = corrupt != false ? NLS.bind((String)"Repair sandbox failed {0} ", (Object)new Date(System.currentTimeMillis()).toString()) : NLS.bind((String)"Rebuilt sandbox {0}", (Object)new Date(System.currentTimeMillis()).toString());
                metadata.setCorrupt(corrupt, debugExplanation, null);
                switch (exceptions.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        e = (Exception)exceptions.get(0);
                        status = new Status(2, "com.ibm.team.filesystem.client", Messages.RebuildCFAOperation_7, (Throwable)e);
                        p.ignoredErrors((IStatus)status);
                        break;
                    }
                    default: {
                        statuses = new IStatus[exceptions.size()];
                        idx = exceptions.size() - 1;
                        while (idx >= 0) {
                            statuses[idx] = FileSystemStatus.getStatusFor((Throwable)exceptions.get(idx));
                            --idx;
                        }
                        ms = new MultiStatus("com.ibm.team.filesystem.client", 0, statuses, Messages.RebuildCFAOperation_8, null){
                            {
                                this.setSeverity(2);
                            }
                        };
                        p.ignoredErrors((IStatus)ms);
                        break;
                    }
                }
            }
            finally {
                CopyFileAreaStore.endBatching(lock, (IProgressMonitor)progress.newChild(1));
            }
        }
        finally {
            Job.getJobManager().endRule(rule);
        }
    }

    private static void ensureUnshared(IPath cfaRoot, IPath sharePath, SubMonitor progress) throws FileSystemClientException {
        IFileStorage fileStorage;
        Shareable shareable = (Shareable)FileSystemCore.getSharingManager().findShareable(cfaRoot.append(sharePath), ResourceType.FOLDER);
        if (shareable != null && (fileStorage = shareable.getFileStorage()) != null) {
            fileStorage.deregisterRepositoryProvider((IProgressMonitor)progress);
        }
    }

    private static boolean isLoggedInToRepo(IRepositoryResolver resolver, ISharingDescriptor descriptor) {
        if (resolver == null) {
            ITeamRepository[] repos;
            ITeamRepositoryService service = TeamPlatform.getTeamRepositoryService();
            ITeamRepository[] iTeamRepositoryArray = repos = service.getTeamRepositories();
            int n = repos.length;
            int n2 = 0;
            while (n2 < n) {
                ITeamRepository teamRepository = iTeamRepositoryArray[n2];
                if (teamRepository.getId().equals((Object)descriptor.getRepositoryId()) && teamRepository.loggedIn()) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        ITeamRepository repository = resolver.getRepoFor(descriptor.getRepositoryUri(), descriptor.getRepositoryId());
        return repository != null && repository.loggedIn();
    }

    private static void delete(File file) {
        if (file.delete() && !file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            File[] children;
            File[] fileArray = children = file.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                RebuildCFAOperation.delete(child);
                ++n2;
            }
        }
        file.delete();
    }

    public static class RebuildOperationParticipant {
        public void noDescriptorsFound() {
        }

        public void ignoredErrors(IStatus status) throws FileSystemClientException {
            throw new FileSystemClientException(status);
        }
    }

    private static class RootKey {
        UUID connection;
        UUID component;
        UUID root;

        public RootKey(UUID connection, UUID component, UUID root) {
            this.connection = connection;
            this.component = component;
            this.root = root;
        }

        public int hashCode() {
            return this.connection.hashCode() ^ this.component.hashCode() ^ this.root.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof RootKey)) {
                return false;
            }
            RootKey other = (RootKey)obj;
            return this.connection.equals((Object)other.connection) && this.component.equals((Object)other.component) && this.root.equals((Object)other.root);
        }
    }
}

