/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.operations.ChangeSetChooser;
import com.ibm.team.filesystem.client.internal.operations.CheckinUploadData;
import com.ibm.team.filesystem.client.internal.operations.CheckinUploadHandler;
import com.ibm.team.filesystem.client.internal.operations.EncodingUploadFailure;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.LineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.internal.operations.LocalChangeCheckinRequest;
import com.ibm.team.filesystem.client.internal.operations.ShareableCheckinRequest;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.FileItem;
import com.ibm.team.filesystem.common.internal.FilesystemFactory;
import com.ibm.team.filesystem.common.internal.SymbolicLink;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.IItemUpdateReport;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.internal.Folder;
import com.ibm.team.scm.common.internal.ScmFactory;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewCheckInOperation
extends FileSystemOperation
implements ICheckinOperation {
    private static final String MULTI_SANDBOX_WARNING = "Component ''{0}'' loaded in multiple sandboxes. Not setting metadata.";
    private final Collection<ComponentCheckInRequest> componentRequests = new LinkedList<ComponentCheckInRequest>();
    protected final Map<UUID, IChangeSetHandle> changeSetsCommitted = new HashMap<UUID, IChangeSetHandle>();
    protected final CommitDilemmaHandler commitProblemHandler;
    private boolean refreshBeforeRun = false;
    private Map<UUID, Map<UUID, IVersionable>> savedVersionable = new HashMap<UUID, Map<UUID, IVersionable>>();
    private Shed backupShed;
    private boolean nonAtomicCommitIsAnOption = true;
    private int uploadLimit = 200;

    @Override
    public Collection<IChangeSetHandle> getCommittedChangeSets() {
        return this.changeSetsCommitted.values();
    }

    public NewCheckInOperation(CommitDilemmaHandler commitProblemHandler) {
        super(commitProblemHandler == null ? CommitDilemmaHandler.getDefault() : commitProblemHandler);
        this.commitProblemHandler = commitProblemHandler == null ? CommitDilemmaHandler.getDefault() : commitProblemHandler;
        this.backupShed = new Shed(this.commitProblemHandler.getBackupDilemmaHandler());
    }

    @Override
    public void requestCheckin(IShareable[] toCommit, IChangeSetHandle changeSet, String commentForNewChangeSet, IProgressMonitor progress) throws FileSystemClientException {
        IShareable[] shareables;
        if (toCommit == null) {
            throw new IllegalArgumentException("Call requestCheckin() with just the workspace/component");
        }
        HashMap grouped = new HashMap();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (String)Messages.NewCheckInOperation_GETTING_READY_TO_UPLOAD, (int)(toCommit.length * 6));
        monitor.subTask(Messages.NewCheckInOperation_ORDERING_CHANGES_TO_LOCAL_FILES_AND_FOLDERS);
        IShareable[] iShareableArray = toCommit;
        int n = toCommit.length;
        int n2 = 0;
        while (n2 < n) {
            IShare share;
            IShareable shareable = iShareableArray[n2];
            HashMap<ConfigurationDescriptor, IShareable[]> configs = (HashMap<ConfigurationDescriptor, IShareable[]>)grouped.get(shareable.getSandbox());
            if (configs == null) {
                configs = new HashMap<ConfigurationDescriptor, IShareable[]>();
                grouped.put(shareable.getSandbox(), configs);
            }
            if ((share = shareable.getShare((IProgressMonitor)monitor.newChild(1))) == null) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_MISSING_SHARE, null));
            }
            ConfigurationDescriptor descriptor = null;
            descriptor = new ConfigurationDescriptor(share.getSharingDescriptor());
            shareables = (IShareable[])configs.get(descriptor);
            if (shareables == null) {
                shareables = new LinkedList();
                configs.put(descriptor, shareables);
            }
            shareables.add(shareable);
            ++n2;
        }
        if (changeSet != null) {
            monitor.setWorkRemaining(grouped.size() * 2);
            monitor.subTask(Messages.NewCheckInOperation_ENSURE_CHANGESET_SANE);
            for (Map.Entry group : grouped.entrySet()) {
                this.validateChangeset(((HashMap)group.getValue()).keySet(), changeSet, monitor.newChild(1));
            }
        }
        monitor.subTask(Messages.NewCheckInOperation_ORDERING_CHANGES_TO_FILES);
        monitor.setWorkRemaining(grouped.size());
        for (Map.Entry group : grouped.entrySet()) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor.newChild(1), (int)(((HashMap)group.getValue()).size() * 2));
            for (Map.Entry req : ((HashMap)group.getValue()).entrySet()) {
                IWorkspaceConnection wsConn;
                try {
                    IConnection conn = ((ConfigurationDescriptor)req.getKey()).getConnection((IProgressMonitor)subMonitor.newChild(1));
                    if (!(conn instanceof IWorkspaceConnection)) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, "Attempt to commit into a non-workspace connection", null));
                    }
                    wsConn = (IWorkspaceConnection)conn;
                }
                catch (TeamRepositoryException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_COULD_NOT_GET_CONNECTION, (Throwable)e));
                }
                IComponentHandle myComponent = ((ConfigurationDescriptor)req.getKey()).componentHandle;
                this.validateShareableRequest((ISandbox)group.getKey(), (IConnection)wsConn, myComponent, (List)req.getValue(), (IProgressMonitor)subMonitor.newChild(1));
                shareables = ((List)req.getValue()).toArray(new IShareable[((List)req.getValue()).size()]);
                this.componentRequests.add(new ShareableCheckinRequest(wsConn, myComponent, (ISandbox)group.getKey(), shareables, changeSet, commentForNewChangeSet));
            }
        }
    }

    private void validateChangeset(Set<ConfigurationDescriptor> configs, IChangeSetHandle changeSet, SubMonitor monitor) throws FileSystemClientException {
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)configs.size());
        for (ConfigurationDescriptor desc : configs) {
            IChangeSet cs;
            try {
                cs = (IChangeSet)desc.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)changeSet, 0, (IProgressMonitor)monitor.newChild(1));
            }
            catch (TeamRepositoryException e) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_FAILURE_GETTING_COMPLETE_ITEM_STATE, (Throwable)e));
            }
            if (desc.componentHandle.sameItemId((IItemHandle)cs.getComponent())) continue;
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_INCONSISTENT_COMPONENT, null));
        }
    }

    @Override
    public void requestCheckin(IWorkspaceConnection workspace, IComponentHandle component, ILocalChange[] toCommit, IChangeSetHandle changeSet, String commentForNewChangeSet, IProgressMonitor progress) throws FileSystemClientException {
        if (toCommit == null) {
            throw new IllegalArgumentException("Call requestCheckin() with just the workspace/component");
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(toCommit.length * 2));
        HashMap grouped = new HashMap();
        ILocalChange[] iLocalChangeArray = toCommit;
        int n = toCommit.length;
        int n2 = 0;
        while (n2 < n) {
            IShareable shareable;
            ILocalChange change = iLocalChangeArray[n2];
            IPath cfaPath = ((LocalChange)change).getCfaRoot();
            HashMap<ConfigurationDescriptor, LinkedList<ILocalChange>> connections = (HashMap<ConfigurationDescriptor, LinkedList<ILocalChange>>)grouped.get(cfaPath);
            if (connections == null) {
                connections = new HashMap<ConfigurationDescriptor, LinkedList<ILocalChange>>();
                grouped.put(cfaPath, connections);
            }
            if ((shareable = change.getShareable()) == null) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_MISSING_FILE_OR_FOLDER_FOR_CHANGE, null));
            }
            IShare desc = shareable.getShare((IProgressMonitor)monitor.newChild(1));
            if (desc == null) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_NOT_SHARED, null));
            }
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(desc.getSharingDescriptor());
            LinkedList<ILocalChange> changes = (LinkedList<ILocalChange>)connections.get(configurationDescriptor);
            if (changes == null) {
                changes = new LinkedList<ILocalChange>();
                connections.put(configurationDescriptor, changes);
            }
            changes.add(change);
            ++n2;
        }
        if (changeSet != null) {
            monitor.setWorkRemaining(grouped.size() * 2);
            monitor.subTask(Messages.NewCheckInOperation_ENSURE_CHANGESET_SANE);
            for (Map.Entry group : grouped.entrySet()) {
                this.validateChangeset(((HashMap)group.getValue()).keySet(), changeSet, monitor.newChild(1));
            }
        }
        monitor.setWorkRemaining(grouped.size());
        for (Map.Entry group : grouped.entrySet()) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor.newChild(1), (int)(((HashMap)group.getValue()).size() * 2));
            for (Map.Entry req : ((HashMap)group.getValue()).entrySet()) {
                IWorkspaceConnection wsConn;
                try {
                    IConnection conn = ((ConfigurationDescriptor)req.getKey()).getConnection((IProgressMonitor)subMonitor.newChild(1));
                    if (!(conn instanceof IWorkspaceConnection)) {
                        throw new IllegalArgumentException("Attempt to commit into a non-workspace connection");
                    }
                    wsConn = (IWorkspaceConnection)conn;
                }
                catch (TeamRepositoryException e) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_COULD_NOT_GET_CONNECTION, (Throwable)e));
                }
                IComponentHandle myComponent = ((ConfigurationDescriptor)req.getKey()).componentHandle;
                this.componentRequests.add(new LocalChangeCheckinRequest(wsConn, myComponent, new Sandbox((IPath)group.getKey()), ((List)req.getValue()).toArray(new ILocalChange[((List)req.getValue()).size()]), changeSet, commentForNewChangeSet));
            }
        }
    }

    static ISchedulingRule generateRuleFor(IWorkspaceConnection wsConn, IComponentHandle component, ILocalChange[] changes, IProgressMonitor monitor) throws FileSystemClientException {
        HashSet<IShare> shares = new HashSet<IShare>();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)changes.length);
        ILocalChange[] iLocalChangeArray = changes;
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange change = iLocalChangeArray[n2];
            IShare share = change.getShareable().getShare((IProgressMonitor)progress.newChild(1));
            ISharingDescriptor desc = share.getSharingDescriptor();
            if (desc.getConnectionHandle().sameItemId((IItemHandle)wsConn.getContextHandle()) && desc.getComponent().sameItemId((IItemHandle)component)) {
                shares.add(share);
            }
            ++n2;
        }
        ArrayList<IShareable> roots = new ArrayList<IShareable>(shares.size());
        for (IShare share : shares) {
            roots.add(share.getShareable());
        }
        return SharingManager.getInstance().makeSchedulingRuleForIDE(roots);
    }

    private void validateShareableRequest(ISandbox sandbox, IConnection workspace, IComponentHandle component, List<IShareable> shareables, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)shareables.size());
        for (IShareable shareable : shareables) {
            if (!shareable.getSandbox().equals(sandbox)) {
                throw new IllegalArgumentException("Shareable " + shareable.getFullPath().toString() + " does not have the same root path as Sandbox (" + sandbox.getRoot() + ")");
            }
            IShare share = shareable.getShare((IProgressMonitor)progress.newChild(1));
            if (share == null) {
                throw new IllegalArgumentException("Shareable " + shareable + " has no share");
            }
            if (share.getSharingDescriptor().getComponent().sameItemId((IItemHandle)component)) continue;
            throw new IllegalArgumentException("Shareable " + shareable + " is not in component " + component);
        }
    }

    private List<WorkspaceCheckInRequest> groupRequestsByConnection() {
        HashMap groupedRequests = new HashMap();
        for (ComponentCheckInRequest req : this.componentRequests) {
            IWorkspaceConnection conn = req.getWorkspace();
            UUID connId = conn.getContextHandle().getItemId();
            CollectionUtil.addToMapOfLists(groupedRequests, (Object)connId, (Object)req);
        }
        ArrayList<WorkspaceCheckInRequest> bulkRequests = new ArrayList<WorkspaceCheckInRequest>(groupedRequests.size());
        for (List reqs : groupedRequests.values()) {
            bulkRequests.add(new WorkspaceCheckInRequest(reqs));
        }
        return bulkRequests;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.NewCheckInOperation_0, (int)100);
        mon.setTaskName(Messages.NewCheckInOperation_1);
        final HashSet<ConfigurationDescriptor> workspaceLocks = new HashSet<ConfigurationDescriptor>();
        for (ComponentCheckInRequest req : this.componentRequests) {
            ConfigurationDescriptor desc = new ConfigurationDescriptor((IConnection)req.getWorkspace(), req.getComponent());
            workspaceLocks.add(desc);
        }
        IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                try {
                    ICopyFileAreaManager.ICopyFileAreaLockRequestFactory factory = ICopyFileAreaManager.instance.lockRequestFactory();
                    ICopyFileAreasLock cfaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(factory.getLockRequest(workspaceLocks, true)), (IProgressMonitor)mon.newChild(1));
                    try {
                        ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
                        SubMonitor subProgress = mon.newChild(98);
                        subProgress.setWorkRemaining(NewCheckInOperation.this.componentRequests.size() * 10);
                        List workspaceReqs = NewCheckInOperation.this.groupRequestsByConnection();
                        for (WorkspaceCheckInRequest workspaceReq : workspaceReqs) {
                            for (ComponentCheckInRequest compReq : workspaceReq.reqs) {
                                if (compReq.getTracker() == null) continue;
                                compReq.validate((IProgressMonitor)subProgress.newChild(1));
                            }
                            NewCheckInOperation.this.runRequest(workspaceReq, determinants, subProgress.newChild(9));
                        }
                    }
                    finally {
                        cfaLock.release((IProgressMonitor)mon.newChild(1));
                    }
                }
                catch (FileSystemClientException e) {
                    throw new InvocationTargetException((Throwable)((Object)e));
                }
                catch (TeamRepositoryException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        FlowNodeLock jazzWorkspaceLock = WorkspaceLockUtil.acquireWrite(workspaceLocks, (IProgressMonitor)mon.newChild(1));
        try {
            this.runWithinFileSystemLock(runnableWithProgress, Messages.NewCheckInOperation_21, (IProgressMonitor)mon.newChild(99));
        }
        finally {
            WorkspaceLockUtil.release(jazzWorkspaceLock);
        }
        mon.done();
    }

    protected void runRequest(WorkspaceCheckInRequest workspaceReq, Collection<IAuditable> determinants, SubMonitor mon) throws FileSystemClientException, TeamRepositoryException {
        String checkInMsg = NLS.bind((String)Messages.NewCheckInOperation_2, (Object)workspaceReq.getWorkspace().getResolvedWorkspace().getName(), (Object[])new Object[0]);
        mon = SubMonitor.convert((IProgressMonitor)mon, (String)checkInMsg, (int)(100 + workspaceReq.reqs.size()));
        this.determineChangesAndVerifyInSync(workspaceReq, (IProgressMonitor)mon.newChild(1));
        int ct = 0;
        for (ComponentCheckInRequest compReq : workspaceReq.reqs) {
            SubMonitor iterMon = mon.newChild(1);
            iterMon.subTask(NLS.bind((String)Messages.NewCheckInOperation_FINDING_LOCAL_CHANGES, (Object)ct++, (Object[])new Object[]{workspaceReq.reqs.size()}));
            iterMon.setWorkRemaining(100);
            IWorkspaceConnection workspace = compReq.getWorkspace();
            IComponentHandle component = compReq.getComponent();
            ChangeSetChooser organizer = new ChangeSetChooser(workspace, determinants);
            HashMap<UUID, IChangeSetHandle> changeSetsToCommit = new HashMap<UUID, IChangeSetHandle>();
            HashMap<UUID, Set<ILocalChange>> changesToCommit = new HashMap<UUID, Set<ILocalChange>>();
            iterMon.setWorkRemaining(compReq.allChanges.size() + 8);
            for (ILocalChange change : compReq.allChanges) {
                UUID key;
                IChangeSetHandle bestChangeSet = organizer.getBestChangeSet(component, change.getTarget(), compReq.getPreferredChangeSet(), (IProgressMonitor)iterMon.newChild(1));
                if (bestChangeSet != null) {
                    key = bestChangeSet.getItemId();
                    changeSetsToCommit.put(key, bestChangeSet);
                } else {
                    key = null;
                }
                Set<ILocalChange> changes = changesToCommit.get(key);
                if (changes == null) {
                    changes = new HashSet<ILocalChange>();
                    changesToCommit.put(key, changes);
                }
                changes.add(change);
            }
            iterMon.worked(8);
            this.checkCancelled((IProgressMonitor)iterMon);
            compReq.setChangesToCommit(changesToCommit);
            compReq.setChangeSetsToCommit(changeSetsToCommit);
        }
        this.commitChanges(workspaceReq, checkInMsg, (IProgressMonitor)mon.newChild(99));
    }

    private void determineChangesAndVerifyInSync(WorkspaceCheckInRequest workspaceReq, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)(workspaceReq.reqs.size() * 2 + 10));
        int ct = 1;
        DilemmaHandler problemHandler = this.getDilemmaHandler();
        if (!(problemHandler instanceof CommitDilemmaHandler)) {
            problemHandler = CommitDilemmaHandler.getDefault();
        }
        IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(((CommitDilemmaHandler)problemHandler).getOutOfSyncDilemmaHandler());
        for (ComponentCheckInRequest compReq : workspaceReq.reqs) {
            SubMonitor iterMon = mon.newChild(1);
            iterMon.subTask(NLS.bind((String)Messages.NewCheckInOperation_FINDING_LOCAL_CHANGES, (Object)ct++, (Object[])new Object[]{workspaceReq.reqs.size()}));
            iterMon.setWorkRemaining(100);
            ILocalChange[] toCommit = compReq.getChanges(this.getRefreshBeforeRun(), (IProgressMonitor)iterMon.newChild(10));
            compReq.allChanges = new HashSet();
            ILocalChange[] iLocalChangeArray = toCommit;
            int n = toCommit.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalChange chg = iLocalChangeArray[n2];
                compReq.allChanges.add(chg);
                ++n2;
            }
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(compReq.getSandbox().getRoot());
            if (cfa == null) {
                this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.NewCheckInOperation_19, (Object)compReq.getSandbox().getRoot().toString(), (Object[])new Object[0]), null));
            }
            IWorkspaceConnection workspace = compReq.getWorkspace();
            HashSet<IShare> toVerify = new HashSet<IShare>();
            SharingManager sharingManager = SharingManager.getInstance();
            SubMonitor subProgress = iterMon.newChild(10);
            subProgress.setWorkRemaining(toCommit.length);
            int i = 0;
            while (i < toCommit.length) {
                IShare share = sharingManager.getShare(cfa.getRoot(), toCommit[i].isType(16) ? toCommit[i].getResultingPath() : toCommit[i].getPath(), (IProgressMonitor)subProgress.newChild(1));
                toVerify.add(share);
                ++i;
            }
            subProgress.done();
            if (!this.verifyInSyncEnabled() || ((CommitDilemmaHandler)problemHandler).getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync() || toVerify.isEmpty()) continue;
            verifyOp.addToVerify((IConnection)workspace, toVerify);
        }
        if (this.verifyInSyncEnabled() && !((CommitDilemmaHandler)problemHandler).getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            verifyOp.run((IProgressMonitor)mon.newChild(10));
        }
        ct = 0;
        for (ComponentCheckInRequest compReq : workspaceReq.reqs) {
            mon.subTask(NLS.bind((String)Messages.NewCheckInOperation_FINDING_LOCAL_CHANGES, (Object)ct++, (Object[])new Object[]{workspaceReq.reqs.size()}));
            ICopyFileArea cfa = ICopyFileAreaManager.instance.getExistingCopyFileArea(compReq.getSandbox().getRoot());
            compReq.allChanges = this.addRequiredChanges(cfa, compReq, compReq.allChanges, compReq.getTracker(), (IProgressMonitor)mon.newChild(1));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void commitChanges(WorkspaceCheckInRequest workspaceReq, String checkInMsg, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        ArrayList<IStatus> sessionStatuses;
        SubMonitor iterMon;
        int numChanges;
        int numUploads;
        CheckinUploadData uploadData;
        boolean isNonAtomicCommitAllowed;
        IWorkspaceConnection workspace;
        CancellationMonitor cMon;
        SubMonitor mon;
        block33: {
            block34: {
                mon = SubMonitor.convert((IProgressMonitor)progress, (int)100);
                cMon = new CancellationMonitor((IProgressMonitor)mon);
                workspace = workspaceReq.getWorkspace();
                isNonAtomicCommitAllowed = this.nonAtomicCommitIsAnOption;
                uploadData = new CheckinUploadData();
                numUploads = 0;
                numChanges = 0;
                int numberChanges = 0;
                iterMon = mon.newChild(1).setWorkRemaining(workspaceReq.reqs.size());
                sessionStatuses = new ArrayList<IStatus>();
                for (ComponentCheckInRequest compReq : workspaceReq.reqs) {
                    boolean serverSupportsSymbolicLinks = FileSystemCore.getFileSystemManager(compReq.getWorkspace().teamRepository()).serverSupportsSymbolicLinks((IProgressMonitor)iterMon.newChild(1));
                    numChanges += compReq.allChanges.size();
                    for (ILocalChange chg : compReq.allChanges) {
                        if (chg.getTarget() instanceof IFileItemHandle && (chg.getType() & 3) != 0) {
                            ++numUploads;
                        } else if (!serverSupportsSymbolicLinks && chg.getTarget() instanceof ISymbolicLinkHandle) {
                            IStatus status = FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.NewCheckInOperation_20, (Object)chg.getPath().toString(), (Object[])new Object[0]), null);
                            sessionStatuses.add(status);
                        }
                        if (chg.isCanceled() || (chg.getType() & 0x10) != 0) continue;
                        ++numberChanges;
                    }
                }
                if (!this.nonAtomicCommitIsAnOption || numUploads < this.uploadLimit || !isNonAtomicCommitAllowed) break block34;
                int direction = this.commitProblemHandler.nonAtomicCommit(workspace, numberChanges, numUploads);
                if (direction == 0) {
                    isNonAtomicCommitAllowed = true;
                    break block33;
                } else if (direction == 3) {
                    isNonAtomicCommitAllowed = false;
                    break block33;
                } else {
                    if (direction == 1) {
                        throw new OperationCanceledException();
                    }
                    throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.NewCheckInOperation_23, (Object)new Integer(numChanges), (Object[])new Object[]{workspace.getName()})));
                }
            }
            isNonAtomicCommitAllowed = false;
        }
        if (!isNonAtomicCommitAllowed && !sessionStatuses.isEmpty()) {
            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_22, sessionStatuses.toArray(new IStatus[sessionStatuses.size()]));
        }
        if (numUploads != 0) {
            IFileContentManagerSession session = FileSystemCore.getContentManager(workspace.teamRepository()).createSession(NLS.bind((String)Messages.NewCheckInOperation_3, (Object)workspace.getName(), (Object[])new Object[0]), true, numUploads, (IProgressMonitor)mon.newChild(40));
            for (ComponentCheckInRequest compReq : workspaceReq.reqs) {
                ICopyFileArea cfa = compReq.getCfa();
                try {
                    for (Object chg : compReq.allChanges) {
                        if (!(chg.getTarget() instanceof IFileItemHandle) || (chg.getType() & 3) == 0) continue;
                        CheckinUploadHandler checkinUploadHandler = new CheckinUploadHandler(cfa, compReq, (ILocalChange)chg, !isNonAtomicCommitAllowed, uploadData, cMon);
                        session.storeContent(checkinUploadHandler);
                    }
                }
                catch (TeamRepositoryException teamRepositoryException) {}
            }
            session.join();
            this.doDilemmaHandling(workspace, isNonAtomicCommitAllowed, session, sessionStatuses, uploadData, mon.newChild(20));
            Collection<CheckinUploadHandler> filesNeedingConversion = uploadData.clearFilesNeedingConversion();
            SubMonitor subProgress = mon.newChild(4);
            subProgress.setWorkRemaining(filesNeedingConversion.size());
            for (CheckinUploadHandler uh : filesNeedingConversion) {
                try {
                    uh.convert(this.backupShed, (IProgressMonitor)subProgress.newChild(1));
                }
                catch (FileSystemClientException e) {
                    if (!isNonAtomicCommitAllowed) {
                        throw e;
                    }
                    sessionStatuses.add(FileSystemStatus.getStatusFor((Throwable)((Object)e)));
                }
            }
        }
        HashMap<UUID, Map<UUID, ILocalChange>> changes = new HashMap<UUID, Map<UUID, ILocalChange>>();
        ArrayList<ILocalChange> allLocalChangesCommitted = new ArrayList<ILocalChange>(numChanges);
        ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>(workspaceReq.reqs.size());
        ArrayList configOps = new ArrayList(changeSets.size());
        SubMonitor subProgress = mon.newChild(5);
        subProgress.setWorkRemaining(numChanges * 2 + workspaceReq.reqs.size());
        for (ComponentCheckInRequest compReq : workspaceReq.reqs) {
            boolean serverSupportsSymbolicLinks = FileSystemCore.getFileSystemManager(compReq.getWorkspace().teamRepository()).serverSupportsSymbolicLinks((IProgressMonitor)iterMon.newChild(1));
            for (Map.Entry entry : compReq.changesToCommit.entrySet()) {
                IChangeSetHandle cs;
                Collection allChanges = (Collection)entry.getValue();
                ArrayList allOps = new ArrayList(allChanges.size());
                SubMonitor iterProgress = subProgress.newChild(1).setWorkRemaining(allChanges.size());
                for (ILocalChange chg : allChanges) {
                    if (!this.addConfigOp(compReq.getCfa(), uploadData, compReq, chg, workspace.configurationOpFactory(), allOps, serverSupportsSymbolicLinks, (IProgressMonitor)iterProgress.newChild(1))) continue;
                    allLocalChangesCommitted.add(chg);
                }
                if (allOps.isEmpty()) continue;
                for (ILocalChange changeToCommit : allChanges) {
                    if (changeToCommit.isCanceled() || (changeToCommit.getType() & 0x10) != 0) continue;
                    LinkedHashMap<UUID, ILocalChange> localChanges = (LinkedHashMap<UUID, ILocalChange>)changes.get(compReq.getComponent().getItemId());
                    if (localChanges == null) {
                        localChanges = new LinkedHashMap<UUID, ILocalChange>(numChanges * 4 / 3);
                        changes.put(compReq.getComponent().getItemId(), localChanges);
                    }
                    localChanges.put(changeToCommit.getTarget().getItemId(), changeToCommit);
                }
                if (entry.getKey() == null) {
                    IComponentHandle component = compReq.getComponent();
                    cs = workspace.getCurrentChangeSet(component);
                    if (cs == null) {
                        String comment = compReq.getCommentForNewChangeSet();
                        if (comment == null) {
                            comment = "";
                        }
                        cs = workspace.createChangeSet(component, comment, true, (IProgressMonitor)subProgress.newChild(1));
                    }
                } else {
                    cs = (IChangeSetHandle)compReq.changeSetsToCommit.get(entry.getKey());
                }
                changeSets.add(cs);
                configOps.add(allOps);
            }
        }
        subProgress.done();
        mon.setTaskName(checkInMsg);
        this.checkCancelled((IProgressMonitor)mon);
        mon.setWorkRemaining(70);
        if (!changeSets.isEmpty()) {
            IUpdateReport updateReport = workspace.commit(changeSets, configOps, (IProgressMonitor)mon.newChild(50));
            for (IChangeSetHandle iChangeSetHandle : changeSets) {
                this.changeSetsCommitted.put(iChangeSetHandle.getItemId(), iChangeSetHandle);
            }
            this.updateMetadata(workspaceReq, uploadData, updateReport, changes, (IProgressMonitor)mon.newChild(5));
            this.savedVersionable = new HashMap<UUID, Map<UUID, IVersionable>>();
            uploadData.clearUploadInfo();
            LocalChangeManager localChangeManager = (LocalChangeManager)FileSystemCore.getSharingManager().getLocalChangeManager();
            localChangeManager.commitChanges(allLocalChangesCommitted.toArray(new ILocalChange[allLocalChangesCommitted.size()]));
            if (!updateReport.incidentalResolutionUpdates().isEmpty()) {
                UpdateOperation op = new UpdateOperation(workspace, Collections.singletonList(updateReport), 2, this.commitProblemHandler, null);
                this.disableVerifyInSync(op);
                op.run((IProgressMonitor)mon.newChild(5));
            }
            this.updateCFAConfigState(workspaceReq, updateReport, mon.newChild(10));
        }
        if (isNonAtomicCommitAllowed) {
            IStatus[] failures = uploadData.getUploadFailureStatuses();
            IStatus[] iStatusArray = sessionStatuses.toArray(new IStatus[sessionStatuses.size() + failures.length]);
            System.arraycopy(failures, 0, iStatusArray, sessionStatuses.size(), failures.length);
            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_6, iStatusArray);
        }
        mon.done();
    }

    private void doDilemmaHandling(IWorkspaceConnection workspace, boolean isNonAtomicCommitAllowed, IFileContentManagerSession session, List<IStatus> sessionStatuses, CheckinUploadData uploadData, SubMonitor mon) throws FileSystemClientException, TeamRepositoryException {
        boolean moreContentUploaded;
        int paranoiaCount = 0;
        do {
            moreContentUploaded = false;
            IStatus[] uploadFailureStatuses = uploadData.getUploadFailureStatuses();
            IStatus[] statuses = session.getErrorStatus();
            IStatus[] allErrors = new IStatus[sessionStatuses.size() + uploadFailureStatuses.length + statuses.length];
            allErrors = sessionStatuses.toArray(allErrors);
            System.arraycopy(uploadFailureStatuses, 0, allErrors, sessionStatuses.size(), uploadFailureStatuses.length);
            System.arraycopy(statuses, 0, allErrors, sessionStatuses.size() + uploadFailureStatuses.length, statuses.length);
            if (isNonAtomicCommitAllowed) {
                this.checkCancellationStatus(allErrors);
            } else if (allErrors.length > 0) {
                RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, allErrors);
            }
            session = null;
            Collection<LineDelimiterUploadFailure> lineDelimiterFailures = uploadData.clearLineDelimiterFailures();
            Collection<EncodingUploadFailure> encodingFailures = uploadData.clearEncodingFailures();
            if (!lineDelimiterFailures.isEmpty() || !encodingFailures.isEmpty()) {
                mon.setWorkRemaining(100);
                session = FileSystemCore.getContentManager(workspace.teamRepository()).createSession(NLS.bind((String)Messages.NewCheckInOperation_3, (Object)workspace.getName(), (Object[])new Object[0]), true, lineDelimiterFailures.size() + encodingFailures.size(), (IProgressMonitor)mon.newChild(40));
                try {
                    int reaction;
                    if (!lineDelimiterFailures.isEmpty()) {
                        reaction = this.commitProblemHandler.lineDelimiterErrors(lineDelimiterFailures, (IProgressMonitor)mon.newChild(1));
                        if (reaction == 1) {
                            throw new OperationCanceledException();
                        }
                        if (reaction == 3 && isNonAtomicCommitAllowed) {
                            for (LineDelimiterUploadFailure lineDelimiterUploadFailure : lineDelimiterFailures) {
                                uploadData.uploadFailure(lineDelimiterUploadFailure);
                            }
                            session.decrementTransferCount(lineDelimiterFailures.size());
                        } else if (reaction == 0) {
                            mon.setWorkRemaining(100);
                            for (LineDelimiterUploadFailure lineDelimiterUploadFailure : lineDelimiterFailures) {
                                if (lineDelimiterUploadFailure.isSkipFailure()) {
                                    uploadData.uploadFailure(lineDelimiterUploadFailure);
                                    session.decrementTransferCount(1L);
                                    continue;
                                }
                                try {
                                    session.storeContent(lineDelimiterUploadFailure.getUploadHandler());
                                    moreContentUploaded = true;
                                }
                                catch (TeamRepositoryException teamRepositoryException) {}
                            }
                        } else {
                            for (LineDelimiterUploadFailure lineDelimiterUploadFailure : lineDelimiterFailures) {
                                uploadData.uploadFailure(lineDelimiterUploadFailure);
                            }
                            for (EncodingUploadFailure encodingUploadFailure : encodingFailures) {
                                uploadData.uploadFailure(encodingUploadFailure);
                            }
                            uploadFailureStatuses = uploadData.getUploadFailureStatuses();
                            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, uploadFailureStatuses);
                        }
                    }
                    if (!encodingFailures.isEmpty()) {
                        reaction = this.commitProblemHandler.encodingErrors(encodingFailures, (IProgressMonitor)mon.newChild(1));
                        if (reaction == 1) {
                            throw new OperationCanceledException();
                        }
                        if (reaction == 3 && isNonAtomicCommitAllowed) {
                            for (EncodingUploadFailure encodingUploadFailure : encodingFailures) {
                                uploadData.uploadFailure(encodingUploadFailure);
                            }
                            session.decrementTransferCount(encodingFailures.size());
                        } else if (reaction == 0) {
                            mon.setWorkRemaining(100);
                            if (!isNonAtomicCommitAllowed) {
                                for (EncodingUploadFailure encodingUploadFailure : encodingFailures) {
                                    if (encodingUploadFailure.isIgnoreEncoding() || !encodingUploadFailure.getEncoding().equals(encodingUploadFailure.getAlternativeEncoding())) continue;
                                    uploadData.uploadFailure(encodingUploadFailure);
                                }
                                uploadFailureStatuses = uploadData.getUploadFailureStatuses();
                                RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, uploadFailureStatuses);
                            }
                            for (EncodingUploadFailure encodingUploadFailure : encodingFailures) {
                                if (encodingUploadFailure.isSkipFailure()) {
                                    uploadData.uploadFailure(encodingUploadFailure);
                                    session.decrementTransferCount(1L);
                                    continue;
                                }
                                try {
                                    session.storeContent(encodingUploadFailure.getUploadHandler());
                                    moreContentUploaded = true;
                                }
                                catch (TeamRepositoryException teamRepositoryException) {}
                            }
                        } else {
                            for (EncodingUploadFailure encodingUploadFailure : encodingFailures) {
                                uploadData.uploadFailure(encodingUploadFailure);
                            }
                            uploadFailureStatuses = uploadData.getUploadFailureStatuses();
                            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, uploadFailureStatuses);
                        }
                    }
                }
                finally {
                    if (session != null && moreContentUploaded) {
                        session.join();
                    }
                }
            }
            if (++paranoiaCount < 500) continue;
            for (LineDelimiterUploadFailure failure : lineDelimiterFailures) {
                uploadData.uploadFailure(failure);
            }
            for (EncodingUploadFailure failure : encodingFailures) {
                uploadData.uploadFailure(failure);
            }
            uploadFailureStatuses = uploadData.getUploadFailureStatuses();
            RepositoryUtils.throwAppropriateException(Messages.NewCheckInOperation_4, uploadFailureStatuses);
        } while (moreContentUploaded && paranoiaCount < 500);
    }

    private void checkCancellationStatus(IStatus[] errorStatus) {
        IStatus[] iStatusArray = errorStatus;
        int n = errorStatus.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus status = iStatusArray[n2];
            if (status.matches(8)) {
                throw new OperationCanceledException();
            }
            ++n2;
        }
    }

    private boolean addConfigOp(ICopyFileArea cfa, CheckinUploadData uploadData, ComponentCheckInRequest req, ILocalChange chg, IWorkspaceConnection.IConfigurationOpFactory configOpFactory, Collection<? super IWorkspaceConnection.IConfigurationOp> allOps, boolean serverSupportsSymbolicLinks, IProgressMonitor mon) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)10);
        IComponentHandle component = req.getComponent();
        IWorkspaceConnection workspace = req.getWorkspace();
        boolean toBeCommitted = true;
        if (chg.isType(4)) {
            if (chg.getTarget() instanceof IFolderHandle) {
                allOps.add((IWorkspaceConnection.IConfigurationOp)configOpFactory.deleteSubtree((IFolderHandle)chg.getTarget()));
            } else {
                allOps.add((IWorkspaceConnection.IConfigurationOp)configOpFactory.delete(chg.getTarget()));
            }
        } else if (uploadData.isUploadFailed(chg.getComponent(), chg.getTarget())) {
            toBeCommitted = false;
        } else if (!chg.isType(16)) {
            UUID componentItemId = chg.getComponent().getItemId();
            Map<UUID, IVersionable> versionables = this.savedVersionable.get(componentItemId);
            if (versionables == null) {
                versionables = new HashMap<UUID, IVersionable>();
                this.savedVersionable.put(componentItemId, versionables);
            }
            if (chg.getTarget() instanceof IFolderHandle) {
                Folder folder = ScmFactory.eINSTANCE.createFolder();
                folder.initNew();
                folder.setItemId(chg.getTarget().getItemId());
                folder.setParent(chg.getTargetParent());
                folder.setName(chg.getResultingPath().lastSegment());
                allOps.add((IWorkspaceConnection.IConfigurationOp)configOpFactory.save((IVersionable)folder));
                versionables.put(folder.getItemId(), (IVersionable)folder);
            } else if (chg.getTarget() instanceof IFileItemHandle) {
                InverseFileItemInfo info = cfa.getItemInfo(chg.getTarget(), component, (IContextHandle)workspace.getResolvedWorkspace());
                FileItem file = FilesystemFactory.eINSTANCE.createFileItem();
                file.initNew();
                file.setItemId(chg.getTarget().getItemId());
                file.setParent(info.getLocalParent());
                file.setName(info.getLocalName());
                IShareable shareable = uploadData.getShareable(component, chg.getTarget());
                if (shareable == null) {
                    shareable = chg.getShareable();
                }
                IFileStorage storage = ((Shareable)shareable).getFileStorage();
                boolean isExecutable = storage.isExecutable((IProgressMonitor)progress.newChild(1));
                file.setExecutable(isExecutable);
                file.setFileTimestamp(new Date(storage.getLocalTimeStamp()));
                FileContent content = uploadData.getContent(component, chg.getTarget());
                if (content != null) {
                    file.setContent((IFileContent)content);
                    String currentContentType = uploadData.getContentType(component, chg.getTarget());
                    file.setContentType(currentContentType);
                } else if (info.getHash() != null) {
                    content = FilesystemFactory.eINSTANCE.createFileContent();
                    ContentHash predecessorHintHash = info.getStoredPredecessorHintHash();
                    content.setPredecessorHint(predecessorHintHash);
                    content.setLineDelimiter(info.getOriginalLineDelimiter());
                    content.setSize(info.getStoredSize());
                    content.setCharacterEncoding(info.getStoredEncoding());
                    content.setHash(info.getStoredHash());
                    content.setLineDelimiterCount(info.getStoredNumLineDelimiters());
                    content.setOriginalContainingState(info.getVersionableHandle());
                    file.setContent((IFileContent)content);
                    file.setContentType(info.getContentType());
                } else {
                    throw new IllegalStateException();
                }
                allOps.add((IWorkspaceConnection.IConfigurationOp)configOpFactory.save((IVersionable)file));
                versionables.put(file.getItemId(), (IVersionable)file);
            } else if (chg.getTarget() instanceof ISymbolicLinkHandle) {
                if (serverSupportsSymbolicLinks) {
                    InverseFileItemInfo info = cfa.getItemInfo(chg.getTarget(), component, (IContextHandle)workspace.getResolvedWorkspace());
                    SymbolicLink symbolicLink = FilesystemFactory.eINSTANCE.createSymbolicLink();
                    symbolicLink.initNew();
                    symbolicLink.setItemId(chg.getTarget().getItemId());
                    symbolicLink.setParent(info.getLocalParent());
                    symbolicLink.setName(info.getLocalName());
                    IShareable shareable = chg.getShareable();
                    IFileStorage storage = ((Shareable)shareable).getFileStorage();
                    symbolicLink.setLinkTimestamp(new Date(storage.getLocalTimeStamp()));
                    symbolicLink.setTarget(storage.getTarget((IProgressMonitor)progress.newChild(1)));
                    allOps.add((IWorkspaceConnection.IConfigurationOp)configOpFactory.save((IVersionable)symbolicLink));
                    versionables.put(symbolicLink.getItemId(), (IVersionable)symbolicLink);
                } else {
                    toBeCommitted = false;
                }
            }
        }
        return toBeCommitted;
    }

    private Set<ILocalChange> addRequiredChanges(ICopyFileArea cfa, ComponentCheckInRequest req, Set<ILocalChange> changesToBeCommitted, LocalChangeTracker lct, IProgressMonitor monitor) throws FileSystemClientException {
        ArrayList<ILocalChange> toCommit = new ArrayList<ILocalChange>(changesToBeCommitted);
        HashSet<ILocalChange> changes = new HashSet<ILocalChange>(changesToBeCommitted.size() * 4 / 3);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)toCommit.size());
        while (!toCommit.isEmpty()) {
            ILocalChange change = (ILocalChange)toCommit.remove(toCommit.size() - 1);
            if (change.isCanceled()) {
                progress.worked(1);
                continue;
            }
            changes.add(change);
            if (change.getCounterpart() != null) {
                changes.add(change.getCounterpart());
                if (change.isType(16)) {
                    change = change.getCounterpart();
                }
                this.addDependentChangesForNewParent(cfa, req, change, toCommit, changes, lct);
            } else if (change.isType(2)) {
                this.addDependentChangesForNewParent(cfa, req, change, toCommit, changes, lct);
            } else if (change.isType(4)) {
                this.addDependentChangesForDeletion(cfa, req, change, toCommit, changes, lct);
            }
            progress.setWorkRemaining(toCommit.size() + 1);
            progress.worked(1);
        }
        progress.done();
        return changes;
    }

    private void addDependentChangesForDeletion(ICopyFileArea cfa, ComponentCheckInRequest req, ILocalChange change, List<ILocalChange> toCommit, Set<ILocalChange> changes, LocalChangeTracker lct) throws FileSystemClientException {
        if (!(change.getTarget() instanceof IFolderHandle)) {
            return;
        }
        IComponentHandle component = req.getComponent();
        IWorkspaceConnection workspace = req.getWorkspace();
        InverseFileItemInfo info = cfa.getItemInfo(change.getTarget(), component, workspace.getContextHandle());
        ArrayList<IVersionableHandle> toVisit = new ArrayList<IVersionableHandle>(info.getRemoteChildren().values());
        while (!toVisit.isEmpty()) {
            IVersionableHandle item = (IVersionableHandle)toVisit.remove(toVisit.size() - 1);
            ILocalChange chg = lct.getPendingChange(item);
            if (chg.getType() != 0) {
                Assert.isTrue((boolean)chg.isType(8));
                if (!changes.add(chg)) continue;
                toCommit.add(chg);
                continue;
            }
            if (!(item instanceof IFolderHandle)) continue;
            info = cfa.getItemInfo(item, component, workspace.getContextHandle());
            toVisit.addAll(info.getRemoteChildren().values());
        }
    }

    private void addDependentChangesForNewParent(ICopyFileArea cfa, ComponentCheckInRequest req, ILocalChange change, List<ILocalChange> toCommit, Set<ILocalChange> changes, LocalChangeTracker lct) throws FileSystemClientException {
        IFolderHandle parent;
        ILocalChange dep = this.getDependentChangeForNewParent(cfa, req, change, lct);
        if (dep != null && changes.add(dep)) {
            toCommit.add(dep);
        }
        if ((dep = lct.getPendingChange((IVersionableHandle)(parent = change.getTargetParent()))).isType(2) && changes.add(dep)) {
            toCommit.add(dep);
        }
    }

    private ILocalChange getDependentChangeForNewParent(ICopyFileArea cfa, ComponentCheckInRequest req, ILocalChange change, LocalChangeTracker lct) throws FileSystemClientException {
        IVersionableHandle conflicting;
        IFolderHandle parent = change.getTargetParent();
        if (lct.getPendingChange((IVersionableHandle)parent).isType(2)) {
            return null;
        }
        IComponentHandle component = req.getComponent();
        IWorkspaceConnection workspace = req.getWorkspace();
        String name = change.getResultingPath().lastSegment();
        InverseFileItemInfo info = cfa.getItemInfo((IVersionableHandle)parent, component, workspace.getContextHandle());
        if (info == null) {
            return null;
        }
        if (cfa.isCaseSensitive()) {
            conflicting = info.getRemoteChildren().get(name);
        } else {
            conflicting = null;
            name = name.toUpperCase().toLowerCase();
            for (Map.Entry<String, IVersionableHandle> e : info.getRemoteChildren().entrySet()) {
                String rName = e.getKey().toUpperCase().toLowerCase();
                if (!name.equals(rName)) continue;
                conflicting = e.getValue();
                break;
            }
        }
        if (conflicting == null || conflicting.sameItemId((IItemHandle)parent)) {
            return null;
        }
        ILocalChange dep = lct.getPendingChange(conflicting);
        Assert.isTrue(((dep.getType() & 0xC) != 0 ? 1 : 0) != 0);
        return dep;
    }

    private void updateMetadata(WorkspaceCheckInRequest workspaceReq, CheckinUploadData uploadData, IUpdateReport updateReport, Map<UUID, Map<UUID, ILocalChange>> changes, IProgressMonitor monitor) throws FileSystemClientException {
        ICopyFileArea cfa;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspaceConnection workspace = workspaceReq.getWorkspace();
        progress.setWorkRemaining(updateReport.updates().size() * 2);
        int completed = 0;
        int size = updateReport.updates().size();
        for (IItemUpdateReport report : updateReport.updates()) {
            IComponentHandle component = report.getComponent();
            SubMonitor loopMon = progress.newChild(1);
            cfa = this.getUniqueCfaContaining(workspaceReq, component, report.item(), progress.newChild(1));
            if (cfa == null) continue;
            loopMon.subTask(NLS.bind((String)Messages.NewCheckInOperation_8, (Object)(++completed), (Object[])new Object[]{size}));
            try {
                FileItemInfoProxy info;
                InverseFileItemInfo oldInfo;
                if (report.getNewCurrentState() == null) continue;
                ILocalChange change = changes.get(component.getItemId()).remove(report.item().getItemId());
                IVersionable versionable = this.savedVersionable.get(report.getComponent().getItemId()).get(report.item().getItemId());
                if (report.item() instanceof IFolderHandle) {
                    if (change == null || (change.getType() & 0xA) == 0) {
                        oldInfo = cfa.getItemInfo(report.item(), report.getComponent(), (IContextHandle)workspace.getResolvedWorkspace());
                        if (change != null && !oldInfo.getName().equals(change.getPath().lastSegment()) && !oldInfo.isLoadedWithAnotherName()) {
                            throw new IllegalStateException("Name should have been " + oldInfo.getName() + " but the path is " + change.getPath());
                        }
                        info = new FileItemInfoProxy(oldInfo);
                        info.setItemState(report.getNewCurrentState());
                    } else {
                        info = new FileItemInfoProxy(report.getNewCurrentState(), change.getTargetParent(), change.getResultingPath().lastSegment(), false);
                    }
                } else if (report.item() instanceof IFileItemHandle) {
                    Long contentSize;
                    oldInfo = cfa.getItemInfo(report.item(), report.getComponent(), (IContextHandle)workspace.getResolvedWorkspace());
                    if (oldInfo != null) {
                        info = new FileItemInfoProxy(oldInfo);
                        info.setItemState(report.getNewCurrentState());
                        if ((change.getType() & 0xA) == 0) {
                            if (!oldInfo.getName().equals(change.getPath().lastSegment()) && !oldInfo.isLoadedWithAnotherName()) {
                                throw new IllegalStateException("Name should have been " + oldInfo.getName() + " but the path is " + change.getPath());
                            }
                        } else {
                            info.changeIdentity(change.getTargetParent(), change.getResultingPath().lastSegment());
                        }
                    } else {
                        info = new FileItemInfoProxy(report.getNewCurrentState(), change.getTargetParent(), change.getResultingPath().lastSegment());
                    }
                    if ((contentSize = uploadData.getContentSize(component, (IVersionableHandle)versionable)) != null) {
                        ContentHash hash = uploadData.getHashCode(component, (IVersionableHandle)versionable);
                        long contentLength = contentSize;
                        Long modTime = uploadData.getModTime(component, (IVersionableHandle)versionable);
                        FileContent contentUploaded = uploadData.getContent(component, (IVersionableHandle)versionable);
                        info.setContentInfo(modTime, hash, contentLength, contentUploaded);
                    }
                } else {
                    oldInfo = cfa.getItemInfo(report.item(), report.getComponent(), (IContextHandle)workspace.getResolvedWorkspace());
                    ISymbolicLink link = (ISymbolicLink)versionable;
                    if (oldInfo != null) {
                        info = new FileItemInfoProxy(oldInfo);
                        info.setItemState(report.getNewCurrentState());
                        if ((change.getType() & 0xA) == 0) {
                            if (!oldInfo.getName().equals(change.getPath().lastSegment()) && !oldInfo.isLoadedWithAnotherName()) {
                                throw new IllegalStateException("Name should have been " + oldInfo.getName() + " but the path is " + change.getPath());
                            }
                        } else {
                            info.changeIdentity(change.getTargetParent(), change.getResultingPath().lastSegment());
                        }
                    } else {
                        info = new FileItemInfoProxy(report.getNewCurrentState(), change.getTargetParent(), change.getResultingPath().lastSegment());
                    }
                    info.setTarget(((Shareable)change.getShareable()).getFileStorage().getModificationStamp(), link.getTarget());
                }
                info.setProperties(versionable);
                assert (change.getResultingPath() != null);
                cfa.setItemMetaData(change.getResultingPath(), info.getFileItemInfo(), (IProgressMonitor)loopMon.newChild(1));
            }
            catch (FileSystemClientException e) {
                this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)e)));
            }
            catch (TeamRepositoryException e) {
                this.collectStatus(FileSystemStatus.getStatusFor(e));
            }
        }
        for (Map<UUID, ILocalChange> localChanges : changes.values()) {
            for (ILocalChange change : localChanges.values()) {
                if (!change.isType(4)) {
                    this.collectStatus((IStatus)new Status(4, "com.ibm.team.filesystem.client", String.valueOf(Messages.NewCheckInOperation_EXPECTED_FILE_OR_FOLDER_DELETION) + change));
                    continue;
                }
                cfa = this.getUniqueCfaContaining(workspaceReq, change.getComponent(), change.getTarget(), progress.newChild(1));
                if (cfa == null) continue;
                try {
                    cfa.deleteTreeInfo(change.getTarget(), change.getComponent(), workspace.getContextHandle(), (IProgressMonitor)progress.newChild(1));
                }
                catch (FileSystemClientException e) {
                    this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)e)));
                }
            }
        }
        progress.done();
    }

    private ICopyFileArea getUniqueCfaContaining(WorkspaceCheckInRequest workspaceReq, IComponentHandle component, IVersionableHandle item, SubMonitor monitor) {
        ICopyFileArea cfa = null;
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)workspaceReq.allCfas().size());
        IWorkspaceConnection workspace = workspaceReq.getWorkspace();
        for (ICopyFileArea candidate : workspaceReq.allCfas()) {
            if (candidate.getItemInfo(item, component, workspace.getContextHandle()) == null) continue;
            if (cfa == null) {
                cfa = candidate;
                continue;
            }
            String compName = Messages.NewCheckInOperation_DEFAULT_NAME_FOR_UNKNOWN_COMPONENT;
            IComponent comp = null;
            try {
                comp = (IComponent)workspace.teamRepository().itemManager().fetchCompleteItem((IItemHandle)component, 0, (IProgressMonitor)monitor.newChild(10));
            }
            catch (TeamRepositoryException e) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_MISSING_NAME_OF_REMOTE_OBJECT, (Throwable)e));
            }
            if (comp != null) {
                compName = comp.getName();
            }
            LoggingHelper.log(FileSystemStatus.getStatusFor(1, NLS.bind((String)MULTI_SANDBOX_WARNING, (Object)compName, (Object[])new Object[0]), null));
            monitor.done();
            return null;
        }
        return cfa;
    }

    private void updateCFAConfigState(WorkspaceCheckInRequest workspaceReq, IUpdateReport updateReport, SubMonitor monitor) throws FileSystemClientException {
        HashMap<UUID, ISyncTime> beforeStates = new HashMap<UUID, ISyncTime>();
        for (IComponentStateSummary summary : updateReport.getComponentStatesBefore()) {
            beforeStates.put(summary.getComponent().getItemId(), summary.getConfigurationTime());
        }
        monitor.beginTask(Messages.NewCheckInOperation_UPDATING_SYNC_TIME, updateReport.getComponentStatesAfter().size());
        IWorkspaceConnection workspace = workspaceReq.getWorkspace();
        for (IComponentStateSummary summary : updateReport.getComponentStatesAfter()) {
            IComponentHandle component = summary.getComponent();
            SubMonitor loopMon = monitor.newChild(1);
            Set<ICopyFileArea> cfas = workspaceReq.allCfas();
            loopMon.setWorkRemaining(cfas.size() + 10);
            ICopyFileArea toUpdate = this.getUniqueCfaContaining(workspaceReq, component, loopMon.newChild(1));
            if (toUpdate == null) continue;
            ISyncTime beforeState = (ISyncTime)beforeStates.get(component.getItemId());
            toUpdate.setConfigurationState((IContextHandle)workspace.getResolvedWorkspace(), component, beforeState, summary.getConfigurationTime(), (IProgressMonitor)loopMon.newChild(10));
        }
    }

    private ICopyFileArea getUniqueCfaContaining(WorkspaceCheckInRequest workspaceReq, IComponentHandle component, SubMonitor monitor) throws FileSystemClientException {
        ICopyFileArea cfa = null;
        monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)workspaceReq.allCfas().size());
        IWorkspaceConnection workspace = workspaceReq.getWorkspace();
        for (ICopyFileArea candidate : workspaceReq.allCfas()) {
            if (!candidate.isConfigurationShared(workspace.getContextHandle(), component, (IProgressMonitor)monitor.newChild(1))) continue;
            if (cfa == null) {
                cfa = candidate;
                continue;
            }
            String compName = Messages.NewCheckInOperation_DEFAULT_NAME_FOR_UNKNOWN_COMPONENT;
            IComponent comp = null;
            try {
                comp = (IComponent)workspace.teamRepository().itemManager().fetchCompleteItem((IItemHandle)component, 0, (IProgressMonitor)monitor.newChild(10));
            }
            catch (TeamRepositoryException e) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(4, Messages.NewCheckInOperation_MISSING_NAME_OF_REMOTE_OBJECT, (Throwable)e));
            }
            if (comp != null) {
                compName = comp.getName();
            }
            LoggingHelper.log(FileSystemStatus.getStatusFor(1, NLS.bind((String)MULTI_SANDBOX_WARNING, (Object)compName, (Object[])new Object[0]), null));
            monitor.done();
            return null;
        }
        return cfa;
    }

    @Override
    protected String getTraceMessage() {
        return "No trace message";
    }

    @Override
    public boolean getRefreshBeforeRun() {
        return this.refreshBeforeRun;
    }

    @Override
    public void setRefreshBeforeRun(boolean newValue) {
        this.refreshBeforeRun = newValue;
    }

    private ILocalChange[] refreshLocalFilesystem(ILocalChange[] toRefresh, IContextHandle contextHandle, IComponentHandle componentHandle, ISandbox sandbox, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(5 + toRefresh.length));
        LocalChangeManager lcm = LocalChangeManager.getInstance();
        ArrayList<IShareable> shareables = new ArrayList<IShareable>(toRefresh.length);
        ILocalChange[] iLocalChangeArray = toRefresh;
        int n = toRefresh.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange change = iLocalChangeArray[n2];
            IShareable shareable = change.getShareable();
            if (shareable != null) {
                ((Shareable)shareable).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(1));
                shareables.add(shareable);
            }
            ++n2;
        }
        lcm.refreshChanges(shareables, (IProgressMonitor)monitor.newChild(2));
        lcm.syncPendingChanges(contextHandle, componentHandle, sandbox, (IProgressMonitor)monitor.newChild(3));
        ILocalChange[] fromLCM = lcm.getPendingChanges(contextHandle, componentHandle, sandbox);
        HashMap<UUID, ILocalChange> newChanges = new HashMap<UUID, ILocalChange>(fromLCM.length);
        ILocalChange[] iLocalChangeArray2 = fromLCM;
        int n3 = fromLCM.length;
        int n4 = 0;
        while (n4 < n3) {
            ILocalChange change = iLocalChangeArray2[n4];
            newChanges.put(change.getTarget().getItemId(), change);
            ++n4;
        }
        ArrayList<ILocalChange> toReturn = new ArrayList<ILocalChange>(toRefresh.length);
        ILocalChange[] iLocalChangeArray3 = toRefresh;
        int n5 = toRefresh.length;
        n3 = 0;
        while (n3 < n5) {
            ILocalChange change = iLocalChangeArray3[n3];
            ILocalChange current = (ILocalChange)newChanges.get(change.getTarget().getItemId());
            if (current != null) {
                toReturn.add(current);
            }
            ++n3;
        }
        return toReturn.toArray(new ILocalChange[toReturn.size()]);
    }

    @Override
    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    @Override
    public void enableNonAtomicCommit(int numberUploads) {
        this.nonAtomicCommitIsAnOption = true;
        this.uploadLimit = numberUploads;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ComponentCheckInRequest {
        private Map<UUID, Set<ILocalChange>> changesToCommit;
        private Set<ILocalChange> allChanges;
        private Map<UUID, IChangeSetHandle> changeSetsToCommit;
        protected final ISandbox sandbox;
        protected final IChangeSetHandle changeSet;
        protected final String commentForNewChangeSet;
        protected final IWorkspaceConnection workspace;
        protected final IComponentHandle component;

        protected ComponentCheckInRequest(ISandbox sb, IWorkspaceConnection workspace, IComponentHandle component, IChangeSetHandle csHandle, String commentForNewChangeSet) {
            this.sandbox = sb;
            this.workspace = workspace;
            this.component = component;
            this.changeSet = csHandle;
            this.commentForNewChangeSet = commentForNewChangeSet;
        }

        public abstract ILocalChange[] getChanges(boolean var1, IProgressMonitor var2) throws FileSystemClientException;

        public final IComponentHandle getComponent() {
            return this.component;
        }

        public final IWorkspaceConnection getWorkspace() {
            return this.workspace;
        }

        public abstract void validate(IProgressMonitor var1) throws FileSystemClientException;

        public final LocalChangeTracker getTracker() throws FileSystemClientException {
            LocalChangeManager lcm = (LocalChangeManager)FileSystemCore.getSharingManager().getLocalChangeManager();
            return lcm.findTracker((IContextHandle)this.getWorkspace().getResolvedWorkspace(), this.getComponent(), this.getSandbox().getRoot());
        }

        public final String getCommentForNewChangeSet() {
            return this.commentForNewChangeSet;
        }

        public final void setChangesToCommit(HashMap<UUID, Set<ILocalChange>> changesToCommit) {
            this.changesToCommit = changesToCommit;
        }

        public final void setChangeSetsToCommit(Map<UUID, IChangeSetHandle> changeSetsToCommit) {
            this.changeSetsToCommit = changeSetsToCommit;
        }

        public final ICopyFileArea getCfa() {
            return CopyFileAreaManager.instance.getCopyFileAreaForPath(this.getSandbox().getRoot());
        }

        public final ISandbox getSandbox() {
            return this.sandbox;
        }

        public final IChangeSetHandle getPreferredChangeSet() {
            return this.changeSet;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WorkspaceCheckInRequest {
        final List<ComponentCheckInRequest> reqs;
        final IWorkspaceConnection workspace;
        Set<ICopyFileArea> allSandboxes = null;

        public WorkspaceCheckInRequest(List<ComponentCheckInRequest> reqs) {
            this.reqs = reqs;
            this.workspace = reqs.iterator().next().getWorkspace();
        }

        public IWorkspaceConnection getWorkspace() {
            return this.workspace;
        }

        public Set<ICopyFileArea> allCfas() {
            if (this.allSandboxes == null) {
                this.allSandboxes = new HashSet<ICopyFileArea>();
                for (ComponentCheckInRequest compReq : this.reqs) {
                    this.allSandboxes.add(compReq.getCfa());
                }
            }
            return this.allSandboxes;
        }
    }
}

