/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.ChangeSetChooser;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IMoveFoldersOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.MoveFoldersDilemmaHandler;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoveFoldersOperation
extends ChangeHistoryChangeSetsOperation
implements IMoveFoldersOperation {
    private List<MoveRequest> moveRequests;
    private Map<IWorkspaceConnection, List<RenameRequest>> renameRequests;
    private MoveFoldersDilemmaHandler moveDilemmaHandler;
    private boolean skipFileAreaUpdates = false;

    public MoveFoldersOperation(MoveFoldersDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? MoveFoldersDilemmaHandler.getDefault() : dilemmaHandler);
        this.moveDilemmaHandler = dilemmaHandler == null ? MoveFoldersDilemmaHandler.getDefault() : dilemmaHandler;
        this.moveRequests = new ArrayList<MoveRequest>();
        this.renameRequests = new HashMap<IWorkspaceConnection, List<RenameRequest>>();
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        monitor.setTaskName(Messages.MoveFoldersOperation_0);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.MoveAcrossComponent_ProgressMessage, (int)100);
        final Set<ConfigurationDescriptor> affectedConfigurations = this.getAffectedConfigurations();
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        try {
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        MoveFoldersOperation.this.processRequests(affectedConfigurations, monitor);
                    }
                    catch (FileSystemClientException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, Messages.MoveFoldersOperation_1, (IProgressMonitor)progress.newChild(99));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
        progress.done();
    }

    private Set<ConfigurationDescriptor> getAffectedConfigurations() {
        HashSet<ConfigurationDescriptor> configurations = new HashSet<ConfigurationDescriptor>();
        for (MoveRequest moveRequest : this.moveRequests) {
            configurations.add(new ConfigurationDescriptor((IConnection)moveRequest.workspaceConnection, moveRequest.sourceComponent));
            configurations.add(new ConfigurationDescriptor((IConnection)moveRequest.workspaceConnection, moveRequest.targetComponent));
        }
        for (List list : this.renameRequests.values()) {
            for (RenameRequest request : list) {
                configurations.add(new ConfigurationDescriptor((IConnection)request.workspaceConnection, request.component));
            }
        }
        return configurations;
    }

    @Override
    public void addMoveWithinComponentRequest(IWorkspaceConnection workspaceConnection, IComponentHandle component, IFolderHandle[] foldersToMove, IFolderHandle[] toDestinationFolders, String changeSetComment) {
        IFolderHandle folder;
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        if (component == null) {
            throw new IllegalArgumentException();
        }
        if (foldersToMove == null) {
            throw new IllegalArgumentException();
        }
        IFolderHandle[] iFolderHandleArray = foldersToMove;
        int n = foldersToMove.length;
        int n2 = 0;
        while (n2 < n) {
            folder = iFolderHandleArray[n2];
            if (folder == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (toDestinationFolders == null) {
            throw new IllegalArgumentException();
        }
        iFolderHandleArray = toDestinationFolders;
        n = toDestinationFolders.length;
        n2 = 0;
        while (n2 < n) {
            folder = iFolderHandleArray[n2];
            if (folder == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (foldersToMove.length != toDestinationFolders.length) {
            throw new IllegalArgumentException();
        }
        MoveRequest request = new MoveRequest(workspaceConnection, component, foldersToMove, component, toDestinationFolders, changeSetComment, changeSetComment);
        this.moveRequests.add(request);
    }

    @Override
    public void addRenameRequest(IWorkspaceConnection workspaceConnection, IComponentHandle component, IFolderHandle[] foldersToRename, String[] newFolderName, String changeSetComment) {
        if (workspaceConnection == null) {
            throw new IllegalArgumentException("WorkspaceConnection must be supplied for rename request");
        }
        if (component == null) {
            throw new IllegalArgumentException("Component must be supplied for rename request");
        }
        if (foldersToRename == null) {
            throw new IllegalArgumentException("Folders to be renamed must be supplied for rename request");
        }
        if (newFolderName == null) {
            throw new IllegalArgumentException("New folder names must be supplied");
        }
        if (foldersToRename.length != newFolderName.length) {
            throw new IllegalArgumentException("There must be a new name for each and every folder");
        }
        RenameRequest request = new RenameRequest(workspaceConnection, component, foldersToRename, newFolderName, changeSetComment);
        List<RenameRequest> requestsForWorkspace = this.renameRequests.get(workspaceConnection);
        if (requestsForWorkspace == null) {
            requestsForWorkspace = new ArrayList<RenameRequest>();
            this.renameRequests.put(workspaceConnection, requestsForWorkspace);
        }
        requestsForWorkspace.add(request);
    }

    @Override
    public void addMoveAcrossComponentRequest(IWorkspaceConnection workspaceConnection, IComponentHandle sourceComponent, IFolderHandle[] foldersToMove, IComponentHandle targetComponent, IFolderHandle[] toDestinationFolders, String sourceChangeSetComment, String targetChangeSetComment) {
        if (workspaceConnection == null) {
            throw new IllegalArgumentException();
        }
        if (sourceComponent == null) {
            throw new IllegalArgumentException();
        }
        if (targetComponent == null) {
            throw new IllegalArgumentException();
        }
        if (sourceComponent.sameItemId((IItemHandle)targetComponent)) {
            throw new IllegalArgumentException();
        }
        if (foldersToMove == null) {
            throw new IllegalArgumentException();
        }
        IFolderHandle[] iFolderHandleArray = foldersToMove;
        int n = foldersToMove.length;
        int n2 = 0;
        while (n2 < n) {
            IFolderHandle folder = iFolderHandleArray[n2];
            if (folder == null) {
                throw new IllegalArgumentException();
            }
            ++n2;
        }
        if (toDestinationFolders == null) {
            throw new IllegalArgumentException();
        }
        if (foldersToMove.length != toDestinationFolders.length) {
            throw new IllegalArgumentException();
        }
        MoveRequest request = new MoveRequest(workspaceConnection, sourceComponent, foldersToMove, targetComponent, toDestinationFolders, sourceChangeSetComment, targetChangeSetComment);
        this.moveRequests.add(request);
    }

    private void processRequests(Set<ConfigurationDescriptor> affectedConfigurations, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(10 + 100 * this.moveRequests.size()));
        if (this.verifyInSyncEnabled() && !this.moveDilemmaHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.moveDilemmaHandler.getOutOfSyncDilemmaHandler());
            for (ConfigurationDescriptor configurationDescriptor : affectedConfigurations) {
                verifyOp.addToVerify((IConnection)((IWorkspaceConnection)configurationDescriptor.getConnection(null)), configurationDescriptor.componentHandle);
            }
            verifyOp.run((IProgressMonitor)progress.newChild(10));
        }
        this.checkCancelled((IProgressMonitor)progress);
        ICopyFileAreaLockRequest lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(affectedConfigurations, true);
        ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
        try {
            this.checkinPendingChanges(affectedConfigurations, this.moveDilemmaHandler, true, (IProgressMonitor)progress.newChild(30));
            this.checkCancelled((IProgressMonitor)progress);
            for (MoveRequest moveRequest : this.moveRequests) {
                IUpdateReport report = moveRequest.sourceComponent.sameItemId((IItemHandle)moveRequest.targetComponent) ? this.moveFoldersWithinComponent(moveRequest, (IProgressMonitor)progress.newChild(50)) : moveRequest.workspaceConnection.moveFoldersBetweenComponents(moveRequest.sourceComponent, moveRequest.targetComponent, moveRequest.foldersToMove, moveRequest.toDestinationFolders, moveRequest.sourceChangeSetComment, moveRequest.targetChangeSetComment, (IProgressMonitor)progress.newChild(48));
                this.checkCancelled((IProgressMonitor)progress);
                if (this.skipFileAreaUpdates) continue;
                UpdateOperation op = new UpdateOperation(moveRequest.workspaceConnection, Collections.singletonList(report), 3, this.moveDilemmaHandler, null);
                this.disableVerifyInSync(op);
                progress.subTask(Messages.MoveFoldersOperation_PROGRESS_UPDATES);
                op.run((IProgressMonitor)progress.newChild(50));
            }
            for (Map.Entry entry : this.renameRequests.entrySet()) {
                this.processRenames((IWorkspaceConnection)entry.getKey(), (List)entry.getValue(), (IProgressMonitor)progress.newChild(100));
            }
        }
        finally {
            copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
        }
    }

    private IUpdateReport moveFoldersWithinComponent(MoveRequest moveRequest, IProgressMonitor progress) throws TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        List<IFolderHandle> toMove = Arrays.asList(moveRequest.foldersToMove);
        List fullToMove = moveRequest.workspaceConnection.configuration(moveRequest.sourceComponent).fetchCompleteItems(toMove, (IProgressMonitor)monitor.newChild(10));
        ChangeSetChooser changeSetChooser = new ChangeSetChooser(moveRequest.workspaceConnection, null);
        int i = 0;
        SubMonitor iterProgress = monitor.newChild(5);
        iterProgress.setWorkRemaining(fullToMove.size());
        for (IFolder folder : fullToMove) {
            folder = (IFolder)folder.getWorkingCopy();
            folder.setParent(moveRequest.toDestinationFolders[i]);
            IWorkspaceConnection.ISaveOp op = moveRequest.workspaceConnection.configurationOpFactory().save((IVersionable)folder);
            changeSetChooser.toCommit(moveRequest.sourceComponent, (IVersionableHandle)folder, (IWorkspaceConnection.IConfigurationOp)op, null, moveRequest.sourceChangeSetComment, (IProgressMonitor)iterProgress.newChild(1));
        }
        return changeSetChooser.commit((IProgressMonitor)monitor.newChild(85));
    }

    private void processRenames(IWorkspaceConnection workspaceConnection, List<RenameRequest> renames, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 + 15 * renames.size()));
        ChangeSetChooser changeSetChooser = new ChangeSetChooser(workspaceConnection, null);
        for (RenameRequest request : renames) {
            List<IFolderHandle> toRename = Arrays.asList(request.foldersToRename);
            List fullToRename = workspaceConnection.configuration(request.component).fetchCompleteItems(toRename, (IProgressMonitor)progress.newChild(10));
            int i = 0;
            SubMonitor iterProgress = progress.newChild(5);
            iterProgress.setWorkRemaining(fullToRename.size());
            for (IFolder folder : fullToRename) {
                folder = (IFolder)folder.getWorkingCopy();
                folder.setName(request.newNames[i]);
                ++i;
                IWorkspaceConnection.ISaveOp op = workspaceConnection.configurationOpFactory().save((IVersionable)folder);
                changeSetChooser.toCommit(request.component, (IVersionableHandle)folder, (IWorkspaceConnection.IConfigurationOp)op, null, request.changeSetComment, (IProgressMonitor)iterProgress.newChild(1));
            }
        }
        IUpdateReport report = changeSetChooser.commit((IProgressMonitor)progress.newChild(50));
        this.checkCancelled((IProgressMonitor)progress);
        if (!this.skipFileAreaUpdates) {
            UpdateOperation op = new UpdateOperation(workspaceConnection, Collections.singletonList(report), 3, this.moveDilemmaHandler, null);
            this.disableVerifyInSync(op);
            progress.subTask(Messages.MoveFoldersOperation_PROGRESS_UPDATES);
            op.run((IProgressMonitor)progress.newChild(50));
        }
    }

    @Override
    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationDescriptor>> affectedAreas, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        SharingManager sm = SharingManager.getInstance();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(this.moveRequests.size() + this.renameRequests.size()));
        for (MoveRequest moveRequest : this.moveRequests) {
            SubMonitor folderMon = monitor.newChild(1);
            folderMon.setWorkRemaining(moveRequest.foldersToMove.length);
            int i = 0;
            while (i < moveRequest.toDestinationFolders.length) {
                SubMonitor sandboxMon = folderMon.newChild(1);
                sandboxMon.setWorkRemaining(affectedAreas.size() * 2);
                for (ISandbox sb : affectedAreas.keySet()) {
                    Shareable target;
                    IShareable source = sm.findShareable(sb.getRoot(), moveRequest.workspaceConnection.getContextHandle(), moveRequest.sourceComponent, (IVersionableHandle)moveRequest.foldersToMove[i], (IProgressMonitor)sandboxMon.newChild(1));
                    if (source == null) continue;
                    refresher.addToRefresh(source);
                    IShareable parent = sm.findShareable(sb.getRoot(), moveRequest.workspaceConnection.getContextHandle(), moveRequest.targetComponent, (IVersionableHandle)moveRequest.toDestinationFolders[i], (IProgressMonitor)sandboxMon.newChild(1));
                    if (parent == null || (target = sm.findShareable(sb, parent.getLocalPath().append(source.getLocalPath().lastSegment()), ResourceType.FOLDER)) == null) continue;
                    refresher.addToRefresh(target);
                }
                ++i;
            }
        }
        for (List list : this.renameRequests.values()) {
            SubMonitor reqGroupMon = monitor.newChild(1);
            reqGroupMon.setWorkRemaining(list.size());
            for (RenameRequest req : list) {
                SubMonitor folderMon = reqGroupMon.newChild(1);
                folderMon.setWorkRemaining(req.foldersToRename.length);
                int i = 0;
                while (i < req.foldersToRename.length) {
                    SubMonitor reqMon = folderMon.newChild(1);
                    reqMon.setWorkRemaining(affectedAreas.size());
                    for (ISandbox sb : affectedAreas.keySet()) {
                        IShareable source = sm.findShareable(sb.getRoot(), req.workspaceConnection.getContextHandle(), req.component, (IVersionableHandle)req.foldersToRename[i], (IProgressMonitor)reqMon.newChild(1));
                        if (source == null) continue;
                        refresher.addToRefresh(source);
                        Shareable target = sm.findShareable(sb, source.getLocalPath().removeLastSegments(1).append(req.newNames[i]), ResourceType.FOLDER);
                        if (target == null) continue;
                        refresher.addToRefresh(target);
                    }
                    ++i;
                }
            }
        }
    }

    @Override
    public void setSkipFileAreaUpdates(boolean skip) {
        this.skipFileAreaUpdates = skip;
    }

    private class MoveRequest {
        final IWorkspaceConnection workspaceConnection;
        final IComponentHandle sourceComponent;
        final IFolderHandle[] foldersToMove;
        final IComponentHandle targetComponent;
        final IFolderHandle[] toDestinationFolders;
        final String sourceChangeSetComment;
        final String targetChangeSetComment;

        public MoveRequest(IWorkspaceConnection workspaceConnection, IComponentHandle sourceComponent, IFolderHandle[] foldersToMove, IComponentHandle targetComponent, IFolderHandle[] toDestinationFolders, String sourceChangeSetComment, String targetChangeSetComment) {
            this.workspaceConnection = workspaceConnection;
            this.sourceComponent = sourceComponent;
            this.foldersToMove = foldersToMove;
            this.targetComponent = targetComponent;
            this.toDestinationFolders = toDestinationFolders;
            this.sourceChangeSetComment = sourceChangeSetComment;
            this.targetChangeSetComment = targetChangeSetComment;
        }
    }

    private class RenameRequest {
        final IWorkspaceConnection workspaceConnection;
        final IComponentHandle component;
        final IFolderHandle[] foldersToRename;
        final String[] newNames;
        final String changeSetComment;

        public RenameRequest(IWorkspaceConnection workspaceConnection, IComponentHandle component, IFolderHandle[] foldersToRename, String[] newFolderNames, String changeSetComment) {
            this.workspaceConnection = workspaceConnection;
            this.component = component;
            this.foldersToRename = foldersToRename;
            this.newNames = newFolderNames;
            this.changeSetComment = changeSetComment;
        }
    }
}

