/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.NewCheckInOperation;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class LocalChangeCheckinRequest
extends NewCheckInOperation.ComponentCheckInRequest {
    ILocalChange[] changes;

    LocalChangeCheckinRequest(IWorkspaceConnection workspace, IComponentHandle component, ISandbox sandbox, ILocalChange[] changes, IChangeSetHandle changeSet, String commentForNewChangeSet) {
        super(sandbox, workspace, component, changeSet, commentForNewChangeSet);
        this.changes = changes;
    }

    public ILocalChange[] getChanges(boolean refreshChanges, IProgressMonitor progress) throws FileSystemClientException {
        if (refreshChanges) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress);
            monitor.setWorkRemaining(this.changes.length);
            ILocalChange[] oldChanges = this.changes;
            LocalChangeManager lcm = LocalChangeManager.getInstance();
            ILocalChange[] iLocalChangeArray = this.changes;
            int n = this.changes.length;
            int n2 = 0;
            while (n2 < n) {
                ILocalChange change = iLocalChangeArray[n2];
                IShareable shareable = change.getShareable();
                if (shareable != null) {
                    lcm.refreshChanges(shareable, ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN, (IProgressMonitor)monitor.newChild(1));
                }
                ++n2;
            }
            lcm.syncPendingChanges(this.getWorkspace().getContextHandle(), this.getComponent(), this.getSandbox(), (IProgressMonitor)monitor.newChild(this.changes.length));
            HashMap<UUID, ILocalChange> indexed = new HashMap<UUID, ILocalChange>();
            ILocalChange[] iLocalChangeArray2 = oldChanges;
            int n3 = oldChanges.length;
            n = 0;
            while (n < n3) {
                ILocalChange oldChange = iLocalChangeArray2[n];
                IVersionableHandle v = oldChange.getTarget();
                if (v != null) {
                    indexed.put(v.getItemId(), oldChange);
                }
                ++n;
            }
            ILocalChange[] candidates = lcm.getPendingChanges(this.getWorkspace().getContextHandle(), this.getComponent(), this.getSandbox());
            ArrayList<ILocalChange> newChanges = new ArrayList<ILocalChange>(candidates.length);
            ILocalChange[] iLocalChangeArray3 = candidates;
            int n4 = candidates.length;
            int n5 = 0;
            while (n5 < n4) {
                ILocalChange oldChange;
                ILocalChange candidate = iLocalChangeArray3[n5];
                IVersionableHandle versionable = candidate.getTarget();
                if (versionable != null && (oldChange = (ILocalChange)indexed.get(versionable.getItemId())) != null && oldChange.getType() == candidate.getType()) {
                    newChanges.add(candidate);
                }
                ++n5;
            }
            this.changes = newChanges.toArray(new ILocalChange[newChanges.size()]);
        }
        return this.changes;
    }

    public void validate(IProgressMonitor progress) throws FileSystemClientException {
    }
}

