/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Trace;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.client.operations.IFileSystemOperation;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public abstract class FileSystemOperation
implements IFileSystemOperation {
    private List errors = new ArrayList();
    private DilemmaHandler dilemmaHandler;
    private boolean verifyInSync;
    private long startTime = 0L;

    protected FileSystemOperation(DilemmaHandler dilemmaHandler) {
        this.dilemmaHandler = dilemmaHandler;
        this.verifyInSync = true;
    }

    public final void run(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.startOperation();
        Object token = ICopyFileAreaManager.instance.beginAvoidNotify();
        LocalChangeManager lcm = LocalChangeManager.getInstance();
        lcm.beginAvoidNotify();
        try {
            try {
                this.execute((IProgressMonitor)progress.newChild(99));
            }
            catch (TeamRepositoryException e) {
                if (e.getCause() instanceof CoreException && !(e.getCause() instanceof FileSystemClientException)) {
                    MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 0, e.getLocalizedMessage(), (Throwable)e);
                    multi.add(((CoreException)e.getCause()).getStatus());
                    throw new FileSystemClientException((IStatus)multi);
                }
                throw e;
            }
        }
        finally {
            try {
                ICopyFileAreaManager.instance.endAvoidNotify(token, (IProgressMonitor)progress.newChild(1));
                lcm.endAvoidNotify();
                if (Trace.LOG_ELAPSED_TIME) {
                    Trace.endTrace(this.startTime, this.getTraceMessage());
                }
            }
            finally {
                this.endOperation();
            }
        }
        this.handleErrors(this.errors.toArray(new IStatus[this.errors.size()]));
    }

    protected String getTraceMessage() {
        return this.getClass().getName();
    }

    protected void startOperation() {
        this.startTime = Trace.LOG_ELAPSED_TIME ? Trace.startTrace() : 0L;
        this.resetErrors();
    }

    protected void endOperation() {
    }

    protected abstract void execute(IProgressMonitor var1) throws FileSystemClientException, TeamRepositoryException;

    protected final void runWithinFileSystemLock(IRunnableWithProgress runnableWithProgress, String operationName, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        this.runWithinFileSystemLock(runnableWithProgress, operationName, null, monitor);
    }

    protected final void runWithinFileSystemLock(IRunnableWithProgress runnableWithProgress, String operationName, ISchedulingRule IDErule, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        try {
            SharingManager.getInstance().runWithinFileSystemLock(runnableWithProgress, IDErule, monitor);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof TeamRepositoryException) {
                throw (TeamRepositoryException)cause;
            }
            if (cause instanceof FileSystemClientException) {
                throw (FileSystemClientException)((Object)cause);
            }
            throw new TeamRepositoryException(NLS.bind((String)Messages.FileSystemOperation_1, (Object)operationName), cause);
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    protected void collectStatus(IStatus status) {
        if (status.isOK()) {
            return;
        }
        if (this.isLastError(status)) {
            return;
        }
        this.errors.add(status);
    }

    protected void resetErrors() {
        this.errors.clear();
    }

    protected IStatus[] getErrors() {
        return this.errors.toArray(new IStatus[this.errors.size()]);
    }

    protected IStatus getLastError() {
        Assert.isTrue((this.errors.size() > 0 ? 1 : 0) != 0);
        IStatus status = (IStatus)this.errors.get(this.errors.size() - 1);
        return status;
    }

    private boolean isLastError(IStatus status) {
        return this.errors.size() > 0 && this.getLastError() == status;
    }

    protected void reportErrorsAsException(IStatus[] errors) throws FileSystemClientException {
        if (errors.length == 0) {
            return;
        }
        if (errors.length == 1) {
            throw new FileSystemClientException(errors[0]);
        }
        MultiStatus result = new MultiStatus("com.ibm.team.filesystem.client", 0, this.getErrorMessage(errors), null);
        int i = 0;
        while (i < errors.length) {
            IStatus s = errors[i];
            result.add(s);
            ++i;
        }
        throw new FileSystemClientException((IStatus)result);
    }

    protected final void handleErrors(IStatus[] errors) throws FileSystemClientException {
        ArrayList<IStatus> reportableErrors = new ArrayList<IStatus>();
        int i = 0;
        while (i < errors.length) {
            IStatus status = errors[i];
            if (this.isReportableError(status)) {
                reportableErrors.add(status);
            } else if (status.isMultiStatus()) {
                IStatus[] children = status.getChildren();
                int j = 0;
                while (j < children.length) {
                    IStatus child = children[j];
                    if (this.isReportableError(child)) {
                        reportableErrors.add(status);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (!reportableErrors.isEmpty()) {
            this.reportErrorsAsException(reportableErrors.toArray(new IStatus[reportableErrors.size()]));
        }
    }

    protected DilemmaHandler getDilemmaHandler() {
        return this.dilemmaHandler;
    }

    protected boolean isReportableError(IStatus status) {
        return true;
    }

    protected String getErrorMessage(IStatus[] failures) {
        return NLS.bind((String)Messages.FileSystemOperation_0, (Object)failures.length);
    }

    protected boolean errorsOccurred() {
        for (IStatus status : this.errors) {
            if (this.isReportableError(status)) {
                return true;
            }
            if (!status.isMultiStatus()) continue;
            IStatus[] children = status.getChildren();
            int j = 0;
            while (j < children.length) {
                IStatus child = children[j];
                if (this.isReportableError(child)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    protected void checkCancelled(IProgressMonitor progress) {
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected final void setVerifyInSync(boolean verifyInSync) {
        this.verifyInSync = verifyInSync;
    }

    protected final boolean verifyInSyncEnabled() {
        return this.verifyInSync;
    }

    protected final void disableVerifyInSync(IFileSystemOperation op) {
        if (op instanceof FileSystemOperation) {
            FileSystemOperation fsOp = (FileSystemOperation)op;
            fsOp.setVerifyInSync(false);
        }
    }
}

