/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.load.DeferredInformation;
import com.ibm.team.filesystem.client.operations.IEncodingDownloadFailure;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.runtime.IStatus;

public class EncodingDownloadFailure
implements IEncodingDownloadFailure {
    private DeferredInformation deferredInformation;
    private IStatus status;

    public EncodingDownloadFailure(DeferredInformation deferredUpdateInformation) {
        this.deferredInformation = deferredUpdateInformation;
        this.status = null;
    }

    public String getEncoding() {
        return this.deferredInformation.getEncoding();
    }

    public IShareable getShareable() {
        return this.deferredInformation.getShareable();
    }

    public boolean hasDirection() {
        return this.deferredInformation.hasAlternateDownloadDirection();
    }

    public void setAlternativeEncoding(String alternativeEncoding) {
        if (alternativeEncoding == null) {
            throw new IllegalArgumentException("alternativeEncoding cannot be null");
        }
        if (!Charset.isSupported(alternativeEncoding)) {
            throw new UnsupportedCharsetException(alternativeEncoding);
        }
        this.deferredInformation.setAlternateEncoding(alternativeEncoding);
    }

    public void setIgnoreEncoding(boolean ignoreEncoding) {
        if (ignoreEncoding) {
            this.deferredInformation.setAlternativeLineDelimiter(FileLineDelimiter.LINE_DELIMITER_NONE);
        } else {
            this.deferredInformation.setAlternativeLineDelimiter(null);
        }
    }

    public IStatus getStatus() {
        return this.status;
    }

    public DeferredInformation getDeferredUpdateInformation() {
        return this.deferredInformation;
    }
}

