/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.operations.UpdateOperation;
import com.ibm.team.filesystem.client.internal.utils.ChangeSetRefreshUtils;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.DiscardDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDiscardOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscardOperation
extends ChangeHistoryChangeSetsOperation
implements IDiscardOperation {
    private final Map<IWorkspaceConnection, List<IChangeSetHandle>> discardRequests;
    private final DiscardDilemmaHandler problemHandler;

    public DiscardOperation(DiscardDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? DiscardDilemmaHandler.getDefault() : dilemmaHandler);
        this.problemHandler = dilemmaHandler == null ? DiscardDilemmaHandler.getDefault() : dilemmaHandler;
        this.discardRequests = new HashMap<IWorkspaceConnection, List<IChangeSetHandle>>();
    }

    @Override
    public void discard(IWorkspaceConnection workspace, Collection<? extends IChangeSetHandle> changeSetsToDiscard) {
        if (workspace == null) {
            throw new IllegalArgumentException();
        }
        if (changeSetsToDiscard == null) {
            throw new IllegalArgumentException();
        }
        List<IChangeSetHandle> toDiscard = this.discardRequests.get(workspace);
        if (toDiscard == null) {
            toDiscard = new ArrayList<IChangeSetHandle>();
            this.discardRequests.put(workspace, toDiscard);
        }
        toDiscard.addAll(changeSetsToDiscard);
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        ThreadCheck.checkLongOpsAllowed();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DiscardOperation_ProgressMessage, (int)100);
        ArrayList<IAuditable> determinants = new ArrayList<IAuditable>();
        final Set<ConfigurationDescriptor> affectedConfigurations = this.getAffectedConfigurations(determinants, (IProgressMonitor)progress.newChild(4));
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(affectedConfigurations, determinants, (IProgressMonitor)progress.newChild(1));
        try {
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        DiscardOperation.this.discard(affectedConfigurations, monitor);
                    }
                    catch (FileSystemClientException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, Messages.DiscardOperation_0, (IProgressMonitor)progress.newChild(95));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    private void discard(Set<ConfigurationDescriptor> affectedConfigurations, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DiscardOperation_ProgressMessage, (int)(3 * this.discardRequests.size() + 23));
        if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            SubMonitor iterProgress = progress.newChild(1);
            iterProgress.setWorkRemaining(affectedConfigurations.size());
            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
            for (ConfigurationDescriptor configurationDescriptor : affectedConfigurations) {
                verifyOp.addToVerify(configurationDescriptor.getConnection((IProgressMonitor)iterProgress.newChild(1)), configurationDescriptor.componentHandle);
            }
            verifyOp.run((IProgressMonitor)progress.newChild(10));
        }
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        ICopyFileAreaLockRequest lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(affectedConfigurations, true);
        ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
        try {
            this.checkinPendingChanges(affectedConfigurations, this.problemHandler, true, (IProgressMonitor)progress.newChild(10));
            for (Map.Entry entry : this.discardRequests.entrySet()) {
                IWorkspaceConnection workspaceConnection = (IWorkspaceConnection)entry.getKey();
                List changeSetHandles = (List)entry.getValue();
                workspaceConnection.ensureClosed((Collection)changeSetHandles, (IProgressMonitor)progress.newChild(changeSetHandles.size()));
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IUpdateReport report = workspaceConnection.discardChangeSets(false, (Collection)changeSetHandles, (IProgressMonitor)progress.newChild(changeSetHandles.size()));
                UpdateOperation updateOperation = new UpdateOperation(workspaceConnection, Collections.singletonList(report), 3, this.problemHandler, null);
                this.disableVerifyInSync(updateOperation);
                updateOperation.run((IProgressMonitor)progress.newChild(changeSetHandles.size()));
            }
        }
        finally {
            copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
        }
    }

    private Set<ConfigurationDescriptor> getAffectedConfigurations(Collection<IAuditable> determinants, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet<ConfigurationDescriptor> affectedConfigurations = new HashSet<ConfigurationDescriptor>();
        for (Map.Entry<IWorkspaceConnection, List<IChangeSetHandle>> entry : this.discardRequests.entrySet()) {
            IWorkspaceConnection workspaceConnection = entry.getKey();
            List<IChangeSetHandle> changeSetHandles = entry.getValue();
            List changeSets = workspaceConnection.teamRepository().itemManager().fetchCompleteItems(changeSetHandles, 0, monitor);
            determinants.addAll(changeSets);
            for (IChangeSet changeSet : changeSets) {
                affectedConfigurations.add(new ConfigurationDescriptor((IConnection)workspaceConnection, changeSet.getComponent()));
            }
        }
        return affectedConfigurations;
    }

    @Override
    protected void refreshLocal(IFilesystemRefresher refresher, Map<ISandbox, Set<ConfigurationDescriptor>> affectedAreas, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        for (Map.Entry<IWorkspaceConnection, List<IChangeSetHandle>> entry : this.discardRequests.entrySet()) {
            IWorkspaceConnection workspaceConnection = entry.getKey();
            List<IChangeSetHandle> changeSetHandles = entry.getValue();
            ChangeSetRefreshUtils.refreshLocalForRemoval(refresher, affectedAreas, workspaceConnection, changeSetHandles, progress);
        }
    }
}

