/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.CommitDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IDeleteFoldersOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteInRepositoryOperation
extends FileSystemOperation
implements IDeleteFoldersOperation {
    private int totalToDelete;
    private Set<ConfigurationDescriptor> affectedConfigurations;
    private Map<ConnectionDescriptor, Map<UUID, Collection<IShareable>>> toDelete;
    private boolean deleteContent;
    private final CommitDilemmaHandler problemHandler;

    public DeleteInRepositoryOperation(CommitDilemmaHandler problemHandler) {
        super(problemHandler == null ? CommitDilemmaHandler.getDefault() : problemHandler);
        this.problemHandler = problemHandler == null ? CommitDilemmaHandler.getDefault() : problemHandler;
        this.toDelete = new HashMap<ConnectionDescriptor, Map<UUID, Collection<IShareable>>>();
        this.affectedConfigurations = new HashSet<ConfigurationDescriptor>();
        this.totalToDelete = 0;
    }

    @Override
    public void addDeleteRequest(IShareable[] shareables, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        if (shareables == null) {
            throw new IllegalArgumentException("Shareables must be supplied");
        }
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)shareables.length);
        IShareable[] iShareableArray = shareables;
        int n = shareables.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<IShareable> shareablesToDelete;
            IShareable shareable = iShareableArray[n2];
            if (shareable == null) {
                throw new IllegalArgumentException("List of shareables must not contain null");
            }
            IShare share = shareable.getShare((IProgressMonitor)monitor.newChild(1));
            if (share == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.DeleteOperation_0, (Object)shareable.getLocalPath().toString(), (Object[])new Object[0]));
            }
            ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
            if (!(sharingDescriptor.getConnectionHandle() instanceof IWorkspaceHandle)) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.DeleteOperation_1, (Object)shareable.getLocalPath().toString(), (Object[])new Object[0]));
            }
            ConfigurationDescriptor configurationDescriptor = new ConfigurationDescriptor(sharingDescriptor.getRepositoryId(), sharingDescriptor.getRepositoryUri(), sharingDescriptor.getConnectionHandle(), sharingDescriptor.getComponent());
            this.affectedConfigurations.add(configurationDescriptor);
            ConnectionDescriptor descriptor = new ConnectionDescriptor(sharingDescriptor.getRepositoryId(), sharingDescriptor.getRepositoryUri(), sharingDescriptor.getConnectionHandle());
            Map<UUID, Collection<IShareable>> components = this.toDelete.get(descriptor);
            if (components == null) {
                components = new HashMap<UUID, Collection<IShareable>>();
                this.toDelete.put(descriptor, components);
            }
            if ((shareablesToDelete = components.get(sharingDescriptor.getComponent().getItemId())) == null) {
                shareablesToDelete = new ArrayList<IShareable>();
                components.put(sharingDescriptor.getComponent().getItemId(), shareablesToDelete);
            }
            shareablesToDelete.add(shareable);
            ++this.totalToDelete;
            ++n2;
        }
    }

    @Override
    public void setDeleteContent(boolean shouldDeleteContent) {
        this.deleteContent = shouldDeleteContent;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.DeleteOperation_MainProgressMessage, (int)100);
        FlowNodeLock workspaceLock = WorkspaceLockUtil.acquireWrite(this.affectedConfigurations, (IProgressMonitor)progress.newChild(1));
        try {
            this.verifyInSync((IProgressMonitor)progress.newChild(9));
            IRunnableWithProgress workspaceOp = new IRunnableWithProgress(){

                /*
                 * Unable to fully structure code
                 */
                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    try {
                        cfaMgr = ICopyFileAreaManager.instance;
                        lockFactory = cfaMgr.lockRequestFactory();
                        lockRequest = lockFactory.getLockRequest(DeleteInRepositoryOperation.access$0(DeleteInRepositoryOperation.this), true);
                        cfaLock = cfaMgr.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
                        try {
                            iterProgress = progress.newChild(3);
                            iterProgress.setWorkRemaining(DeleteInRepositoryOperation.access$0(DeleteInRepositoryOperation.this).size());
                            affectedCopyFileAreas = new HashSet<ICopyFileArea>();
                            affectedCopyFileAreasByConfiguration = new HashMap<ConfigurationDescriptor, Collection<ICopyFileArea>>();
                            for (ConfigurationDescriptor configuration : DeleteInRepositoryOperation.access$0(DeleteInRepositoryOperation.this)) {
                                copyFileAreas = cfaMgr.getCopyFileAreasForConfiguration(configuration, (IProgressMonitor)iterProgress.newChild(1));
                                affectedCopyFileAreas.addAll(copyFileAreas);
                                affectedCopyFileAreasByConfiguration.put(configuration, copyFileAreas);
                            }
                            try {
                                try {
                                    DeleteInRepositoryOperation.access$1(DeleteInRepositoryOperation.this, affectedCopyFileAreasByConfiguration, (IProgressMonitor)progress.newChild(95));
                                }
                                catch (TeamRepositoryException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            finally {
                                ** for (cfa : affectedCopyFileAreas)
                            }
lbl-1000:
                            // 1 sources

                            {
                                cfa.syncMetaData();
                                continue;
lbl30:
                                // 1 sources

                            }
                        }
                        finally {
                            cfaLock.release((IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (FileSystemClientException e) {
                        throw new InvocationTargetException((Throwable)e);
                    }
                }
            };
            this.runWithinFileSystemLock(workspaceOp, Messages.DeleteInRepositoryOperation_0, (IProgressMonitor)progress.newChild(90));
        }
        finally {
            WorkspaceLockUtil.release(workspaceLock);
        }
    }

    private void verifyInSync(IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(this.toDelete.size() * 10 + 10));
        if (this.verifyInSyncEnabled() && !this.problemHandler.getOutOfSyncDilemmaHandler().willIgnoreAllSharesOutOfSync()) {
            IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.problemHandler.getOutOfSyncDilemmaHandler());
            boolean verify = false;
            for (Map.Entry<ConnectionDescriptor, Map<UUID, Collection<IShareable>>> entry : this.toDelete.entrySet()) {
                SubMonitor iterProgress = monitor.newChild(10);
                iterProgress.setWorkRemaining(entry.getValue().size() + 1);
                HashMap<String, IShare> toVerify = new HashMap<String, IShare>();
                for (Collection<IShareable> shareablesToDelete : entry.getValue().values()) {
                    for (IShareable shareable : shareablesToDelete) {
                        IShare share = shareable.getShare((IProgressMonitor)iterProgress.newChild(1));
                        if (share == null) continue;
                        toVerify.put(share.getPath().toString(), share);
                    }
                }
                if (toVerify.isEmpty()) continue;
                verifyOp.addToVerify(entry.getKey().getConnection((IProgressMonitor)iterProgress.newChild(1)), toVerify.values());
                verify = true;
            }
            if (verify) {
                verifyOp.run((IProgressMonitor)monitor.newChild(10));
            }
        }
    }

    private void delete(Map<ConfigurationDescriptor, Collection<ICopyFileArea>> affectedCopyFileAreas, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.totalToDelete + this.toDelete.size()));
        for (Map.Entry<ConnectionDescriptor, Map<UUID, Collection<IShareable>>> entry : this.toDelete.entrySet()) {
            IWorkspaceConnection connection = (IWorkspaceConnection)entry.getKey().getConnection((IProgressMonitor)progress.newChild(1));
            ArrayList<IChangeSetHandle> changeSets = new ArrayList<IChangeSetHandle>();
            ArrayList<Collection<? extends IWorkspaceConnection.IConfigurationOp>> configurationOps = new ArrayList<Collection<? extends IWorkspaceConnection.IConfigurationOp>>();
            Map<UUID, Collection<IShareable>> shareablesByComponent = entry.getValue();
            this.prepareCommitArgs(connection, shareablesByComponent, changeSets, configurationOps, (IProgressMonitor)progress);
            try {
                if (!configurationOps.isEmpty()) {
                    IUpdateReport updateReport = connection.commit(changeSets, configurationOps, (IProgressMonitor)progress.newChild(100));
                    HashMap<UUID, ISyncTime> beforeStates = new HashMap<UUID, ISyncTime>();
                    for (IComponentStateSummary summary : updateReport.getComponentStatesBefore()) {
                        beforeStates.put(summary.getComponent().getItemId(), summary.getConfigurationTime());
                    }
                    for (IComponentStateSummary summary : updateReport.getComponentStatesAfter()) {
                        ISyncTime beforeState = (ISyncTime)beforeStates.get(summary.getComponent().getItemId());
                        Collection<ICopyFileArea> cfaForConfiguration = affectedCopyFileAreas.get(new ConfigurationDescriptor((IConnection)connection, summary.getComponent()));
                        for (ICopyFileArea cfa : cfaForConfiguration) {
                            cfa.setConfigurationState((IContextHandle)connection.getResolvedWorkspace(), summary.getComponent(), beforeState, summary.getConfigurationTime(), null);
                        }
                    }
                }
                this.deleteFromCFA(shareablesByComponent, (IProgressMonitor)progress.newChild(100));
            }
            catch (TeamRepositoryException e) {
                this.collectStatus(FileSystemStatus.getStatusFor(4, "com.ibm.team.filesystem.client", 0, Messages.DeleteOperation_ErrorFromServer, e));
            }
        }
    }

    private void deleteFromCFA(Map<UUID, Collection<IShareable>> shareablesByComponent, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(shareablesByComponent.size() * 100));
        String action = this.deleteContent ? Messages.DeleteOperation_SubProgressActionName : Messages.DeleteOperation_SubProgressActionNameAlt;
        int i = 0;
        for (Collection<IShareable> shareables : shareablesByComponent.values()) {
            ++i;
            final SubMonitor subProgress = progress.newChild(100);
            subProgress.setWorkRemaining(shareables.size() * 50);
            for (IShareable shareable : shareables) {
                IPath path = shareable.getLocalPath();
                subProgress.setTaskName(NLS.bind((String)Messages.DeleteOperation_ActionNumbers, (Object)action, (Object[])new Object[]{path, i, this.totalToDelete}));
                final IFileStorage fileStorage = ((Shareable)shareable).getFileStorage();
                try {
                    ((Shareable)shareable).forget((IProgressMonitor)subProgress.newChild(24));
                }
                catch (FileSystemClientException e) {
                    this.collectStatus(FileSystemStatus.getStatusFor(4, "com.ibm.team.filesystem.client", 0, NLS.bind((String)Messages.DeleteOperation_ErrorFromClientDelete, (Object)path, (Object[])new Object[0]), (Throwable)((Object)e)));
                    break;
                }
                boolean exists = false;
                try {
                    exists = shareable.exists((IProgressMonitor)subProgress.newChild(1));
                }
                catch (FileSystemClientException e) {
                    this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)e)));
                }
                if (!exists || !this.deleteContent) continue;
                try {
                    SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                        public void run() throws CoreException {
                            try {
                                fileStorage.delete((IProgressMonitor)subProgress.newChild(25));
                            }
                            catch (TeamRepositoryException e) {
                                throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
                            }
                        }
                    });
                }
                catch (CoreException e) {
                    this.collectStatus(FileSystemStatus.getStatusFor(4, "com.ibm.team.filesystem.client", 0, NLS.bind((String)Messages.DeleteOperation_ErrorFromFileSystemDelete, (Object)path, (Object[])new Object[0]), e));
                }
            }
            subProgress.done();
        }
    }

    private void prepareCommitArgs(IWorkspaceConnection connection, Map<UUID, Collection<IShareable>> shareablesForConnection, ArrayList<IChangeSetHandle> changeSets, ArrayList<Collection<? extends IWorkspaceConnection.IConfigurationOp>> configurationOps, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(shareablesForConnection.size() * 100));
        for (Map.Entry<UUID, Collection<IShareable>> shareablesByComponent : shareablesForConnection.entrySet()) {
            Collection<IShareable> shareables = shareablesByComponent.getValue();
            ArrayList<Object> configurationOpsForComponent = new ArrayList<Object>(shareables.size());
            SubMonitor iterProgress = monitor.newChild(100);
            iterProgress.setWorkRemaining(shareables.size() + 1);
            for (IShareable shareable : shareables) {
                IVersionableHandle versionable = shareable.getRemote((IProgressMonitor)iterProgress.newChild(1));
                if (versionable instanceof IFolderHandle) {
                    configurationOpsForComponent.add(connection.configurationOpFactory().deleteSubtree((IFolderHandle)versionable));
                    continue;
                }
                if (!(versionable instanceof IFileItemHandle) && !(versionable instanceof ISymbolicLinkHandle)) continue;
                configurationOpsForComponent.add(connection.configurationOpFactory().delete(versionable));
            }
            if (iterProgress.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (configurationOpsForComponent.isEmpty()) continue;
            IComponentHandle componentHandle = (IComponentHandle)IComponent.ITEM_TYPE.createItemHandle((Object)connection, shareablesByComponent.getKey(), null);
            IChangeSetHandle cs = connection.getCurrentChangeSet(componentHandle);
            if (cs == null) {
                cs = connection.createChangeSet(componentHandle, Messages.DeleteOperation_2, true, (IProgressMonitor)iterProgress.newChild(1));
            }
            changeSets.add(cs);
            configurationOps.add(configurationOpsForComponent);
        }
    }

    static /* synthetic */ Set access$0(DeleteInRepositoryOperation deleteInRepositoryOperation) {
        return deleteInRepositoryOperation.affectedConfigurations;
    }

    static /* synthetic */ void access$1(DeleteInRepositoryOperation deleteInRepositoryOperation, Map map, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        deleteInRepositoryOperation.delete(map, iProgressMonitor);
    }
}

