/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileUploadHandler;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.magic.ContentProperties;
import com.ibm.team.filesystem.client.internal.operations.CheckinUploadData;
import com.ibm.team.filesystem.client.internal.operations.EncodingUploadFailure;
import com.ibm.team.filesystem.client.internal.operations.LineDelimiterUploadFailure;
import com.ibm.team.filesystem.client.internal.operations.NewCheckInOperation;
import com.ibm.team.filesystem.client.internal.operations.UploadFailure;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.util.LineDelimiterUtil;
import com.ibm.team.filesystem.common.util.LineDelimiterVerifier;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRLFInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToLFInputStream;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.ContentLineDelimiterError;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.content.AbstractUploadHandler;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.UnsupportedCharsetException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

public class CheckinUploadHandler
extends FileUploadHandler {
    private final IComponentHandle component;
    private final IWorkspaceConnection workspace;
    private final IVersionableHandle versionable;
    private final UUID itemId;
    private final IShareable shareable;
    private final ICopyFileArea cfa;
    private final CheckinUploadData uploadData;
    private boolean initialized;
    private IPath path;
    private IFileStorage file;
    private ContentHash predecessorHintHash;
    private String predecessorEncoding;
    private IContentProperties contentProperties;
    private boolean inferredLineDelimiter;
    private LineDelimiterVerifier delimiterVerifier;
    private FileLineDelimiter expectedLineDelimiter;
    private FileLineDelimiter propsLineDelimiter;
    private FileLineDelimiter foundLineDelimiter;
    private DigestComputingInputStream contents;
    private long size;
    private ContentHash hashcode;
    private LineDelimiterUploadFailure overrideLineDelimiter;
    private boolean forceConsistentDelimiters;
    private final CancellationMonitor cMon;
    private final AbstractVersionedContentManagerInputStreamProvider inProvider = new AbstractVersionedContentManagerInputStreamProvider(){

        public InputStream wrapInputStream(InputStream in) throws IOException, TeamRepositoryException {
            return CheckinUploadHandler.this.wrapInputStream(in);
        }

        public InputStream getInputStream(int flags) throws IOException, TeamRepositoryException {
            return CheckinUploadHandler.this.getInputStream(flags);
        }

        public void dispose() throws IOException, TeamRepositoryException {
        }
    };
    private EncodingUploadFailure overrideEncoding;
    private boolean atomicCommitRequired;

    public CheckinUploadHandler(ICopyFileArea cfa, NewCheckInOperation.ComponentCheckInRequest req, ILocalChange localChange, boolean atomicCommitRequired, CheckinUploadData uploadData, CancellationMonitor cMon) throws FileSystemClientException {
        this.cfa = cfa;
        this.shareable = localChange.getShareable();
        this.versionable = localChange.getTarget();
        this.itemId = this.versionable.getItemId();
        this.overrideLineDelimiter = null;
        this.component = req.getComponent();
        this.workspace = req.getWorkspace();
        this.atomicCommitRequired = atomicCommitRequired;
        this.uploadData = uploadData;
        this.cMon = cMon;
        this.initialized = false;
    }

    public IComponentHandle getComponent() {
        return this.component;
    }

    public IVersionableHandle getVersionable() {
        return this.versionable;
    }

    protected String getEncoding() throws TeamRepositoryException {
        this.init();
        return this.contentProperties.getEncoding();
    }

    protected String getContentType() throws TeamRepositoryException {
        this.init();
        return this.contentProperties.getMimeType();
    }

    protected FileLineDelimiter getLineDelimiter() throws TeamRepositoryException {
        this.init();
        return this.propsLineDelimiter;
    }

    public ContentHash getPredecessorHintHash() throws TeamRepositoryException {
        this.init();
        return this.predecessorHintHash;
    }

    public AbstractVersionedContentManagerInputStreamProvider getStreamProvider() throws TeamRepositoryException {
        return this.inProvider;
    }

    InputStream wrapInputStream(InputStream in) throws IOException, TeamRepositoryException {
        return in;
    }

    private void updateFields() {
        if (this.delimiterVerifier != null) {
            this.foundLineDelimiter = this.delimiterVerifier.getLineDelimiter();
            this.delimiterVerifier = null;
        }
        if (this.contents != null) {
            this.size = this.contents.getContentSize();
            this.hashcode = ContentHash.valueOf((byte[])this.contents.getFinalDigest());
            this.contents = null;
        }
    }

    InputStream getInputStream(int flags) throws IOException, TeamRepositoryException {
        this.init();
        try {
            InputStream in;
            SharingManager.getInstance().disableChangeMonitoring();
            try {
                in = this.file.getContents();
            }
            catch (FileSystemClientException e) {
                throw new TeamRepositoryException((Throwable)((Object)e));
            }
            if (this.propsLineDelimiter == FileLineDelimiter.LINE_DELIMITER_NONE) {
                this.delimiterVerifier = null;
                this.expectedLineDelimiter = this.propsLineDelimiter;
                if ((flags & 2) != 0 && this.contents != null) {
                    InputStream inputStream = in;
                    return inputStream;
                }
                DigestComputingInputStream digestComputingInputStream = this.contents = ContentHash.getDigestComputingStream((InputStream)in);
                return digestComputingInputStream;
            }
            this.expectedLineDelimiter = this.propsLineDelimiter == FileLineDelimiter.LINE_DELIMITER_PLATFORM ? FileLineDelimiter.getPlatformDelimiter() : this.propsLineDelimiter;
            if (this.forceConsistentDelimiters) {
                this.delimiterVerifier = LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)in, (String)this.contentProperties.getEncoding(), (FileLineDelimiter)this.expectedLineDelimiter);
            } else if (this.expectedLineDelimiter == FileLineDelimiter.LINE_DELIMITER_LF) {
                this.delimiterVerifier = new VerifyConvertToLFInputStream(in, this.contentProperties.getEncoding());
            } else if (this.expectedLineDelimiter == FileLineDelimiter.LINE_DELIMITER_CRLF) {
                this.delimiterVerifier = new VerifyConvertToCRLFInputStream(in, this.contentProperties.getEncoding());
            } else if (this.expectedLineDelimiter == FileLineDelimiter.LINE_DELIMITER_CR) {
                this.delimiterVerifier = new VerifyConvertToCRInputStream(in, this.contentProperties.getEncoding());
            } else {
                throw new IllegalStateException();
            }
            if ((flags & 2) != 0 && this.contents != null) {
                ReaderToInputStream readerToInputStream = new ReaderToInputStream((InputStreamReader)this.delimiterVerifier);
                return readerToInputStream;
            }
            DigestComputingInputStream digestComputingInputStream = this.contents = ContentHash.getDigestComputingStream((InputStream)new ReaderToInputStream((InputStreamReader)this.delimiterVerifier));
            return digestComputingInputStream;
        }
        finally {
            SharingManager.getInstance().enableChangeMonitoring();
        }
    }

    public void uploadCanceled() throws TeamRepositoryException {
        this.delimiterVerifier = null;
        this.contents = null;
    }

    public void uploadCompleted(IFileContent content) throws TeamRepositoryException {
        this.updateFields();
        boolean needsConversion = false;
        if (this.forceConsistentDelimiters) {
            needsConversion = true;
        } else if (this.foundLineDelimiter == null) {
            if (this.expectedLineDelimiter != FileLineDelimiter.LINE_DELIMITER_NONE) {
                throw new IllegalStateException();
            }
        } else if (this.foundLineDelimiter != this.expectedLineDelimiter && this.foundLineDelimiter != FileLineDelimiter.LINE_DELIMITER_NONE) {
            needsConversion = true;
        }
        Long uploadedSize = this.size;
        ContentHash uploadedHashCode = this.hashcode;
        String uploadedContentType = this.contentProperties != null ? this.contentProperties.getMimeType() : this.contentProperties.getMimeType();
        FileContent uploadedContent = (FileContent)content;
        this.uploadData.setUploadInfo(this, uploadedSize, uploadedHashCode, uploadedContent, uploadedContentType, this.shareable, needsConversion);
    }

    public void convert(Shed backupShed, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        block50: {
            if (!(this.forceConsistentDelimiters || this.foundLineDelimiter != null && this.foundLineDelimiter != this.expectedLineDelimiter && this.foundLineDelimiter != FileLineDelimiter.LINE_DELIMITER_NONE)) {
                throw new IllegalStateException();
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                SharingManager.getInstance().disableChangeMonitoring();
                boolean canWrite = true;
                if (this.file.isReadOnly((IProgressMonitor)progress.newChild(1))) {
                    canWrite = this.file.setWritable(true, (IProgressMonitor)progress.newChild(1));
                }
                if (canWrite) {
                    TemporaryOutputStream tmpOut = null;
                    InputStream fileIn = null;
                    InputStream tmpIn = null;
                    try {
                        try {
                            LineDelimiterVerifier conversionStream;
                            fileIn = this.file.getContents();
                            if (this.forceConsistentDelimiters) {
                                conversionStream = LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)fileIn, (String)this.contentProperties.getEncoding(), (FileLineDelimiter)this.expectedLineDelimiter);
                            } else if (this.expectedLineDelimiter == FileLineDelimiter.LINE_DELIMITER_LF) {
                                conversionStream = new VerifyConvertToLFInputStream(fileIn, this.contentProperties.getEncoding());
                            } else if (this.expectedLineDelimiter == FileLineDelimiter.LINE_DELIMITER_CRLF) {
                                conversionStream = new VerifyConvertToCRLFInputStream(fileIn, this.contentProperties.getEncoding());
                            } else if (this.expectedLineDelimiter == FileLineDelimiter.LINE_DELIMITER_CR) {
                                conversionStream = new VerifyConvertToCRInputStream(fileIn, this.contentProperties.getEncoding());
                            } else {
                                throw new IllegalStateException();
                            }
                            ReaderToInputStream in = new ReaderToInputStream((InputStreamReader)conversionStream);
                            SubMonitor subProgress = progress.newChild(50);
                            int work = 1000;
                            int worked = 0;
                            long total = this.size * 2L;
                            long transferred = 0L;
                            subProgress.setWorkRemaining(work);
                            byte[] buffer = new byte[4096];
                            tmpOut = TemporaryOutputStream.getTemporaryOutputStream((long)this.size);
                            int numbytes = in.read(buffer);
                            while (numbytes != -1) {
                                int newWorked = (int)((double)(transferred += (long)numbytes) / (double)total * (double)work);
                                subProgress.worked(newWorked - worked);
                                worked = newWorked;
                                tmpOut.write(buffer, 0, numbytes);
                                newWorked = (int)((double)(transferred += (long)numbytes) / (double)total * (double)work);
                                subProgress.worked(newWorked - worked);
                                worked = newWorked;
                                numbytes = in.read(buffer);
                            }
                            subProgress.done();
                            fileIn.close();
                            fileIn = null;
                            tmpOut.close();
                            tmpIn = tmpOut.getInputStream((IProgressMonitor)progress.newChild(24));
                            this.file.setContents(tmpIn, backupShed, (IProgressMonitor)progress.newChild(25));
                            tmpIn.close();
                            tmpIn = null;
                            tmpOut.dispose();
                            tmpOut = null;
                            this.uploadData.setConvertInfo(this.component, this.itemId, this.size, this.hashcode, this.file.getModificationStamp());
                        }
                        catch (FileSystemClientException e) {
                            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.NewCheckInOperation_9, (Object)this.path, (Object[])new Object[0]), (Throwable)((Object)e)));
                        }
                        catch (IOException e) {
                            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.NewCheckInOperation_10, (Object)this.path, (Object[])new Object[0]), (Throwable)e));
                        }
                    }
                    catch (Throwable throwable) {
                        if (fileIn != null) {
                            try {
                                fileIn.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (tmpIn != null) {
                            try {
                                tmpIn.close();
                            }
                            catch (IOException iOException) {}
                        }
                        if (tmpOut != null) {
                            try {
                                tmpOut.close();
                                tmpOut.dispose();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (fileIn != null) {
                        try {
                            fileIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (tmpIn != null) {
                        try {
                            tmpIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (tmpOut != null) {
                        try {
                            tmpOut.close();
                            tmpOut.dispose();
                        }
                        catch (IOException iOException) {}
                    }
                    break block50;
                }
                SubMonitor subProgress = progress.newChild(50);
                int work = 1000;
                int worked = 0;
                long total = this.size * 2L;
                long transferred = 0L;
                subProgress.setWorkRemaining(work);
                InputStream fileIn = null;
                try {
                    try {
                        fileIn = this.file.getContents();
                        DigestComputingInputStream hashCalculator = ContentHash.getDigestComputingStream((InputStream)fileIn);
                        byte[] buffer = new byte[4096];
                        int numbytes = hashCalculator.read(buffer);
                        while (numbytes != -1) {
                            int newWorked = (int)((double)(transferred += (long)numbytes) / (double)total * (double)work);
                            subProgress.worked(newWorked - worked);
                            worked = newWorked;
                            numbytes = hashCalculator.read(buffer);
                        }
                        this.size = hashCalculator.getContentSize();
                        this.hashcode = ContentHash.valueOf((byte[])hashCalculator.getFinalDigest());
                        this.uploadData.setConvertInfo(this.component, this.itemId, this.size, this.hashcode, this.file.getModificationStamp());
                        fileIn.close();
                        fileIn = null;
                    }
                    catch (IOException e) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CheckinUploadHandler_0, (Object)this.path, (Object[])new Object[0]), (Throwable)e));
                    }
                }
                catch (Throwable throwable) {
                    if (fileIn != null) {
                        try {
                            fileIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (fileIn != null) {
                    try {
                        fileIn.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
        }
    }

    public AbstractUploadHandler.UploadFailureDirection uploadFailed(Exception e, IProgressMonitor monitor) {
        this.delimiterVerifier = null;
        this.contents = null;
        try {
            SharingManager.getInstance().disableChangeMonitoring();
            Throwable rootCause = this.getRootCause(e);
            if (rootCause instanceof ContentLineDelimiterError) {
                if (this.inferredLineDelimiter) {
                    this.propsLineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
                    AbstractUploadHandler.UploadFailureDirection uploadFailureDirection = AbstractUploadHandler.UploadFailureDirection.RETRY;
                    return uploadFailureDirection;
                }
                this.overrideLineDelimiter = new LineDelimiterUploadFailure(this.shareable, this, this.propsLineDelimiter, rootCause);
                this.uploadData.lineDelimiterFailure(this.overrideLineDelimiter);
                AbstractUploadHandler.UploadFailureDirection uploadFailureDirection = AbstractUploadHandler.UploadFailureDirection.CONTINUE;
                return uploadFailureDirection;
            }
            if (rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException) {
                this.overrideEncoding = new EncodingUploadFailure(this.shareable, this.contentProperties.getEncoding(), this.predecessorEncoding, true, false, this, rootCause);
                this.uploadData.encodingUploadFailure(this.overrideEncoding);
                AbstractUploadHandler.UploadFailureDirection uploadFailureDirection = AbstractUploadHandler.UploadFailureDirection.CONTINUE;
                return uploadFailureDirection;
            }
            if (rootCause instanceof CharacterCodingException) {
                this.overrideEncoding = new EncodingUploadFailure(this.shareable, this.contentProperties.getEncoding(), this.predecessorEncoding, false, true, this, rootCause);
                this.uploadData.encodingUploadFailure(this.overrideEncoding);
                AbstractUploadHandler.UploadFailureDirection uploadFailureDirection = AbstractUploadHandler.UploadFailureDirection.CONTINUE;
                return uploadFailureDirection;
            }
            if (rootCause instanceof OperationCanceledException) {
                AbstractUploadHandler.UploadFailureDirection uploadFailureDirection = AbstractUploadHandler.UploadFailureDirection.FAIL;
                return uploadFailureDirection;
            }
            UploadFailure uploadFailure = new UploadFailure(this.shareable, this, e);
            this.uploadData.uploadFailure(uploadFailure);
            AbstractUploadHandler.UploadFailureDirection uploadFailureDirection = AbstractUploadHandler.UploadFailureDirection.CONTINUE;
            return uploadFailureDirection;
        }
        finally {
            SharingManager.getInstance().enableChangeMonitoring();
        }
    }

    private Throwable getRootCause(Throwable rootCause) {
        int paranoiaCount = 0;
        while (rootCause instanceof TeamRepositoryException && paranoiaCount < 50) {
            Throwable t = ((TeamRepositoryException)rootCause).getCause();
            if (t == null) break;
            rootCause = t;
            ++paranoiaCount;
        }
        return rootCause;
    }

    public void uploadStart() throws TeamRepositoryException {
    }

    private void init() throws TeamRepositoryException {
        if (!this.initialized) {
            try {
                try {
                    InverseFileItemInfo info;
                    SharingManager.getInstance().disableChangeMonitoring();
                    this.file = ((Shareable)this.shareable).getFileStorage();
                    Long modStamp = this.file.getModificationStamp();
                    this.uploadData.setModTime(this.component, this.itemId, modStamp);
                    this.contentProperties = SharingManager.getInstance().getContentExaminer().findStoredProperties(this.shareable, (IProgressMonitor)this.cMon);
                    if (this.contentProperties == null) {
                        throw new TeamRepositoryException(NLS.bind((String)Messages.NewCheckInOperation_16, (Object)this.file.getIDEPath(), (Object[])new Object[0]));
                    }
                    this.propsLineDelimiter = this.contentProperties.getLineDelimiter();
                    AbstractLock lock = CFALockUtil.lockExistingForRead(this.cfa.getRoot(), (IProgressMonitor)this.cMon);
                    try {
                        info = this.cfa.getItemInfo(this.versionable, this.component, (IContextHandle)this.workspace.getResolvedWorkspace());
                    }
                    finally {
                        CFALockUtil.endBatching(lock, (IProgressMonitor)this.cMon);
                    }
                    this.inferredLineDelimiter = info.getLineDelimiter() == null;
                    this.predecessorHintHash = info.getStoredHash();
                    this.predecessorEncoding = info.getStoredEncoding();
                    this.initialized = true;
                }
                catch (FileSystemClientException e) {
                    throw new TeamRepositoryException(NLS.bind((String)Messages.NewCheckInOperation_17, (Object)this.shareable.getLocalPath(), (Object[])new Object[0]), (Throwable)((Object)e));
                }
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
        }
        if (this.overrideLineDelimiter != null) {
            if (this.overrideLineDelimiter.isForceConsistentDelimiters()) {
                this.forceConsistentDelimiters = true;
            } else {
                this.propsLineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
                this.inferredLineDelimiter = false;
                this.forceConsistentDelimiters = false;
            }
            this.overrideLineDelimiter = null;
        }
        if (this.overrideEncoding != null) {
            if (this.overrideEncoding.isIgnoreEncoding()) {
                this.propsLineDelimiter = FileLineDelimiter.LINE_DELIMITER_NONE;
                this.inferredLineDelimiter = false;
                this.forceConsistentDelimiters = false;
            } else {
                this.contentProperties = new ContentProperties(this.overrideEncoding.getAlternativeEncoding(), this.contentProperties.getMimeType(), this.contentProperties.getLineDelimiter());
            }
            this.overrideEncoding = null;
        }
    }

    public boolean isAtomicCommitRequired() {
        return this.atomicCommitRequired;
    }
}

