/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Sandbox;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.ChangeHistoryChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.IFilesystemRefresher;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.internal.utils.RationalizingTree;
import com.ibm.team.filesystem.client.operations.ICheckinOperation;
import com.ibm.team.filesystem.client.operations.ICheckinOptions;
import com.ibm.team.filesystem.client.operations.IRefreshingOperation;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ChangeHistoryChangeSetsOperation
extends FileSystemOperation
implements IRefreshingOperation,
ICheckinOptions {
    private boolean refreshBeforeRun = false;
    private boolean nonAtomicCommitIsAnOption = true;
    private int nonAtomicCommitFileUploadLimit = 200;

    protected ChangeHistoryChangeSetsOperation(ChangeHistoryChangeSetsDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler);
    }

    @Override
    public final void setRefreshBeforeRun(boolean newValue) {
        this.refreshBeforeRun = newValue;
    }

    @Override
    public final boolean getRefreshBeforeRun() {
        return this.refreshBeforeRun;
    }

    protected abstract void refreshLocal(IFilesystemRefresher var1, Map<ISandbox, Set<ConfigurationDescriptor>> var2, IProgressMonitor var3) throws FileSystemClientException, TeamRepositoryException;

    protected void checkinPendingChanges(final Set<ConfigurationDescriptor> affectedConfigurations, final ChangeHistoryChangeSetsDilemmaHandler problemHandler, boolean locksAcquired, IProgressMonitor progress) throws TeamRepositoryException, FileSystemClientException {
        if (locksAcquired) {
            this.checkinPendingChanges(affectedConfigurations, problemHandler, progress);
        } else {
            IRunnableWithProgress runnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    ICopyFileAreaLockRequest lockRequest = ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(affectedConfigurations, true);
                    try {
                        ICopyFileAreasLock copyFileAreaLock = ICopyFileAreaManager.instance.lock(Collections.singleton(lockRequest), (IProgressMonitor)progress.newChild(1));
                        try {
                            ChangeHistoryChangeSetsOperation.this.checkinPendingChanges(affectedConfigurations, problemHandler, (IProgressMonitor)progress.newChild(98));
                        }
                        finally {
                            copyFileAreaLock.release((IProgressMonitor)progress.newChild(1));
                        }
                    }
                    catch (FileSystemClientException e) {
                        throw new InvocationTargetException((Throwable)((Object)e));
                    }
                    catch (TeamRepositoryException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.runWithinFileSystemLock(runnableWithProgress, Messages.ChangeHistoryChangeSetsOperation_1, progress);
        }
    }

    private void checkinPendingChanges(Set<ConfigurationDescriptor> affectedConfigurations, ChangeHistoryChangeSetsDilemmaHandler problemHandler, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        HashMap<ConfigurationDescriptor, List<ILocalChange>> checkin = new HashMap<ConfigurationDescriptor, List<ILocalChange>>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)150);
        Map<ISandbox, Set<ConfigurationDescriptor>> affectedAreas = this.getCopyFileAreasAffected(affectedConfigurations, (IProgressMonitor)monitor.newChild(1));
        if (this.getRefreshBeforeRun()) {
            monitor.setTaskName(Messages.ChangeHistoryChangeSetsOperation_REFRESHING_FILESYSTEM);
            Refresher refresher = new Refresher();
            this.refreshLocal(refresher, affectedAreas, (IProgressMonitor)monitor.newChild(10));
            List<IShareable> shareables = this.rationalizeRefreshTree(refresher.shareables);
            monitor.setWorkRemaining(110 + shareables.size() * 2);
            for (IShareable shareable : shareables) {
                ((Shareable)shareable).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(1));
            }
            LocalChangeManager.getInstance().refreshChanges(shareables, (IProgressMonitor)monitor.newChild(shareables.size()));
            SubMonitor syncMon = monitor.newChild(10);
            syncMon.setWorkRemaining(affectedAreas.size());
            for (Map.Entry<ISandbox, Set<ConfigurationDescriptor>> area : affectedAreas.entrySet()) {
                SubMonitor descMon = syncMon.newChild(1);
                descMon.setWorkRemaining(area.getValue().size());
                for (ConfigurationDescriptor desc : area.getValue()) {
                    LocalChangeManager.getInstance().syncPendingChanges(desc.connectionHandle, desc.componentHandle, area.getKey(), (IProgressMonitor)monitor);
                }
            }
        }
        monitor.setWorkRemaining(100);
        SubMonitor iterProgress = monitor.newChild(5).setWorkRemaining(affectedAreas.size());
        for (Map.Entry<ISandbox, Set<ConfigurationDescriptor>> entry : affectedAreas.entrySet()) {
            ISandbox sandbox = entry.getKey();
            Set<ConfigurationDescriptor> configurationsForCFA = entry.getValue();
            SubMonitor subIterProgress = iterProgress.newChild(1).setWorkRemaining(configurationsForCFA.size());
            for (ConfigurationDescriptor descriptor : configurationsForCFA) {
                ILocalChangeManager lcm = FileSystemCore.getSharingManager().getLocalChangeManager();
                lcm.syncPendingChanges(descriptor.connectionHandle, descriptor.componentHandle, sandbox, (IProgressMonitor)subIterProgress.newChild(1));
                ILocalChange[] localChanges = lcm.getPendingChanges(descriptor.connectionHandle, descriptor.componentHandle, sandbox);
                if (localChanges.length <= 0) continue;
                List<ILocalChange> changes = Arrays.asList(localChanges);
                changes = Collections.unmodifiableList(changes);
                checkin.put(descriptor, changes);
            }
        }
        if (!checkin.isEmpty()) {
            int result = problemHandler.uncheckedInChanges(Collections.unmodifiableMap(checkin));
            if (result == 0) {
                SubMonitor subProgress = monitor.newChild(10).setWorkRemaining(checkin.size() * 2);
                ICheckinOperation op = IOperationFactory.instance.getCheckinOperation(problemHandler.getCommitDilemmaHandler());
                if (this.nonAtomicCommitIsAnOption) {
                    op.enableNonAtomicCommit(this.nonAtomicCommitFileUploadLimit);
                } else {
                    op.disableNonAtomicCommit();
                }
                op.setRefreshBeforeRun(false);
                for (Map.Entry entry : checkin.entrySet()) {
                    Collection changesToCheckin = (Collection)entry.getValue();
                    ILocalChange[] changes = changesToCheckin.toArray(new ILocalChange[changesToCheckin.size()]);
                    if (changesToCheckin.isEmpty()) continue;
                    ConfigurationDescriptor descriptor = (ConfigurationDescriptor)entry.getKey();
                    op.requestCheckin((IWorkspaceConnection)descriptor.getConnection((IProgressMonitor)subProgress.newChild(1)), descriptor.componentHandle, changes, null, "", (IProgressMonitor)subProgress.newChild(1));
                }
                this.disableVerifyInSync(op);
                op.run((IProgressMonitor)monitor.newChild(84));
            } else {
                if (result == 1) {
                    throw new OperationCanceledException();
                }
                if (result != 3) {
                    throw new FileSystemClientException(new FileSystemStatus(4, Messages.ChangeHistoryChangeSetsOperation_0));
                }
            }
        }
        monitor.done();
    }

    private List<IShareable> rationalizeRefreshTree(List<IShareable> shareables) {
        HashMap<ISandbox, RationalizingTree<String, IShareable>> rationalized = new HashMap<ISandbox, RationalizingTree<String, IShareable>>();
        for (IShareable shareable : shareables) {
            RationalizingTree<String, IShareable> tree = (RationalizingTree<String, IShareable>)rationalized.get(shareable.getSandbox());
            if (tree == null) {
                tree = new RationalizingTree<String, IShareable>();
                rationalized.put(shareable.getSandbox(), tree);
            }
            tree.put(shareable.getLocalPath().segments(), shareable);
        }
        ArrayList<IShareable> toReturn = new ArrayList<IShareable>(shareables.size());
        for (RationalizingTree tree : rationalized.values()) {
            for (IShareable shareable : tree) {
                toReturn.add(shareable);
            }
        }
        return toReturn;
    }

    protected final Map<ISandbox, Set<ConfigurationDescriptor>> getCopyFileAreasAffected(Set<ConfigurationDescriptor> affectedConfigurations, IProgressMonitor progress) throws FileSystemClientException {
        HashMap<ISandbox, Set<ConfigurationDescriptor>> result = new HashMap<ISandbox, Set<ConfigurationDescriptor>>();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)affectedConfigurations.size());
        ICopyFileAreaManager copyFileAreaManager = ICopyFileAreaManager.instance;
        for (ConfigurationDescriptor configuration : affectedConfigurations) {
            Collection<ICopyFileArea> copyFileAreas = copyFileAreaManager.getCopyFileAreasForConfiguration(configuration, (IProgressMonitor)monitor.newChild(1));
            for (ICopyFileArea cfa : copyFileAreas) {
                Sandbox sandbox = new Sandbox(cfa);
                HashSet<ConfigurationDescriptor> configurations = (HashSet<ConfigurationDescriptor>)result.get(sandbox);
                if (configurations == null) {
                    configurations = new HashSet<ConfigurationDescriptor>();
                    result.put(sandbox, configurations);
                }
                configurations.add(configuration);
            }
        }
        return result;
    }

    @Override
    public void disableNonAtomicCommit() {
        this.nonAtomicCommitIsAnOption = false;
    }

    @Override
    public void enableNonAtomicCommit(int numberUploads) {
        this.nonAtomicCommitIsAnOption = true;
        this.nonAtomicCommitFileUploadLimit = numberUploads;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Refresher
    implements IFilesystemRefresher {
        private List<IShareable> shareables = new LinkedList<IShareable>();
        private Map<ISandbox, Map<UUID, Set<UUID>>> fullyRefreshedComponents = new HashMap<ISandbox, Map<UUID, Set<UUID>>>();

        private Refresher() {
        }

        @Override
        public void addToRefresh(IShareable toAdd) {
            this.shareables.add(toAdd);
        }

        @Override
        public void addToRefresh(Collection<IShareable> toAdd) {
            this.shareables.addAll(toAdd);
        }

        @Override
        public void addToRefresh(Collection<ISandbox> affectedAreas, IContextHandle contextHandle, IComponentHandle component, IProgressMonitor progress) throws FileSystemClientException {
            SubMonitor sbMon = SubMonitor.convert((IProgressMonitor)progress);
            sbMon.setWorkRemaining(affectedAreas.size());
            for (ISandbox sandbox : affectedAreas) {
                if (!this.shouldRefreshComponent(sandbox, contextHandle, component)) continue;
                IShare[] iShareArray = SharingManager.getInstance().allShares(sandbox.getRoot(), contextHandle, component, (IProgressMonitor)sbMon.newChild(1));
                int n = iShareArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IShare share = iShareArray[n2];
                    this.addToRefresh(share.getShareable());
                    ++n2;
                }
            }
        }

        private boolean shouldRefreshComponent(ISandbox sb, IContextHandle ctx, IComponentHandle comp) {
            Set<UUID> refreshedComponents;
            Map<UUID, Set<UUID>> refreshedContexts = this.fullyRefreshedComponents.get(sb);
            if (refreshedContexts == null) {
                refreshedContexts = new HashMap<UUID, Set<UUID>>();
                this.fullyRefreshedComponents.put(sb, refreshedContexts);
            }
            if ((refreshedComponents = refreshedContexts.get(ctx.getItemId())) == null) {
                refreshedComponents = new HashSet<UUID>();
                refreshedContexts.put(ctx.getItemId(), refreshedComponents);
            }
            return refreshedComponents.add(comp.getItemId());
        }
    }
}

