/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaLockRequest;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangeFilePropertiesOperation;
import com.ibm.team.filesystem.client.operations.IChangePropertiesRequest;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.util.LineDelimiterUtil;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRLFInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToLFInputStream;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.ContentLineDelimiterError;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnmappableCharacterException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeFilePropertiesOperation
extends FileSystemOperation
implements IChangeFilePropertiesOperation {
    private ChangePropertiesDilemmaHandler dilemmaHandler;
    private HashMap<IPath, ChangePropertiesRequest> changeProperties;
    private Shed shed;
    private boolean reportedSupportedCharSets;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter;

    public ChangeFilePropertiesOperation(ChangePropertiesDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? ChangePropertiesDilemmaHandler.getDefault() : dilemmaHandler);
        this.dilemmaHandler = dilemmaHandler == null ? ChangePropertiesDilemmaHandler.getDefault() : dilemmaHandler;
        this.shed = new Shed(this.dilemmaHandler.getBackupDilemmaHandler());
        this.changeProperties = new HashMap();
        this.reportedSupportedCharSets = false;
    }

    @Override
    public void setLineDelimiter(IShareable shareableFile, FileLineDelimiter lineDelimiter) {
        if (shareableFile == null) {
            throw new IllegalArgumentException();
        }
        if (lineDelimiter == null) {
            throw new IllegalArgumentException();
        }
        IPath path = shareableFile.getLocalPath();
        ChangePropertiesRequest existingRequest = this.changeProperties.get(path);
        if (existingRequest == null) {
            this.changeProperties.put(path, new ChangePropertiesRequest((Shareable)shareableFile, lineDelimiter));
        } else {
            existingRequest.lineDelimiter = lineDelimiter;
        }
    }

    @Override
    public void setContentType(IShareable shareableFile, String contentType) {
        if (shareableFile == null) {
            throw new IllegalArgumentException();
        }
        if (contentType == null) {
            throw new IllegalArgumentException();
        }
        IPath path = shareableFile.getLocalPath();
        ChangePropertiesRequest existingRequest = this.changeProperties.get(path);
        if (existingRequest == null) {
            this.changeProperties.put(path, new ChangePropertiesRequest((Shareable)shareableFile, contentType));
        } else {
            existingRequest.contentType = contentType;
        }
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (this.changeProperties.isEmpty()) {
            return;
        }
        this.verifyShares((IProgressMonitor)progress.newChild(10));
        final ArrayList<IShareable> shareables = new ArrayList<IShareable>();
        ISchedulingRule workspaceRule = this.getAffectedElements(shareables);
        IRunnableWithProgress workspaceOp = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 + 8 * ChangeFilePropertiesOperation.this.changeProperties.size()));
                ICopyFileAreaManager.ICopyFileAreaLockRequestFactory factory = ICopyFileAreaManager.instance.lockRequestFactory();
                ICopyFileAreaLockRequest lockToObtain = factory.getLockRequest(shareables);
                try {
                    ICopyFileAreasLock copyFileAreaRule = ICopyFileAreaManager.instance.lock(Collections.singleton(lockToObtain), (IProgressMonitor)subMonitor.newChild(1));
                    try {
                        ChangeFilePropertiesOperation.this.updateProperties((IProgressMonitor)subMonitor.newChild(8 * ChangeFilePropertiesOperation.this.changeProperties.size()));
                    }
                    finally {
                        copyFileAreaRule.release((IProgressMonitor)subMonitor.newChild(1));
                    }
                }
                catch (FileSystemClientException e) {
                    throw new InvocationTargetException((Throwable)((Object)e));
                }
            }
        };
        this.runWithinFileSystemLock(workspaceOp, "Change Properties", workspaceRule, monitor);
    }

    private ISchedulingRule getAffectedElements(List<IShareable> shareables) {
        for (ChangePropertiesRequest request : this.changeProperties.values()) {
            shareables.add(request.shareableFile);
        }
        return SharingManager.getInstance().makeSchedulingRuleForIDE(shareables, ISharingManager.RuleKind.MODIFY);
    }

    private void verifyShares(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        if (!this.verifyInSyncEnabled() || this.dilemmaHandler.willIgnoreAllSharesOutOfSync()) {
            monitor.done();
            return;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.changeProperties.size() * 3));
        HashMap<ConnectionDescriptor, ConnectionDescriptor> resolvedDescriptors = new HashMap<ConnectionDescriptor, ConnectionDescriptor>();
        IVerifyInSyncOperation verifyOp = IOperationFactory.instance.getVerifyInSyncOperation(this.dilemmaHandler);
        for (ChangePropertiesRequest request : this.changeProperties.values()) {
            IShare share = request.shareableFile.getShare((IProgressMonitor)progress.newChild(1));
            if (share == null) continue;
            ISharingDescriptor sharingDescriptor = share.getSharingDescriptor();
            ConnectionDescriptor descriptor = new ConnectionDescriptor(sharingDescriptor.getRepositoryId(), sharingDescriptor.getRepositoryUri(), sharingDescriptor.getConnectionHandle());
            ConnectionDescriptor resolvedDescriptor = (ConnectionDescriptor)resolvedDescriptors.get(descriptor);
            if (resolvedDescriptor == null) {
                resolvedDescriptor = descriptor;
                resolvedDescriptors.put(resolvedDescriptor, resolvedDescriptor);
            }
            verifyOp.addToVerify(descriptor.getConnection((IProgressMonitor)progress.newChild(1)), share);
        }
        progress.setWorkRemaining(1);
        verifyOp.run((IProgressMonitor)progress.newChild(1));
    }

    private void updateProperties(IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.changeProperties.size() * 2 + 11));
        ArrayList<IChangePropertiesRequest> inconsistentDelimiters = new ArrayList<IChangePropertiesRequest>();
        for (ChangePropertiesRequest request : this.changeProperties.values()) {
            this.checkCancelled((IProgressMonitor)progress);
            ResourceType type = request.getShareableToChange().getResourceType((IProgressMonitor)progress.newChild(1));
            if (type == null) {
                this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_11, (Object)request.getShareableToChange().getFullPath().toString(), (Object[])new Object[0]), null));
                continue;
            }
            if (type != ResourceType.FILE) {
                this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_12, (Object)request.getShareableToChange().getFullPath().toString(), (Object[])new Object[]{type.name()}), null));
                continue;
            }
            if (request.getShareableToChange().getShare((IProgressMonitor)progress.newChild(1)) == null) {
                this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_9, (Object)request.getShareableToChange().getFullPath().toString(), (Object[])new Object[0]), null));
                break;
            }
            this.convert(request, inconsistentDelimiters, (IProgressMonitor)progress.newChild(1));
        }
        if (!inconsistentDelimiters.isEmpty()) {
            int result = this.dilemmaHandler.inconsistentLineDelimiters(Collections.unmodifiableList(inconsistentDelimiters), (IProgressMonitor)progress.newChild(1));
            if (result == 0) {
                progress.setWorkRemaining(inconsistentDelimiters.size());
                for (IChangePropertiesRequest request : inconsistentDelimiters) {
                    if (!request.isChangeLineDelimiterRequest() || !request.isForceLineDelimiterChange()) continue;
                    this.convert((ChangePropertiesRequest)request, null, (IProgressMonitor)progress.newChild(1));
                }
            } else if (result != 1) {
                IStatus[] reportedInconsistencies = new IStatus[inconsistentDelimiters.size()];
                int i = 0;
                for (IChangePropertiesRequest request : inconsistentDelimiters) {
                    reportedInconsistencies[i] = new FileSystemStatus(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_2, (Object)request.getShareableToChange().getLocalPath(), (Object[])new Object[0]));
                    ++i;
                }
                MultiStatus status = new MultiStatus("com.ibm.team.filesystem.client", 2, reportedInconsistencies, Messages.ChangeFilePropertiesOperation_3, null);
                this.handleErrors(new IStatus[]{status});
            } else {
                throw new OperationCanceledException();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void convert(ChangePropertiesRequest request, ArrayList<IChangePropertiesRequest> inconsistentDelimiters, IProgressMonitor monitor) {
        block43: {
            block47: {
                block45: {
                    block46: {
                        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
                        try {
                            copyFileArea = ICopyFileAreaManager.instance.getExistingCopyFileArea(ChangePropertiesRequest.access$2(request).getSandbox().getRoot());
                            oldInfo = copyFileArea.getItemInfo(ChangePropertiesRequest.access$2(request).getLocalPath());
                            progress.setTaskName(NLS.bind((String)Messages.ChangeFilePropertiesOperation_0, (Object)ChangePropertiesRequest.access$2(request).getLocalPath().toPortableString(), (Object[])new Object[0]));
                            if (oldInfo == null) {
                                this.collectStatus(new FileSystemStatus(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_1, (Object)ChangePropertiesRequest.access$2(request).getLocalPath().toString(), (Object[])new Object[0])));
                                break block43;
                            }
                            lineDelimiter = request.isChangeLineDelimiterRequest() != false ? ChangePropertiesRequest.access$3(request) : oldInfo.getLineDelimiter();
                            contentType = request.isChangeContentTypeRequest() != false ? ChangePropertiesRequest.access$4(request) : oldInfo.getContentType();
                            newInfo = new FileItemInfoProxy(oldInfo);
                            newInfo.changeProperties(oldInfo.isContentChanged(), oldInfo.getLastContentChangeCheckStamp(), lineDelimiter, contentType, oldInfo.isExecutable());
                            copyFileArea.setItemMetaData(ChangePropertiesRequest.access$2(request).getLocalPath(), newInfo.getFileItemInfo(), (IProgressMonitor)progress.newChild(1));
                            if (!request.isChangeLineDelimiterRequest() || lineDelimiter == FileLineDelimiter.LINE_DELIMITER_NONE) break block43;
                            convertingStream = null;
                            inputStream = null;
                            file = ChangePropertiesRequest.access$2(request).getFileStorage();
                            contentSet = false;
                            try {
                                encoding = SharingManager.getInstance().getContentExaminer().getEncoding(ChangePropertiesRequest.access$2(request), (IProgressMonitor)progress.newChild(1));
                                if (request.isForceLineDelimiterChange()) {
                                    convertingStream = new ReaderToInputStream((InputStreamReader)LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)file.getContents(), (String)encoding, (FileLineDelimiter)lineDelimiter));
                                } else {
                                    block8 : switch (ChangeFilePropertiesOperation.$SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter()[lineDelimiter.ordinal()]) {
                                        case 2: {
                                            convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(file.getContents(), encoding));
                                            break;
                                        }
                                        case 4: {
                                            convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(file.getContents(), encoding));
                                            break;
                                        }
                                        case 3: {
                                            convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(file.getContents(), encoding));
                                            break;
                                        }
                                        case 5: {
                                            switch (ChangeFilePropertiesOperation.$SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter()[FileLineDelimiter.getPlatformDelimiter().ordinal()]) {
                                                case 4: {
                                                    convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(file.getContents(), encoding));
                                                    break block8;
                                                }
                                                case 2: {
                                                    convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(file.getContents(), encoding));
                                                    break block8;
                                                }
                                                case 3: {
                                                    convertingStream = new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(file.getContents(), encoding));
                                                    break block8;
                                                }
                                            }
                                            throw new IllegalStateException();
                                        }
                                        default: {
                                            throw new IllegalStateException();
                                        }
                                    }
                                }
                                provider = TemporaryOutputStream.createLocalBuffer((InputStream)convertingStream, (IProgressMonitor)progress.newChild(2));
                                try {
                                    inputStream = provider.getInputStream((IProgressMonitor)progress.newChild(1));
                                    try {
                                        file.setContents(inputStream, this.shed, (IProgressMonitor)progress.newChild(2));
                                        contentSet = true;
                                    }
                                    finally {
                                        inputStream.close();
                                    }
                                }
                                finally {
                                    provider.dispose();
                                }
                            }
                            catch (Throwable var18_29) {
                                try {
                                    if (convertingStream != null) {
                                        convertingStream.close();
                                    }
                                }
                                catch (IOException v0) {}
                                try {
                                    if (inputStream != null) {
                                        inputStream.close();
                                    }
                                }
                                catch (IOException v1) {}
                                if (!contentSet) {
                                    copyFileArea.setItemMetaData(ChangePropertiesRequest.access$2(request).getLocalPath(), oldInfo, (IProgressMonitor)progress.newChild(1));
                                }
                                throw var18_29;
                            }
                            try {
                                if (convertingStream != null) {
                                    convertingStream.close();
                                }
                            }
                            catch (IOException v2) {}
                            try {
                                if (inputStream != null) {
                                    inputStream.close();
                                }
                            }
                            catch (IOException v3) {}
                            if (!contentSet) {
                                copyFileArea.setItemMetaData(ChangePropertiesRequest.access$2(request).getLocalPath(), oldInfo, (IProgressMonitor)progress.newChild(1));
                            }
                            break block43;
                        }
                        catch (ContentLineDelimiterError v4) {
                            inconsistentDelimiters.add(request);
                            break block43;
                        }
                        catch (FileSystemClientException e) {
                            status = FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_8, (Object)ChangePropertiesRequest.access$2(request).getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e);
                            this.collectStatus(status);
                            break block43;
                        }
                        catch (TeamRepositoryException e) {
                            status = FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_8, (Object)ChangePropertiesRequest.access$2(request).getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e);
                            this.collectStatus(status);
                            break block43;
                        }
                        catch (UnsupportedCharsetException e) {
                            status = FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_4, (Object)ChangePropertiesRequest.access$2(request).getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e);
                            this.collectStatus(status);
                            break block43;
                        }
                        catch (IOException e) {
                            if (!(e instanceof UnsupportedEncodingException)) break block45;
                            if (this.reportedSupportedCharSets) break block46;
                            charSetsAvailable = new StringBuffer();
                            ** for (charsetName : Charset.availableCharsets().keySet())
                        }
lbl-1000:
                        // 1 sources

                        {
                            charSetsAvailable.append(charsetName).append(' ');
                            continue;
                        }
lbl113:
                        // 1 sources

                        infoStatus = new Status(1, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.ChangeFilePropertiesOperation_10, (Object)charSetsAvailable.toString(), (Object[])new Object[0]));
                        this.collectStatus((IStatus)infoStatus);
                        this.reportedSupportedCharSets = true;
                    }
                    status = FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_5, (Object)ChangePropertiesRequest.access$2(request).getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e);
                    break block47;
                }
                status = e instanceof CharacterCodingException != false || e instanceof UnmappableCharacterException != false ? FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_6, (Object)ChangePropertiesRequest.access$2(request).getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e) : FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.ChangeFilePropertiesOperation_7, (Object)ChangePropertiesRequest.access$2(request).getLocalPath().toString(), (Object[])new Object[0]), (Throwable)e);
            }
            this.collectStatus(status);
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter() {
        if ($SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter != null) {
            return $SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter;
        }
        int[] nArray = new int[FileLineDelimiter.values().length];
        try {
            nArray[FileLineDelimiter.LINE_DELIMITER_CR.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileLineDelimiter.LINE_DELIMITER_CRLF.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileLineDelimiter.LINE_DELIMITER_LF.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileLineDelimiter.LINE_DELIMITER_NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FileLineDelimiter.LINE_DELIMITER_PLATFORM.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$ibm$team$filesystem$common$FileLineDelimiter = nArray;
        return nArray;
    }

    private class ChangePropertiesRequest
    implements IChangePropertiesRequest {
        private final Shareable shareableFile;
        private FileLineDelimiter lineDelimiter;
        private String contentType;
        private boolean forceLineDelimiterConversion;

        public ChangePropertiesRequest(Shareable shareableFile, FileLineDelimiter lineDelimiter) {
            this.shareableFile = shareableFile;
            this.lineDelimiter = lineDelimiter;
            this.forceLineDelimiterConversion = false;
        }

        public ChangePropertiesRequest(Shareable shareableFile, String contentType) {
            this.shareableFile = shareableFile;
            this.contentType = contentType;
            this.forceLineDelimiterConversion = false;
        }

        public IShareable getShareableToChange() {
            return this.shareableFile;
        }

        public FileLineDelimiter getLineDelimiter(IProgressMonitor progress) throws FileSystemClientException {
            if (this.isChangeLineDelimiterRequest()) {
                return this.lineDelimiter;
            }
            return this.shareableFile.getLineDelimiter(progress);
        }

        public String getContentType(IProgressMonitor monitor) throws FileSystemClientException {
            if (this.isChangeContentTypeRequest()) {
                return this.contentType;
            }
            return this.shareableFile.getContentType(monitor);
        }

        public boolean isChangeLineDelimiterRequest() {
            return this.lineDelimiter != null;
        }

        public boolean isChangeContentTypeRequest() {
            return this.contentType != null;
        }

        public void setForceLineDelimiterConversion(boolean forceConversion) {
            if (!this.isChangeLineDelimiterRequest()) {
                throw new IllegalStateException();
            }
            this.forceLineDelimiterConversion = forceConversion;
        }

        public boolean isForceLineDelimiterChange() {
            return this.forceLineDelimiterConversion;
        }

        static /* synthetic */ FileLineDelimiter access$3(ChangePropertiesRequest changePropertiesRequest) {
            return changePropertiesRequest.lineDelimiter;
        }

        static /* synthetic */ String access$4(ChangePropertiesRequest changePropertiesRequest) {
            return changePropertiesRequest.contentType;
        }
    }
}

