/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.operations.LockDilemmaHandler;
import com.ibm.team.filesystem.client.operations.LockEntry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.LockOperationFailureException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLockOperation
extends FileSystemOperation {
    private Map<ITeamRepository, List<LockEntry>> repoBatch = new HashMap<ITeamRepository, List<LockEntry>>();

    public AbstractLockOperation(LockDilemmaHandler dilemmaHandler) {
        super(dilemmaHandler == null ? new LockDilemmaHandler() : dilemmaHandler);
    }

    protected LockEntry add(IWorkspaceConnection workspaceConnection, IComponentHandle componentHandle, IVersionableHandle versionableHandle, IContributorHandle contributorHandle) {
        LockEntry lockEntry = new LockEntry(workspaceConnection, componentHandle, versionableHandle, contributorHandle);
        this.addLockEntry(lockEntry);
        return lockEntry;
    }

    protected void addLockEntry(LockEntry lockEntry) {
        ITeamRepository repo = lockEntry.getRepository();
        List<LockEntry> list = this.repoBatch.get(repo);
        if (list == null) {
            list = new ArrayList<LockEntry>();
            this.repoBatch.put(repo, list);
        }
        list.add(lockEntry);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void execute(IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        sub = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.repoBatch.size() * 2));
        for (Map.Entry<ITeamRepository, List<LockEntry>> entry : this.repoBatch.entrySet()) {
            lockEntries = entry.getValue();
            workspaceManager = SCMPlatform.getWorkspaceManager((ITeamRepository)entry.getKey());
            child = sub.newChild(1);
            child.setTaskName(Messages.AbstractLockOperation_0);
            lockOperations = this.getLockOperations(workspaceManager, lockEntries, (IProgressMonitor)child);
            child = sub.newChild(1);
            child.setTaskName(Messages.AbstractLockOperation_1);
            try {
                workspaceManager.applyLockOperations(lockOperations, (IProgressMonitor)child);
                continue;
            }
            catch (LockOperationFailureException e) {
                strings = e.getMessage().split("\r\n|\r|\n");
                if (strings.length == 1) {
                    throw e;
                }
                errors = new IStatus[strings.length];
                i = 0;
                ** while (i < strings.length)
            }
lbl-1000:
            // 1 sources

            {
                errors[i] = new FileSystemStatus(strings[i]);
                ++i;
                continue;
            }
lbl23:
            // 1 sources

            status = new MultiStatus("com.ibm.team.filesystem.client", 4, errors, "Lock operation failed", null);
            throw new FileSystemClientException((IStatus)status);
        }
    }

    private List<IWorkspaceManager.IVersionableLockOperation> getLockOperations(IWorkspaceManager workspaceManager, List<LockEntry> lockEntries, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)lockEntries.size());
        IWorkspaceManager.IVersionableLockOperationFactory lockOperationFactory = workspaceManager.lockOperationFactory();
        ArrayList<IWorkspaceManager.IVersionableLockOperation> lockOperations = new ArrayList<IWorkspaceManager.IVersionableLockOperation>();
        for (LockEntry lockEntry : lockEntries) {
            IWorkspaceConnection connection;
            IWorkspaceManager.IVersionableLockOperation op = this.getLockOperation(lockOperationFactory, lockEntry, connection = workspaceManager.getWorkspaceConnection(lockEntry.getStream(), (IProgressMonitor)sub.newChild(1)));
            if (op == null) continue;
            lockOperations.add(op);
        }
        return lockOperations;
    }

    protected Map<ITeamRepository, List<LockEntry>> getRepositoryBatch() {
        return this.repoBatch;
    }

    protected abstract IWorkspaceManager.IVersionableLockOperation getLockOperation(IWorkspaceManager.IVersionableLockOperationFactory var1, LockEntry var2, IWorkspaceConnection var3);

    protected int checkLockOwners() {
        HashMap<ITeamRepository, List<LockEntry>> lockOwnerNotLoggedIn = new HashMap<ITeamRepository, List<LockEntry>>();
        for (Map.Entry<ITeamRepository, List<LockEntry>> entry : this.getRepositoryBatch().entrySet()) {
            ITeamRepository repo = entry.getKey();
            for (LockEntry lockEntry : entry.getValue()) {
                IContributorHandle owner = lockEntry.getContributor();
                if (owner != null && owner.sameItemId((IItemHandle)repo.loggedInContributor())) continue;
                ArrayList<LockEntry> list = (ArrayList<LockEntry>)lockOwnerNotLoggedIn.get(repo);
                if (list == null) {
                    list = new ArrayList<LockEntry>();
                    lockOwnerNotLoggedIn.put(repo, list);
                }
                list.add(lockEntry);
            }
        }
        LockDilemmaHandler handler = (LockDilemmaHandler)this.getDilemmaHandler();
        int result = !lockOwnerNotLoggedIn.isEmpty() ? handler.currentUserDoesntOwnLock(lockOwnerNotLoggedIn) : 3;
        return result;
    }
}

