/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.namespace.impl;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.era.DeliveryInfo;
import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.era.EraSyncReport;
import com.ibm.team.filesystem.client.internal.namespace.WorkspaceNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.AbstractConfigurationContext;
import com.ibm.team.filesystem.client.internal.namespace.impl.BaselineContext;
import com.ibm.team.filesystem.client.internal.namespace.impl.ContextNameUtil;
import com.ibm.team.filesystem.client.util.ConnectionUtil;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IEvent;
import com.ibm.team.repository.client.util.IListener;
import com.ibm.team.repository.client.util.PropertyChangeEvent;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.ChangeListenerList;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.repository.rcp.common.NullUtil;
import com.ibm.team.repository.rcp.common.collection.SetDiff;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IChangeHistory;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.events.IChangeHistoryEvent;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.ComponentNotInWorkspaceException;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.internal.util.FetchProfile;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.ItemLists;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WorkspaceContext
extends AbstractConfigurationContext {
    private IWorkspaceConnection workspace;
    private IWorkspace workspaceSharedItem;
    private IComponentHandle component;
    private EraDescriptor lastSnapshot = null;
    private boolean lastSnapshotDirty;
    private ISyncTime lastSyncTime;
    private ChangeListenerList historyListeners = new ChangeListenerList();
    private boolean allocated = false;
    private static final String[] eventsToListenTo = new String[]{"com.ibm.team.scm.Commit", "com.ibm.team.scm.ChangeHistoryEvent.Deliver", "com.ibm.team.scm.ChangeHistoryEvent.AcceptChangeSets", "com.ibm.team.scm.ChangeHistoryEvent.AcceptCombined", "com.ibm.team.scm.ChangeHistoryEvent.CreateChangeSet", "com.ibm.team.scm.ChangeHistoryEvent.DiscardChangeSet", "components", "bases"};
    private static final String[] workspaceManagerEventsToListTo = new String[]{"suspended"};
    public static boolean TRACE_CONTEXT;
    public static boolean TRACE_INCOMING_EVENTS;
    public static boolean TRACE_LISTENERS;
    private IListener workspaceListener = new IListener(){

        public void handleEvents(List events) {
            for (IEvent event : events) {
                if (!(event instanceof IChangeHistoryEvent) && !(event instanceof PropertyChangeEvent)) continue;
                if (TRACE_INCOMING_EVENTS) {
                    WorkspaceContext.this.trace("Workspace event recieved");
                }
                WorkspaceContext.this.updateWorkspaceJob.schedule();
            }
        }
    };
    private Object changeSetsMutex = new Object();
    private Set oldAfterStates = Collections.EMPTY_SET;
    private Set<IChangeSet> knownActiveChangeSets = Collections.EMPTY_SET;
    private Job updateWorkspaceJob = new Job(Messages.WorkspaceContext_3){

        protected IStatus run(IProgressMonitor monitor) {
            try {
                WorkspaceContext.this.update(false, monitor);
            }
            catch (TeamRepositoryException e) {
                LoggingHelper.error("com.ibm.team.filesystem.client", Messages.WorkspaceContext_2, e);
            }
            return Status.OK_STATUS;
        }
    };
    private IConfiguration configuration;
    private String name;
    private ISharedItemChangeListener changeSetListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            for (Object next : events) {
                ISharedItemChangeEvent event = (ISharedItemChangeEvent)next;
                if (event.getBeforeState() == null) continue;
                if (TRACE_INCOMING_EVENTS) {
                    WorkspaceContext.this.trace("Change set event recieved");
                }
                WorkspaceContext.this.updateWorkspaceJob.schedule();
            }
        }
    };
    private ISharedItemChangeListener workspaceSharedItemChangeListener = new ISharedItemChangeListener(){

        public void itemsChanged(List events) {
            for (Object next : events) {
                ISharedItemChangeEvent sharedEvent = (ISharedItemChangeEvent)next;
                if (TRACE_INCOMING_EVENTS) {
                    WorkspaceContext.this.trace("Workspace shared item event recieved");
                }
                WorkspaceContext.this.updateWorkspaceJob.schedule();
            }
        }
    };
    private ISyncTime lastConfigurationTime;

    static {
        TRACE_INCOMING_EVENTS = TRACE_CONTEXT = false;
        TRACE_LISTENERS = TRACE_CONTEXT;
    }

    public WorkspaceContext(IWorkspaceConnection workspace, IComponent component) {
        this(workspace, (ItemId<IComponent>)ItemId.forItem((IItem)component), ContextNameUtil.getContextName(workspace, component));
    }

    protected void trace(String string) {
        if (TRACE_CONTEXT) {
            System.out.println("[WorkspaceContext " + this.getName() + "]: " + string);
        }
    }

    public WorkspaceContext(IWorkspaceConnection workspace, ItemId<IComponent> componentId, String name) {
        super(WorkspaceNamespace.create(workspace.teamRepository(), (ItemId<IWorkspace>)ItemId.forItem((IItem)workspace.getResolvedWorkspace()), componentId));
        this.workspace = workspace;
        this.component = (IComponentHandle)componentId.toHandle();
        this.updateWorkspaceJob.setUser(false);
        this.name = name;
        this.configuration = null;
        this.workspaceSharedItem = workspace.getResolvedWorkspace();
        Assert.isTrue((boolean)ClientRepositoryUtil.isSharedItem(workspace.teamRepository(), (IItem)this.workspaceSharedItem));
    }

    @Override
    public IConnection getConnection() {
        return this.workspace;
    }

    public WorkspaceNamespace getWorkspaceNamespace() {
        return (WorkspaceNamespace)this.getNamespace();
    }

    public IWorkspaceConnection getWorkspace() {
        return this.workspace;
    }

    @Override
    public ItemId<IComponent> getComponent() {
        return new ItemId((IItemHandle)this.component);
    }

    public static WorkspaceContext create(IWorkspaceConnection workspace, ItemId<IComponent> componentId, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IComponent component = null;
        try {
            component = (IComponent)RepoFetcher.fetchCurrent((ITeamRepository)workspace.teamRepository(), componentId, (IProgressMonitor)progress.newChild(100));
        }
        catch (ItemNotFoundException itemNotFoundException) {}
        return new WorkspaceContext(workspace, componentId, ContextNameUtil.getContextName(workspace, component));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (!this.allocated) {
            return;
        }
        ISyncTime configTime = this.getConfigurationTime();
        ISyncTime changeHistoryTime = this.getChangeHistoryTime();
        EraDescriptor oldSnapshot = null;
        WorkspaceContext workspaceContext = this;
        synchronized (workspaceContext) {
            this.lastSnapshotDirty = true;
            if (this.compareTimes(changeHistoryTime, this.lastSyncTime) && this.compareTimes(configTime, this.lastConfigurationTime)) {
                return;
            }
            oldSnapshot = this.lastSnapshot;
        }
        EraDescriptor newSnapshot = this.getCurrentEraDescriptor(refresh, (IProgressMonitor)progress.newChild(48));
        if (NullUtil.equals((Object)oldSnapshot, (Object)newSnapshot)) {
            return;
        }
        if (newSnapshot != null && oldSnapshot != null && !this.stateCacheEmpty()) {
            EraDescriptor oldPrevious;
            EraDescriptor newPrevious = newSnapshot.getPreviousEra(null);
            if (NullUtil.equals((Object)newPrevious, (Object)(oldPrevious = oldSnapshot.getPreviousEra(null)))) {
                EraSyncReport syncReport = oldSnapshot.compare(newSnapshot, (IProgressMonitor)progress.newChild(10));
                Set<StateId<IVersionable>> discardedStates = syncReport.getOutgoing().getAfterStates(this.getRepository(), (IProgressMonitor)progress.newChild(10));
                HashSet<ItemId<IVersionable>> discardedItems = new HashSet<ItemId<IVersionable>>();
                for (StateId<IVersionable> nextState : discardedStates) {
                    discardedItems.add((ItemId<IVersionable>)nextState.getItemId());
                }
                this.discardStates(discardedItems);
                Set<StateId<IVersionable>> changedStates = syncReport.getIncoming().getAfterStates(this.getRepository(), (IProgressMonitor)progress.newChild(10));
                this.updateStates(changedStates);
            } else {
                this.flushStateCache();
            }
        } else {
            this.flushStateCache();
        }
        this.updateActiveChangeSets((IProgressMonitor)progress.newChild(10));
        this.historyListeners.notifyListeners((Object)this, PROP_HISTORY);
    }

    private ISyncTime getConfigurationTime() throws ComponentNotInWorkspaceException {
        try {
            return this.workspace.getComponentInfo(this.component).configurationTime();
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            return null;
        }
    }

    private ISyncTime getChangeHistoryTime() throws ComponentNotInWorkspaceException {
        try {
            return this.workspace.getComponentInfo(this.component).changeHistoryTime();
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set updateActiveChangeSets(IProgressMonitor monitor) throws TeamRepositoryException {
        SetDiff changedStates;
        Object next2;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List<ItemId<IChangeSet>> activeChangeSetIds = this.getActiveChangeSets();
        Collection activeChangeSets = RepoFetcher.fetchCurrents((ITeamRepository)this.getRepository(), activeChangeSetIds, (IProgressMonitor)progress.newChild(50)).values();
        HashSet<StateId> afterStates = new HashSet<StateId>();
        for (Object next2 : activeChangeSets) {
            if (next2 == null) continue;
            for (IChange change : next2.changes()) {
                afterStates.add(ChangeSetUtil.getAfterState((IChange)change));
            }
        }
        next2 = this.changeSetsMutex;
        synchronized (next2) {
            SetDiff changedChangeSets;
            changedStates = SetDiff.computeDiff((Collection)this.oldAfterStates, afterStates);
            this.oldAfterStates = afterStates;
            if (this.allocated && !(changedChangeSets = SetDiff.computeDiff(this.knownActiveChangeSets, activeChangeSets)).isEmpty()) {
                IChangeSet next3;
                for (Object removal : changedChangeSets.getRemovals()) {
                    next3 = (IChangeSet)removal;
                    if (next3 == null) continue;
                    this.getRepository().itemManager().removeItemChangeListener((IItem)next3, this.changeSetListener);
                }
                for (Object addition : changedChangeSets.getAdditions()) {
                    next3 = (IChangeSet)addition;
                    if (next3 == null) continue;
                    this.getRepository().itemManager().addItemChangeListener((IItem)next3, this.changeSetListener);
                }
                this.knownActiveChangeSets = new HashSet<IChangeSet>();
                this.knownActiveChangeSets.addAll(activeChangeSets);
            }
        }
        HashSet changedItemIds = new HashSet();
        changedItemIds.addAll(ItemLists.statesToIds((Collection)changedStates.getAdditions()));
        return changedItemIds;
    }

    public List<ItemId<IChangeSet>> getActiveChangeSets() throws TeamRepositoryException {
        try {
            if (ConnectionUtil.hasComponent(this.workspace, (ItemId<IComponent>)new ItemId((IItemHandle)this.component))) {
                return ItemLists.handlesToIds((Collection)this.workspace.activeChangeSets(this.component));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {}
        return new ArrayList<ItemId<IChangeSet>>();
    }

    @Override
    public IConfiguration getConfiguration() {
        if (this.configuration == null) {
            try {
                if (ConnectionUtil.hasComponent(this.workspace, (ItemId<IComponent>)new ItemId((IItemHandle)this.component))) {
                    this.configuration = this.workspace.configuration(this.component);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            }
            catch (TeamRepositoryException e) {
                throw new RuntimeException(e);
            }
        }
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAllocation() {
        boolean shouldAllocate = false;
        ChangeListenerList changeListenerList = this.historyListeners;
        synchronized (changeListenerList) {
            if (!this.historyListeners.isEmpty()) {
                shouldAllocate = true;
            }
            if (shouldAllocate != this.allocated) {
                if (shouldAllocate) {
                    this.allocate();
                } else {
                    this.deallocate();
                }
                this.allocated = shouldAllocate;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocate() {
        if (TRACE_LISTENERS) {
            this.trace("Allocated");
        }
        int i = 0;
        while (i < eventsToListenTo.length) {
            String next = eventsToListenTo[i];
            this.workspace.addGenericListener((Object)next, this.workspaceListener);
            ++i;
        }
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository());
        int i2 = 0;
        while (i2 < workspaceManagerEventsToListTo.length) {
            String next = workspaceManagerEventsToListTo[i2];
            wm.addGenericListener((Object)next, this.workspaceListener);
            ++i2;
        }
        this.getRepository().itemManager().addItemChangeListener((IItem)this.workspaceSharedItem, this.workspaceSharedItemChangeListener);
        Object object = this.changeSetsMutex;
        synchronized (object) {
            for (IChangeSet knownChangeSet : this.knownActiveChangeSets) {
                this.getRepository().itemManager().addItemChangeListener((IItem)knownChangeSet, this.changeSetListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deallocate() {
        if (TRACE_LISTENERS) {
            this.trace("Deallocated");
        }
        int i = 0;
        while (i < eventsToListenTo.length) {
            String next = eventsToListenTo[i];
            this.workspace.removeGenericListener((Object)next, this.workspaceListener);
            ++i;
        }
        IWorkspaceManager wm = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getRepository());
        int i2 = 0;
        while (i2 < workspaceManagerEventsToListTo.length) {
            String next = workspaceManagerEventsToListTo[i2];
            wm.removeGenericListener((Object)next, this.workspaceListener);
            ++i2;
        }
        this.getRepository().itemManager().removeItemChangeListener((IItem)this.workspaceSharedItem, this.workspaceSharedItemChangeListener);
        Object object = this.changeSetsMutex;
        synchronized (object) {
            for (IChangeSet knownChangeSet : this.knownActiveChangeSets) {
                this.getRepository().itemManager().removeItemChangeListener((IItem)knownChangeSet, this.changeSetListener);
            }
        }
        this.lastSnapshotDirty = true;
    }

    public <T extends IItem> Map<ItemId<T>, T> fetchCurrents(List<ItemId<T>> itemIds, FetchProfile profile, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        Map<ItemId<T>, T> currents = super.fetchCurrents(itemIds, profile, refresh, monitor);
        return currents;
    }

    @Override
    public <T extends IItem> Map<ItemId<T>, StateId<T>> getStates(Collection<ItemId<T>> itemIds, boolean shouldRefresh, IProgressMonitor rep) throws TeamRepositoryException {
        Map<ItemId<T>, StateId<T>> result = super.getStates(itemIds, shouldRefresh, rep);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EraDescriptor getCurrentEraDescriptor(boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean dirty;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        EraDescriptor last = null;
        WorkspaceContext workspaceContext = this;
        synchronized (workspaceContext) {
            last = this.lastSnapshot;
            dirty = refresh || this.lastSnapshotDirty;
        }
        ISyncTime syncTimeStart = null;
        ISyncTime configurationTime = null;
        if (last == null || dirty) {
            try {
                ISyncTime configurationTimeEnd;
                ISyncTime syncTimeEnd;
                do {
                    syncTimeStart = this.workspace.getComponentInfo(this.component).changeHistoryTime();
                    configurationTime = this.workspace.getComponentInfo(this.component).configurationTime();
                    last = EraDescriptor.createLiveHistory(this.getWorkspaceNamespace(), refresh, (IProgressMonitor)progress.newChild(60));
                    syncTimeEnd = this.workspace.getComponentInfo(this.component).changeHistoryTime();
                    configurationTimeEnd = this.workspace.getComponentInfo(this.component).configurationTime();
                } while (!this.compareTimes(syncTimeStart, syncTimeEnd) || !this.compareTimes(configurationTime, configurationTimeEnd));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                last = EraDescriptor.createEmptyEra(this.workspace.teamRepository(), (ItemId<IComponent>)ItemUtil.getComponent((IComponentHandle)this.component));
            }
            catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
                last = EraDescriptor.createEmptyEra(this.workspace.teamRepository(), (ItemId<IComponent>)ItemUtil.getComponent((IComponentHandle)this.component));
            }
        }
        if (last == null) {
            last = EraDescriptor.createEmptyEra(this.workspace.teamRepository(), (ItemId<IComponent>)ItemUtil.getComponent((IComponentHandle)this.component));
        }
        this.publishSnapshot(syncTimeStart, configurationTime, last, (IProgressMonitor)progress.newChild(40));
        return last;
    }

    private boolean compareTimes(ISyncTime syncTimeStart, ISyncTime syncTimeEnd) {
        if (syncTimeStart == null || syncTimeEnd == null) {
            return syncTimeStart == syncTimeEnd;
        }
        return syncTimeStart.toString().equals(syncTimeEnd.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishSnapshot(ISyncTime syncTime, ISyncTime configurationTime, EraDescriptor last, IProgressMonitor monitor) throws TeamRepositoryException {
        boolean dirty = false;
        WorkspaceContext workspaceContext = this;
        synchronized (workspaceContext) {
            if (!NullUtil.equals((Object)this.lastSnapshot, (Object)last)) {
                this.lastSnapshot = last;
                this.lastSnapshotDirty = false;
                this.lastConfigurationTime = configurationTime;
                this.lastSyncTime = syncTime;
                dirty = true;
            }
        }
        if (dirty) {
            this.updateActiveChangeSets(monitor);
            this.historyListeners.notifyListeners((Object)this, PROP_HISTORY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(IProgressMonitor monitor) throws TeamRepositoryException {
        super.refresh(monitor);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.flushStateCache();
        try {
            this.workspace.refresh((IProgressMonitor)progress.newChild(20));
        }
        catch (ItemNotFoundException itemNotFoundException) {}
        WorkspaceContext workspaceContext = this;
        synchronized (workspaceContext) {
            this.lastSnapshotDirty = true;
        }
        this.update(true, (IProgressMonitor)progress.newChild(80));
    }

    @Override
    public void addHistoryListener(IChangeListener toAdd) {
        if (TRACE_LISTENERS) {
            this.trace("History listener added");
        }
        this.historyListeners.add(toAdd);
        this.updateAllocation();
    }

    @Override
    public void removeHistoryListener(IChangeListener toRemove) {
        if (TRACE_LISTENERS) {
            this.trace("History listener removed");
        }
        this.historyListeners.remove(toRemove);
        this.updateAllocation();
    }

    @Override
    public EraDescriptor getChangeSets(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getCurrentEraDescriptor(false, monitor);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isLive() {
        return true;
    }

    @Override
    public List<ItemId<IChangeSet>> getBlame(StateId<IFileItem> fileItemHandle, ItemId<IChangeSet> changeSetHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        IFileSystemView fsview = FileSystemCore.getFileSystemManager(this.workspace.teamRepository()).getFileSystemView((IConnection)this.workspace);
        return ItemLists.handlesToIds((Collection)fsview.getBlame(this.component, (IFileItemHandle)fileItemHandle.toHandle(), (IChangeSetHandle)changeSetHandle.toHandle(), monitor));
    }

    public ItemId<IChangeSet> createChangeSet(String optionalComment, boolean makeCurrent, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemId.create((IItemHandle)this.workspace.createChangeSet(this.component, optionalComment, makeCurrent, monitor));
    }

    public void close(List<ItemId<IChangeSet>> changeSetList, IProgressMonitor monitor) throws TeamRepositoryException {
        this.workspace.ensureClosed((Collection)ItemLists.idsToHandles(changeSetList), monitor);
    }

    public void close(ItemId<IChangeSet> changeSet, IProgressMonitor monitor) throws TeamRepositoryException {
        this.close(Collections.singletonList(changeSet), monitor);
    }

    public BaselineContext createBaseline(String name, String comment, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.createBaseline(Collections.EMPTY_LIST, name, comment, monitor);
    }

    public BaselineContext createBaseline(List<ItemId<IChangeSet>> changeSetsToExclude, String name, String comment, IProgressMonitor monitor) throws TeamRepositoryException {
        IBaselineConnection connection = this.workspace.createBaseline(this.component, name, comment, monitor);
        return new BaselineContext(connection);
    }

    public ItemId<IComponent> getComponentId() {
        return this.getWorkspaceNamespace().getComponentId();
    }

    public Collection<ItemId<IChangeSet>> getSuspended() throws TeamRepositoryException {
        return ItemLists.handlesToIds((Collection)this.getWorkspace().suspendedChangeSets());
    }

    public List<ItemId<IChangeSet>> filterChangeSetsInHistory(List<ItemId<IChangeSet>> changeSets, IProgressMonitor newChild) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)newChild, (int)changeSets.size());
        ArrayList filtered = NewCollection.arrayList();
        for (ItemId<IChangeSet> next : changeSets) {
            if (this.getWorkspace().hasChangeSets(Collections.singletonList(next.toHandle()), (IProgressMonitor)progress.newChild(1))) continue;
            filtered.add(next);
        }
        return filtered;
    }

    public void ensureActiveChangeSet(IProgressMonitor monitor) throws TeamRepositoryException {
        IChangeSet changeSet;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ItemId<IChangeSet> changeSetId = this.getCurrentChangeSet();
        try {
            changeSet = (IChangeSet)RepoFetcher.fetchCurrent((ITeamRepository)this.getRepository(), changeSetId, (boolean)true, (IProgressMonitor)progress.newChild(10));
        }
        catch (ItemNotFoundException itemNotFoundException) {
            changeSet = null;
        }
        if (changeSet != null && changeSet.isActive()) {
            return;
        }
        this.workspace.refresh((IProgressMonitor)progress.newChild(20));
        List<ItemId<IChangeSet>> activeChanges = this.getActiveChangeSets();
        if (activeChanges.isEmpty()) {
            ItemId<IChangeSet> newChangeSet = this.createChangeSet("", true, (IProgressMonitor)progress.newChild(70));
        } else {
            ItemId<IChangeSet> newChangeSet = activeChanges.iterator().next();
            this.setCurrentChangeSet(newChangeSet, (IProgressMonitor)progress.newChild(70));
        }
    }

    public void setCurrentChangeSet(ItemId<IChangeSet> changeSet, IProgressMonitor monitor) throws TeamRepositoryException {
        this.workspace.setCurrentChangeSet((IChangeSetHandle)changeSet.toHandle(), monitor);
    }

    public ItemId<IChangeSet> getCurrentChangeSet() {
        return ChangeSetUtil.getChangeSet((IChangeSetHandle)this.workspace.getCurrentChangeSet(this.component));
    }

    public IComponentHandle getComponentHandle() {
        return this.component;
    }

    @Override
    public List<DeliveryInfo> findChangeSetsAffecting(ItemId<?> item, int maxResults, IProgressMonitor monitor) throws TeamRepositoryException {
        IChangeHistory changeHistory;
        try {
            changeHistory = this.workspace.changeHistory(this.component);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.emptyList();
        }
        catch (ItemNotFoundException itemNotFoundException) {
            return Collections.emptyList();
        }
        catch (ComponentNotInWorkspaceException componentNotInWorkspaceException) {
            return Collections.emptyList();
        }
        return EraDescriptor.getDeliveryInfo(changeHistory, item, maxResults, monitor);
    }

    public void discard(Collection<ItemId<IChangeSet>> toDiscard, IProgressMonitor monitor) throws TeamRepositoryException {
        this.workspace.discardChangeSets(false, (Collection)ItemLists.idsToHandles(toDiscard), monitor);
    }
}

