/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.namespace.impl;

import com.ibm.team.filesystem.client.internal.namespace.IItemContext;
import com.ibm.team.filesystem.client.internal.namespace.impl.IItemStateSelector;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.rcp.common.IChangeListener;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ItemListenerMap
implements IItemStateSelector {
    private Map mapItemIdOntoListenerStruct = Collections.synchronizedMap(new HashMap());

    public void addStates(List newStates) {
        for (StateId next : newStates) {
            this.addState(next);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addState(StateId newState) {
        ListenerStruct listenerStruct;
        Map map = this.mapItemIdOntoListenerStruct;
        synchronized (map) {
            listenerStruct = (ListenerStruct)this.mapItemIdOntoListenerStruct.get(newState.getItemId());
        }
        if (listenerStruct != null) {
            listenerStruct.setState(newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch(Collection toTouch) {
        Map map = this.mapItemIdOntoListenerStruct;
        synchronized (map) {
            for (StateId next : toTouch) {
                this.touch(next);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch(StateId itemId) {
        Map map = this.mapItemIdOntoListenerStruct;
        synchronized (map) {
            ListenerStruct listenerStruct = (ListenerStruct)this.mapItemIdOntoListenerStruct.get(itemId);
            if (listenerStruct != null) {
                listenerStruct.touch(itemId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addListener(ItemId itemId, IChangeListener listener) {
        Map map = this.mapItemIdOntoListenerStruct;
        synchronized (map) {
            ListenerStruct listenerStruct = (ListenerStruct)this.mapItemIdOntoListenerStruct.get(itemId);
            if (listenerStruct == null) {
                listenerStruct = new ListenerStruct();
                this.mapItemIdOntoListenerStruct.put(itemId, listenerStruct);
            }
            return listenerStruct.addListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(ItemId itemId, IChangeListener listener) {
        Map map = this.mapItemIdOntoListenerStruct;
        synchronized (map) {
            ListenerStruct listenerStruct = (ListenerStruct)this.mapItemIdOntoListenerStruct.get(itemId);
            if (listenerStruct != null) {
                return listenerStruct.removeListener(listener);
            }
            return false;
        }
    }

    public Object getMutex() {
        return this.mapItemIdOntoListenerStruct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListener(ItemId handle) {
        Map map = this.mapItemIdOntoListenerStruct;
        synchronized (map) {
            return this.mapItemIdOntoListenerStruct.containsKey(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map map = this.mapItemIdOntoListenerStruct;
        synchronized (map) {
            return this.mapItemIdOntoListenerStruct.isEmpty();
        }
    }

    public Set getItemsBeingObserved() {
        return this.mapItemIdOntoListenerStruct.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID resolveState(ItemId statelessHandle) {
        Map map = this.mapItemIdOntoListenerStruct;
        synchronized (map) {
            ListenerStruct listenerStruct;
            block4: {
                listenerStruct = (ListenerStruct)this.mapItemIdOntoListenerStruct.get(statelessHandle);
                if (listenerStruct != null) break block4;
                return null;
            }
            return listenerStruct.stateId;
        }
    }

    private final class ListenerStruct {
        public UUID stateId;
        public Object listeners;
        public boolean isDirty = true;

        private ListenerStruct() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addListener(IChangeListener listener) {
            Map map = ItemListenerMap.this.mapItemIdOntoListenerStruct;
            synchronized (map) {
                block12: {
                    Collection listenerList;
                    block13: {
                        block10: {
                            IChangeListener last;
                            block11: {
                                block9: {
                                    if (this.listeners != null) break block9;
                                    this.listeners = listener;
                                    return true;
                                }
                                if (!(this.listeners instanceof IChangeListener)) break block10;
                                last = (IChangeListener)this.listeners;
                                if (!last.equals(listener)) break block11;
                                return false;
                            }
                            ArrayList<IChangeListener> listenerList2 = new ArrayList<IChangeListener>();
                            listenerList2.add(last);
                            listenerList2.add(listener);
                            this.listeners = listenerList2;
                            return true;
                        }
                        if (!(this.listeners instanceof Collection)) break block12;
                        listenerList = (Collection)this.listeners;
                        if (!listenerList.contains(listener)) break block13;
                        return false;
                    }
                    listenerList.add(listener);
                    if (listenerList instanceof List && listenerList.size() > 16) {
                        HashSet listenerSet = new HashSet();
                        listenerSet.addAll(listenerList);
                        this.listeners = listenerSet;
                    }
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeListener(IChangeListener listener) {
            Map map = ItemListenerMap.this.mapItemIdOntoListenerStruct;
            synchronized (map) {
                block8: {
                    block7: {
                        if (this.listeners != null) break block7;
                        return false;
                    }
                    if (this.listeners != listener) break block8;
                    this.listeners = null;
                    return true;
                }
                if (this.listeners instanceof Collection) {
                    Collection listenerList = (Collection)this.listeners;
                    boolean result = listenerList.remove(listener);
                    if (listenerList.isEmpty()) {
                        listenerList = null;
                    }
                    return result;
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void touch(StateId reportedState) {
            Map map = ItemListenerMap.this.mapItemIdOntoListenerStruct;
            synchronized (map) {
                this.isDirty = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(StateId newState) {
            IChangeListener[] listenerArray;
            Map map = ItemListenerMap.this.mapItemIdOntoListenerStruct;
            synchronized (map) {
                if (this.stateId != null && newState.getStateUUID().equals((Object)this.stateId)) {
                    return;
                }
                this.stateId = newState.getStateUUID();
                if (this.isDirty) {
                    return;
                }
                this.isDirty = true;
                if (this.listeners == null) {
                    return;
                }
                if (this.listeners instanceof IChangeListener) {
                    listenerArray = new IChangeListener[]{(IChangeListener)this.listeners};
                } else if (this.listeners instanceof Collection) {
                    Collection listenerList = (Collection)this.listeners;
                    listenerArray = listenerList.toArray(new IChangeListener[listenerList.size()]);
                } else {
                    return;
                }
            }
            ItemId itemId = newState.getItemId();
            int i = 0;
            while (i < listenerArray.length) {
                IChangeListener next = listenerArray[i];
                next.changed((Object)itemId, IItemContext.PROP_STATE_ID);
                ++i;
            }
        }
    }
}

