/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.namespace.impl;

import com.ibm.team.filesystem.client.internal.ClientRepositoryUtil;
import com.ibm.team.filesystem.client.internal.era.DeliveryInfo;
import com.ibm.team.filesystem.client.internal.era.EraDescriptor;
import com.ibm.team.filesystem.client.internal.namespace.ItemLocator;
import com.ibm.team.filesystem.client.internal.namespace.ItemNamespace;
import com.ibm.team.filesystem.client.internal.namespace.RepositoryNamespace;
import com.ibm.team.filesystem.client.internal.namespace.impl.DescriptionRecord;
import com.ibm.team.filesystem.client.internal.namespace.impl.MruCache;
import com.ibm.team.filesystem.client.internal.namespace.impl.ParentComputer;
import com.ibm.team.filesystem.common.internal.util.ChangeSetUtil;
import com.ibm.team.filesystem.common.internal.util.ItemUtil;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.collection.CollectionUtil;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.client.internal.RepoFetcher;
import com.ibm.team.scm.common.IChange;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.internal.util.ItemId;
import com.ibm.team.scm.common.internal.util.NewCollection;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EraCache {
    private static final int PREFETCH_SIZE = 64;
    private MruCache mapEraOntoDeliveryList = new MruCache();
    private MruCache<ItemLocator<IChangeSet>, IChangeSet> mapHandlesOntoChangeSets = new MruCache();
    private MruCache mapChangeSetStatesOntoChangeSets = new MruCache();
    private MruCache<EraDescriptor, List<IChangeSet>> mapErasOntoChangeSetList = new MruCache();
    private MruCache<EraDescriptor, ParentComputer> configurationCache = new MruCache();
    private MruCache<ItemId<IChangeSet>, DescriptionRecord> mapChangeSetStatesOntoDescriptions = new MruCache();
    private Object changeSetMutex = new Object();
    private static EraCache cache;

    public static EraCache getDefault() {
        if (cache == null) {
            cache = new EraCache();
        }
        return cache;
    }

    public void enableFlushes(boolean enabled) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParentComputer fetchParentComputer(EraDescriptor descriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository repo = descriptor.getRepository();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Object object = this.changeSetMutex;
        synchronized (object) {
            ParentComputer parents = this.configurationCache.get(descriptor);
            if (parents != null) {
                return parents;
            }
        }
        List<IChangeSet> changeSets = this.fetchChangeSets(descriptor, (IProgressMonitor)progress.newChild(50));
        HashMap changedVersionables = NewCollection.hashMap();
        for (IChangeSet next : changeSets) {
            List changes = next.changes();
            for (IChange nextChange : changes) {
                StateId stateId = ChangeSetUtil.getAfterState((IChange)nextChange);
                changedVersionables.put(stateId.getItemId(), stateId);
            }
        }
        Map fetchedVersionables = RepoFetcher.fetchItems((ITeamRepository)repo, changedVersionables.values(), (IProgressMonitor)progress.newChild(50));
        HashMap mapItemsOntoParents = NewCollection.hashMap();
        HashMap mapParentsOntoChildren = NewCollection.hashMap();
        HashMap mapItemsOntoNames = NewCollection.hashMap();
        for (Map.Entry next : fetchedVersionables.entrySet()) {
            IVersionable versionable = (IVersionable)next.getValue();
            ItemId parent = ItemUtil.getParent((IVersionable)versionable);
            ItemId child = ItemId.forItem((IItem)versionable);
            String name = versionable.getName();
            mapItemsOntoParents.put(child, parent);
            mapItemsOntoNames.put(child, name);
            CollectionUtil.addToMapOfLists((Map)mapParentsOntoChildren, (Object)parent, (Object)child);
        }
        ParentComputer result = new ParentComputer(mapItemsOntoParents, mapParentsOntoChildren, mapItemsOntoNames);
        Object object2 = this.changeSetMutex;
        synchronized (object2) {
            this.configurationCache.put(descriptor, result);
        }
        return result;
    }

    public IChangeSet fetchChangeSet(EraDescriptor descriptor, int index, boolean sharedItem, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetchChangeSet(descriptor, index, 64, sharedItem, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DescriptionRecord fetchDescriptionRecord(EraDescriptor descriptor, int index, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        IChangeSet changeSet = this.fetchChangeSet(descriptor, index, false, (IProgressMonitor)progress.newChild(15));
        if (changeSet == null) {
            return DescriptionRecord.DELETED_DESCRIPTION;
        }
        ItemId state = ItemId.create((IItemHandle)changeSet);
        Object object = this.changeSetMutex;
        synchronized (object) {
            DescriptionRecord description = this.mapChangeSetStatesOntoDescriptions.get((ItemId<IChangeSet>)state);
            if (description != null) {
                return description;
            }
        }
        ITeamRepository repo = descriptor.getRepository();
        HashMap changeSets = NewCollection.hashMap();
        int current = index;
        while (current < index + 64) {
            progress.setWorkRemaining(20);
            IChangeSet next = this.fetchChangeSet(descriptor, current, false, (IProgressMonitor)progress.newChild(1));
            if (next == null) break;
            changeSets.put(new ItemId((IItemHandle)next), next);
            ++current;
        }
        progress.setWorkRemaining(100);
        Map<ItemId<IChangeSet>, DescriptionRecord> descriptions = EraCache.fetchDescriptions(repo, changeSets.values(), (IProgressMonitor)progress.newChild(100));
        DescriptionRecord result = descriptions.get(state);
        Object object2 = this.changeSetMutex;
        synchronized (object2) {
            this.mapChangeSetStatesOntoDescriptions.putAll(descriptions);
        }
        return result == null ? new DescriptionRecord(changeSet, null) : result;
    }

    public static Map<ItemId<IChangeSet>, DescriptionRecord> fetchDescriptions(ITeamRepository repo, Collection<IChangeSet> changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (changeSets.isEmpty()) {
            return Collections.emptyMap();
        }
        IWorkspaceManager manager = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
        List summaries = manager.getChangeSetLinkSummary(changeSets, (IProgressMonitor)progress.newChild(90));
        HashMap result = NewCollection.hashMap();
        HashMap mapIdsOntoChangeSets = NewCollection.hashMap();
        for (IChangeSet next : changeSets) {
            mapIdsOntoChangeSets.put(ItemId.forItem((IItem)next), next);
        }
        progress.setWorkRemaining(summaries.size());
        for (IChangeSet next : summaries) {
            next.getSummary();
            ItemId nextId = ItemId.create((IItemHandle)next.getChangeSet());
            IChangeSet cs = (IChangeSet)mapIdsOntoChangeSets.get(nextId);
            DescriptionRecord nextRec = new DescriptionRecord(cs, (IChangeSetLinkSummary)next);
            result.put(nextId, nextRec);
        }
        return result;
    }

    public String fetchChangeSetDescription(EraDescriptor descriptor, int index, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetchDescriptionRecord(descriptor, index, monitor).getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IChangeSet fetchChangeSet(EraDescriptor era, int absoluteIndex, int prefetchSize, boolean sharedItem, IProgressMonitor monitor) throws TeamRepositoryException {
        int relativeIndex = absoluteIndex;
        EraDescriptor descriptor = era;
        Object object = this.changeSetMutex;
        synchronized (object) {
            ItemId<IChangeSet> handle;
            Map<ItemId<IChangeSet>, StateId<IChangeSet>> activeStates;
            int fetchIdx;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            List<DeliveryInfo> changeSetList = this.fetchDeliveries(descriptor, (IProgressMonitor)progress.newChild(20));
            while (true) {
                if (relativeIndex < changeSetList.size()) {
                    progress.setWorkRemaining(100);
                    fetchIdx = changeSetList.size() - 1 - relativeIndex;
                    if (fetchIdx >= 0) break;
                    return null;
                }
                relativeIndex -= changeSetList.size();
                progress.setWorkRemaining(100);
                descriptor = descriptor.getPreviousEra((IProgressMonitor)progress.newChild(10));
                if (descriptor == null) {
                    return null;
                }
                changeSetList = this.fetchDeliveries(descriptor, (IProgressMonitor)progress.newChild(10));
            }
            List<ItemId<IChangeSet>> changeSets = DeliveryInfo.getChangeSetList(changeSetList);
            if (!sharedItem && (activeStates = descriptor.getActiveChangeSetStates()).containsKey(handle = changeSets.get(fetchIdx))) {
                return this.fetchChangeSetFromState(descriptor.getRepository(), activeStates, handle, (IProgressMonitor)progress.newChild(100));
            }
            return this.fetchChangeSetFromList(descriptor.getRepository(), changeSets, relativeIndex, prefetchSize, (IProgressMonitor)progress.newChild(100));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IChangeSet> fetchChangeSets(EraDescriptor descriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Object object = this.changeSetMutex;
        synchronized (object) {
            List<IChangeSet> result = this.mapErasOntoChangeSetList.get(descriptor);
            if (result != null) {
                return result;
            }
        }
        Map<ItemId<IChangeSet>, StateId<IChangeSet>> activeStates = descriptor.getActiveChangeSetStates();
        ITeamRepository repo = descriptor.getRepository();
        IItemManager mgr = repo.itemManager();
        List<DeliveryInfo> deliveries = this.fetchDeliveries(descriptor, (IProgressMonitor)progress.newChild(40));
        List<ItemId<IChangeSet>> changeSetIds = DeliveryInfo.getChangeSetList(deliveries);
        HashMap fetched = NewCollection.hashMap();
        HashSet inactiveToFetch = NewCollection.hashSet();
        HashSet activeToFetch = NewCollection.hashSet();
        Object object2 = this.changeSetMutex;
        synchronized (object2) {
            for (ItemId<IChangeSet> itemId : changeSetIds) {
                StateId<IChangeSet> nextChangeSetState = activeStates.get(itemId);
                if (nextChangeSetState != null) {
                    IChangeSet fixedState = (IChangeSet)this.mapChangeSetStatesOntoChangeSets.get(nextChangeSetState);
                    if (fixedState != null) {
                        fetched.put(itemId, fixedState);
                        continue;
                    }
                    activeToFetch.add(nextChangeSetState);
                    continue;
                }
                inactiveToFetch.add(itemId);
            }
        }
        Map inactiveChangeSets = RepoFetcher.fetchCurrents((ITeamRepository)repo, (Collection)inactiveToFetch, (IProgressMonitor)progress.newChild(40));
        for (Map.Entry entry : inactiveChangeSets.entrySet()) {
            fetched.put((ItemId)entry.getKey(), (IChangeSet)mgr.getImmutableState((IItem)entry.getValue()));
        }
        Map map = RepoFetcher.fetchItems((ITeamRepository)repo, (Collection)activeToFetch, (IProgressMonitor)progress.newChild(20));
        Object object3 = this.changeSetMutex;
        synchronized (object3) {
            for (Map.Entry next : map.entrySet()) {
                ItemId nextId = ((StateId)next.getKey()).getItemId();
                fetched.put(nextId, (IChangeSet)next.getValue());
                this.mapChangeSetStatesOntoChangeSets.put(nextId, next.getValue());
            }
            List result = CollectionUtil.reorderValues((Map)fetched, changeSetIds);
            this.mapErasOntoChangeSetList.put(descriptor, result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DeliveryInfo> fetchDeliveries(EraDescriptor descriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        Object object = this.changeSetMutex;
        synchronized (object) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            List<DeliveryInfo> changeSetList = (List<DeliveryInfo>)this.mapEraOntoDeliveryList.get(descriptor);
            if (changeSetList == null) {
                changeSetList = descriptor.getDeliveries((IProgressMonitor)progress.newChild(100));
            }
            this.mapEraOntoDeliveryList.put(descriptor, changeSetList);
            return changeSetList;
        }
    }

    private IChangeSet fetchChangeSetFromState(ITeamRepository repository, Map<ItemId<IChangeSet>, StateId<IChangeSet>> activeStates, ItemId<IChangeSet> handle, IProgressMonitor monitor) throws TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IChangeSet changeSet = (IChangeSet)this.mapChangeSetStatesOntoChangeSets.get(handle);
        if (changeSet != null) {
            return changeSet;
        }
        ArrayList itemStatesToFetch = NewCollection.arrayList();
        itemStatesToFetch.addAll(activeStates.values());
        Map changeSets = RepoFetcher.fetchItems((ITeamRepository)repository, (Collection)itemStatesToFetch, (IProgressMonitor)progress.newChild(100));
        this.mapChangeSetStatesOntoChangeSets.putAll(changeSets);
        StateId<IChangeSet> desiredState = activeStates.get(handle);
        return (IChangeSet)changeSets.get(desiredState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IChangeSet fetchChangeSetFromList(ITeamRepository repo, List<ItemId<IChangeSet>> changeSetList, int index, int prefetchSize, IProgressMonitor monitor) throws TeamRepositoryException {
        Object object = this.changeSetMutex;
        synchronized (object) {
            int fetchIdx;
            SubMonitor progress;
            block6: {
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                fetchIdx = changeSetList.size() - 1 - index;
                if (fetchIdx >= 0) break block6;
                return null;
            }
            ItemId<IChangeSet> handle = changeSetList.get(fetchIdx);
            RepositoryNamespace namespace = RepositoryNamespace.create(repo);
            ItemLocator<IChangeSet> locator = ItemLocator.create(repo, handle);
            IChangeSet changeSet = this.mapHandlesOntoChangeSets.get(locator);
            if (changeSet != null) {
                Assert.isTrue((boolean)ClientRepositoryUtil.isSharedItem(repo, (IItem)changeSet));
                return changeSet;
            }
            int startIdx = Math.max(0, fetchIdx - prefetchSize);
            List<ItemId<IChangeSet>> itemIdsToFetch = changeSetList.subList(startIdx, fetchIdx + 1);
            Map changeSets = RepoFetcher.fetchCurrents((ITeamRepository)repo, itemIdsToFetch, (IProgressMonitor)progress.newChild(100));
            for (ItemId next : changeSets.keySet()) {
                IChangeSet nextChangeSet = (IChangeSet)changeSets.get(next);
                Assert.isTrue((nextChangeSet == null || ClientRepositoryUtil.isSharedItem(repo, (IItem)nextChangeSet) ? 1 : 0) != 0);
                this.mapHandlesOntoChangeSets.put(ItemLocator.create((ItemNamespace)namespace, next), nextChangeSet);
            }
            IChangeSet result = (IChangeSet)changeSets.get(handle);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.changeSetMutex;
        synchronized (object) {
            this.mapChangeSetStatesOntoDescriptions.clear();
        }
    }

    public int fetchWorkItemType(EraDescriptor descriptor, int index, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.fetchDescriptionRecord(descriptor, index, monitor).getWorkItemType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DeliveryInfo fetchDelivery(EraDescriptor eraDescriptor, int index, IProgressMonitor monitor) throws TeamRepositoryException {
        int relativeIndex = index;
        EraDescriptor descriptor = eraDescriptor;
        Object object = this.changeSetMutex;
        synchronized (object) {
            int fetchIdx;
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            List<DeliveryInfo> changeSetList = this.fetchDeliveries(descriptor, (IProgressMonitor)progress.newChild(20));
            while (true) {
                if (relativeIndex < changeSetList.size()) {
                    progress.setWorkRemaining(100);
                    fetchIdx = changeSetList.size() - 1 - relativeIndex;
                    if (fetchIdx >= 0) break;
                    return null;
                }
                relativeIndex -= changeSetList.size();
                progress.setWorkRemaining(100);
                descriptor = descriptor.getPreviousEra((IProgressMonitor)progress.newChild(10));
                if (descriptor == null) {
                    return null;
                }
                changeSetList = this.fetchDeliveries(descriptor, (IProgressMonitor)progress.newChild(10));
            }
            return changeSetList.get(fetchIdx);
        }
    }
}

