/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.magic;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IContentExaminer;
import com.ibm.team.filesystem.client.IContentProperties;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.magic.ContentProperties;
import com.ibm.team.filesystem.client.internal.magic.MagicPattern;
import com.ibm.team.filesystem.client.internal.utils.PropertiesLoader;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalContentExaminer
implements IContentExaminer {
    private static final String PROP_MIME = "mime";
    private static final String PROP_DELIM = "delim";
    private static final String PROP_ENCODING = "encoding";
    private static final String PROP_CASE = "respectcase";
    private static final String MAGIC_SOURCE_DEFAULT = "/resources/magic.default.properties";
    public static final String MAGIC_SOURCE_USER_FILENAME = "magic.properties";
    public static final byte[] BOM_UTF_8 = new byte[]{-17, -69, -65};
    public static final byte[] BOM_UTF_16BE = new byte[]{-2, -1};
    public static final byte[] BOM_UTF_16LE = new byte[]{-1, -2};
    private static volatile LocalContentExaminer instance = new LocalContentExaminer();
    private final File userDir;
    private List<MagicPattern> matchers = null;
    private static final MagicPattern UNKNOWN = new MagicPattern("", true, ContentProperties.UNKNOWN.getMimeType(), ContentProperties.UNKNOWN.getLineDelimiter(), null, true);
    private static final char ESCAPE = '\\';
    private static final char QUOTE = '\"';
    private static final char SEMI = ';';

    public static FileLineDelimiter getLineDelimiter(String lineDelimiterSetting) {
        if ("lf".equals(lineDelimiterSetting)) {
            return FileLineDelimiter.LINE_DELIMITER_LF;
        }
        if ("cr".equals(lineDelimiterSetting)) {
            return FileLineDelimiter.LINE_DELIMITER_CR;
        }
        if ("crlf".equals(lineDelimiterSetting)) {
            return FileLineDelimiter.LINE_DELIMITER_CRLF;
        }
        if ("platform".equals(lineDelimiterSetting)) {
            return FileLineDelimiter.LINE_DELIMITER_PLATFORM;
        }
        if ("none".equals(lineDelimiterSetting)) {
            return FileLineDelimiter.LINE_DELIMITER_NONE;
        }
        throw new IllegalArgumentException(NLS.bind((String)"{0} has value {1} which is not one of {2}, {3}, {4}, {5}, {6}", (Object[])new Object[]{"lineDelimiter", lineDelimiterSetting, "lf", "cr", "crlf", "platform", "none"}));
    }

    public static String getLineDelimiter(FileLineDelimiter lineDelimiterSetting) {
        if (lineDelimiterSetting == null) {
            return "";
        }
        switch (lineDelimiterSetting) {
            case LINE_DELIMITER_PLATFORM: {
                return "platform";
            }
            case LINE_DELIMITER_CRLF: {
                return "crlf";
            }
            case LINE_DELIMITER_LF: {
                return "lf";
            }
            case LINE_DELIMITER_CR: {
                return "cr";
            }
            case LINE_DELIMITER_NONE: {
                return "none";
            }
        }
        return "";
    }

    public static IContentExaminer getInstance() {
        return instance;
    }

    public LocalContentExaminer(String pathToUserHome) {
        File candidateHome = new File(FileSystemCore.USER_DIR);
        if (pathToUserHome != null && !(candidateHome = new File(pathToUserHome)).exists()) {
            candidateHome = null;
        }
        this.userDir = candidateHome;
    }

    public LocalContentExaminer() {
        this(FileSystemCore.USER_DIR);
    }

    public synchronized List<MagicPattern> getMatchers(IProgressMonitor progress) {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)1);
        if (this.matchers != null) {
            return this.matchers;
        }
        mon.beginTask(Messages.LocalContentExaminer_LOAD_PROGRESS_MESSAGE, 4);
        this.matchers = new ArrayList<MagicPattern>();
        InputStream in = this.getUserPatternStream(mon.newChild(1));
        if (in != null) {
            mon.setTaskName(Messages.LocalContentExaminer_LOAD_SUBTASK_USER);
            this.matchers.addAll(this.parseStream(in, false, mon.newChild(1)));
        }
        mon.setWorkRemaining(2);
        in = this.getBasePatternStream(mon.newChild(1));
        if (in != null) {
            mon.setTaskName(Messages.LocalContentExaminer_LOAD_SUBTASK_DEFAULTS);
            this.matchers.addAll(this.parseStream(in, true, mon.newChild(1)));
        }
        return this.matchers;
    }

    public synchronized void setMatchers(List<MagicPattern> patterns, IProgressMonitor progress) throws IOException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)2);
        this.matchers = new ArrayList<MagicPattern>();
        for (MagicPattern p : patterns) {
            if (!p.isBuiltIn()) continue;
            throw new IllegalArgumentException();
        }
        this.matchers.addAll(patterns);
        mon.setWorkRemaining(2);
        InputStream in = this.getBasePatternStream(mon.newChild(1));
        if (in != null) {
            mon.setTaskName(Messages.LocalContentExaminer_LOAD_SUBTASK_DEFAULTS);
            this.matchers.addAll(this.parseStream(in, true, mon.newChild(1)));
        }
        File patternFile = new File(this.userDir, MAGIC_SOURCE_USER_FILENAME);
        patternFile.getParentFile().mkdirs();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(patternFile, false), "UTF-8"));
        try {
            writer.write("### Jazz Magic 0");
            writer.newLine();
            for (MagicPattern p : patterns) {
                writer.append(LocalContentExaminer.escapePattern(p.getPattern()));
                writer.append(": ");
                boolean writeSep = false;
                if (p.getMimeType() != null) {
                    this.writeSep(writer, writeSep);
                    writer.append(PROP_MIME);
                    writer.append(": ");
                    writer.append(LocalContentExaminer.escapeValue(p.getMimeType()));
                    writeSep = true;
                }
                if (p.getEncoding() != null) {
                    this.writeSep(writer, writeSep);
                    writer.append(PROP_ENCODING);
                    writer.append(": ");
                    writer.append(LocalContentExaminer.escapeValue(p.getEncoding()));
                    writeSep = true;
                }
                if (p.getDelim() != null && p.getDelim() != FileLineDelimiter.LINE_DELIMITER_NONE) {
                    this.writeSep(writer, writeSep);
                    writer.append(PROP_DELIM);
                    writer.append(": ");
                    writer.write(LocalContentExaminer.getLineDelimiter(p.getDelim()));
                    writeSep = true;
                }
                if (!p.matcher.isIgnoreCase()) {
                    this.writeSep(writer, writeSep);
                    writer.append(PROP_CASE);
                    writer.append(": true");
                    writeSep = true;
                }
                writer.newLine();
            }
        }
        finally {
            writer.close();
        }
    }

    void writeSep(BufferedWriter writer, boolean writeSep) throws IOException {
        if (writeSep) {
            writer.append("; ");
        }
    }

    private static String escapePattern(String s) {
        return s;
    }

    private static String escapeValue(String s) {
        boolean quote = false;
        if (s.contains("\"")) {
            s = s.replace("\"", "\\\"");
            quote = true;
        }
        if (quote || s.contains(";")) {
            return "\"" + s + "\"";
        }
        return s;
    }

    private InputStream getUserPatternStream(SubMonitor subMonitor) {
        if (this.userDir == null || !this.userDir.exists()) {
            return null;
        }
        File patternFile = new File(this.userDir, MAGIC_SOURCE_USER_FILENAME);
        if (!patternFile.exists()) {
            return null;
        }
        try {
            return new FileInputStream(patternFile);
        }
        catch (FileNotFoundException e) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.LocalContentExaminer_COULD_NOT_OPEN_MAGIC_FILE, (Object)patternFile.getAbsolutePath()), (Throwable)e));
            return null;
        }
    }

    private List<MagicPattern> parseStream(InputStream in, boolean isBuiltIn, SubMonitor monitor) {
        LinkedHashMap<String, String> patterns;
        block12: {
            monitor = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
            patterns = new LinkedHashMap<String, String>();
            try {
                try {
                    PropertiesLoader.load(patterns, in, "UTF-8", -1L, (IProgressMonitor)monitor.newChild(9));
                }
                catch (IOException e) {
                    LoggingHelper.log(FileSystemStatus.getStatusFor(4, "Couldn't load base magic file", (Throwable)e));
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        monitor.setWorkRemaining(patterns.size());
        ArrayList<MagicPattern> result = new ArrayList<MagicPattern>(patterns.size());
        for (Map.Entry<String, String> entry : patterns.entrySet()) {
            MagicPattern template = this.parseTemplate(entry.getKey(), entry.getValue(), isBuiltIn, monitor.newChild(1));
            if (template == null) continue;
            result.add(template);
        }
        return result;
    }

    private StringBuffer convertToPropsFile(String line) {
        StringBuffer buf = new StringBuffer();
        State s = State.BARE;
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            block0 : switch (s) {
                case BARE: {
                    switch (c) {
                        case '\"': {
                            s = State.QUOTED;
                            break block0;
                        }
                        case ';': {
                            buf.append("\n");
                            break block0;
                        }
                    }
                    buf.append(c);
                    break;
                }
                case QUOTED: {
                    switch (c) {
                        case '\\': {
                            s = State.ESCAPED;
                            break block0;
                        }
                        case '\"': {
                            s = State.BARE;
                            break block0;
                        }
                    }
                    buf.append(c);
                    break;
                }
                case ESCAPED: {
                    buf.append(c);
                    s = State.QUOTED;
                }
            }
            ++i;
        }
        return buf;
    }

    private MagicPattern parseTemplate(String pattern, String template, boolean isBuiltIn, SubMonitor monitor) {
        FileLineDelimiter delim;
        String asPropFile = this.convertToPropsFile(template).toString();
        HashMap<String, String> props = new HashMap<String, String>();
        try {
            PropertiesLoader.load(props, new ByteArrayInputStream(asPropFile.getBytes("UTF-8")), "UTF-8", -1L, (IProgressMonitor)monitor);
        }
        catch (IOException e) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(4, -1, NLS.bind((String)Messages.LocalContentExaminer_FAILED_TO_PARSE, (Object)pattern), e));
            return null;
        }
        String mime = props.get(PROP_MIME);
        String delimStr = props.get(PROP_DELIM);
        if (delimStr == null) {
            delim = null;
        } else {
            try {
                delim = LocalContentExaminer.getLineDelimiter(delimStr);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(4, -1, NLS.bind((String)Messages.LocalContentExaminer_UNRECOGNIZED_VALUE, (Object[])new String[]{PROP_DELIM, pattern, delimStr}), null));
                delim = null;
            }
        }
        String encoding = props.get(PROP_ENCODING);
        boolean respectCase = false;
        if (props.containsKey(PROP_CASE)) {
            respectCase = props.get(PROP_CASE).trim().toLowerCase().equals("true");
        }
        return new MagicPattern(pattern, !respectCase, mime, delim, encoding, isBuiltIn);
    }

    private InputStream getBasePatternStream(SubMonitor subMonitor) {
        InputStream r = this.getClass().getResourceAsStream(MAGIC_SOURCE_DEFAULT);
        if (r == null) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(4, "Could not open default magic file", null));
        }
        return r;
    }

    @Override
    public IContentProperties examine(String name, IContentExaminer.IStreamSource data, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)10);
        List<MagicPattern> matched = this.getMagicMatchers(name, (IProgressMonitor)mon.newChild(5));
        String mimeType = this.getMimeType(matched);
        FileLineDelimiter delim = this.getLineDelimiter(matched);
        String encoding = this.getEncoding(name, data, (IProgressMonitor)mon.newChild(5));
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        return new ContentProperties(encoding, mimeType, delim);
    }

    @Override
    public IContentProperties examine(final IShareable shareable, IProgressMonitor mon) throws FileSystemClientException {
        return this.examine(shareable.getLocalPath().lastSegment(), new IContentExaminer.IStreamSource(){

            public InputStream getStream() throws FileSystemClientException {
                return ((Shareable)shareable).getFileStorage().getContents();
            }
        }, mon);
    }

    @Override
    public IContentProperties findStoredProperties(IShareable shareable, IProgressMonitor mon) throws FileSystemClientException {
        String encoding;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        final File file = (File)shareable.getAdapter(File.class);
        final ResourceType type = shareable.getResourceType((IProgressMonitor)progress.newChild(1));
        if (file == null || type == null) {
            return ContentProperties.UNKNOWN;
        }
        String mimeType = shareable.getContentType((IProgressMonitor)progress.newChild(25));
        FileLineDelimiter lineDelimiter = shareable.getLineDelimiter((IProgressMonitor)progress.newChild(25));
        if (mimeType == null || lineDelimiter == null) {
            IContentProperties props = this.examine(shareable, (IProgressMonitor)progress.newChild(50));
            if (mimeType == null) {
                mimeType = props.getMimeType();
            }
            if (lineDelimiter == null) {
                lineDelimiter = props.getLineDelimiter();
            }
            encoding = props.getEncoding();
        } else {
            IContentExaminer.IStreamSource data = new IContentExaminer.IStreamSource(){

                public InputStream getStream() throws FileSystemClientException {
                    block3: {
                        try {
                            if (file != null && type == ResourceType.FILE && file.canRead()) break block3;
                            return null;
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            return null;
                        }
                    }
                    return new FileInputStream(file);
                }
            };
            encoding = this.getEncoding(shareable.getLocalPath().lastSegment(), data, (IProgressMonitor)progress.newChild(50));
        }
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        return new ContentProperties(encoding, mimeType, lineDelimiter);
    }

    @Override
    public String getEncoding(IShareable shareable, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progress, (int)10);
        final File file = (File)shareable.getAdapter(File.class);
        final ResourceType type = shareable.getResourceType((IProgressMonitor)mon);
        String encoding = null;
        IContentExaminer.IStreamSource data = new IContentExaminer.IStreamSource(){

            public InputStream getStream() throws FileSystemClientException {
                block3: {
                    try {
                        if (file != null && type == ResourceType.FILE && file.canRead()) break block3;
                        return null;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        return null;
                    }
                }
                return new FileInputStream(file);
            }
        };
        encoding = this.getEncoding(shareable.getLocalPath().lastSegment(), data, (IProgressMonitor)mon.newChild(10));
        if (encoding == null) {
            encoding = System.getProperty("file.encoding");
        }
        return encoding;
    }

    private String getEncoding(String name, IContentExaminer.IStreamSource data, IProgressMonitor mon) throws FileSystemClientException {
        String encoding = null;
        if (data != null) {
            encoding = LocalContentExaminer.sniffEncoding(data);
        }
        if (encoding == null) {
            List<MagicPattern> matched = this.getMagicMatchers(name, mon);
            encoding = this.getEncoding(matched);
        }
        return encoding;
    }

    private List<MagicPattern> getMagicMatchers(String name, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        List<MagicPattern> matchers = this.getMatchers((IProgressMonitor)progress.newChild(9));
        ArrayList<MagicPattern> matched = new ArrayList<MagicPattern>(1);
        progress.setWorkRemaining(matchers.size());
        for (MagicPattern defn : matchers) {
            if (defn.matcher.match(name)) {
                matched.add(defn);
            }
            progress.worked(1);
        }
        if (matched.size() == 0) {
            matched.add(UNKNOWN);
        }
        return matched;
    }

    private FileLineDelimiter getLineDelimiter(List<MagicPattern> matched) {
        FileLineDelimiter delim = FileLineDelimiter.LINE_DELIMITER_NONE;
        for (MagicPattern defn : matched) {
            if (defn.delim == null) continue;
            delim = defn.delim;
            break;
        }
        return delim;
    }

    private String getMimeType(List<MagicPattern> matched) {
        String mimeType = "application/unknown";
        for (MagicPattern defn : matched) {
            if (defn.mimeType == null) continue;
            mimeType = defn.mimeType;
            break;
        }
        return mimeType;
    }

    private String getEncoding(List<MagicPattern> matched) {
        for (MagicPattern defn : matched) {
            if (defn.encoding == null) continue;
            return defn.encoding;
        }
        return null;
    }

    /*
     * Loose catch block
     */
    public static String sniffEncoding(IContentExaminer.IStreamSource data) throws FileSystemClientException {
        block23: {
            InputStream input;
            block22: {
                int offset;
                byte[] buffer;
                block21: {
                    block20: {
                        input = data.getStream();
                        if (input == null) {
                            return null;
                        }
                        buffer = new byte[3];
                        int len = 0;
                        offset = 0;
                        int max = buffer.length;
                        while (len != -1 && offset < buffer.length) {
                            len = input.read(buffer, offset, max);
                            if (len == -1) continue;
                            offset += len;
                            max -= len;
                        }
                        if (!LocalContentExaminer.startsWith(buffer, offset, BOM_UTF_8)) break block20;
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                        return "UTF-8";
                    }
                    if (!LocalContentExaminer.startsWith(buffer, offset, BOM_UTF_16BE)) break block21;
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                    return "UTF-16BE";
                }
                if (!LocalContentExaminer.startsWith(buffer, offset, BOM_UTF_16LE)) break block22;
                try {
                    input.close();
                }
                catch (IOException iOException) {}
                return "UTF-16LE";
                catch (IOException iOException) {
                    try {}
                    catch (Throwable throwable) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                    try {
                        input.close();
                    }
                    catch (IOException iOException3) {}
                    break block23;
                }
            }
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static boolean startsWith(byte[] buffer, int size, byte[] bom) {
        if (size < bom.length) {
            return false;
        }
        int i = 0;
        while (i < bom.length) {
            if (buffer[i] != bom[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void makeDefault() {
        instance = this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        BARE,
        QUOTED,
        ESCAPED;

    }
}

