/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IMetadataChangeTracker;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFALockUtil;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreasLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalAddition;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNode;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNotifier;
import com.ibm.team.filesystem.client.internal.localchanges.LocalDeletion;
import com.ibm.team.filesystem.client.internal.localchanges.LocalModification;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveFrom;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveTo;
import com.ibm.team.filesystem.client.internal.localchanges.NoOpChange;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class LocalChangeTracker {
    public static final Object CHANGES_COMPUTER_JOB_FAMILY = Messages.LocalChangeTracker_0;
    private static final long DELAY = 200000000L;
    private static final long DELAY_MS = 200L;
    private LocalChangeNotifier notifier;
    LocalChangeContext context;
    private LocalChangeNode changeTree = new LocalChangeNode(null, null);
    private LocalChangesComputer computeChangesjob;
    private Map<UUID, LocalChange> localChanges = new HashMap<UUID, LocalChange>();
    private HashMap<DateRecord, Long> needDates = new HashMap();

    private static void setCounterpart(LocalMoveFrom moveFrom, LocalMoveTo moveTo) {
        moveFrom.setCounterpart(moveTo);
        moveTo.setCounterpart(moveFrom);
    }

    private static void setNode(LocalChangeNode node, LocalChange change) {
        change.setNode(node);
        node.addChange(change);
    }

    public LocalChangeTracker(LocalChangeNotifier notifier, LocalChangeContext context, ISchedulingRule schedulingRule) {
        this.notifier = notifier;
        this.context = context;
        if (schedulingRule == null) {
            schedulingRule = new DefaultSchedulingRule();
        }
        this.computeChangesjob = new LocalChangesComputer(schedulingRule);
        this.computeChangesjob.requestRefresh();
    }

    public synchronized void cancelChanges(ILocalChange[] canceled) {
        ILocalChange[] allCanceled = this.forgetChanges(canceled);
        this.notifier.changesCanceled(this.context, allCanceled);
    }

    public synchronized void cancelChanges(IShareable root) {
        ILocalChange[] allCanceled = this.forgetChanges(root);
        this.notifier.changesCanceled(this.context, allCanceled);
    }

    public synchronized void cancelAllChanges() {
        if (!this.localChanges.isEmpty()) {
            this.cancelChanges(this.localChanges.values().toArray(new ILocalChange[this.localChanges.size()]));
        }
    }

    private void changeCanceled(LocalChange change) {
        if (this.notifier != null && this.context != null) {
            this.notifier.changeCanceled(this.context, change);
        }
    }

    private void changeOccurred(LocalChange change) {
        if (this.notifier != null && this.context != null) {
            this.notifier.changeOccurred(this.context, change);
        }
    }

    public synchronized void confirmChanges(ILocalChange[] confirmed) {
        ILocalChange[] allConfirmed = this.forgetChanges(confirmed);
        this.notifier.changesConfirmed(this.context, allConfirmed);
    }

    private ILocalChange[] forgetChanges(ILocalChange[] toForget) {
        ArrayList<LocalChange> closure = new ArrayList<LocalChange>();
        int i = 0;
        while (i < toForget.length) {
            if (!toForget[i].isCanceled()) {
                LocalChange c = (LocalChange)toForget[i];
                closure.add(c);
                c.cancel();
                c.getNode().removeChange(c);
                this.localChanges.remove(c.getItemId());
            }
            ++i;
        }
        return closure.toArray(new ILocalChange[closure.size()]);
    }

    private ILocalChange[] forgetChanges(IShareable shareable) {
        LocalChangeNode startingPoint = this.changeTree.getNode(shareable.getLocalPath(), false);
        if (startingPoint == null) {
            return new ILocalChange[0];
        }
        ArrayList closure = new ArrayList();
        startingPoint.collect(closure);
        for (LocalChange c : closure) {
            c.cancel();
            this.localChanges.remove(c.getItemId());
        }
        this.clear(startingPoint);
        return closure.toArray(new ILocalChange[closure.size()]);
    }

    public synchronized ILocalChange getPendingChange(IVersionableHandle item) {
        if (item == null) {
            return NoOpChange.NO_OP;
        }
        LocalChange c = this.localChanges.get(item.getItemId());
        if (c == null) {
            return NoOpChange.NO_OP;
        }
        c.setWild();
        return c;
    }

    public ILocalChange[] getPendingChanges() {
        return this.getPendingChanges(false);
    }

    public synchronized ILocalChange[] getPendingChanges(boolean consume) {
        ILocalChange[] changes;
        ILocalChange[] iLocalChangeArray = changes = this.getPendingChanges(this.changeTree, consume);
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange change = iLocalChangeArray[n2];
            ((LocalChange)change).setWild();
            ++n2;
        }
        return changes;
    }

    public synchronized ILocalChange[] getPendingChanges(IPath root, boolean consume) {
        ILocalChange[] changes;
        LocalChangeNode rootNode = this.changeTree.getNode(root, false);
        if (rootNode == null) {
            return LocalChangeManager.NO_CHANGES;
        }
        ILocalChange[] iLocalChangeArray = changes = this.getPendingChanges(rootNode, consume);
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange change = iLocalChangeArray[n2];
            ((LocalChange)change).setWild();
            ++n2;
        }
        return changes;
    }

    public synchronized ILocalChange[] getPendingChangesAt(IPath root) {
        ILocalChange[] changes;
        LocalChangeNode rootNode = this.changeTree.getNode(root, false);
        if (rootNode == null) {
            return LocalChangeManager.NO_CHANGES;
        }
        ILocalChange[] iLocalChangeArray = changes = rootNode.getChanges().toArray(new LocalChange[rootNode.getChanges().size()]);
        int n = changes.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange c = iLocalChangeArray[n2];
            ((LocalChange)c).setWild();
            ++n2;
        }
        return changes;
    }

    private ILocalChange[] getPendingChanges(LocalChangeNode startingPoint, boolean consume) {
        Assert.isNotNull((Object)startingPoint);
        ArrayList result = new ArrayList();
        startingPoint.collect(result);
        if (consume) {
            for (LocalChange change : result) {
                this.localChanges.remove(change.getItemId());
                change.cancel();
            }
            this.clear(startingPoint);
        }
        return result.toArray(new ILocalChange[result.size()]);
    }

    /*
     * Exception decompiling
     */
    public void trackFileAddition(IFolderHandle targetParent, IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[CATCHBLOCK]], but top level block is 17[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void trackFolderAddition(IFolderHandle targetParent, IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        FileItemInfo targetInfo;
        Assert.isNotNull((Object)shareable, (String)Messages.LocalChangeTracker_7);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.context.getRoot());
        Assert.isNotNull((Object)cfa);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IPath path = shareable.getLocalPath();
        if (targetParent == null) {
            IShare share = shareable.getShare((IProgressMonitor)progress.newChild(50));
            ISharingDescriptor desc = share.getSharingDescriptor();
            Assert.isTrue((boolean)(desc.getRootVersionable() instanceof IFolderHandle));
            Assert.isTrue((share.getPath().segmentCount() == path.segmentCount() ? 1 : 0) != 0);
            targetInfo = cfa.getItemInfo(desc.getRootVersionable(), desc.getComponent(), desc.getConnectionHandle());
            if (targetInfo == null) {
                targetInfo = new FileItemInfo((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(desc.getRootVersionable().getItemId(), null), null, null, false);
            }
        } else {
            targetInfo = cfa.getDeletedItem(targetParent, path.lastSegment(), this.context.getComponent(), this.context.getConnection(), (IProgressMonitor)progress.newChild(50));
            if (targetInfo == null || targetInfo.getVersionableHandle().getItemType() != IFolder.ITEM_TYPE) {
                targetInfo = null;
            }
        }
        if (targetInfo == null) {
            targetInfo = new FileItemInfo((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(UUID.generate(), null), null, null, false);
        }
        progress.setWorkRemaining(50);
        cfa.setItemInfo(path, targetInfo, (IProgressMonitor)progress.newChild(50));
        progress.done();
    }

    public void trackSymbolicLinkAddition(IFolderHandle targetParent, IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        FileItemInfo targetInfo;
        Assert.isNotNull((Object)shareable, (String)Messages.LocalChangeTracker_7);
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.context.getRoot());
        Assert.isNotNull((Object)cfa);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IPath path = shareable.getLocalPath();
        if (targetParent == null) {
            IShare share = shareable.getShare((IProgressMonitor)progress.newChild(15));
            ISharingDescriptor desc = share.getSharingDescriptor();
            Assert.isTrue((boolean)(desc.getRootVersionable() instanceof ISymbolicLinkHandle));
            Assert.isTrue((share.getPath().segmentCount() == path.segmentCount() ? 1 : 0) != 0);
            targetInfo = cfa.getItemInfo(desc.getRootVersionable(), desc.getComponent(), desc.getConnectionHandle());
            if (targetInfo == null) {
                targetInfo = new FileItemInfo((ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle(desc.getRootVersionable().getItemId(), null), false, null, null, false, null, null);
            }
        } else {
            targetInfo = cfa.getDeletedItem(targetParent, path.lastSegment(), this.context.getComponent(), this.context.getConnection(), (IProgressMonitor)progress.newChild(25));
            if (targetInfo != null && targetInfo.getVersionableHandle().getItemType() != ISymbolicLink.ITEM_TYPE) {
                targetInfo = null;
            }
        }
        if (targetInfo == null) {
            targetInfo = new FileItemInfo((ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle(UUID.generate(), null), false, null, null, false, null, null);
        } else if (targetInfo.getHash() != null) {
            IFileStorage storage = ((Shareable)shareable).getFileStorage();
            boolean contentChange = LocalChangeTracker.contentChanged(targetInfo, storage, (IProgressMonitor)progress.newChild(10));
            targetInfo = new FileItemInfo((ISymbolicLinkHandle)targetInfo.getVersionableHandle(), contentChange, targetInfo.getParent(), targetInfo.getName(), targetInfo.isLoadedWithAnotherName(), targetInfo.getHash(), targetInfo.getStoredHash());
        }
        progress.setWorkRemaining(50);
        cfa.setItemInfo(path, targetInfo, (IProgressMonitor)progress.newChild(50));
        progress.done();
    }

    private IFileInfo fetchBaseInfo(final IFileStore fileStore, final SubMonitor progress) throws CoreException {
        final IFileInfo[] info = new IFileInfo[1];
        SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

            public void run() throws CoreException {
                info[0] = fileStore.fetchInfo(0, (IProgressMonitor)progress);
            }
        });
        return info[0];
    }

    public static boolean contentChanged(FileItemInfo targetInfo, IFileStorage link, IProgressMonitor progress) {
        if (targetInfo.getHash() == null) {
            return false;
        }
        try {
            String linkTarget = link.getTarget(progress);
            return LocalChangeTracker.contentChanged(targetInfo, linkTarget);
        }
        catch (FileSystemClientException fileSystemClientException) {
            return true;
        }
    }

    public static boolean contentChanged(FileItemInfo targetInfo, String linkTarget) {
        block6: {
            block5: {
                if (linkTarget != null) break block5;
                return true;
            }
            if (targetInfo.getHash() != null) break block6;
            return false;
        }
        try {
            return !LocalChangeTracker.getLinkHash(linkTarget).equals((Object)targetInfo.getHash());
        }
        catch (ContentHashAlgorithmException contentHashAlgorithmException) {
            return true;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public static ContentHash getLinkHash(String linkTarget) throws ContentHashAlgorithmException, IOException {
        ContentHash contentHash;
        block9: {
            ByteArrayInputStream in = null;
            try {
                in = new ByteArrayInputStream(linkTarget.getBytes("UTF-8"));
                ContentHash newHash = ContentHash.valueOf((InputStream)in);
                ((InputStream)in).close();
                in = null;
                contentHash = newHash;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {
                    }
                    catch (RuntimeException runtimeException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {
            }
            catch (RuntimeException runtimeException) {}
        }
        return contentHash;
    }

    private void clear(LocalChangeNode startingPoint) {
        startingPoint.prune();
    }

    public void syncChanges(IProgressMonitor monitor) {
        this.computeChangesjob.rejoin(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPendingChanges(IProgressMonitor monitor) throws FileSystemClientException {
        Object pair;
        SharingManager shareManager = SharingManager.getInstance();
        HashMap<DateRecord, Long> modifiedInFuture = new HashMap<DateRecord, Long>();
        CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(this.context.getRoot());
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        SubMonitor subProgress = progress.newChild(1);
        while (true) {
            int size;
            HashMap<DateRecord, Long> hashMap = this.needDates;
            synchronized (hashMap) {
                size = this.needDates.size();
                if (size == 0) {
                    break;
                }
                Iterator<Map.Entry<DateRecord, Long>> it = this.needDates.entrySet().iterator();
                pair = it.next();
                it.remove();
            }
            subProgress.setWorkRemaining(size + 1);
            DateRecord rec = (DateRecord)pair.getKey();
            long hashedAt = (Long)pair.getValue();
            IShareable shareable = shareManager.findShareable(this.context.getRoot(), rec.connection, rec.component, rec.versionable, null);
            if (shareable == null) continue;
            long stamp = ((Shareable)shareable).getFileStorage().getLocalTimeStamp();
            if (stamp != hashedAt) {
                if (stamp >= hashedAt) continue;
                modifiedInFuture.put(rec, hashedAt);
                continue;
            }
            FileItemInfo oldInfo = ((Shareable)shareable).getFileItemInfo((IProgressMonitor)subProgress.newChild(1));
            Assert.isNotNull((Object)oldInfo);
            Assert.isNotNull((Object)oldInfo.getHash());
            long modStamp = ((Shareable)shareable).getFileStorage().getModificationStamp();
            if (modStamp == oldInfo.getLastContentChangeCheckStamp()) continue;
            FileItemInfo newInfo = new FileItemInfo(oldInfo.getVersionableHandle(), oldInfo.isContentChanged(), modStamp, oldInfo.getParent(), oldInfo.getName(), oldInfo.isLoadedWithAnotherName(), oldInfo.getHash(), oldInfo.getContentLength(), oldInfo.getOriginalLineDelimiter(), oldInfo.getLineDelimiter(), oldInfo.getOriginalContentType(), oldInfo.getContentType(), oldInfo.getStoredPredecessorHintHash(), oldInfo.getStoredSize(), oldInfo.getStoredEncoding(), oldInfo.getStoredHash(), oldInfo.getStoredNumLineDelimiters(), oldInfo.isExecutable(), oldInfo.isOriginalExecutable());
            cfa.setItemInfo(shareable.getLocalPath(), newInfo, null);
        }
        subProgress.done();
        pair = this.needDates;
        synchronized (pair) {
            this.needDates.putAll(modifiedInFuture);
        }
        List<IMetadataChangeTracker.IChangeType> changes = ((IMetadataChangeTracker)((Object)cfa.internalGetMetadata())).getLocalChanges(this.context.getComponent(), this.context.getConnection(), (IProgressMonitor)progress.newChild(1));
        ArrayList<LocalChange> localChanges = new ArrayList<LocalChange>(changes.size());
        HashSet<UUID> modifiedItems = new HashSet<UUID>();
        block13: for (IMetadataChangeTracker.IChangeType ct : changes) {
            switch (ct.getType()) {
                case 2: {
                    break;
                }
                case 1: {
                    localChanges.add(new LocalDeletion(this.context, ct.getCurrentPath(), ct.getOriginalPath(), ct.getItem(), ct.getPreviousParent()));
                    modifiedItems.add(ct.getItem().getItemId());
                    break;
                }
                case 3: {
                    int type = 0;
                    if (ct.isContentChange()) {
                        type = 1;
                    }
                    if (ct.isFlagChange()) {
                        type |= 0x20;
                    }
                    LocalMoveFrom moveFrom = new LocalMoveFrom(this.context, ct.getCurrentMovedFromPath(), ct.getOriginalPath(), ct.getItem(), ct.getPreviousParent(), type);
                    LocalMoveTo moveTo = new LocalMoveTo(this.context, ct.getCurrentPath(), ct.getItem(), ct.getCurrentParent(), type);
                    LocalChangeTracker.setCounterpart(moveFrom, moveTo);
                    localChanges.add(moveTo);
                    modifiedItems.add(ct.getItem().getItemId());
                    break;
                }
                case 4: {
                    localChanges.add(new LocalAddition(this.context, ct.getCurrentPath(), ct.getItem(), ct.getCurrentParent()));
                    modifiedItems.add(ct.getItem().getItemId());
                    break;
                }
                default: {
                    int type = 0;
                    if (ct.isContentChange()) {
                        type = 1;
                    }
                    if (ct.isFlagChange()) {
                        type |= 0x20;
                    }
                    if (type == 0) continue block13;
                    localChanges.add(new LocalModification(this.context, ct.getCurrentPath(), ct.getOriginalPath(), ct.getItem(), type));
                    modifiedItems.add(ct.getItem().getItemId());
                }
            }
        }
        Iterator<Map.Entry<UUID, LocalChange>> i = this.localChanges.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<UUID, LocalChange> e = i.next();
            if (modifiedItems.contains(e.getKey())) continue;
            e.getValue().cancel();
            e.getValue().getNode().removeChange(e.getValue());
            this.changeCanceled(e.getValue());
            i.remove();
        }
        for (LocalChange c : localChanges) {
            LocalChange oldChange = this.localChanges.get(c.getItemId());
            if (oldChange != null) {
                if (c.equals(oldChange)) continue;
                oldChange.cancel();
                oldChange.getNode().removeChange(oldChange);
                this.changeCanceled(oldChange);
            }
            LocalChangeNode node = this.changeTree.getNode(c.getPath(), true);
            LocalChangeTracker.setNode(node, c);
            this.localChanges.put(c.getItemId(), c);
            this.changeOccurred(c);
        }
    }

    public static void computePendingChanges(final IShareable root, final ILocalChangeManager.RefreshType traversalType, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final ArrayList<FileSystemClientException> exceptions = new ArrayList<FileSystemClientException>();
        LocalChangeTracker tracker = null;
        ICopyFileAreasLock lock = ICopyFileAreaManager.instance.lock(Collections.singleton(ICopyFileAreaManager.instance.lockRequestFactory().getLockRequest(Collections.singleton(root))), (IProgressMonitor)progress.newChild(1));
        try {
            final Share share = (Share)root.getShare((IProgressMonitor)progress.newChild(1));
            if (share == null || !CFALockUtil.isLockedForUpdate(share.getSandbox().getRoot(), share.getSharingDescriptor().getComponent(), share.getSharingDescriptor().getConnectionHandle())) {
                return;
            }
            final LocalChangeTracker myTracker = tracker = share.getTracker();
            final CopyFileArea cfa = CopyFileAreaManager.instance.getExistingCopyFileArea(root.getSandbox().getRoot());
            final ArrayList<IShareable> toVisit = new ArrayList<IShareable>();
            toVisit.add(root);
            do {
                progress.setWorkRemaining(98);
                final ArrayList toDelete = new ArrayList();
                Shareable next = (Shareable)toVisit.remove(toVisit.size() - 1);
                next.accept(new IShareableVisitor(){

                    public boolean visit(IShareable shareable, IProgressMonitor progress) {
                        ResourceType type;
                        FileItemInfo parentInfo;
                        IFileStorage parent;
                        IFileStorage fileStorage;
                        SubMonitor monitor;
                        block49: {
                            block50: {
                                monitor = SubMonitor.convert((IProgressMonitor)progress, (int)5);
                                try {
                                    if (shareable.shouldBeIgnored((IProgressMonitor)monitor.newChild(1))) {
                                        return false;
                                    }
                                }
                                catch (FileSystemClientException e) {
                                    exceptions.add(e);
                                }
                                fileStorage = ((Shareable)shareable).getFileStorage();
                                if (!fileStorage.isRepositoryProviderRegistered((IProgressMonitor)monitor.newChild(1))) break block49;
                                if (traversalType != ILocalChangeManager.RefreshType.OPTIMIZED_TRAVERSAL) break block50;
                                return false;
                            }
                            try {
                                if (traversalType == ILocalChangeManager.RefreshType.TRAVERSE_ALL_WITH_RECOMPUTE_OF_KNOWN && (root.equals(shareable) || fileStorage.getIDEPath().segmentCount() == 1)) {
                                    SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                                        public void run() throws CoreException {
                                            fileStorage.refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(1));
                                        }
                                    });
                                }
                            }
                            catch (FileSystemClientException e) {
                                exceptions.add(e);
                            }
                            catch (CoreException e) {
                                exceptions.add(new FileSystemClientException(FileSystemStatus.getStatusFor(e)));
                            }
                        }
                        monitor.subTask(NLS.bind((String)Messages.LocalChangeTracker_RecomputeChangesForPath, (Object)shareable.getLocalPath().toString()));
                        Shareable parentShareable = (Shareable)((Shareable)shareable).getParent();
                        if (parentShareable != null) {
                            parent = parentShareable.getFileStorage();
                            parentInfo = cfa.getItemInfo(parentShareable.getLocalPath());
                            if (parentInfo == null) {
                                try {
                                    ManagedFileStore.createFolderHierarchyUpToParentOf(shareable.getLocalPath(), share, cfa, false, (IProgressMonitor)monitor.newChild(1));
                                    parentInfo = cfa.getItemInfo(parentShareable.getLocalPath());
                                }
                                catch (CoreException e) {
                                    LoggingHelper.log(e);
                                }
                            }
                        } else {
                            parent = null;
                            parentInfo = null;
                        }
                        try {
                            type = shareable.getResourceType((IProgressMonitor)monitor.newChild(1));
                        }
                        catch (FileSystemClientException e) {
                            exceptions.add(e);
                            return false;
                        }
                        if (parent == null && type == ResourceType.FOLDER) {
                            return true;
                        }
                        if (parent != null && type == null) {
                            toDelete.add(shareable);
                            return false;
                        }
                        FileItemInfo info = cfa.getItemInfo(shareable.getLocalPath());
                        if (parent != null && info != null && (type == ResourceType.SYMBOLIC_LINK != info.isSymbolicLink() || !info.isSymbolicLink() && info.isFolder() != (type == ResourceType.FOLDER))) {
                            toDelete.add(shareable);
                            toVisit.add(shareable);
                            return false;
                        }
                        if (parent != null && info == null && parentInfo != null) {
                            try {
                                if (type == ResourceType.SYMBOLIC_LINK) {
                                    myTracker.trackSymbolicLinkAddition((IFolderHandle)parentInfo.getVersionableHandle(), shareable, (IProgressMonitor)monitor.newChild(1));
                                } else if (type == ResourceType.FOLDER) {
                                    myTracker.trackFolderAddition((IFolderHandle)parentInfo.getVersionableHandle(), shareable, (IProgressMonitor)monitor.newChild(1));
                                } else if (type == ResourceType.FILE) {
                                    myTracker.trackFileAddition((IFolderHandle)parentInfo.getVersionableHandle(), shareable, (IProgressMonitor)monitor.newChild(1));
                                }
                            }
                            catch (FileSystemClientException e) {
                                exceptions.add(e);
                            }
                        } else if (info != null && info.isFile() && info.getHash() != null) {
                            long modStamp;
                            SubMonitor folderMon = monitor.newChild(1).setWorkRemaining(100);
                            boolean contentChange = info.isContentChanged();
                            boolean isExecutable = info.isExecutable();
                            try {
                                try {
                                    SharingManager.getInstance().disableChangeMonitoring();
                                    modStamp = fileStorage.getModificationStamp();
                                    if (fileStorage.supportsExecBit()) {
                                        isExecutable = fileStorage.isExecutable((IProgressMonitor)folderMon.newChild(25));
                                        folderMon.setWorkRemaining(100);
                                    }
                                    contentChange = fileStorage.isContentChangedFrom(info, (IProgressMonitor)folderMon.newChild(50));
                                }
                                catch (FileSystemClientException e) {
                                    if (e.getStatus().getCode() != 203) {
                                        exceptions.add(e);
                                    }
                                    SharingManager.getInstance().enableChangeMonitoring();
                                    return true;
                                }
                            }
                            finally {
                                SharingManager.getInstance().enableChangeMonitoring();
                            }
                            boolean nameChange = false;
                            if (!cfa.isCaseSensitive()) {
                                ISharingDescriptor desc = share.getSharingDescriptor();
                                InverseFileItemInfo itemInfo = cfa.getItemInfo(info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle());
                                boolean bl = nameChange = !itemInfo.getLocalName().equals(shareable.getLocalPath().lastSegment());
                            }
                            if (info.getLastContentChangeCheckStamp() != modStamp || contentChange != info.isContentChanged() || isExecutable != info.isExecutable() || nameChange) {
                                FileItemInfo touchedInfo = new FileItemInfo(info.getVersionableHandle(), contentChange, modStamp, info.getParent(), info.getName(), info.isLoadedWithAnotherName(), info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredPredecessorHintHash(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredHash(), info.getStoredNumLineDelimiters(), isExecutable, info.isOriginalExecutable());
                                folderMon.setWorkRemaining(100);
                                try {
                                    cfa.setItemInfo(shareable.getLocalPath(), touchedInfo, (IProgressMonitor)folderMon.newChild(100));
                                }
                                catch (FileSystemClientException e) {
                                    exceptions.add(e);
                                }
                            }
                            progress.done();
                        } else if (info != null && info.isSymbolicLink() && info.getHash() != null) {
                            boolean contentChange = LocalChangeTracker.contentChanged(info, fileStorage, (IProgressMonitor)monitor.newChild(1));
                            if (contentChange != info.isContentChanged()) {
                                FileItemInfo touchedInfo = new FileItemInfo((ISymbolicLinkHandle)info.getVersionableHandle(), contentChange, info.getParent(), info.getName(), info.isLoadedWithAnotherName(), info.getHash(), info.getStoredHash());
                                try {
                                    cfa.setItemInfo(shareable.getLocalPath(), touchedInfo, (IProgressMonitor)monitor.newChild(1));
                                }
                                catch (FileSystemClientException e) {
                                    exceptions.add(e);
                                }
                            }
                        } else if (info != null && info.isFolder() && !cfa.isCaseSensitive()) {
                            ISharingDescriptor desc = share.getSharingDescriptor();
                            InverseFileItemInfo itemInfo = cfa.getItemInfo(info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle());
                            if (!itemInfo.getLocalName().equals(shareable.getLocalPath().lastSegment())) {
                                FileItemInfo touchedInfo = new FileItemInfo((IFolderHandle)info.getVersionableHandle(), info.getParent(), info.getName(), info.isLoadedWithAnotherName());
                                try {
                                    cfa.setItemInfo(shareable.getLocalPath(), touchedInfo, (IProgressMonitor)monitor.newChild(1));
                                }
                                catch (FileSystemClientException e) {
                                    exceptions.add(e);
                                }
                            }
                        }
                        return true;
                    }
                }, Integer.MAX_VALUE, true, true, (IProgressMonitor)progress.newChild(68));
                SubMonitor subProgress = progress.newChild(10);
                subProgress.setWorkRemaining(toDelete.size());
                for (IShareable shareable : toDelete) {
                    try {
                        cfa.deleteTreeInfo(shareable.getLocalPath(), false, (IProgressMonitor)subProgress.newChild(1));
                    }
                    catch (FileSystemClientException e) {
                        exceptions.add(e);
                    }
                }
                subProgress.done();
            } while (!toVisit.isEmpty());
            if (!exceptions.isEmpty()) {
                MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.LocalChangeTracker_11, null);
                for (FileSystemClientException ex : exceptions) {
                    multi.add(FileSystemStatus.getStatusFor((Throwable)((Object)ex)));
                }
                throw new FileSystemClientException((IStatus)multi);
            }
        }
        finally {
            lock.release((IProgressMonitor)progress.newChild(1));
            if (tracker != null) {
                tracker.computeChangesjob.requestRefresh();
            }
            progress.done();
        }
    }

    public LocalChangeContext getContext() {
        return this.context;
    }

    public void metadataChanged() {
        this.computeChangesjob.requestRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerDatelessVersionable(long hashedAt, IVersionableHandle handle, IComponentHandle component, IContextHandle connection) {
        HashMap<DateRecord, Long> hashMap = this.needDates;
        synchronized (hashMap) {
            DateRecord rec = new DateRecord(handle, component, connection);
            this.needDates.remove(rec);
            this.needDates.put(rec, hashedAt);
        }
        this.computeChangesjob.requestRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregisterDatelessVersionable(IVersionableHandle handle, IComponentHandle component, IContextHandle connection) {
        HashMap<DateRecord, Long> hashMap = this.needDates;
        synchronized (hashMap) {
            DateRecord rec = new DateRecord(handle, component, connection);
            this.needDates.remove(rec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDatelessVersionable(long hashedAt, IVersionableHandle handle, IComponentHandle component, IContextHandle connection) {
        Long oldDate;
        HashMap<DateRecord, Long> hashMap = this.needDates;
        synchronized (hashMap) {
            oldDate = this.needDates.get(new DateRecord(handle, component, connection));
        }
        return oldDate != null && oldDate == hashedAt;
    }

    private static class DateRecord {
        IVersionableHandle versionable;
        IComponentHandle component;
        IContextHandle connection;

        DateRecord(IVersionableHandle handle, IComponentHandle component, IContextHandle connection) {
            this.versionable = handle;
            this.component = component;
            this.connection = connection;
        }

        public int hashCode() {
            return this.versionable.getItemId().hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof DateRecord)) {
                return false;
            }
            DateRecord other = (DateRecord)o;
            return this.versionable.sameItemId((IItemHandle)other.versionable) && this.component.sameItemId((IItemHandle)other.component) && this.connection.sameItemId((IItemHandle)other.connection);
        }

        public String toString() {
            return "DateRecord(" + this.versionable.toString() + ")";
        }
    }

    private static final class DefaultSchedulingRule
    implements ISchedulingRule {
        private DefaultSchedulingRule() {
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof DefaultSchedulingRule;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof DefaultSchedulingRule;
        }
    }

    class LocalChangesComputer
    extends Job {
        volatile long lastRecompute;
        volatile long lastRequest;

        public LocalChangesComputer(ISchedulingRule rule) {
            super(Messages.LocalChangeTracker_1);
            this.setPriority(30);
            this.setRule(rule);
            this.setSystem(true);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                if (progress.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                AbstractLock rule = CFALockUtil.lockExistingForUpdate(LocalChangeTracker.this.context.getRoot(), LocalChangeTracker.this.context.getConnection(), LocalChangeTracker.this.context.getComponent(), (IProgressMonitor)progress.newChild(1));
                try {
                    long time = System.nanoTime();
                    long lastReq = this.lastRequest;
                    long remaining = (lastReq + 200000000L - time) / 1000000L;
                    if (remaining > 5L) {
                        this.schedule(remaining);
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    if (rule == null) return Status.OK_STATUS;
                    this.runRecompute((IProgressMonitor)progress.newChild(98));
                    return Status.OK_STATUS;
                }
                finally {
                    if (rule != null) {
                        CFALockUtil.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                    }
                    progress.done();
                }
            }
            catch (FileSystemClientException e) {
                return FileSystemStatus.getStatusFor((Throwable)((Object)e));
            }
        }

        public boolean belongsTo(Object family) {
            return family == CHANGES_COMPUTER_JOB_FAMILY;
        }

        public void requestRefresh() {
            this.lastRequest = System.nanoTime();
            if (this.getState() == 4) {
                this.cancel();
            }
            this.schedule(200L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runRecompute(IProgressMonitor monitor) throws FileSystemClientException {
            this.lastRecompute = System.nanoTime();
            LocalChangeTracker localChangeTracker = LocalChangeTracker.this;
            synchronized (localChangeTracker) {
                LocalChangeTracker.this.refreshPendingChanges(monitor);
            }
        }

        public void rejoin(IProgressMonitor monitor) {
            if (CFALockUtil.isLockedForUpdate(LocalChangeTracker.this.context.getRoot(), LocalChangeTracker.this.context.getComponent(), LocalChangeTracker.this.context.getConnection())) {
                this.cancel();
                if (this.lastRequest <= this.lastRecompute) {
                    return;
                }
                try {
                    this.runRecompute(monitor);
                }
                catch (FileSystemClientException e) {
                    LoggingHelper.log(e);
                }
            } else {
                while (true) {
                    if (this.getState() == 0) {
                        if (this.lastRequest <= this.lastRecompute) {
                            return;
                        }
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    try {
                        this.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

