/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileDownloadHandler;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileItemInfoProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.Shed;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileArea;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.load.DeferredUpdateInformation;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.EncodingDownloadFailure;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.NonCancellingProgressMonitor;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.client.internal.utils.SilentProgressMonitor;
import com.ibm.team.filesystem.client.operations.IDownloadListener;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.internal.repository.rcp.streams.DigestComputingInputStream;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.ContentManager;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeLoadMutator
extends FileSystemOperation {
    final IDownloadListener downloadMonitor;
    protected IFileContentManagerSession contentSession = null;
    private final IConnection connection;
    private IComponent component;
    private final IContextHandle connectionHandle;
    private final ISandbox sandbox;
    private final LoadTree loadTree;
    private final ITeamRepository repo;
    private Map<UUID, ILoadLocation> loadLocations;
    private LoadDilemmaHandler problemHandler;
    private Shed shed;

    public MergeLoadMutator(IConnection connection, IComponent component, ISandbox sandbox, List<LoadLocation> itemsToLoad, LoadTree loadTree, LoadDilemmaHandler loadProblemHandler, IDownloadListener downloadMonitor) {
        super(loadProblemHandler == null ? LoadDilemmaHandler.getDefault() : loadProblemHandler);
        LoadDilemmaHandler loadDilemmaHandler = this.problemHandler = loadProblemHandler == null ? LoadDilemmaHandler.getDefault() : loadProblemHandler;
        if (connection == null) {
            throw new IllegalArgumentException("Invalid connection");
        }
        if (component == null) {
            throw new IllegalArgumentException("Invalid component");
        }
        if (itemsToLoad == null) {
            throw new IllegalArgumentException("Invalid items to load");
        }
        if (loadTree == null) {
            throw new IllegalArgumentException("Invalid load tree");
        }
        this.connection = connection;
        this.component = component;
        this.repo = connection.teamRepository();
        this.sandbox = sandbox;
        this.loadTree = loadTree;
        this.loadLocations = new HashMap<UUID, ILoadLocation>();
        this.downloadMonitor = downloadMonitor;
        for (ILoadLocation iLoadLocation : itemsToLoad) {
            if (!component.sameItemId((IItemHandle)iLoadLocation.getComponent())) {
                throw new IllegalArgumentException("Items to be loaded not for component " + component.getName());
            }
            if (!sandbox.equals(iLoadLocation.getSandbox())) {
                throw new IllegalArgumentException("Items to be loaded must be for the same sandbox " + sandbox.getRoot().toString() + " and " + iLoadLocation.getSandbox().toString());
            }
            this.loadLocations.put(iLoadLocation.getRootToLoad().getItemId(), iLoadLocation);
        }
        this.connectionHandle = connection instanceof IWorkspaceConnection ? (IContextHandle)((IWorkspaceConnection)connection).getResolvedWorkspace().getItemHandle() : ((IBaselineConnection)connection).getBaseline();
        this.shed = new Shed(this.problemHandler.getBackupDilemmaHandler());
    }

    protected void beginning() throws TeamRepositoryException, FileSystemClientException {
    }

    @Override
    protected final void execute(IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        ThreadCheck.checkLongOpsAllowed();
        List updates = this.loadTree.getFileAreaUpdates();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)210);
        this.contentSession = FileSystemCore.getContentManager(this.repo).createSession("", true, updates.size(), (IProgressMonitor)progress.newChild(155));
        HashMap<UUID, IPath> foldersToVerify = new HashMap<UUID, IPath>();
        HashMap<UUID, HashMap<String, UUID>> allFolderChildren = new HashMap<UUID, HashMap<String, UUID>>();
        DeferredUpdateInformation[] pathsToUpdate = new DeferredUpdateInformation[updates.size()];
        HashSet<Shareable> linksToRefresh = new HashSet<Shareable>();
        HashSet<Shareable> linksToRecompute = new HashSet<Shareable>();
        ArrayList<IShareable> shares = new ArrayList<IShareable>();
        HashSet<IShareable> inconsistentShares = new HashSet<IShareable>();
        HashSet syncdChanges = new HashSet();
        LocalChangeManager localChangeManager = LocalChangeManager.getInstance();
        ICopyFileArea cfa = ICopyFileAreaManager.instance.getCopyFileAreaForPath(this.sandbox.getRoot());
        CancellationMonitor cMon = new CancellationMonitor((IProgressMonitor)progress);
        try {
            int i = -1;
            HashSet<Shareable> versionablesLoaded = new HashSet<Shareable>();
            for (FileAreaUpdate update : updates) {
                FileItemInfo proxy;
                boolean isDirty;
                boolean typesMatch;
                ResourceType shareableType;
                Shareable shareable;
                IPath path;
                Shareable parentShareable;
                Shareable shareableLoaded;
                this.checkCancelled(monitor);
                ++i;
                IComponentHandle componentHandle = update.getComponent();
                if (!componentHandle.sameItemId((IItemHandle)this.component)) {
                    this.collectStatus(new FileSystemStatus(4, NLS.bind((String)Messages.MergeLoadMutator_13, (Object)this.component.getName(), (Object[])new Object[0])));
                    break;
                }
                if (update.getChangeType() != 1) {
                    throw new IllegalStateException("Mutator is intended to only load new files/folders");
                }
                IVersionableHandle versionableState = update.afterState();
                ResourceType type = ResourceType.getResourceType(versionableState);
                boolean isShare = false;
                ILoadLocation loadLocation = this.loadLocations.get(update.getItem().getItemId());
                if (loadLocation != null) {
                    IShare share;
                    shareableLoaded = this.getExistingShareable(cfa, update.getItem(), (IProgressMonitor)cMon);
                    parentShareable = update.getDestinationParent() == null ? null : this.getExistingShareable(cfa, (IVersionableHandle)update.getDestinationParent(), (IProgressMonitor)cMon);
                    if (parentShareable == null) {
                        isShare = true;
                        path = loadLocation.getLoadPath();
                        shareable = new Shareable(this.sandbox, path, type);
                        Shareable localParent = (Shareable)shareable.getParent();
                        if (localParent != null && !localParent.exists((IProgressMonitor)progress.newChild(1))) {
                            SharingManager.getInstance().disableChangeMonitoring();
                            try {
                                localParent.getFileStorage().create(true, (IProgressMonitor)cMon);
                            }
                            finally {
                                SharingManager.getInstance().enableChangeMonitoring();
                            }
                        }
                    } else {
                        path = parentShareable.getLocalPath().append(update.getName());
                        shareable = new Shareable(this.sandbox, path, type);
                    }
                    ArrayList<IShare> sharesToRefresh = new ArrayList<IShare>(2);
                    if (shareable.exists((IProgressMonitor)cMon) && (share = shareable.getShare((IProgressMonitor)cMon)) != null && !syncdChanges.contains(share.getShareable())) {
                        sharesToRefresh.add(share);
                    }
                    if (shareableLoaded != null && (share = shareableLoaded.getShare((IProgressMonitor)cMon)) != null && !syncdChanges.contains(share.getShareable())) {
                        sharesToRefresh.add(share);
                    }
                    if (!sharesToRefresh.isEmpty()) {
                        localChangeManager.refreshChanges(sharesToRefresh.toArray(new IShare[sharesToRefresh.size()]), ILocalChangeManager.RefreshType.TRAVERSE_ALL_KNOWN, (IProgressMonitor)cMon);
                    }
                } else {
                    shareableLoaded = this.getExistingShareable(cfa, update.getItem(), (IProgressMonitor)cMon);
                    parentShareable = this.getExistingShareable(cfa, (IVersionableHandle)update.getDestinationParent(), (IProgressMonitor)cMon);
                    if (parentShareable == null) {
                        this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.MergeLoadMutator_19, (Object)update.getName(), (Object[])new Object[0]), null));
                        if (shareableLoaded == null) continue;
                        MergeLoadMutator.deleteSubtree(shareableLoaded, type, this.shed, (IProgressMonitor)cMon);
                        shareableLoaded.forget((IProgressMonitor)cMon);
                        continue;
                    }
                    path = parentShareable.getLocalPath().append(update.getName());
                    shareable = new Shareable(this.sandbox, path, type);
                    HashMap<String, UUID> contents = allFolderChildren.get(update.getDestinationParent().getItemId());
                    if (contents != null) {
                        contents.put(update.getName(), update.getItem().getItemId());
                    }
                }
                if (isShare) {
                    shares.add(shareable);
                }
                if (shareableLoaded != null) {
                    if (isShare != shareableLoaded.isShare((IProgressMonitor)cMon)) {
                        MergeLoadMutator.deleteSubtree(shareableLoaded, type, this.shed, (IProgressMonitor)cMon);
                        shareableLoaded.forget((IProgressMonitor)cMon);
                    } else {
                        IShareable existingParent = shareableLoaded.getParent();
                        if (existingParent == null && parentShareable != null || existingParent != null && !update.parent().sameItemId((IItemHandle)existingParent.getRemote((IProgressMonitor)cMon)) || !shareable.getLocalPath().lastSegment().equals(shareableLoaded.getLocalPath().lastSegment())) {
                            MergeLoadMutator.deleteSubtree(shareableLoaded, type, this.shed, (IProgressMonitor)cMon);
                            shareableLoaded.forget((IProgressMonitor)cMon);
                        }
                    }
                } else {
                    SharingManager.getInstance().forget(this.sandbox.getRoot(), this.connectionHandle, (IComponentHandle)this.component, update.getItem(), (IProgressMonitor)cMon);
                }
                if (!this.sandbox.isCaseSensitive()) {
                    if (versionablesLoaded.contains(shareable)) {
                        IShare share = shareable.getShare((IProgressMonitor)cMon);
                        if (share == null) {
                            inconsistentShares.add(shareable);
                        } else {
                            inconsistentShares.add(share.getShareable());
                        }
                        this.collectStatus(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.MergeLoadMutator_20, (Object)path, (Object[])new Object[0]), null));
                        continue;
                    }
                    versionablesLoaded.add(shareable);
                }
                if ((shareableType = shareable.getResourceType((IProgressMonitor)cMon)) == null) {
                    if (type == ResourceType.FOLDER) {
                        this.createNewFolder(cfa, isShare, shareable, update, (IProgressMonitor)cMon);
                        if (update.getDestinationParent() != null && allFolderChildren.containsKey(update.getDestinationParent().getItemId())) {
                            allFolderChildren.put(versionableState.getItemId(), new HashMap());
                        }
                        this.contentSession.decrementTransferCount(1L);
                        continue;
                    }
                    if (type == ResourceType.FILE) {
                        pathsToUpdate[i] = new DeferredUpdateInformation(this.sandbox, path, update, isShare);
                        this.createNewFile(pathsToUpdate[i], (IProgressMonitor)cMon);
                        continue;
                    }
                    if (type != ResourceType.SYMBOLIC_LINK) continue;
                    this.createNewLink(cfa, isShare, shareable, update, linksToRefresh, linksToRecompute, (IProgressMonitor)cMon);
                    this.contentSession.decrementTransferCount(1L);
                    continue;
                }
                IVersionableHandle oldVersionable = shareable.getRemote((IProgressMonitor)cMon);
                boolean bl = typesMatch = shareableType == type;
                if (!(typesMatch && (oldVersionable == null || versionableState.sameItemId((IItemHandle)oldVersionable)) && (this.sandbox.isCaseSensitive() || shareable.getFileStorage().storageExists((IProgressMonitor)cMon) && update.getName().equals(shareable.getFileStorage().getActualName())))) {
                    MergeLoadMutator.deleteSubtree(shareable, shareableType, this.shed, (IProgressMonitor)cMon);
                    shareable.forget((IProgressMonitor)cMon);
                    if (!this.sandbox.isCaseSensitive() && !update.getName().equals(shareable.getFileStorage().getActualName())) {
                        shareable = new Shareable(shareable.getSandbox(), path, type);
                    }
                    if (type == ResourceType.FOLDER) {
                        this.createNewFolder(cfa, isShare, shareable, update, (IProgressMonitor)cMon);
                        if (update.getDestinationParent() != null && allFolderChildren.containsKey(update.getDestinationParent().getItemId())) {
                            allFolderChildren.put(versionableState.getItemId(), new HashMap());
                        }
                        this.contentSession.decrementTransferCount(1L);
                        continue;
                    }
                    if (type == ResourceType.FILE) {
                        pathsToUpdate[i] = new DeferredUpdateInformation(this.sandbox, path, update, isShare);
                        this.createNewFile(pathsToUpdate[i], (IProgressMonitor)cMon);
                        continue;
                    }
                    if (type != ResourceType.SYMBOLIC_LINK) continue;
                    this.createNewLink(cfa, isShare, shareable, update, linksToRefresh, linksToRecompute, (IProgressMonitor)cMon);
                    this.contentSession.decrementTransferCount(1L);
                    continue;
                }
                boolean bl2 = isDirty = !versionableState.sameStateId((IItemHandle)oldVersionable);
                if (type == ResourceType.FILE) {
                    isDirty |= localChangeManager.isContentDirty(shareable, (IProgressMonitor)cMon);
                    ILocalChange change = localChangeManager.getPendingChange(shareable, (IProgressMonitor)cMon);
                    isDirty |= change != null && change.getType() != 0;
                } else if (type == ResourceType.FOLDER) {
                    foldersToVerify.put(versionableState.getItemId(), path);
                    allFolderChildren.put(versionableState.getItemId(), new HashMap());
                } else if (type == ResourceType.SYMBOLIC_LINK) {
                    String oldLinkTarget;
                    String linkTarget = update.getLinkTarget();
                    boolean bl3 = isDirty = !linkTarget.equals(oldLinkTarget = shareable.getFileStorage().getTarget((IProgressMonitor)cMon));
                }
                if (isDirty) {
                    if (isShare) {
                        FileItemInfo proxy2;
                        SharingDescriptor descriptor = new SharingDescriptor(this.repo.getRepositoryURI(), this.repo.getId(), this.connection, componentHandle, this.component.getName(), versionableState);
                        if (type == ResourceType.FOLDER) {
                            proxy2 = new FileItemInfoProxy((IVersionableHandle)((IFolderHandle)versionableState), update.getDestinationParent(), update.getName(), PathUtils.isLoadedWithAnotherName(this.sandbox, path, update.getName())).getFileItemInfo();
                            SharingManager.getInstance().share(shareable, descriptor, proxy2, 2, (IProgressMonitor)cMon);
                            this.contentSession.decrementTransferCount(1L);
                            continue;
                        }
                        if (type == ResourceType.FILE) {
                            proxy2 = cfa.getItemInfo(path);
                            SharingManager.getInstance().share(shareable, descriptor, proxy2, 2, (IProgressMonitor)cMon);
                            pathsToUpdate[i] = new DeferredUpdateInformation(this.sandbox, path, update, false, this.loadLocations.containsKey(update.getItem().getItemId()));
                            this.modifyFile(shareable, pathsToUpdate[i], (IProgressMonitor)cMon);
                            continue;
                        }
                        if (type != ResourceType.SYMBOLIC_LINK) continue;
                        this.modifyLink(cfa, isShare, versionableState, update, shareable, this.loadLocations.containsKey(update.getItem().getItemId()), linksToRefresh, linksToRecompute, (IProgressMonitor)cMon);
                        continue;
                    }
                    if (type == ResourceType.FOLDER) {
                        proxy = new FileItemInfoProxy((IVersionableHandle)((IFolderHandle)versionableState), update.getDestinationParent(), update.getName()).getFileItemInfo();
                        cfa.setItemMetaData(shareable.getLocalPath(), proxy, (IProgressMonitor)cMon);
                        this.contentSession.decrementTransferCount(1L);
                        continue;
                    }
                    if (type == ResourceType.FILE) {
                        pathsToUpdate[i] = new DeferredUpdateInformation(this.sandbox, path, update, isShare, this.loadLocations.containsKey(update.getItem().getItemId()));
                        this.modifyFile(shareable, pathsToUpdate[i], (IProgressMonitor)cMon);
                        continue;
                    }
                    if (type != ResourceType.SYMBOLIC_LINK) continue;
                    this.modifyLink(cfa, isShare, versionableState, update, shareable, this.loadLocations.containsKey(update.getItem().getItemId()), linksToRefresh, linksToRecompute, (IProgressMonitor)cMon);
                    linksToRefresh.add(shareable);
                    continue;
                }
                if (isShare) {
                    proxy = cfa.getItemInfo(path);
                    assert (proxy != null);
                    SharingDescriptor descriptor = new SharingDescriptor(this.repo.getRepositoryURI(), this.repo.getId(), this.connection, componentHandle, this.component.getName(), versionableState);
                    SharingManager.getInstance().share(shareable, descriptor, proxy, 2, (IProgressMonitor)cMon);
                    this.contentSession.decrementTransferCount(1L);
                    continue;
                }
                this.contentSession.decrementTransferCount(1L);
            }
        }
        finally {
            this.contentSession.join();
            try {
                if (!progress.isCanceled()) {
                    this.doDilemmaHandling(pathsToUpdate, (IProgressMonitor)progress.newChild(10));
                }
            }
            finally {
                if (progress.isCanceled()) {
                    progress.subTask(Messages.MergeLoadMutator_11);
                } else if (this.component != null) {
                    progress.subTask(NLS.bind((String)Messages.MergeLoadMutator_12, (Object)this.component.getName(), (Object[])new Object[0]));
                } else {
                    progress.subTask(Messages.MergeLoadMutator_10);
                }
                this.updateContentLoadedMetaData(cfa, pathsToUpdate, updates, (IProgressMonitor)new NonCancellingProgressMonitor((IProgressMonitor)progress.newChild(25)));
                this.refreshLinks(linksToRefresh, linksToRecompute, (IProgressMonitor)new NonCancellingProgressMonitor((IProgressMonitor)progress.newChild(5)));
            }
        }
        IStatus[] failures = this.getDownloadFailures(pathsToUpdate);
        if (failures.length > 0) {
            boolean seriousFailure = false;
            IStatus[] iStatusArray = failures;
            int n = failures.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus failure = iStatusArray[n2];
                if (failure.getSeverity() == 4 || failure.getSeverity() == 8) {
                    seriousFailure = true;
                }
                this.collectStatus(failure);
                ++n2;
            }
            if (seriousFailure) {
                failures = this.getErrors();
                RepositoryUtils.throwAppropriateException(Messages.MergeLoadMutator_4, failures);
            }
        } else if (this.contentSession.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.removeExtraneousContent(cfa, shares, foldersToVerify, allFolderChildren, (IProgressMonitor)progress.newChild(5));
        this.removeExtraneousMetadata(cfa, allFolderChildren, (IProgressMonitor)progress.newChild(5));
        SubMonitor iterProgress = progress.newChild(5);
        iterProgress.setWorkRemaining(shares.size());
        ISyncTime syncTime = ISyncTime.FACTORY.createFrom(this.loadTree.getConfigurationState());
        for (IShareable shareInfo : shares) {
            if (inconsistentShares.contains(shareInfo)) continue;
            cfa.setConfigurationState(this.connectionHandle, (IComponentHandle)this.component, shareInfo.getLocalPath(), syncTime, (IProgressMonitor)iterProgress.newChild(1));
        }
        progress.done();
    }

    private void removeExtraneousMetadata(ICopyFileArea cfa, HashMap<UUID, HashMap<String, UUID>> allFolderChildren, IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)allFolderChildren.size());
        for (Map.Entry<UUID, HashMap<String, UUID>> entry : allFolderChildren.entrySet()) {
            SubMonitor subProgress = monitor.newChild(1);
            IFolderHandle folderHandle = (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle((Object)this.repo, entry.getKey(), null);
            HashMap<String, UUID> namesOfChildrenLoaded = entry.getValue();
            InverseFileItemInfo info = cfa.getItemInfo((IVersionableHandle)folderHandle, (IComponentHandle)this.component, this.connectionHandle);
            if (info != null) {
                HashMap<String, IVersionableHandle> children = new HashMap<String, IVersionableHandle>(info.getRemoteChildren());
                subProgress.setWorkRemaining(children.size());
                for (Map.Entry child : children.entrySet()) {
                    UUID childLoaded = namesOfChildrenLoaded.get(child.getKey());
                    if (childLoaded != null && ((IVersionableHandle)child.getValue()).getItemId().equals((Object)childLoaded)) continue;
                    cfa.forget(this.connectionHandle, (IComponentHandle)this.component, (IVersionableHandle)child.getValue(), (IProgressMonitor)subProgress.newChild(1));
                }
            }
            subProgress.done();
        }
    }

    private void removeExtraneousContent(ICopyFileArea cfa, ArrayList<IShareable> shares, HashMap<UUID, IPath> foldersToVerify, HashMap<UUID, HashMap<String, UUID>> allFolderChildren, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)foldersToVerify.size());
        for (Map.Entry<UUID, IPath> entry : foldersToVerify.entrySet()) {
            IPath parentFolder = entry.getValue();
            HashMap<String, Object> expectedContents = allFolderChildren.get(entry.getKey());
            if (expectedContents == null) {
                expectedContents = new HashMap();
            }
            ArrayList<Shareable> actualContents = Collections.EMPTY_LIST;
            File folder = this.sandbox.getRoot().append(parentFolder).toFile();
            File[] members = folder.listFiles();
            if (members != null) {
                actualContents = new ArrayList<Shareable>(members.length);
                int i = 0;
                while (i < members.length) {
                    actualContents.add(SharingManager.getInstance().findShareable(this.sandbox, parentFolder.append(members[i].getName()), members[i].isDirectory() ? ResourceType.FOLDER : ResourceType.FILE));
                    ++i;
                }
            }
            SubMonitor subProgress = monitor.newChild(1);
            subProgress.setWorkRemaining(actualContents.size());
            for (IShareable iShareable : actualContents) {
                SubMonitor subSubProgress = subProgress.newChild(1);
                subSubProgress.setWorkRemaining(100);
                if (expectedContents.containsKey(iShareable.getLocalPath().lastSegment())) continue;
                cfa.forget(iShareable.getLocalPath(), (IProgressMonitor)subSubProgress.newChild(40));
                if (iShareable.shouldBeIgnored((IProgressMonitor)subSubProgress.newChild(10))) continue;
                if (!this.isSpecialCase(iShareable, (IProgressMonitor)subSubProgress.newChild(1))) {
                    MergeLoadMutator.deleteSubtree((Shareable)iShareable, iShareable.getResourceType((IProgressMonitor)subSubProgress.newChild(1)), this.shed, (IProgressMonitor)subSubProgress.newChild(48));
                    continue;
                }
                LocalChangeManager.getInstance().computeChanges(iShareable, (IProgressMonitor)subSubProgress.newChild(49));
            }
        }
    }

    private void doDilemmaHandling(DeferredUpdateInformation[] pathsToUpdate, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(100);
        ArrayList<EncodingDownloadFailure> encodingFailures = new ArrayList<EncodingDownloadFailure>();
        DeferredUpdateInformation[] deferredUpdateInformationArray = pathsToUpdate;
        int n = pathsToUpdate.length;
        int n2 = 0;
        while (n2 < n) {
            DeferredUpdateInformation deferredUpdateInformation = deferredUpdateInformationArray[n2];
            if (deferredUpdateInformation != null && deferredUpdateInformation.getFailure() != null) {
                Throwable rootCause = deferredUpdateInformation.getFailure().getCause();
                int digParanoiaCount = 0;
                while (rootCause instanceof TeamRepositoryException && digParanoiaCount < 50) {
                    Throwable cause = ((TeamRepositoryException)rootCause).getCause();
                    if (cause == null) break;
                    rootCause = cause;
                    ++digParanoiaCount;
                }
                if (rootCause instanceof UnsupportedEncodingException || rootCause instanceof UnsupportedCharsetException) {
                    encodingFailures.add(new EncodingDownloadFailure(deferredUpdateInformation));
                } else if (rootCause instanceof CharacterCodingException) {
                    encodingFailures.add(new EncodingDownloadFailure(deferredUpdateInformation));
                } else if (rootCause instanceof OperationCanceledException) {
                    throw new OperationCanceledException();
                }
            }
            ++n2;
        }
        if (encodingFailures.size() > 0) {
            for (EncodingDownloadFailure failure : encodingFailures) {
                failure.setIgnoreEncoding(true);
            }
            boolean moreContentUploaded = false;
            this.contentSession = FileSystemCore.getContentManager(this.repo).createSession("", true, encodingFailures.size(), (IProgressMonitor)progress.newChild(75));
            try {
                for (EncodingDownloadFailure failure : encodingFailures) {
                    if (!failure.hasDirection()) continue;
                    DeferredUpdateInformation info = (DeferredUpdateInformation)failure.getDeferredUpdateInformation();
                    IVersionableHandle fileItemState = info.getFileItemState();
                    this.contentSession.retrieveContent((IFileItemHandle)fileItemState, info.getContent(), info.getEncoding(), info.getLineDelimiter(), new DownloadHandler(info, this));
                    moreContentUploaded = true;
                }
            }
            finally {
                if (moreContentUploaded) {
                    this.contentSession.join();
                }
            }
            SubMonitor iterProgress = progress.newChild(25);
            iterProgress.setWorkRemaining(encodingFailures.size());
            for (EncodingDownloadFailure failure : encodingFailures) {
                if (!failure.getDeferredUpdateInformation().isLineDelimiterIgnored() || failure.getDeferredUpdateInformation().getFailure() != null) continue;
                failure.getDeferredUpdateInformation().convert((IProgressMonitor)iterProgress.newChild(1));
            }
        }
    }

    protected void createNewLink(ICopyFileArea copyFileArea, boolean isShare, Shareable shareable, FileAreaUpdate update, HashSet<Shareable> linksToRefresh, HashSet<Shareable> linksToRecompute, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.setTaskName(Messages.MergeLoadMutator_15);
        ISandbox sandbox = shareable.getSandbox();
        IPath path = shareable.getLocalPath();
        final String target = update.getLinkTarget();
        try {
            final IFileStorage fileStorage = shareable.getFileStorage();
            if (fileStorage != null) {
                if (ManagedFileStore.supportsSymLinks()) {
                    SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                        public void run() throws CoreException {
                            fileStorage.create(target == null ? "" : target, (IProgressMonitor)progress.newChild(1));
                        }
                    });
                    linksToRefresh.add(shareable);
                    if (this.downloadMonitor != null) {
                        this.downloadMonitor.downloadStarted(path, 0L);
                    }
                } else {
                    linksToRecompute.add(shareable);
                    this.collectStatus(FileSystemStatus.getStatusFor(1, NLS.bind((String)Messages.MergeLoadMutator_21, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{target}), null));
                }
                ISymbolicLinkHandle versionableState = (ISymbolicLinkHandle)update.afterState();
                if (isShare) {
                    FileItemInfoProxy proxy = new FileItemInfoProxy((IVersionableHandle)versionableState, update.parent(), update.getName(), PathUtils.isLoadedWithAnotherName(sandbox, path, update.getName()));
                    proxy.setTarget(fileStorage.getModificationStamp(), target);
                    SharingDescriptor descriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)this.component, this.component.getName(), (IVersionableHandle)versionableState);
                    SharingManager.getInstance().share(shareable, descriptor, proxy.getFileItemInfo(), 2, (IProgressMonitor)progress.newChild(1));
                } else {
                    FileItemInfo parentInfo = copyFileArea.getItemInfo(path.removeLastSegments(1));
                    FileItemInfoProxy proxy = new FileItemInfoProxy((IVersionableHandle)versionableState, (IFolderHandle)parentInfo.getVersionableHandle(), update.getName());
                    proxy.setTarget(fileStorage.getModificationStamp(), target);
                    copyFileArea.setItemMetaData(shareable.getLocalPath(), proxy.getFileItemInfo(), (IProgressMonitor)progress.newChild(1));
                }
            }
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.MergeLoadMutator_16, (Object)path, (Object[])new Object[0]), (Throwable)e));
        }
        monitor.done();
        this.checkCancelled(monitor);
    }

    private void modifyLink(ICopyFileArea copyFileArea, boolean isShare, IVersionableHandle symbolicLinkHandle, FileAreaUpdate updateInfo, Shareable shareable, boolean isUndo, HashSet<Shareable> linksToRefresh, HashSet<Shareable> linksToRecompute, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        String linkTarget = updateInfo.getLinkTarget();
        this.shed.forceBackup(shareable, (IProgressMonitor)monitor);
        if (ManagedFileStore.supportsSymLinks()) {
            SharingManager.getInstance().disableChangeMonitoring();
            try {
                shareable.getFileStorage().setTarget(this.shed, linkTarget == null ? "" : linkTarget, (IProgressMonitor)monitor.newChild(50));
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
            linksToRefresh.add(shareable);
        } else {
            linksToRecompute.add(shareable);
            this.collectStatus(FileSystemStatus.getStatusFor(1, NLS.bind((String)Messages.MergeLoadMutator_22, (Object)shareable.getLocalPath().toString(), (Object[])new Object[]{linkTarget}), null));
        }
        InverseFileItemInfo oldInfo = copyFileArea.getItemInfo(symbolicLinkHandle, (IComponentHandle)this.component, this.connectionHandle);
        IFolderHandle parent = null;
        String name = null;
        boolean loadedWithAnotherName = false;
        if (isUndo && oldInfo != null) {
            parent = oldInfo.getParent();
            name = oldInfo.getName();
            loadedWithAnotherName = oldInfo.isLoadedWithAnotherName();
        } else {
            parent = updateInfo.parent();
            name = updateInfo.getName();
            if (isShare) {
                loadedWithAnotherName = PathUtils.isLoadedWithAnotherName(shareable.getSandbox(), shareable.getLocalPath(), name);
            }
        }
        FileItemInfoProxy newInfoProxy = new FileItemInfoProxy(symbolicLinkHandle, parent, name, loadedWithAnotherName);
        newInfoProxy.setTarget(shareable.getFileStorage().getModificationStamp(), linkTarget);
        FileItemInfo newInfo = newInfoProxy.getFileItemInfo();
        if (isShare) {
            SharingDescriptor descriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)this.component, this.component.getName(), symbolicLinkHandle);
            SharingManager.getInstance().share(shareable, descriptor, newInfo, 2, (IProgressMonitor)monitor.newChild(10));
        } else {
            copyFileArea.setItemMetaData(shareable.getLocalPath(), newInfo, (IProgressMonitor)monitor.newChild(10));
        }
    }

    protected boolean isSpecialCase(IShareable shareable, IProgressMonitor monitor) throws FileSystemClientException {
        return false;
    }

    private IStatus[] getDownloadFailures(DeferredUpdateInformation[] pathsToUpdate) {
        ArrayList<Status> errors = new ArrayList<Status>();
        boolean reportedSupportedCharSets = false;
        DeferredUpdateInformation[] deferredUpdateInformationArray = pathsToUpdate;
        int n = pathsToUpdate.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                Status status;
                DeferredUpdateInformation deferredUpdateInformation;
                block8: {
                    block10: {
                        Throwable rootCause;
                        block11: {
                            block9: {
                                deferredUpdateInformation = deferredUpdateInformationArray[n2];
                                if (deferredUpdateInformation == null) break block7;
                                if (deferredUpdateInformation.getFailure() == null) break block8;
                                rootCause = deferredUpdateInformation.getFailure().getCause();
                                int paranoiaCount = 0;
                                while (rootCause instanceof TeamRepositoryException && paranoiaCount < 50) {
                                    Throwable cause = ((TeamRepositoryException)rootCause).getCause();
                                    if (cause == null) break;
                                    rootCause = cause;
                                    ++paranoiaCount;
                                }
                                if (!(rootCause instanceof UnsupportedEncodingException) && !(rootCause instanceof UnsupportedCharsetException)) break block9;
                                if (!reportedSupportedCharSets) {
                                    StringBuffer charSetsAvailable = new StringBuffer();
                                    for (String charsetName : Charset.availableCharsets().keySet()) {
                                        charSetsAvailable.append(charsetName).append(' ');
                                    }
                                    Status infoStatus = new Status(1, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.MergeLoadMutator_3, (Object)charSetsAvailable.toString(), (Object[])new Object[0]));
                                    errors.add(infoStatus);
                                    reportedSupportedCharSets = true;
                                }
                                status = new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.MergeLoadMutator_5, (Object)deferredUpdateInformation.getPath().toString(), (Object[])new Object[]{deferredUpdateInformation.getContent().getCharacterEncoding()}), (Throwable)deferredUpdateInformation.getFailure());
                                break block10;
                            }
                            if (!(rootCause instanceof CharacterCodingException)) break block11;
                            status = new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.MergeLoadMutator_1, (Object)deferredUpdateInformation.getPath().toString(), (Object[])new Object[]{deferredUpdateInformation.getContent().getCharacterEncoding()}), (Throwable)deferredUpdateInformation.getFailure());
                            break block10;
                        }
                        if (rootCause instanceof OperationCanceledException) break block7;
                        status = new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.MergeLoadMutator_6, (Object)deferredUpdateInformation.getPath(), (Object[])new Object[0]), (Throwable)deferredUpdateInformation.getFailure());
                    }
                    errors.add(status);
                    break block7;
                }
                if (deferredUpdateInformation.isLineDelimiterIgnored()) {
                    IFileContent contentInfo = deferredUpdateInformation.getFileAreaUpdate().getOptionalContent();
                    status = new Status(2, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.MergeLoadMutator_23, (Object)deferredUpdateInformation.getPath().toString(), (Object[])new Object[]{contentInfo.getCharacterEncoding(), contentInfo.getLineDelimiter().toString()}));
                    errors.add(status);
                }
            }
            ++n2;
        }
        return errors.toArray(new IStatus[errors.size()]);
    }

    private void updateContentLoadedMetaData(ICopyFileArea cfa, DeferredUpdateInformation[] pathsToUpdate, List<FileAreaUpdate> updates, IProgressMonitor progress) throws FileSystemClientException {
        Shareable shareable;
        FileAreaUpdate update;
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)progress, (int)(pathsToUpdate.length * 2 + 10));
        Shareable[] shareablesForUpdate = new Shareable[pathsToUpdate.length];
        int i = 0;
        while (i < pathsToUpdate.length) {
            if (pathsToUpdate[i] == null || !pathsToUpdate[i].contentUpdated()) {
                subProgress.worked(1);
            } else {
                update = updates.get(i);
                shareablesForUpdate[i] = shareable = new Shareable(pathsToUpdate[i].getSandbox(), pathsToUpdate[i].getPath(), ResourceType.getResourceType(update.afterState()));
                this.refresh(shareable, 0, (IProgressMonitor)subProgress.newChild(1));
            }
            ++i;
        }
        i = 0;
        while (i < pathsToUpdate.length) {
            if (pathsToUpdate[i] == null || !pathsToUpdate[i].contentUpdated()) {
                subProgress.worked(1);
            } else {
                update = updates.get(i);
                shareable = shareablesForUpdate[i];
                if (shareable == null) {
                    shareablesForUpdate[i] = shareable = new Shareable(pathsToUpdate[i].getSandbox(), pathsToUpdate[i].getPath(), ResourceType.getResourceType(update.afterState()));
                }
                this.updateMetaInfoForPath(cfa, update.getComponent(), update.afterState(), shareable, pathsToUpdate[i], (IProgressMonitor)subProgress.newChild(1));
            }
            ++i;
        }
        this.contentLoadCompleted((IProgressMonitor)subProgress.newChild(10));
        subProgress.done();
    }

    private void refreshLinks(Set<Shareable> linksToRefresh, HashSet<Shareable> linksToRecompute, IProgressMonitor progress) {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)(linksToRefresh.size() + linksToRecompute.size()));
        for (Shareable shareable : linksToRefresh) {
            try {
                new Shareable(shareable.getSandbox(), shareable.getLocalPath(), ResourceType.SYMBOLIC_LINK).getFileStorage().refreshCachedSubTree(Integer.MAX_VALUE, (IProgressMonitor)monitor.newChild(1));
            }
            catch (FileSystemClientException fileSystemClientException) {}
        }
        LocalChangeManager lcm = LocalChangeManager.getInstance();
        for (Shareable shareable : linksToRecompute) {
            try {
                lcm.computeChanges(shareable, (IProgressMonitor)monitor.newChild(1));
            }
            catch (FileSystemClientException fileSystemClientException) {}
        }
    }

    private void refresh(Shareable shareable, final int depth, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final IFileStorage file = shareable.getFileStorage();
        if (file != null) {
            try {
                SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                    public void run() throws CoreException {
                        file.refreshCachedSubTree(depth, (IProgressMonitor)new SilentProgressMonitor((IProgressMonitor)progress.newChild(100)));
                    }
                });
            }
            catch (CoreException e) {
                this.collectStatus(FileSystemStatus.getStatusFor(e));
            }
        }
    }

    private void updateMetaInfoForPath(ICopyFileArea copyFileArea, IComponentHandle componentHandle, IVersionableHandle fileItem, Shareable shareable, DeferredUpdateInformation updateInfo, IProgressMonitor monitor) throws FileSystemClientException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)new NonCancellingProgressMonitor(monitor), (int)100);
        IFileStorage file = shareable.getFileStorage();
        InverseFileItemInfo oldInfo = copyFileArea.getItemInfo(fileItem, componentHandle, this.connectionHandle);
        IFolderHandle parent = null;
        String name = null;
        boolean loadedWithAnotherName = false;
        if (updateInfo.isUndo()) {
            parent = oldInfo.getParent();
            name = oldInfo.getName();
            loadedWithAnotherName = oldInfo.isLoadedWithAnotherName();
        } else {
            parent = updateInfo.getRemoteParent();
            name = updateInfo.getRemoteName();
            if (updateInfo.isShare()) {
                loadedWithAnotherName = PathUtils.isLoadedWithAnotherName(shareable.getSandbox(), updateInfo.getPath(), name);
            }
        }
        FileContent content = (FileContent)updateInfo.getContent();
        FileItemInfoProxy newInfoProxy = new FileItemInfoProxy(fileItem, parent, name, loadedWithAnotherName);
        newInfoProxy.setContentInfo(file.getModificationStamp(), updateInfo.getHash(), updateInfo.getContentSize(), content);
        newInfoProxy.setExecutable(updateInfo.isExecutable(), updateInfo.isExecutable());
        newInfoProxy.setProperties(updateInfo.getFileAreaUpdate().getProperties());
        FileItemInfo newInfo = newInfoProxy.getFileItemInfo();
        if (updateInfo.isShare()) {
            SharingDescriptor descriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)this.component, this.component.getName(), fileItem);
            SharingManager.getInstance().share(shareable, descriptor, newInfo, 2, (IProgressMonitor)progress.newChild(10));
        } else {
            copyFileArea.setItemMetaData(updateInfo.getPath(), newInfo, (IProgressMonitor)progress.newChild(10));
        }
        file.setExecutable(updateInfo.isExecutable(), (IProgressMonitor)progress.newChild(10));
        this.contentLoadCompleted(shareable, (IProgressMonitor)progress.newChild(30));
        progress.done();
    }

    protected void contentLoadCompleted(Shareable shareable, IProgressMonitor progress) throws FileSystemClientException {
    }

    protected void contentLoadCompleted(IProgressMonitor progress) throws FileSystemClientException {
    }

    private Shareable getExistingShareable(ICopyFileArea copyFileArea, IVersionableHandle item, IProgressMonitor monitor) throws FileSystemClientException {
        IPath path = copyFileArea.getLocalPathFor(this.connectionHandle, (IComponentHandle)this.component, item, monitor);
        return path == null ? null : new Shareable(this.sandbox, path, ResourceType.getResourceType(item));
    }

    protected void createNewFile(DeferredUpdateInformation deferredUpdateInformation, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        if (deferredUpdateInformation.getContent() != null) {
            this.contentSession.retrieveContent((IFileItemHandle)deferredUpdateInformation.getFileItemState(), deferredUpdateInformation.getContent(), new DownloadHandler(deferredUpdateInformation, this));
        } else {
            this.storeFileContents(deferredUpdateInformation.getSandbox().getRoot(), deferredUpdateInformation.getPath(), deferredUpdateInformation.getContent(), new ByteArrayInputStream(new byte[0]));
        }
    }

    protected void createNewFolder(ICopyFileArea copyFileArea, boolean isShare, Shareable shareable, FileAreaUpdate update, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        progress.setTaskName(Messages.MergeLoadMutator_15);
        ISandbox sandbox = shareable.getSandbox();
        IPath path = shareable.getLocalPath();
        try {
            final IFileStorage fileStorage = shareable.getFileStorage();
            if (fileStorage != null) {
                SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                    public void run() throws CoreException {
                        fileStorage.create(false, (IProgressMonitor)progress.newChild(1));
                    }
                });
                IFolderHandle versionableState = (IFolderHandle)update.afterState();
                if (isShare) {
                    FileItemInfo proxy = new FileItemInfoProxy((IVersionableHandle)versionableState, update.parent(), update.getName(), PathUtils.isLoadedWithAnotherName(sandbox, path, update.getName())).getFileItemInfo();
                    SharingDescriptor descriptor = new SharingDescriptor(this.connection.teamRepository().getRepositoryURI(), this.connection.teamRepository().getId(), this.connection, (IComponentHandle)this.component, this.component.getName(), (IVersionableHandle)versionableState);
                    SharingManager.getInstance().share(shareable, descriptor, proxy, 2, (IProgressMonitor)progress.newChild(1));
                } else {
                    FileItemInfo parentInfo = copyFileArea.getItemInfo(path.removeLastSegments(1));
                    FileItemInfo proxy = new FileItemInfoProxy((IVersionableHandle)versionableState, (IFolderHandle)parentInfo.getVersionableHandle(), update.getName()).getFileItemInfo();
                    copyFileArea.setItemMetaData(shareable.getLocalPath(), proxy, (IProgressMonitor)progress.newChild(1));
                }
            }
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.MergeLoadMutator_16, (Object)path, (Object[])new Object[0]), (Throwable)e));
        }
        monitor.done();
        this.checkCancelled(monitor);
    }

    protected static void deleteSubtree(final Shareable shareable, final ResourceType typeHint, final Shed backupShed, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        final SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        try {
            SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                public void run() throws CoreException {
                    IFileStorage fileStorage = null;
                    if (shareable.getFileStorage().storageExists((IProgressMonitor)monitor.newChild(1))) {
                        fileStorage = shareable.getFileStorage();
                    } else if (!shareable.getSandbox().isCaseSensitive()) {
                        IFileStorage parentStorage = shareable.getFileStorage().getParent();
                        if (parentStorage != null) {
                            fileStorage = parentStorage.getChild(shareable.getLocalPath().lastSegment(), (IProgressMonitor)monitor.newChild(1));
                        } else {
                            IPath parentPath = shareable.getFullPath().removeLastSegments(1);
                            File parentFile = parentPath.toFile();
                            String[] childrenNames = parentFile.list();
                            if (childrenNames != null) {
                                String name = shareable.getLocalPath().lastSegment().toUpperCase().toLowerCase();
                                String[] stringArray = childrenNames;
                                int n = childrenNames.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Shareable realShareable;
                                    String childName = stringArray[n2];
                                    if (childName.length() == name.length() && childName.toUpperCase().toLowerCase().equals(name) && (realShareable = (Shareable)SharingManager.getInstance().findShareable(parentPath.append(childName), typeHint)) != null) {
                                        fileStorage = realShareable.getFileStorage();
                                    }
                                    ++n2;
                                }
                            }
                        }
                    }
                    if (fileStorage == null) {
                        fileStorage = SharingManager.getInstance().getLocalFileStorage(shareable.getSandbox(), shareable.getLocalPath(), typeHint);
                    }
                    try {
                        fileStorage.delete(backupShed, (IProgressMonitor)monitor.newChild(50));
                    }
                    catch (TeamRepositoryException e) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
                    }
                }
            });
        }
        catch (CoreException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, 370, NLS.bind((String)Messages.MergeLoadMutator_17, (Object)shareable.getLocalPath(), (Object[])new Object[0]), e));
        }
    }

    protected void modifyFile(Shareable shareable, DeferredUpdateInformation deferredUpdateInformation, IProgressMonitor monitor) throws FileSystemClientException, TeamRepositoryException {
        this.shed.forceBackup(shareable, monitor);
        IVersionableHandle fileItem = deferredUpdateInformation.getFileItemState();
        this.contentSession.retrieveContent((IFileItemHandle)fileItem, deferredUpdateInformation.getContent(), new DownloadHandler(deferredUpdateInformation, this));
    }

    protected void deleteIncompleteFile(final IPath copyFileAreaRoot, final IPath path) throws TeamRepositoryException {
        try {
            SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                public void run() throws CoreException {
                    File file = copyFileAreaRoot.append(path).toFile();
                    if (!file.exists()) {
                        return;
                    }
                    if (!file.delete()) {
                        throw new CoreException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.MergeLoadMutator_0, (Object)path, (Object[])new Object[0]), null));
                    }
                }
            });
        }
        catch (CoreException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private void storeFileContents(final IPath copyFileAreaRoot, final IPath path, final IFileContent content, final InputStream in) throws TeamRepositoryException {
        try {
            SharingManager.getInstance().doSilentChange(new SharingManager.CoreRunnable(){

                public void run() throws CoreException {
                    if (MergeLoadMutator.this.downloadMonitor != null) {
                        if (content != null) {
                            MergeLoadMutator.this.downloadMonitor.downloadStarted(path, content.getEstimatedConvertedLength());
                        } else {
                            MergeLoadMutator.this.downloadMonitor.downloadStarted(path, 0L);
                        }
                    }
                    try {
                        MergeLoadMutator.this.internalStoreFileContents(copyFileAreaRoot, path, in);
                    }
                    catch (TeamRepositoryException e) {
                        throw new CoreException(FileSystemStatus.getStatusFor(e));
                    }
                }
            });
        }
        catch (CoreException e) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.MergeLoadMutator_18, (Object)path, (Object[])new Object[0]), (Throwable)e);
        }
    }

    protected void internalStoreFileContents(IPath copyPathFileAreaRoot, IPath path, InputStream in) throws TeamRepositoryException {
        try {
            FileOutputStream out = new FileOutputStream(copyPathFileAreaRoot.append(path).toFile());
            try {
                ContentManager.read((InputStream)in, (OutputStream)out);
            }
            catch (Throwable throwable) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((OutputStream)out).close();
            }
            catch (IOException iOException) {}
        }
        catch (SocketException e) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.MergeLoadMutator_7, (Object)e.getMessage(), (Object[])new Object[0]), (Throwable)e);
        }
        catch (IOException e) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.MergeLoadMutator_8, (Object)path, (Object[])new Object[0]), (Throwable)e);
        }
    }

    @Override
    protected void reportErrorsAsException(IStatus[] errors) throws FileSystemClientException {
        if (errors.length == 0) {
            return;
        }
        MultiStatus result = new MultiStatus("com.ibm.team.filesystem.client", 0, errors, NLS.bind((String)Messages.MergeLoadMutator_9, (Object)errors.length, (Object[])new Object[0]), null);
        throw new FileSystemClientException((IStatus)result);
    }

    public static void deleteShare(IShare share, Shed backupShed, IProgressMonitor progress) throws FileSystemClientException, TeamRepositoryException {
        IShareable shareable = share.getShareable();
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
        MergeLoadMutator.deleteSubtree((Shareable)shareable, ResourceType.getResourceType(share.getSharingDescriptor().getRootVersionable()), backupShed, (IProgressMonitor)monitor.newChild(75));
        SharingManager.getInstance().forget((Shareable)shareable, (IProgressMonitor)monitor.newChild(25));
    }

    protected static class DownloadHandler
    extends FileDownloadHandler {
        DeferredUpdateInformation deferredUpdateInformation;
        MergeLoadMutator mutator;

        public DownloadHandler(DeferredUpdateInformation deferredUpdateInformation, MergeLoadMutator mutator) {
            this.deferredUpdateInformation = deferredUpdateInformation;
            this.mutator = mutator;
        }

        public void downloadStreamAcquired(IFileItemHandle h, IFileContent content, InputStream in) throws TeamRepositoryException {
            boolean completed = false;
            try {
                DigestComputingInputStream inStream = ContentHash.getDigestComputingStream((InputStream)in);
                this.deferredUpdateInformation.reset();
                this.mutator.storeFileContents(this.deferredUpdateInformation.getSandbox().getRoot(), this.deferredUpdateInformation.getPath(), content, (InputStream)inStream);
                completed = true;
                this.deferredUpdateInformation.setContentUpdated(ContentHash.valueOf((byte[])inStream.getFinalDigest()), inStream.getContentSize());
            }
            finally {
                if (!completed) {
                    this.mutator.deleteIncompleteFile(this.deferredUpdateInformation.getSandbox().getRoot(), this.deferredUpdateInformation.getPath());
                }
            }
        }

        public void downloadFailed(IFileItemHandle h, IFileContent content, Exception e) {
            this.deferredUpdateInformation.setFailure(e);
        }
    }
}

