/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRLFInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToLFInputStream;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.repository.common.utils.TemporaryOutputStream;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.ContentHashAlgorithmException;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DeferredInformation {
    private boolean contentTransferred;
    private ContentHash hash;
    private long contentSize;
    private Exception failure;
    private FileAreaUpdate fileAreaUpdate;
    private String alternateEncoding;
    private FileLineDelimiter alternateDelimiter;

    public DeferredInformation(FileAreaUpdate update) {
        this.fileAreaUpdate = update;
        this.contentTransferred = false;
        this.alternateEncoding = null;
    }

    public boolean contentUpdated() {
        return this.contentTransferred;
    }

    public boolean isExecutable() {
        return this.fileAreaUpdate.isExecutable();
    }

    public void setContentUpdated(ContentHash hash, long contentSize) {
        this.contentTransferred = true;
        this.hash = hash;
        this.contentSize = contentSize;
    }

    public IFileContent getContent() {
        return this.fileAreaUpdate.getOptionalContent();
    }

    public String getContentType() {
        return this.fileAreaUpdate.getContentType();
    }

    public String getRemoteName() {
        return this.fileAreaUpdate.getName();
    }

    public IFolderHandle getRemoteParent() {
        return this.fileAreaUpdate.getDestinationParent();
    }

    public IVersionableHandle getFileItemState() {
        return this.fileAreaUpdate.afterState();
    }

    public IComponentHandle getComponent() {
        return this.fileAreaUpdate.getComponent();
    }

    public Map<String, String> getProperties() {
        return this.fileAreaUpdate.getProperties();
    }

    public ContentHash getHash() {
        return this.hash;
    }

    public long getContentSize() {
        return this.contentSize;
    }

    public void setFailure(Exception failureCause) {
        this.failure = failureCause;
        this.contentTransferred = false;
    }

    public Exception getFailure() {
        return this.failure;
    }

    public String getEncoding() {
        if (this.alternateEncoding == null) {
            return this.fileAreaUpdate.getOptionalContent().getCharacterEncoding();
        }
        return this.alternateEncoding;
    }

    public FileLineDelimiter getLineDelimiter() {
        if (this.alternateDelimiter == null) {
            return this.fileAreaUpdate.getOptionalContent().getLineDelimiter();
        }
        return this.alternateDelimiter;
    }

    public FileAreaUpdate getFileAreaUpdate() {
        return this.fileAreaUpdate;
    }

    public void setAlternateEncoding(String alternateEncoding) {
        this.alternateEncoding = alternateEncoding;
    }

    public void setAlternativeLineDelimiter(FileLineDelimiter lineDelimiter) {
        this.alternateDelimiter = lineDelimiter;
    }

    public boolean hasAlternateDownloadDirection() {
        return this.alternateDelimiter != null && this.fileAreaUpdate.getOptionalContent().getLineDelimiter() != this.alternateDelimiter || this.alternateEncoding != null && !this.fileAreaUpdate.getOptionalContent().getCharacterEncoding().equals(this.alternateEncoding);
    }

    public boolean isLineDelimiterIgnored() {
        return this.alternateDelimiter != null && this.fileAreaUpdate.getOptionalContent().getLineDelimiter() != this.alternateDelimiter && this.alternateDelimiter == FileLineDelimiter.LINE_DELIMITER_NONE;
    }

    public void reset() {
        this.failure = null;
        this.contentTransferred = false;
        this.hash = null;
        this.contentSize = 0L;
    }

    /*
     * Unable to fully structure code
     */
    public void convert(IProgressMonitor progress) {
        block63: {
            monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            if (!this.contentUpdated()) {
                return;
            }
            try {
                block64: {
                    block65: {
                        SharingManager.getInstance().disableChangeMonitoring();
                        shareable = this.getShareable();
                        ((Shareable)shareable).getFileStorage().refreshCachedSubTree(1, (IProgressMonitor)monitor.newChild(10));
                        contentProperties = SharingManager.getInstance().getContentExaminer().findStoredProperties(shareable, (IProgressMonitor)monitor.newChild(10));
                        expectedLineDelimiter = this.fileAreaUpdate.getOptionalContent().getLineDelimiter();
                        if (expectedLineDelimiter.equals((Object)FileLineDelimiter.LINE_DELIMITER_PLATFORM)) {
                            expectedLineDelimiter = FileLineDelimiter.getPlatformDelimiter();
                        }
                        encoding = contentProperties.getEncoding();
                        if (this.fileAreaUpdate.getOptionalContent().getCharacterEncoding().equals(encoding)) break block63;
                        file = ((Shareable)shareable).getFileStorage();
                        tmpOut = null;
                        fileIn = null;
                        tmpIn = null;
                        fileIn = file.getContents();
                        if (expectedLineDelimiter == FileLineDelimiter.LINE_DELIMITER_LF) {
                            conversionStream = new VerifyConvertToLFInputStream(fileIn, contentProperties.getEncoding());
                            break block64;
                        }
                        if (expectedLineDelimiter == FileLineDelimiter.LINE_DELIMITER_CRLF) {
                            conversionStream = new VerifyConvertToCRLFInputStream(fileIn, contentProperties.getEncoding());
                            break block64;
                        }
                        if (expectedLineDelimiter != FileLineDelimiter.LINE_DELIMITER_CR) break block65;
                        conversionStream = new VerifyConvertToCRInputStream(fileIn, contentProperties.getEncoding());
                        break block64;
                    }
lbl30:
                    // 2 sources

                    while (true) {
                        if (fileIn != null) {
                            try {
                                fileIn.close();
                            }
                            catch (IOException v0) {}
                        }
                        if (tmpIn != null) {
                            try {
                                tmpIn.close();
                            }
                            catch (IOException v1) {}
                        }
                        if (tmpOut != null) {
                            try {
                                tmpOut.close();
                                tmpOut.dispose();
                            }
                            catch (IOException v2) {}
                        }
                        return;
                    }
                }
                try {
                    block67: {
                        try {
                            in = new ReaderToInputStream((InputStreamReader)conversionStream);
                            subProgress = monitor.newChild(40);
                            work = 1000;
                            worked = 0;
                            total = this.fileAreaUpdate.getOptionalContent().getEstimatedConvertedLength();
                            transferred = 0L;
                            subProgress.setWorkRemaining(work);
                            buffer = new byte[4096];
                            tmpOut = TemporaryOutputStream.getTemporaryOutputStream((long)total);
                            numbytes = in.read(buffer);
                            while (numbytes != -1) {
                                newWorked = (int)((double)(transferred += (long)numbytes) / (double)total * (double)work);
                                subProgress.worked(newWorked - worked);
                                worked = newWorked;
                                tmpOut.write(buffer, 0, numbytes);
                                newWorked = (int)((double)(transferred += (long)numbytes) / (double)total * (double)work);
                                subProgress.worked(newWorked - worked);
                                worked = newWorked;
                                numbytes = in.read(buffer);
                            }
                            subProgress.done();
                            fileIn.close();
                            fileIn = null;
                            tmpOut.close();
                            tmpIn = tmpOut.getInputStream((IProgressMonitor)monitor.newChild(5));
                            inStream = ContentHash.getDigestComputingStream((InputStream)tmpIn);
                            try {
                                file.setContents((InputStream)inStream, true, (IProgressMonitor)monitor.newChild(35));
                                this.setContentUpdated(ContentHash.valueOf((byte[])inStream.getFinalDigest()), inStream.getContentSize());
                                this.alternateDelimiter = null;
                            }
                            catch (FileSystemClientException e) {
                                this.setFailure((Exception)e);
                                ** continue;
                            }
                            tmpIn.close();
                            tmpIn = null;
                            tmpOut.dispose();
                            tmpOut = null;
                        }
                        catch (IOException v3) {
                            if (fileIn != null) {
                                try {
                                    fileIn.close();
                                }
                                catch (IOException v4) {}
                            }
                            if (tmpIn != null) {
                                try {
                                    tmpIn.close();
                                }
                                catch (IOException v5) {}
                            }
                            if (tmpOut != null) {
                                try {
                                    tmpOut.close();
                                    tmpOut.dispose();
                                }
                                catch (IOException v6) {}
                            }
                            break block63;
                        }
                        catch (ContentHashAlgorithmException v7) {
                            block66: {
                                try {
                                    if (fileIn == null) break block66;
                                }
                                catch (Throwable var23_23) {
                                    if (fileIn != null) {
                                        try {
                                            fileIn.close();
                                        }
                                        catch (IOException v8) {}
                                    }
                                    if (tmpIn != null) {
                                        try {
                                            tmpIn.close();
                                        }
                                        catch (IOException v9) {}
                                    }
                                    if (tmpOut != null) {
                                        try {
                                            tmpOut.close();
                                            tmpOut.dispose();
                                        }
                                        catch (IOException v10) {}
                                    }
                                    throw var23_23;
                                }
                                try {
                                    fileIn.close();
                                }
                                catch (IOException v11) {}
                            }
                            if (tmpIn != null) {
                                try {
                                    tmpIn.close();
                                }
                                catch (IOException v12) {}
                            }
                            if (tmpOut != null) {
                                try {
                                    tmpOut.close();
                                    tmpOut.dispose();
                                }
                                catch (IOException v13) {}
                            }
                            break block63;
                        }
                        if (fileIn == null) break block67;
                        try {
                            fileIn.close();
                        }
                        catch (IOException v14) {}
                    }
                    if (tmpIn != null) {
                        try {
                            tmpIn.close();
                        }
                        catch (IOException v15) {}
                    }
                    if (tmpOut == null) break block63;
                    try {
                        tmpOut.close();
                        tmpOut.dispose();
                    }
                    catch (IOException v16) {
                    }
                }
                catch (FileSystemClientException v17) {}
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
            }
        }
    }

    public abstract IShareable getShareable();
}

