/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.IShareable;
import org.eclipse.core.runtime.IPath;

public class PathPair {
    private final IPath root;
    private final IPath innerPath;

    public PathPair(IShareable shareable) {
        this.root = PathPair.normalize(shareable.getSandbox().getRoot());
        this.innerPath = PathPair.normalize(shareable.getLocalPath());
    }

    public PathPair(IPath root, IPath innerPath) {
        this.root = PathPair.normalize(root);
        this.innerPath = PathPair.normalize(innerPath);
    }

    private static IPath normalize(IPath path) {
        return path.makeAbsolute().removeTrailingSeparator();
    }

    public int hashCode() {
        return this.root.hashCode() + this.innerPath.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof PathPair) {
            PathPair other = (PathPair)o;
            return this.getRoot().equals((Object)other.getRoot()) && this.getInnerPath().equals((Object)other.getInnerPath());
        }
        return false;
    }

    public IPath getRoot() {
        return this.root;
    }

    public IPath getInnerPath() {
        return this.innerPath;
    }

    public PathPair append(String segment) {
        return new PathPair(this.getRoot(), this.getInnerPath().append(segment));
    }

    public boolean isPrefixOf(PathPair other) {
        return this.root.equals((Object)other.getRoot()) && this.innerPath.isPrefixOf(other.getInnerPath());
    }

    public String toString() {
        return this.root + " -> " + this.innerPath;
    }
}

