/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas.migration;

import com.ibm.team.filesystem.client.internal.copyfileareas.migration.HeapValidator;
import com.ibm.team.internal.repository.rcp.dbhm.BTreeComparator;
import com.ibm.team.internal.repository.rcp.dbhm.ByteBTreeComparator;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentDiskBackedHashMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class BTreeContentValidator {
    protected static final int KEY_SIZE = 16;
    protected HeapValidator hv;
    protected StringBuilder log;
    protected File freeF;
    protected PersistentDiskBackedHashMap<Long, BlockInfo> free;

    public BTreeContentValidator(HeapValidator hv) throws IOException {
        this.hv = hv;
        this.freeF = File.createTempFile("bTreeFree", null);
        boolean success = false;
        try {
            this.free = new PersistentDiskBackedHashMap<Long, BlockInfo>(this.freeF){

                protected Object readObject(InputStream in, int flags) throws IOException, ClassNotFoundException {
                    return new ObjectInputStream(in).readObject();
                }
            };
            success = true;
        }
        finally {
            if (!success) {
                this.cleanUp();
            }
        }
    }

    public BTreeComparator getComparator() {
        return ByteBTreeComparator.CMP;
    }

    public long getKeySize() {
        return 16L;
    }

    public void beginValidation() throws IOException {
        this.log = this.hv.getLog();
    }

    public void validateData(long offset, byte[] key) {
        long blocksize = (key[0] & 0xFF) << 56 | (key[1] & 0xFF) << 48 | (key[2] & 0xFF) << 40 | (key[3] & 0xFF) << 32 | (key[4] & 0xFF) << 24 | (key[5] & 0xFF) << 16 | (key[6] & 0xFF) << 8 | key[7] & 0xFF;
        long off = ((key[8] & 0xFF) << 56 | (key[9] & 0xFF) << 48 | (key[10] & 0xFF) << 40 | (key[11] & 0xFF) << 32 | (key[12] & 0xFF) << 24 | (key[13] & 0xFF) << 16 | (key[14] & 0xFF) << 8 | key[15] & 0xFF) + 9;
        Long size = this.hv.getFreeMap().get(off);
        if (size == null) {
            size = this.hv.getAllocatedMap().get(off);
            if (size == null) {
                this.log.append("The B-Tree node " + offset + " lists a block of size " + blocksize + " at " + off + " as free, but the heap knows nothing about it\n");
            } else {
                this.log.append("The B-Tree node " + offset + " lists a block of size " + blocksize + " at " + off + " as free, but the heap says it's allocated with size " + size.toString() + "\n");
            }
        } else if (size != blocksize) {
            this.log.append("The B-Tree node " + offset + " lists a block of size " + blocksize + " at " + off + " as free, but the heap says its size is " + size.toString() + "\n");
        }
        BlockInfo info = new BlockInfo(blocksize, offset);
        info = (BlockInfo)this.free.put((Object)off, (Object)info);
        if (info != null) {
            this.log.append("The B-Tree node " + offset + " lists a block of size " + blocksize + " at " + off + " as free, while the node " + info.getNode() + " also lists it as having size " + info.getSize() + "\n");
        }
    }

    public void endValidation() {
        for (Long offset : this.hv.getFreeMap().keySet()) {
            if (this.free.containsKey((Object)offset)) continue;
            this.log.append("The block of size " + this.hv.getFreeMap().get(offset) + " at " + offset + " is marked as free in the heap, but does not appear in the B-Tree\n");
        }
        this.free.clear();
    }

    public void cleanUp() throws IOException {
        if (this.freeF != null) {
            try {
                if (this.free != null) {
                    this.free.close();
                    this.free = null;
                }
            }
            finally {
                this.freeF.delete();
            }
        }
    }

    protected static class BlockInfo
    implements Serializable {
        private static final long serialVersionUID = -5403515896619587778L;
        protected long size;
        protected long nodeOffset;

        public BlockInfo(long size, long nodeOffset) {
            this.size = size;
            this.nodeOffset = nodeOffset;
        }

        public long getNode() {
            return this.nodeOffset;
        }

        public long getSize() {
            return this.size;
        }
    }
}

