/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IRemoteVisitor;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.IVisitor;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.StringWrapper;
import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.ILockParticipant;
import com.ibm.team.filesystem.client.internal.copyfileareas.MultiLock;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CopyFileAreaStore {
    protected final ISharingMetadata metadata;
    protected final IPath path;
    protected final ListenerList listeners;
    protected final ReentrantLock sharingInfoLock;
    protected final CFAReadLock rlock;

    protected CopyFileAreaStore(IPath path, ISharingMetadata metadataStore) {
        Assert.isNotNull((Object)path);
        Assert.isNotNull((Object)metadataStore);
        this.path = path;
        this.metadata = metadataStore;
        this.listeners = new ListenerList();
        this.sharingInfoLock = new ReentrantLock();
        this.rlock = new CFAReadLock(path);
    }

    public void addListener(ICopyFileAreaListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(ICopyFileAreaListener listener) {
        this.listeners.remove((Object)listener);
    }

    public ReentrantLock getSharingLock() {
        return this.sharingInfoLock;
    }

    protected void assertReadLocked() {
        Assert.isTrue((boolean)CopyFileAreaManager.instance.batchingLock.isLocked(this.rlock));
        Assert.isTrue((this == CopyFileAreaManager.instance.getExistingCopyFileArea(this.getRoot()) ? 1 : 0) != 0);
    }

    public boolean isLocked(IComponentHandle component, IContextHandle connection) {
        return CopyFileAreaManager.instance.batchingLock.isLocked(new ComponentLock(this.getRoot(), connection, component));
    }

    public AbstractLock lock(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) {
        return CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), monitor);
    }

    public AbstractLock lock(IPath shareablePath, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        RuleDescriptorPair pair = this.beginBatching(shareablePath, (IProgressMonitor)progress.newChild(99));
        if (pair.desc == null) {
            CopyFileAreaStore.endBatching(pair.rule, (IProgressMonitor)progress.newChild(1));
            return null;
        }
        return pair.rule;
    }

    public void release(AbstractLock rule, IProgressMonitor monitor) throws FileSystemClientException {
        CopyFileAreaManager.instance.batchingLock.release(rule, monitor);
    }

    private void updateParentInfoForChange(FileItemInfo newInfo, FileItemInfo oldInfo, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        if (oldInfo != null && !oldInfo.getVersionableHandle().sameItemId((IItemHandle)newInfo.getVersionableHandle())) {
            throw new IllegalArgumentException("Infos must be for the same versionable");
        }
        if (this.metadata.getPathForShareRoot(newInfo.getVersionableHandle(), component, connection) == null) {
            if (oldInfo != null && oldInfo.getParent() != null && oldInfo.getParent().sameItemId((IItemHandle)newInfo.getParent()) && !oldInfo.getName().equals(newInfo.getName())) {
                this.updateParentInfoForRename(oldInfo, newInfo, component, connection);
            } else {
                if (oldInfo != null && oldInfo.getParent() != null && !oldInfo.getParent().sameItemId((IItemHandle)newInfo.getParent())) {
                    this.updateParentInfoForRemoval(oldInfo, component, connection);
                }
                if (!(newInfo.getParent() == null || oldInfo != null && newInfo.getParent().sameItemId((IItemHandle)oldInfo.getParent()))) {
                    InverseFileItemInfo oldParentInverseInfo = this.metadata.getFileItemInfo((IVersionableHandle)newInfo.getParent(), component, connection);
                    if (oldParentInverseInfo == null) {
                        this.metadata.setCorrupt(true, "Unexpected null parent", null);
                        throw new RuntimeException("Detected metadata corruption");
                    }
                    InverseFileItemInfo newParentInverseInfo = oldParentInverseInfo.addRemoteChild(newInfo.getName(), newInfo.getVersionableHandle());
                    this.metadata.setFileItemInfo((IVersionableHandle)newInfo.getParent(), component, connection, newParentInverseInfo);
                }
            }
        }
    }

    private void updateParentInfoForRename(FileItemInfo oldInfo, FileItemInfo newInfo, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        InverseFileItemInfo oldParentInverseInfo = this.metadata.getFileItemInfo((IVersionableHandle)newInfo.getParent(), component, connection);
        IVersionableHandle oldChild = oldParentInverseInfo.getRemoteChild(oldInfo.getName());
        if (oldChild == null) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_0, (Object)newInfo.getName()), null));
        }
        LinkedHashMap<String, IVersionableHandle> children = new LinkedHashMap<String, IVersionableHandle>(oldParentInverseInfo.getRemoteChildren());
        if (oldInfo.getVersionableHandle().sameItemId((IItemHandle)oldChild)) {
            children.remove(oldInfo.getName());
        }
        children.put(newInfo.getName(), newInfo.getVersionableHandle());
        InverseFileItemInfo newParentInverseInfo = oldParentInverseInfo.withRemoteChildren(children);
        this.metadata.setFileItemInfo((IVersionableHandle)newInfo.getParent(), component, connection, newParentInverseInfo);
    }

    private void updateParentInfoForRemoval(FileItemInfo oldInfo, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        if (oldInfo.getParent() != null) {
            InverseFileItemInfo oldParentInverseInfo = this.metadata.getFileItemInfo((IVersionableHandle)oldInfo.getParent(), component, connection);
            if (oldParentInverseInfo == null) {
                return;
            }
            IVersionableHandle child = oldParentInverseInfo.getRemoteChild(oldInfo.getName());
            if (child == null) {
                throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_0, (Object)oldInfo.getName()), null));
            }
            if (!oldInfo.getVersionableHandle().sameItemId((IItemHandle)child)) {
                return;
            }
            InverseFileItemInfo newParentInverseInfo = oldParentInverseInfo.removeRemoteChild(oldInfo.getName());
            this.metadata.setFileItemInfo((IVersionableHandle)oldInfo.getParent(), component, connection, newParentInverseInfo);
        }
    }

    private void updateLocalParent(IPath path, IFolderHandle newParent, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        Map<StringWrapper, FileItemInfo> childMap = this.metadata.getChildInfos(path);
        for (FileItemInfo i : childMap.values()) {
            InverseFileItemInfo oldInfo = this.metadata.getFileItemInfo(i.getVersionableHandle(), component, connection);
            if (oldInfo.getLocalName() == null) continue;
            InverseFileItemInfo newInfo = oldInfo.withLocalParent(newParent);
            this.metadata.setFileItemInfo(newInfo.getVersionableHandle(), component, connection, newInfo);
        }
    }

    public FileItemInfo setItemInfo(IPath shareablePath, FileItemInfo info, IProgressMonitor monitor) throws FileSystemClientException {
        FileItemInfo fileItemInfo;
        SubMonitor progress;
        block15: {
            Assert.isNotNull((Object)info);
            this.assertReadLocked();
            AbstractLock rule = null;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            try {
                FileItemInfo existing;
                IFolderHandle parent;
                RuleDescriptorPair pair = this.beginBatching(shareablePath, (IProgressMonitor)progress.newChild(1));
                ISharingDescriptor desc = pair.desc;
                rule = pair.rule;
                InverseFileItemInfo oldInfo = this.metadata.getFileItemInfo(info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle());
                if (info.getVersionableHandle().sameItemId((IItemHandle)desc.getRootVersionable())) {
                    parent = info.getParent();
                    if (oldInfo != null && !oldInfo.getVersionableHandle().sameItemId((IItemHandle)info.getVersionableHandle())) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, "Internal error: Share root must be at root of share", null));
                    }
                } else {
                    FileItemInfo parentInfo = this.metadata.getFileItemInfo(shareablePath.removeLastSegments(1));
                    if (parentInfo == null) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)"Internal error: Parent info missing for path {0}", (Object)shareablePath.toOSString()), null));
                    }
                    parent = (IFolderHandle)parentInfo.getVersionableHandle();
                    if (!(oldInfo == null || oldInfo.getLocalParent() == null || parent != null && parent.sameItemId((IItemHandle)oldInfo.getLocalParent()))) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_3, (Object)shareablePath.toString(), (Object)this.getLocalPathInternal(oldInfo, desc.getComponent(), desc.getConnectionHandle())), null));
                    }
                }
                String name = shareablePath.lastSegment();
                if (this.isCaseSensitive()) {
                    existing = this.metadata.setFileItemInfo(shareablePath, info);
                } else {
                    existing = this.metadata.setFileItemInfo(shareablePath, null);
                    this.metadata.setFileItemInfo(shareablePath, info);
                }
                if (existing != null && !info.getVersionableHandle().sameItemId((IItemHandle)existing.getVersionableHandle())) {
                    if (existing.getVersionableHandle().sameItemId((IItemHandle)desc.getRootVersionable())) {
                        throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, "Internal error: Cannot change share root item id this way", null));
                    }
                    if (existing.getVersionableHandle() instanceof IFolderHandle) {
                        this.updateLocalParent(shareablePath, (IFolderHandle)info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle());
                    }
                    if (existing.getVersionableHandle().hasStateId()) {
                        InverseFileItemInfo existingInverse = this.metadata.getFileItemInfo(existing.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle());
                        existingInverse = new InverseFileItemInfo(existingInverse.getVersionableHandle(), false, -1L, existingInverse.getParent(), existingInverse.getName(), existingInverse.isLoadedWithAnotherName(), existingInverse.getRemoteChildren(), null, null, existingInverse.getHash(), existingInverse.getContentLength(), existingInverse.getOriginalLineDelimiter(), existingInverse.getLineDelimiter(), existingInverse.getOriginalContentType(), existingInverse.getContentType(), existingInverse.getStoredPredecessorHintHash(), existingInverse.getStoredSize(), existingInverse.getStoredEncoding(), existingInverse.getStoredHash(), existingInverse.getStoredNumLineDelimiters(), existingInverse.isOriginalExecutable(), existingInverse.isOriginalExecutable());
                        this.metadata.setFileItemInfo(existing.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), existingInverse);
                    } else {
                        this.metadata.setFileItemInfo(existing.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), null);
                    }
                }
                this.updateParentInfoForChange(info, oldInfo, desc.getComponent(), desc.getConnectionHandle());
                Map<String, Object> children = info.isFolder() ? (oldInfo != null ? oldInfo.getRemoteChildren() : Collections.EMPTY_MAP) : Collections.EMPTY_MAP;
                InverseFileItemInfo newInfo = new InverseFileItemInfo(info.getVersionableHandle(), info.isContentChanged(), info.getLastContentChangeCheckStamp(), info.getParent(), info.getName(), info.isLoadedWithAnotherName(), children, parent, name, info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredPredecessorHintHash(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredHash(), info.getStoredNumLineDelimiters(), info.isExecutable(), info.isOriginalExecutable());
                this.metadata.setFileItemInfo(info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle(), newInfo);
                fileItemInfo = existing;
                if (rule == null) break block15;
            }
            catch (Throwable throwable) {
                if (rule != null) {
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                throw throwable;
            }
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return fileItemInfo;
    }

    public FileItemInfo setItemInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection, FileItemInfo info, IProgressMonitor monitor) throws FileSystemClientException {
        InverseFileItemInfo inverseFileItemInfo;
        SubMonitor progress;
        block6: {
            this.assertReadLocked();
            AbstractLock rule = null;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                IFolderHandle localParent;
                String localName;
                rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
                InverseFileItemInfo oldInfo = this.metadata.getFileItemInfo(item, component, connection);
                this.updateParentInfoForChange(info, oldInfo, component, connection);
                Map<String, IVersionableHandle> children = info.isFolder() && oldInfo != null ? oldInfo.getRemoteChildren() : Collections.EMPTY_MAP;
                IPath localPath = this.getLocalPathInternal(oldInfo, component, connection);
                if (localPath != null) {
                    this.metadata.setFileItemInfo(localPath, info);
                }
                if (oldInfo != null) {
                    localName = oldInfo.getLocalName();
                    localParent = oldInfo.getLocalParent();
                } else {
                    localName = null;
                    localParent = null;
                }
                InverseFileItemInfo newInfo = new InverseFileItemInfo(info.getVersionableHandle(), info.isContentChanged(), info.getLastContentChangeCheckStamp(), info.getParent(), info.getName(), info.isLoadedWithAnotherName(), children, localParent, localName, info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredPredecessorHintHash(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredHash(), info.getStoredNumLineDelimiters(), info.isExecutable(), info.isOriginalExecutable());
                this.metadata.setFileItemInfo(item, component, connection, newInfo);
                progress.worked(98);
                inverseFileItemInfo = oldInfo;
                if (rule == null) break block6;
            }
            catch (Throwable throwable) {
                if (rule != null) {
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                throw throwable;
            }
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return inverseFileItemInfo;
    }

    public Map<StringWrapper, FileItemInfo> getChildInfos(IPath shareablePath, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Map<StringWrapper, FileItemInfo> result = this.metadata.getChildInfos(shareablePath);
        progress.done();
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public UUID getRemoteAncestor(Set<UUID> potentialAncestors, IVersionableHandle item, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        block10: {
            block8: {
                block9: {
                    block7: {
                        this.assertReadLocked();
                        progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                        rule = null;
                        if (!potentialAncestors.isEmpty()) break block7;
                        while (true) {
                            if (rule != null) {
                                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                            }
                            progress.done();
                            return null;
                        }
                    }
                    try {
                        if (!potentialAncestors.contains(item.getItemId())) break block8;
                        var11_8 = item.getItemId();
                        if (rule == null) break block9;
                    }
                    catch (Throwable var10_12) {
                        if (rule != null) {
                            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                        }
                        progress.done();
                        throw var10_12;
                    }
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                return var11_8;
            }
            rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
            if ((info = this.metadata.getFileItemInfo(item, component, connection)) == null || !info.getVersionableHandle().hasStateId() || (rootPath = this.metadata.getPathForShareRoot(info.getVersionableHandle(), component, connection)) != null) ** continue;
            var11_9 = this.getRemoteAncestorInternal_rec(potentialAncestors, (IVersionableHandle)info.getParent(), component, connection);
            if (rule == null) break block10;
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return var11_9;
    }

    private UUID getRemoteAncestorInternal(Set<UUID> potentialAncestors, IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        if (potentialAncestors.isEmpty()) {
            return null;
        }
        if (potentialAncestors.contains(item.getItemId())) {
            return item.getItemId();
        }
        InverseFileItemInfo info = this.metadata.getFileItemInfo(item, component, connection);
        if (info == null) {
            return null;
        }
        IPath rootPath = this.metadata.getPathForShareRoot(info.getVersionableHandle(), component, connection);
        if (rootPath != null) {
            return null;
        }
        if (info.getName() == null) {
            return null;
        }
        return this.getRemoteAncestorInternal_rec(potentialAncestors, (IVersionableHandle)info.getParent(), component, connection);
    }

    private UUID getRemoteAncestorInternal_rec(Set<UUID> potentialAncestors, IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        while (!potentialAncestors.contains(item.getItemId())) {
            IPath rootPath = this.metadata.getPathForShareRoot(item, component, connection);
            if (rootPath != null) {
                return null;
            }
            InverseFileItemInfo info = this.metadata.getFileItemInfo(item, component, connection);
            if (info == null) {
                throw new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_6, (Object)info.getVersionableHandle()));
            }
            if (info.getName() == null) {
                throw new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_7, (Object)info.getVersionableHandle()));
            }
            item = info.getParent();
        }
        return item.getItemId();
    }

    public IPath getRemotePathFor(IPath shareablePath, IProgressMonitor monitor) throws FileSystemClientException {
        IPath iPath;
        SubMonitor progress;
        block12: {
            FileItemInfo info;
            ISharingDescriptor desc;
            AbstractLock rule;
            block8: {
                IPath iPath2;
                block11: {
                    IPath rootPath;
                    block9: {
                        IPath iPath3;
                        block10: {
                            block6: {
                                block7: {
                                    this.assertReadLocked();
                                    rule = null;
                                    progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                                    try {
                                        RuleDescriptorPair pair = this.beginBatching(shareablePath, (IProgressMonitor)progress.newChild(1));
                                        desc = pair.desc;
                                        rule = pair.rule;
                                        info = this.metadata.getFileItemInfo(shareablePath);
                                        if (info != null && info.getVersionableHandle().hasStateId()) break block6;
                                        if (rule == null) break block7;
                                    }
                                    catch (Throwable throwable) {
                                        if (rule != null) {
                                            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                                        }
                                        progress.done();
                                        throw throwable;
                                    }
                                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                                }
                                progress.done();
                                return null;
                            }
                            rootPath = this.metadata.getPathForShareRoot(info.getVersionableHandle(), desc.getComponent(), desc.getConnectionHandle());
                            if (rootPath == null) break block8;
                            if (info.getName() == null || info.getName().equals(rootPath.lastSegment())) break block9;
                            iPath3 = rootPath.removeLastSegments(1).append(info.getName());
                            if (rule == null) break block10;
                            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                        }
                        progress.done();
                        return iPath3;
                    }
                    iPath2 = rootPath;
                    if (rule == null) break block11;
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                return iPath2;
            }
            iPath = this.getRemotePathInternal((IVersionableHandle)info.getParent(), desc.getComponent(), desc.getConnectionHandle()).append(info.getName());
            if (rule == null) break block12;
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return iPath;
    }

    public IPath getRemotePathFor(IVersionableHandle item, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        IPath iPath;
        SubMonitor progress;
        block12: {
            InverseFileItemInfo info;
            AbstractLock rule;
            block8: {
                IPath iPath2;
                block11: {
                    IPath rootPath;
                    block9: {
                        IPath iPath3;
                        block10: {
                            block6: {
                                block7: {
                                    this.assertReadLocked();
                                    rule = null;
                                    progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                                    try {
                                        rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
                                        info = this.metadata.getFileItemInfo(item, component, connection);
                                        if (info != null && info.getVersionableHandle().hasStateId()) break block6;
                                        if (rule == null) break block7;
                                    }
                                    catch (Throwable throwable) {
                                        if (rule != null) {
                                            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                                        }
                                        progress.done();
                                        throw throwable;
                                    }
                                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                                }
                                progress.done();
                                return null;
                            }
                            rootPath = this.metadata.getPathForShareRoot(info.getVersionableHandle(), component, connection);
                            if (rootPath == null) break block8;
                            if (info.getName() == null || info.getName().equals(rootPath.lastSegment())) break block9;
                            iPath3 = rootPath.removeLastSegments(1).append(info.getName());
                            if (rule == null) break block10;
                            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                        }
                        progress.done();
                        return iPath3;
                    }
                    iPath2 = rootPath;
                    if (rule == null) break block11;
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                return iPath2;
            }
            iPath = this.getRemotePathInternal((IVersionableHandle)info.getParent(), component, connection).append(info.getName());
            if (rule == null) break block12;
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return iPath;
    }

    private IPath getRemotePathInternal(IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        InverseFileItemInfo info = this.metadata.getFileItemInfo(item, component, connection);
        if (info == null || !info.getVersionableHandle().hasStateId()) {
            return null;
        }
        IPath rootPath = this.metadata.getPathForShareRoot(item, component, connection);
        if (rootPath != null) {
            if (info.getName() != null && !info.getName().equals(rootPath.lastSegment())) {
                return rootPath.removeLastSegments(1).append(info.getName());
            }
            return rootPath;
        }
        return this.getRemotePathInternal_rec(info, component, connection);
    }

    private IPath getRemotePathInternal_rec(FileItemInfo info, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        ArrayList<String> segments = null;
        int pathlen = 0;
        while (true) {
            String name;
            IPath rootPath;
            if ((rootPath = this.metadata.getPathForShareRoot(info.getVersionableHandle(), component, connection)) != null) {
                if (info.getName() != null && !info.getName().equals(rootPath.lastSegment())) {
                    if (segments == null) {
                        return rootPath.removeLastSegments(1).append(info.getName());
                    }
                    rootPath = rootPath.removeLastSegments(1);
                    name = info.getName();
                    pathlen += name.length();
                    segments.add(name);
                } else if (segments == null) {
                    return rootPath;
                }
                int max = segments.size() - 1;
                if (max == 0) {
                    return rootPath.append((String)segments.get(0));
                }
                StringBuilder buf = new StringBuilder(pathlen + max);
                buf.append((String)segments.get(max));
                int i = max - 1;
                while (i >= 0) {
                    buf.append('/');
                    buf.append((String)segments.get(i));
                    --i;
                }
                return rootPath.append(buf.toString());
            }
            name = info.getName();
            if (name == null) {
                throw new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_8, (Object)info.getVersionableHandle()));
            }
            if (segments == null) {
                segments = new ArrayList<String>();
            }
            pathlen += name.length();
            segments.add(name);
            info = this.metadata.getFileItemInfo((IVersionableHandle)info.getParent(), component, connection);
        }
    }

    public List<IPath> getLocalPathFor(List<IVersionableHandle> items, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        ArrayList<IPath> arrayList;
        SubMonitor progress;
        block4: {
            this.assertReadLocked();
            AbstractLock rule = null;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
                ArrayList<IPath> result = new ArrayList<IPath>(items.size());
                SubMonitor subProgress = progress.newChild(98);
                subProgress.setWorkRemaining(items.size());
                for (IVersionableHandle item : items) {
                    result.add(this.getLocalPathInternal(item, component, connection));
                    subProgress.worked(1);
                }
                subProgress.done();
                arrayList = result;
                if (rule == null) break block4;
            }
            catch (Throwable throwable) {
                if (rule != null) {
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                throw throwable;
            }
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return arrayList;
    }

    public IPath getLocalPathFor(IVersionableHandle item, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        IPath iPath;
        SubMonitor progress;
        block3: {
            this.assertReadLocked();
            AbstractLock rule = null;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
                iPath = this.getLocalPathInternal(item, component, connection);
                if (rule == null) break block3;
            }
            catch (Throwable throwable) {
                if (rule != null) {
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                throw throwable;
            }
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return iPath;
    }

    private IPath getLocalPathInternal(IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        InverseFileItemInfo info = this.metadata.getFileItemInfo(item, component, connection);
        return this.getLocalPathInternal(info, component, connection);
    }

    private IPath getLocalPathInternal(InverseFileItemInfo info, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        if (info == null) {
            return null;
        }
        IPath rootPath = this.metadata.getPathForShareRoot(info.getVersionableHandle(), component, connection);
        if (rootPath != null) {
            return rootPath;
        }
        if (info.getLocalName() == null) {
            return null;
        }
        return this.getLocalPathInternal_rec(this.metadata.getFileItemInfo((IVersionableHandle)info.getLocalParent(), component, connection), component, connection).append(info.getLocalName());
    }

    private IPath getLocalPathInternal_rec(InverseFileItemInfo info, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        ArrayList<String> segments = null;
        int pathlen = 0;
        while (true) {
            IPath rootPath;
            if ((rootPath = this.metadata.getPathForShareRoot(info.getVersionableHandle(), component, connection)) != null) {
                if (segments == null) {
                    return rootPath;
                }
                int max = segments.size() - 1;
                if (max == 0) {
                    return rootPath.append((String)segments.get(0));
                }
                StringBuilder buf = new StringBuilder(pathlen + max);
                buf.append((String)segments.get(max));
                int i = max - 1;
                while (i >= 0) {
                    buf.append('/');
                    buf.append((String)segments.get(i));
                    --i;
                }
                return rootPath.append(buf.toString());
            }
            String name = info.getLocalName();
            if (name == null) {
                throw new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_10, (Object)info.getVersionableHandle()));
            }
            if (segments == null) {
                segments = new ArrayList<String>();
            }
            pathlen += name.length();
            segments.add(name);
            info = this.metadata.getFileItemInfo((IVersionableHandle)info.getLocalParent(), component, connection);
        }
    }

    public InverseFileItemInfo getItemInfo(IVersionableHandle handle, IComponentHandle component, IContextHandle connection) {
        this.assertReadLocked();
        try {
            return this.metadata.getFileItemInfo(handle, component, connection);
        }
        catch (FileSystemClientException e) {
            LoggingHelper.log(e);
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public FileItemInfo getDeletedItem(IFolderHandle handle, String name, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) {
        block17: {
            SubMonitor progress;
            AbstractLock rule;
            block14: {
                InverseFileItemInfo inverseFileItemInfo;
                block15: {
                    IVersionableHandle h;
                    this.assertReadLocked();
                    rule = null;
                    progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                    rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
                    InverseFileItemInfo info = this.metadata.getFileItemInfo((IVersionableHandle)handle, component, connection);
                    if (info == null || (h = info.getRemoteChildren().get(name)) == null || (info = this.metadata.getFileItemInfo(h, component, connection)).getLocalName() != null) break block14;
                    inverseFileItemInfo = info;
                    if (rule == null) break block15;
                    try {
                        CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                    }
                    catch (FileSystemClientException e) {
                        LoggingHelper.log(e);
                    }
                }
                progress.done();
                return inverseFileItemInfo;
                catch (FileSystemClientException e) {
                    block16: {
                        try {
                            LoggingHelper.log(e);
                            if (rule == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (rule != null) {
                                try {
                                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                                }
                                catch (FileSystemClientException e2) {
                                    LoggingHelper.log(e2);
                                }
                            }
                            progress.done();
                            throw throwable;
                        }
                        try {
                            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                        }
                        catch (FileSystemClientException e3) {
                            LoggingHelper.log(e3);
                        }
                    }
                    progress.done();
                    break block17;
                }
            }
            if (rule != null) {
                try {
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                catch (FileSystemClientException e) {
                    LoggingHelper.log(e);
                }
            }
            progress.done();
        }
        return null;
    }

    public Collection getLocalItemPaths(IVersionableHandle handle, IProgressMonitor monitor) throws FileSystemClientException {
        AbstractLock rule;
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<ISharingMetadata.IConnectionComponent> locations = this.metadata.getLocations(handle);
        block7: while (true) {
            progress.setWorkRemaining(100);
            if (locations.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            AbstractLock[] rules = new AbstractLock[locations.size()];
            int idx = 0;
            for (ISharingMetadata.IConnectionComponent c : locations) {
                rules[idx++] = new ComponentLock(this.getRoot(), c.getConnection(), c.getComponent());
            }
            AbstractLock schedRule = MultiLock.combine(rules);
            rule = CopyFileAreaStore.beginBatching(schedRule, (IProgressMonitor)progress.newChild(1));
            boolean success = false;
            try {
                Collection<ISharingMetadata.IConnectionComponent> newLocations = this.metadata.getLocations(handle);
                if (newLocations.size() != locations.size()) {
                    locations = newLocations;
                    continue;
                }
                HashSet<ISharingMetadata.IConnectionComponent> old = new HashSet<ISharingMetadata.IConnectionComponent>(locations);
                locations = newLocations;
                for (ISharingMetadata.IConnectionComponent c : newLocations) {
                    if (!old.contains(c)) continue block7;
                }
                success = true;
            }
            finally {
                if (success) continue;
                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            break;
        }
        try {
            SubMonitor subProgress = progress.newChild(98);
            subProgress.setWorkRemaining(locations.size());
            ArrayList<IPath> paths = new ArrayList<IPath>(locations.size());
            for (ISharingMetadata.IConnectionComponent c : locations) {
                IPath path = this.getLocalPathInternal(handle, c.getComponent(), c.getConnection());
                if (path != null) {
                    paths.add(path);
                }
                subProgress.worked(1);
            }
            subProgress.done();
            ArrayList<IPath> arrayList = paths;
            return arrayList;
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public Collection getLocalItemPaths(IVersionableHandle handle, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        AbstractLock rule;
        int numResults;
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<ISharingMetadata.IConnectionComponent> locations = this.metadata.getLocations(handle);
        block7: while (true) {
            progress.setWorkRemaining(100);
            AbstractLock[] rules = new AbstractLock[locations.size()];
            numResults = 0;
            for (ISharingMetadata.IConnectionComponent c : locations) {
                if (!c.getConnection().sameItemId((IItemHandle)connection)) continue;
                rules[numResults++] = new ComponentLock(this.getRoot(), c.getConnection(), c.getComponent());
            }
            if (numResults == 0) {
                return Collections.EMPTY_LIST;
            }
            AbstractLock schedRule = MultiLock.combine(rules);
            rule = CopyFileAreaStore.beginBatching(schedRule, (IProgressMonitor)progress.newChild(1));
            boolean success = false;
            try {
                HashSet<ISharingMetadata.IConnectionComponent> old = new HashSet<ISharingMetadata.IConnectionComponent>(numResults * 4 / 3);
                for (ISharingMetadata.IConnectionComponent c : locations) {
                    if (!c.getConnection().sameItemId((IItemHandle)connection)) continue;
                    old.add(c);
                }
                locations = this.metadata.getLocations(handle);
                numResults = 0;
                for (ISharingMetadata.IConnectionComponent c : locations) {
                    if (!c.getConnection().sameItemId((IItemHandle)connection)) continue;
                    if (!old.contains(c)) continue block7;
                    ++numResults;
                }
                if (numResults != old.size()) continue;
                success = true;
            }
            finally {
                if (success) continue;
                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            break;
        }
        try {
            SubMonitor subProgress = progress.newChild(98);
            subProgress.setWorkRemaining(numResults);
            ArrayList<IPath> paths = new ArrayList<IPath>(numResults);
            for (ISharingMetadata.IConnectionComponent c : locations) {
                if (!c.getConnection().sameItemId((IItemHandle)connection)) continue;
                IPath path = this.getLocalPathInternal(handle, c.getComponent(), c.getConnection());
                if (path != null) {
                    paths.add(path);
                }
                subProgress.worked(1);
            }
            subProgress.done();
            ArrayList<IPath> arrayList = paths;
            return arrayList;
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public Collection getLocalItemPaths(IVersionableHandle handle, IComponentHandle component, IProgressMonitor monitor) throws FileSystemClientException {
        AbstractLock rule;
        int numResults;
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Collection<ISharingMetadata.IConnectionComponent> locations = this.metadata.getLocations(handle);
        block7: while (true) {
            progress.setWorkRemaining(100);
            AbstractLock[] rules = new AbstractLock[locations.size()];
            numResults = 0;
            for (ISharingMetadata.IConnectionComponent c : locations) {
                if (!c.getComponent().sameItemId((IItemHandle)component)) continue;
                rules[numResults++] = new ComponentLock(this.getRoot(), c.getConnection(), c.getComponent());
            }
            if (numResults == 0) {
                return Collections.EMPTY_LIST;
            }
            AbstractLock schedRule = MultiLock.combine(rules);
            rule = CopyFileAreaStore.beginBatching(schedRule, (IProgressMonitor)progress.newChild(1));
            boolean success = false;
            try {
                HashSet<ISharingMetadata.IConnectionComponent> old = new HashSet<ISharingMetadata.IConnectionComponent>(numResults * 4 / 3);
                for (ISharingMetadata.IConnectionComponent c : locations) {
                    if (!c.getComponent().sameItemId((IItemHandle)component)) continue;
                    old.add(c);
                }
                locations = this.metadata.getLocations(handle);
                numResults = 0;
                for (ISharingMetadata.IConnectionComponent c : locations) {
                    if (!c.getComponent().sameItemId((IItemHandle)component)) continue;
                    if (!old.contains(c)) continue block7;
                    ++numResults;
                }
                if (numResults != old.size()) continue;
                success = true;
            }
            finally {
                if (success) continue;
                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            break;
        }
        try {
            SubMonitor subProgress = progress.newChild(98);
            subProgress.setWorkRemaining(numResults);
            ArrayList<IPath> paths = new ArrayList<IPath>(numResults);
            for (ISharingMetadata.IConnectionComponent c : locations) {
                if (!c.getComponent().sameItemId((IItemHandle)component)) continue;
                IPath path = this.getLocalPathInternal(handle, c.getComponent(), c.getConnection());
                if (path != null) {
                    paths.add(path);
                }
                subProgress.worked(1);
            }
            subProgress.done();
            ArrayList<IPath> arrayList = paths;
            return arrayList;
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public FileItemInfo getItemInfo(IPath path) {
        this.assertReadLocked();
        try {
            return this.metadata.getFileItemInfo(path);
        }
        catch (FileSystemClientException e) {
            LoggingHelper.log(e);
            return null;
        }
    }

    public void moveSharingInfo(final IPath sourcePath, final IPath destinationPath, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final ISharingDescriptor[] oldInfo = new ISharingDescriptor[1];
        final FileSystemClientException[] exception = new FileSystemClientException[1];
        AbstractLock rule = null;
        try {
            rule = CopyFileAreaStore.beginBatchingWithLock(null, new ILockParticipant(){

                public AbstractLock locking(AbstractLock rule) {
                    CopyFileAreaStore.this.sharingInfoLock.lock();
                    try {
                        IPath conflicting = CopyFileAreaStore.this.metadata.findConflictingShare(destinationPath);
                        if (conflicting != null) {
                            throw new IllegalArgumentException("Cannot move share from " + sourcePath + " to " + destinationPath + " because destination conflicts with existing share " + conflicting);
                        }
                        oldInfo[0] = CopyFileAreaStore.this.metadata.getSharingDescriptor(sourcePath);
                        if (oldInfo[0] != null) {
                            ComponentLock lock = new ComponentLock(CopyFileAreaStore.this.getRoot(), oldInfo[0].getConnectionHandle(), oldInfo[0].getComponent());
                            return lock;
                        }
                        throw new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.CopyFileAreaStore_11, (Object)sourcePath)));
                    }
                    catch (FileSystemClientException e) {
                        exception[0] = e;
                        return null;
                    }
                }

                public void waiting() {
                    CopyFileAreaStore.this.sharingInfoLock.unlock();
                }
            }, (IProgressMonitor)progress.newChild(1));
            if (exception[0] != null) {
                throw exception[0];
            }
            InverseFileItemInfo oldFiInfo = this.metadata.getFileItemInfo(oldInfo[0].getRootVersionable(), oldInfo[0].getComponent(), oldInfo[0].getConnectionHandle());
            if (oldFiInfo != null) {
                this.metadata.setFileItemInfo(oldFiInfo.getVersionableHandle(), oldInfo[0].getComponent(), oldInfo[0].getConnectionHandle(), oldFiInfo.withLocalName(destinationPath.lastSegment()));
                this.metadata.moveFileItemInfo(sourcePath, destinationPath);
            }
            progress.worked(50);
            this.metadata.setSharingDescriptor(sourcePath, null, (IProgressMonitor)progress.newChild(24));
            CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(oldInfo[0].getRootVersionable(), this, sourcePath, 2));
            this.metadata.setSharingDescriptor(destinationPath, oldInfo[0], (IProgressMonitor)progress.newChild(24));
            CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(oldInfo[0].getRootVersionable(), this, destinationPath, 1));
        }
        catch (Throwable throwable) {
            this.sharingInfoLock.unlock();
            if (rule != null) {
                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
            throw throwable;
        }
        this.sharingInfoLock.unlock();
        if (rule != null) {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    public void setSharingInfo(IPath path, final ISharingDescriptor info, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        final IPath sharePath = path.setDevice(null).makeUNC(false).makeAbsolute().removeTrailingSeparator();
        Assert.isNotNull((Object)info);
        AbstractLock rule = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final ISharingDescriptor[] oldInfo = new ISharingDescriptor[1];
        final FileSystemClientException[] exception = new FileSystemClientException[1];
        try {
            rule = CopyFileAreaStore.beginBatchingWithLock(null, new ILockParticipant(){

                public AbstractLock locking(AbstractLock rule) {
                    CopyFileAreaStore.this.sharingInfoLock.lock();
                    try {
                        oldInfo[0] = CopyFileAreaStore.this.metadata.getSharingDescriptor(sharePath);
                        if (oldInfo[0] != null) {
                            rule = MultiLock.combine(new ComponentLock(CopyFileAreaStore.this.getRoot(), info.getConnectionHandle(), info.getComponent()), new ComponentLock(CopyFileAreaStore.this.getRoot(), oldInfo[0].getConnectionHandle(), oldInfo[0].getComponent()));
                        } else {
                            IPath conflicting = CopyFileAreaStore.this.metadata.findConflictingShare(sharePath);
                            if (conflicting != null) {
                                throw new IllegalArgumentException("Cannot share " + sharePath + " because it conflicts with " + conflicting);
                            }
                            rule = new ComponentLock(CopyFileAreaStore.this.getRoot(), info.getConnectionHandle(), info.getComponent());
                        }
                        return rule;
                    }
                    catch (FileSystemClientException e) {
                        exception[0] = e;
                        return null;
                    }
                }

                public void waiting() {
                    CopyFileAreaStore.this.sharingInfoLock.unlock();
                }
            }, (IProgressMonitor)progress.newChild(1));
            if (exception[0] != null) {
                throw exception[0];
            }
            if (oldInfo[0] == null) {
                if (this.getFileItemInfo(info) != null) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_12, (Object[])new Object[]{sharePath, info.getRootVersionable().getItemId().getUuidValue(), info.getConnectionName(), info.getComponentName()}), null));
                }
                this.metadata.deleteFileItemInfo(sharePath, (IProgressMonitor)progress.newChild(70));
            } else if (!(oldInfo[0].getComponent().sameItemId((IItemHandle)info.getComponent()) && oldInfo[0].getConnectionHandle().sameItemId((IItemHandle)info.getConnectionHandle()) && oldInfo[0].getRootVersionable().sameItemId((IItemHandle)info.getRootVersionable()))) {
                if (this.getFileItemInfo(info) != null) {
                    throw new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_12, (Object[])new Object[]{sharePath, info.getRootVersionable().getItemId().getUuidValue(), info.getConnectionName(), info.getComponentName()}), null));
                }
                if (!oldInfo[0].getRootVersionable().sameItemId((IItemHandle)info.getRootVersionable())) {
                    CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(oldInfo[0].getRootVersionable(), this, sharePath, 2));
                }
                IPath oldSharePath = this.metadata.getPathForShareRoot(oldInfo[0].getRootVersionable(), oldInfo[0].getComponent(), oldInfo[0].getConnectionHandle());
                if (info.getRootVersionable() instanceof IFolderHandle) {
                    if (oldInfo[0].getRootVersionable() instanceof IFolderHandle) {
                        this.moveShareRootToWC(oldSharePath, oldInfo[0], sharePath, info, (IProgressMonitor)progress.newChild(70));
                    } else {
                        this.deleteTreeInfoInternal(oldSharePath, oldInfo[0].getComponent(), oldInfo[0].getConnectionHandle(), true, (IProgressMonitor)progress.newChild(70));
                    }
                } else if (info.getRootVersionable().sameItemId((IItemHandle)oldInfo[0].getRootVersionable())) {
                    InverseFileItemInfo oldRootInfo = this.metadata.getFileItemInfo(info.getRootVersionable(), oldInfo[0].getComponent(), oldInfo[0].getConnectionHandle());
                    this.deleteTreeInfoInternal(oldSharePath, oldInfo[0].getComponent(), oldInfo[0].getConnectionHandle(), true, (IProgressMonitor)progress.newChild(70));
                    InverseFileItemInfo newRootInfo = oldRootInfo.withLocalName(sharePath.lastSegment());
                    this.metadata.setFileItemInfo(sharePath, newRootInfo);
                    this.metadata.setFileItemInfo(info.getRootVersionable(), info.getComponent(), info.getConnectionHandle(), newRootInfo);
                } else {
                    this.deleteTreeInfoInternal(oldSharePath, oldInfo[0].getComponent(), oldInfo[0].getConnectionHandle(), true, (IProgressMonitor)progress.newChild(70));
                }
            } else {
                progress.setWorkRemaining(29);
            }
            this.metadata.setSharingDescriptor(sharePath, info, (IProgressMonitor)progress.newChild(14));
            if (!(oldInfo[0] == null || oldInfo[0].getComponent().sameItemId((IItemHandle)info.getComponent()) && oldInfo[0].getConnectionHandle().sameItemId((IItemHandle)info.getConnectionHandle()))) {
                progress.setWorkRemaining(16);
                if (!this.metadata.hasShares(oldInfo[0].getComponent(), oldInfo[0].getConnectionHandle(), (IProgressMonitor)progress.newChild(1))) {
                    LocalChangeManager.getInstance().clearPendingChanges(oldInfo[0].getConnectionHandle(), oldInfo[0].getComponent(), this.getRoot());
                }
            }
            boolean alreadyLoaded = this.metadata.componentLoaded(new LoadedConfigurationDescriptor(info.getRepositoryId(), info.getRepositoryUri(), info.getConnectionHandle(), info.getConnectionName(), info.getComponent(), info.getComponentName()), (IProgressMonitor)progress.newChild(14)) != null;
            CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(info.getRootVersionable(), this, sharePath, 1));
            if (!alreadyLoaded) {
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(null, this, null, 7));
            }
        }
        catch (Throwable throwable) {
            this.sharingInfoLock.unlock();
            if (rule != null) {
                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
            throw throwable;
        }
        this.sharingInfoLock.unlock();
        if (rule != null) {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    private InverseFileItemInfo getFileItemInfo(ISharingDescriptor info) throws FileSystemClientException {
        return this.metadata.getFileItemInfo(info.getRootVersionable(), info.getComponent(), info.getConnectionHandle());
    }

    private void moveShareRootToWC(IPath oldSharePath, ISharingDescriptor oldInfo, IPath newSharePath, ISharingDescriptor newInfo, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean foundNewRootInRemoteSubtree = false;
        InverseFileItemInfo oldRootInfo = null;
        if (this.sameWorkspaceComponent(oldInfo, newInfo)) {
            foundNewRootInRemoteSubtree = this.getRemoteAncestorInternal(Collections.singleton(oldInfo.getRootVersionable().getItemId()), newInfo.getRootVersionable(), oldInfo.getComponent(), oldInfo.getConnectionHandle()) != null;
            oldRootInfo = this.metadata.getFileItemInfo(oldInfo.getRootVersionable(), oldInfo.getComponent(), oldInfo.getConnectionHandle());
            progress.setWorkRemaining(10);
        } else {
            this.removeLocalInfoFromInverseMetadata(oldSharePath, oldInfo.getComponent(), oldInfo.getConnectionHandle(), progress.newChild(25));
            this.assignNewUUIDsToRemoteSharesWithNoLocal(oldInfo.getRootVersionable(), oldInfo.getComponent(), oldInfo.getConnectionHandle(), progress.newChild(20));
            foundNewRootInRemoteSubtree = this.moveInverseMetadataForShareRootToNewWC(oldInfo, newInfo, progress.newChild(20));
            oldRootInfo = this.fixLocalItemInverseMetadataForShareRootToNewWC(oldSharePath, oldInfo, newInfo, progress.newChild(25));
        }
        if (!oldRootInfo.getVersionableHandle().sameItemId((IItemHandle)newInfo.getRootVersionable())) {
            this.handeLocalMoveWithRemoteVersionableChange(oldSharePath, oldInfo, oldRootInfo, newSharePath, newInfo, foundNewRootInRemoteSubtree, progress);
        }
        if (!oldSharePath.equals((Object)newSharePath)) {
            this.metadata.moveFileItemInfo(oldSharePath, newSharePath);
        }
        progress.done();
    }

    private void handeLocalMoveWithRemoteVersionableChange(IPath oldSharePath, ISharingDescriptor oldInfo, InverseFileItemInfo oldRootInfo, IPath newSharePath, ISharingDescriptor newInfo, boolean foundNewRootInRemoteSubtree, SubMonitor progress) throws FileSystemClientException {
        IFolderHandle localParent;
        String localName;
        IPath pathToNewRootInOldComponent;
        InverseFileItemInfo newRootInfo;
        if (!oldInfo.getRootVersionable().sameItemId((IItemHandle)newInfo.getRootVersionable())) {
            newRootInfo = this.metadata.getFileItemInfo(newInfo.getRootVersionable(), oldInfo.getComponent(), oldInfo.getConnectionHandle());
            pathToNewRootInOldComponent = this.getLocalPathInternal(newRootInfo, oldInfo.getComponent(), oldInfo.getConnectionHandle());
        } else {
            newRootInfo = null;
            pathToNewRootInOldComponent = null;
        }
        HashMap<UUID, InverseFileItemInfo> itemInfos = new HashMap<UUID, InverseFileItemInfo>();
        itemInfos.put(oldRootInfo.getVersionableHandle().getItemId(), oldRootInfo);
        if (newRootInfo != null) {
            newRootInfo = this.getFileItemInfo(newInfo);
        }
        if (newRootInfo != null) {
            localName = newRootInfo.getLocalName();
            localParent = newRootInfo.getLocalParent();
        } else {
            localName = null;
            localParent = null;
        }
        if (foundNewRootInRemoteSubtree) {
            itemInfos.put(newRootInfo.getVersionableHandle().getItemId(), newRootInfo);
            InverseFileItemInfo parentInfo = this.getFileItemInfo((IVersionableHandle)newRootInfo.getParent(), newInfo.getComponent(), newInfo.getConnectionHandle(), itemInfos);
            parentInfo = parentInfo.removeRemoteChild(newRootInfo.getName());
            itemInfos.put(parentInfo.getVersionableHandle().getItemId(), parentInfo);
        } else {
            newRootInfo = new InverseFileItemInfo((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(newInfo.getRootVersionable().getItemId(), UUID.generate()), null, null, true, Collections.EMPTY_MAP, null, newSharePath.lastSegment());
            itemInfos.put(newRootInfo.getVersionableHandle().getItemId(), newRootInfo);
        }
        oldRootInfo = this.getFileItemInfo(oldRootInfo.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), itemInfos);
        if (oldRootInfo.getVersionableHandle().hasStateId()) {
            HashMap<String, IVersionableHandle> children = new HashMap<String, IVersionableHandle>(newRootInfo.getRemoteChildren());
            String name = newSharePath.lastSegment();
            int i = 0;
            while (children.containsKey(name)) {
                name = String.valueOf(newSharePath.lastSegment()) + Integer.toString(i);
                ++i;
            }
            children.put(name, oldRootInfo.getVersionableHandle());
            IVersionableHandle newRootHandle = newRootInfo.getVersionableHandle().hasStateId() ? newRootInfo.getVersionableHandle() : (IVersionableHandle)newRootInfo.getVersionableHandle().getItemType().createItemHandle(newRootInfo.getVersionableHandle().getItemId(), UUID.generate());
            newRootInfo = new InverseFileItemInfo(newRootHandle, newRootInfo.isContentChanged(), newRootInfo.getLastContentChangeCheckStamp(), null, null, true, Collections.unmodifiableMap(children), newRootInfo.getLocalParent(), newRootInfo.getLocalName(), newRootInfo.getHash(), newRootInfo.getContentLength(), newRootInfo.getOriginalLineDelimiter(), newRootInfo.getLineDelimiter(), newRootInfo.getOriginalContentType(), newRootInfo.getContentType(), newRootInfo.getStoredPredecessorHintHash(), newRootInfo.getStoredSize(), newRootInfo.getStoredEncoding(), newRootInfo.getStoredHash(), newRootInfo.getStoredNumLineDelimiters(), newRootInfo.isExecutable(), newRootInfo.isOriginalExecutable());
            itemInfos.put(newRootInfo.getVersionableHandle().getItemId(), newRootInfo);
            oldRootInfo = new InverseFileItemInfo(oldRootInfo.getVersionableHandle(), oldRootInfo.isContentChanged(), oldRootInfo.getLastContentChangeCheckStamp(), (IFolderHandle)newInfo.getRootVersionable(), name, oldRootInfo.isLoadedWithAnotherName(), oldRootInfo.getRemoteChildren(), localParent, localName, oldRootInfo.getHash(), oldRootInfo.getContentLength(), oldRootInfo.getOriginalLineDelimiter(), oldRootInfo.getLineDelimiter(), oldRootInfo.getOriginalContentType(), oldRootInfo.getContentType(), oldRootInfo.getStoredPredecessorHintHash(), oldRootInfo.getStoredSize(), oldRootInfo.getStoredEncoding(), oldRootInfo.getStoredHash(), oldRootInfo.getStoredNumLineDelimiters(), oldRootInfo.isExecutable(), oldRootInfo.isOriginalExecutable());
            itemInfos.put(oldRootInfo.getVersionableHandle().getItemId(), oldRootInfo);
        }
        this.metadata.setFileItemInfo(oldSharePath, newRootInfo);
        if (pathToNewRootInOldComponent != null && oldSharePath.isPrefixOf(pathToNewRootInOldComponent)) {
            this.metadata.setFileItemInfo(pathToNewRootInOldComponent, oldRootInfo);
        }
        this.adjustChildrenToNewParent(oldSharePath, (IFolderHandle)newInfo.getRootVersionable(), newInfo.getComponent(), newInfo.getConnectionHandle(), itemInfos, (IProgressMonitor)progress.newChild(5));
        if (pathToNewRootInOldComponent != null && oldSharePath.isPrefixOf(pathToNewRootInOldComponent)) {
            this.adjustChildrenToNewParent(pathToNewRootInOldComponent, (IFolderHandle)oldRootInfo.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), itemInfos, (IProgressMonitor)progress.newChild(5));
        }
        for (InverseFileItemInfo info : itemInfos.values()) {
            this.metadata.setFileItemInfo(info.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), info);
        }
    }

    private boolean sameWorkspaceComponent(ISharingDescriptor oldInfo, ISharingDescriptor newInfo) {
        return oldInfo.getComponent().sameItemId((IItemHandle)newInfo.getComponent()) && oldInfo.getConnectionHandle().sameItemId((IItemHandle)newInfo.getConnectionHandle());
    }

    private void removeLocalInfoFromInverseMetadata(IPath oldSharePath, final IComponentHandle component, final IContextHandle connection, SubMonitor progress) throws FileSystemClientException {
        final ArrayList<FileSystemClientException> exceptions = new ArrayList<FileSystemClientException>();
        this.metadata.accept(new IVisitor(){

            public boolean visit(IPath path, FileItemInfo entry, IProgressMonitor monitor) {
                try {
                    if (entry.getVersionableHandle().hasStateId()) {
                        InverseFileItemInfo inverse = CopyFileAreaStore.this.metadata.getFileItemInfo(entry.getVersionableHandle(), component, connection);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), component, connection, inverse.asLocalDeletion());
                    }
                }
                catch (FileSystemClientException e) {
                    exceptions.add(e);
                }
                return true;
            }
        }, oldSharePath, Integer.MAX_VALUE, true, (IProgressMonitor)progress);
        this.handleExceptions(exceptions, Messages.CopyFileAreaStore_21);
    }

    private void assignNewUUIDsToRemoteSharesWithNoLocal(IVersionableHandle root, final IComponentHandle component, final IContextHandle connection, SubMonitor progress) throws FileSystemClientException {
        final ArrayList<FileSystemClientException> exceptions = new ArrayList<FileSystemClientException>();
        this.metadata.accept(new IRemoteVisitor(){

            public boolean visit(IPath path, InverseFileItemInfo entry, IProgressMonitor monitor) {
                try {
                    if (entry.getLocalName() != null && entry.getVersionableHandle().hasStateId()) {
                        IPath localPath = CopyFileAreaStore.this.getLocalPathInternal(entry, component, connection);
                        InverseFileItemInfo newItemInfo = entry.withNewUUID();
                        CopyFileAreaStore.this.metadata.setFileItemInfo(localPath, newItemInfo);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(newItemInfo.getVersionableHandle(), component, connection, newItemInfo);
                        if (entry.getVersionableHandle() instanceof IFolderHandle) {
                            CopyFileAreaStore.this.updateLocalParent(localPath, (IFolderHandle)newItemInfo.getVersionableHandle(), component, connection);
                        }
                    }
                }
                catch (FileSystemClientException e) {
                    exceptions.add(e);
                }
                return true;
            }
        }, root, component, connection, Integer.MAX_VALUE, true, (IProgressMonitor)progress);
        this.handleExceptions(exceptions, Messages.CopyFileAreaStore_22);
    }

    private boolean moveInverseMetadataForShareRootToNewWC(final ISharingDescriptor oldInfo, final ISharingDescriptor newInfo, SubMonitor progress) throws FileSystemClientException {
        final ArrayList<FileSystemClientException> exceptions = new ArrayList<FileSystemClientException>();
        final boolean[] foundNewRootInRemoteSubtree = new boolean[1];
        this.metadata.accept(new IRemoteVisitor(){

            public boolean visit(IPath path, InverseFileItemInfo entry, IProgressMonitor monitor) {
                try {
                    IVersionableHandle versionableHandle = entry.getVersionableHandle();
                    CopyFileAreaStore.this.metadata.setFileItemInfo(versionableHandle, oldInfo.getComponent(), oldInfo.getConnectionHandle(), null);
                    boolean isNewRoot = versionableHandle.sameItemId((IItemHandle)newInfo.getRootVersionable());
                    if (isNewRoot) {
                        foundNewRootInRemoteSubtree[0] = true;
                    }
                    InverseFileItemInfo newFI = entry.forMoveToNewWC(entry.getParent(), entry.getName());
                    InverseFileItemInfo oldFI = CopyFileAreaStore.this.metadata.setFileItemInfo(versionableHandle, newInfo.getComponent(), newInfo.getConnectionHandle(), newFI);
                    if (oldFI == null) {
                        if (!versionableHandle.sameItemId((IItemHandle)oldInfo.getRootVersionable())) {
                            InverseFileItemInfo parentFI = CopyFileAreaStore.this.metadata.getFileItemInfo((IVersionableHandle)entry.getParent(), newInfo.getComponent(), newInfo.getConnectionHandle());
                            String name = entry.getName();
                            if (parentFI.getRemoteChildren().containsKey(name)) {
                                int cnt = 0;
                                do {
                                    name = String.valueOf(entry.getName()) + Integer.toString(cnt);
                                    ++cnt;
                                } while (parentFI.getRemoteChildren().containsKey(name));
                                newFI = entry.forMoveToNewWC(entry.getParent(), name);
                                CopyFileAreaStore.this.metadata.setFileItemInfo(versionableHandle, newInfo.getComponent(), newInfo.getConnectionHandle(), newFI);
                            }
                            parentFI = parentFI.addRemoteChild(name, versionableHandle);
                            CopyFileAreaStore.this.metadata.setFileItemInfo(parentFI.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), parentFI);
                        }
                    } else {
                        CopyFileAreaStore.this.metadata.setFileItemInfo(versionableHandle, newInfo.getComponent(), newInfo.getConnectionHandle(), oldFI);
                    }
                }
                catch (FileSystemClientException e) {
                    exceptions.add(e);
                }
                return true;
            }
        }, oldInfo.getRootVersionable(), oldInfo.getComponent(), oldInfo.getConnectionHandle(), Integer.MAX_VALUE, true, (IProgressMonitor)progress);
        this.handleExceptions(exceptions, Messages.CopyFileAreaStore_14);
        return foundNewRootInRemoteSubtree[0];
    }

    private InverseFileItemInfo fixLocalItemInverseMetadataForShareRootToNewWC(IPath oldSharePath, final ISharingDescriptor oldInfo, final ISharingDescriptor newInfo, SubMonitor progress) throws FileSystemClientException {
        final ArrayList<FileSystemClientException> exceptions = new ArrayList<FileSystemClientException>();
        final InverseFileItemInfo[] oldRootInfo = new InverseFileItemInfo[1];
        this.metadata.accept(new IVisitor(){

            public boolean visit(IPath path, FileItemInfo entry, IProgressMonitor monitor) {
                try {
                    if (!entry.getVersionableHandle().hasStateId()) {
                        CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), oldInfo.getComponent(), oldInfo.getConnectionHandle(), null);
                    }
                    InverseFileItemInfo inverse = CopyFileAreaStore.this.metadata.getFileItemInfo(entry.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle());
                    String localName = path.lastSegment();
                    if (inverse == null) {
                        FileItemInfo parentInfo = CopyFileAreaStore.this.metadata.getFileItemInfo(path.removeLastSegments(1));
                        inverse = entry.createInverseFileItemInfoForLocalItem((IFolderHandle)parentInfo.getVersionableHandle(), path.lastSegment());
                        CopyFileAreaStore.this.metadata.setFileItemInfo(inverse.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), inverse);
                    } else if (inverse.getLocalName() != null || CopyFileAreaStore.this.metadata.getPathForShareRoot(inverse.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle()) != null) {
                        IVersionableHandle h = (IVersionableHandle)entry.getVersionableHandle().getItemType().createItemHandle(UUID.generate(), null);
                        if (entry.getVersionableHandle().sameItemId((IItemHandle)oldInfo.getRootVersionable())) {
                            inverse = new InverseFileItemInfo((IFolderHandle)h, null, null, false, Collections.EMPTY_MAP, null, localName);
                            CopyFileAreaStore.this.metadata.setFileItemInfo(path, inverse);
                            CopyFileAreaStore.this.metadata.setFileItemInfo(inverse.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), inverse);
                            oldRootInfo[0] = inverse;
                        } else {
                            FileItemInfo parentInfo = CopyFileAreaStore.this.metadata.getFileItemInfo(path.removeLastSegments(1));
                            inverse = new InverseFileItemInfo(h, false, -1L, null, null, false, Collections.EMPTY_MAP, (IFolderHandle)parentInfo.getVersionableHandle(), localName, null, -1L, null, entry.getLineDelimiter(), null, entry.getContentType(), null, -1L, null, null, -1L, entry.isExecutable(), false);
                            CopyFileAreaStore.this.metadata.setFileItemInfo(path, inverse);
                            CopyFileAreaStore.this.metadata.setFileItemInfo(inverse.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), inverse);
                        }
                    } else if (!entry.getVersionableHandle().sameItemId((IItemHandle)oldInfo.getRootVersionable())) {
                        boolean modified;
                        long timeStamp;
                        FileItemInfo parentInfo = CopyFileAreaStore.this.metadata.getFileItemInfo(path.removeLastSegments(1));
                        if (inverse.isFolder()) {
                            timeStamp = -1L;
                            modified = false;
                        } else if (entry.getContentLength() == inverse.getContentLength() && inverse.getHash().equals((Object)entry.getHash())) {
                            timeStamp = entry.getLastContentChangeCheckStamp();
                            modified = entry.isContentChanged();
                        } else {
                            timeStamp = -1L;
                            modified = true;
                        }
                        inverse = inverse.updateLocalInfo(entry, modified, timeStamp, (IFolderHandle)parentInfo.getVersionableHandle(), localName);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(path, inverse);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), inverse);
                    } else {
                        IFolderHandle parent = inverse.getParent();
                        if (parent != null && CopyFileAreaStore.this.metadata.getFileItemInfo((IVersionableHandle)parent, newInfo.getComponent(), newInfo.getConnectionHandle()) != null) {
                            parent = null;
                        }
                        inverse = new InverseFileItemInfo((IFolderHandle)inverse.getVersionableHandle(), inverse.getParent(), inverse.getName(), inverse.isLoadedWithAnotherName(), inverse.getRemoteChildren(), parent, localName);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(path, inverse);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), newInfo.getComponent(), newInfo.getConnectionHandle(), inverse);
                        oldRootInfo[0] = inverse;
                    }
                }
                catch (FileSystemClientException e) {
                    exceptions.add(e);
                }
                return true;
            }
        }, oldSharePath, Integer.MAX_VALUE, true, (IProgressMonitor)progress);
        this.handleExceptions(exceptions, Messages.CopyFileAreaStore_15);
        return oldRootInfo[0];
    }

    private void adjustChildrenToNewParent(IPath parentPath, IFolderHandle newParent, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache, IProgressMonitor monitor) throws FileSystemClientException {
        Map<StringWrapper, FileItemInfo> childMap = this.metadata.getChildInfos(parentPath);
        for (FileItemInfo entry : childMap.values()) {
            InverseFileItemInfo newInfo = this.getFileItemInfo(entry.getVersionableHandle(), component, connection, cache);
            cache.put(newInfo.getVersionableHandle().getItemId(), newInfo.withLocalParent(newParent));
        }
    }

    private InverseFileItemInfo getFileItemInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection, Map<UUID, InverseFileItemInfo> cache) throws FileSystemClientException {
        InverseFileItemInfo result = cache.get(item.getItemId());
        if (result != null) {
            return result;
        }
        result = this.metadata.getFileItemInfo(item, component, connection);
        if (result == null) {
            return null;
        }
        cache.put(item.getItemId(), result);
        return result;
    }

    public ISharingDescriptor getSharingInfo(IPath sharePath) {
        this.assertReadLocked();
        try {
            return this.metadata.getSharingDescriptor(sharePath);
        }
        catch (FileSystemClientException e) {
            LoggingHelper.log(e);
            return null;
        }
    }

    public ISharingDescriptor findSharingDescriptor(IPath shareablePath) throws FileSystemClientException {
        this.assertReadLocked();
        return this.internalFindSharingDescriptor(shareablePath);
    }

    private ISharingDescriptor internalFindSharingDescriptor(IPath shareablePath) throws FileSystemClientException {
        return this.metadata.findSharingDescriptor(shareablePath);
    }

    public boolean isShareRoot(IVersionableHandle item, IComponentHandle component, IContextHandle connection) throws FileSystemClientException {
        this.assertReadLocked();
        return this.metadata.getPathForShareRoot(item, component, connection) != null;
    }

    public void removeSharingInfo(IPath sharePath, IProgressMonitor monitor) throws FileSystemClientException {
        block6: {
            this.assertReadLocked();
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            RuleDescriptorPair pair = this.beginBatching(sharePath, (IProgressMonitor)progress.newChild(1));
            try {
                ISharingDescriptor info = pair.desc;
                if (info != null) {
                    if (this.metadata.setSharingDescriptor(sharePath, null, (IProgressMonitor)progress.newChild(49)) == null) {
                        throw new IllegalArgumentException(sharePath + " is not a share root");
                    }
                    CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(info.getRootVersionable(), this, sharePath, 2));
                    if (!this.metadata.hasShares(info.getComponent(), info.getConnectionHandle(), (IProgressMonitor)progress.newChild(44))) {
                        LocalChangeManager.getInstance().clearPendingChanges(info.getConnectionHandle(), info.getComponent(), this.getRoot());
                        this.componentUnloaded(info.getComponent(), info.getConnectionHandle(), (IProgressMonitor)progress.newChild(5));
                    }
                    break block6;
                }
                throw new IllegalArgumentException(sharePath + " is not shared");
            }
            finally {
                CopyFileAreaStore.endBatching(pair.rule, (IProgressMonitor)progress.newChild(1));
                progress.done();
            }
        }
    }

    public void removeSharingInfo(IContextHandle connectionHandle, IComponentHandle component, IVersionableHandle item, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connectionHandle, component), (IProgressMonitor)progress.newChild(1));
        try {
            IPath sharePath = this.metadata.getPathForShareRoot(item, component, connectionHandle);
            if (sharePath != null) {
                this.metadata.setSharingDescriptor(sharePath, null, (IProgressMonitor)progress.newChild(49));
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(item, this, sharePath, 2));
                if (!this.metadata.hasShares(component, connectionHandle, (IProgressMonitor)progress.newChild(44))) {
                    LocalChangeManager.getInstance().clearPendingChanges(connectionHandle, component, this.getRoot());
                    this.componentUnloaded(component, connectionHandle, (IProgressMonitor)progress.newChild(5));
                }
            } else {
                progress.setWorkRemaining(1);
            }
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    protected RuleDescriptorPair beginBatching(IPath shareablePath, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        RuleDescriptorPair result = new RuleDescriptorPair();
        ISharingDescriptor desc = this.internalFindSharingDescriptor(shareablePath);
        while (true) {
            progress.setWorkRemaining(100);
            result.desc = desc;
            if (desc == null) {
                result.rule = CopyFileAreaStore.beginBatching(BatchingLock.NULL_SCHEDULING_RULE, null);
                progress.done();
                return result;
            }
            result.rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), desc.getConnectionHandle(), desc.getComponent()), (IProgressMonitor)progress.newChild(50));
            boolean success = false;
            try {
                desc = this.internalFindSharingDescriptor(shareablePath);
                if (desc == null || !desc.getComponent().sameItemId((IItemHandle)result.desc.getComponent()) || !desc.getConnectionHandle().sameItemId((IItemHandle)result.desc.getConnectionHandle())) continue;
                progress.done();
                success = true;
                RuleDescriptorPair ruleDescriptorPair = result;
                return ruleDescriptorPair;
            }
            finally {
                if (success) continue;
                CopyFileAreaStore.endBatching(result.rule, (IProgressMonitor)progress.newChild(1));
                continue;
            }
            break;
        }
    }

    private RuleDescriptorPairForMove beginBatching(IPath sourcePath, IPath destinationPath, SubMonitor progress) throws FileSystemClientException {
        RuleDescriptorPairForMove desc = new RuleDescriptorPairForMove();
        while (true) {
            progress.setWorkRemaining(100);
            desc.beginBatching(this.getRoot(), this.internalFindSharingDescriptor(sourcePath), this.internalFindSharingDescriptor(destinationPath), progress.newChild(50));
            boolean success = false;
            try {
                if (!desc.descriptorsInSameComponent(this.internalFindSharingDescriptor(sourcePath), this.internalFindSharingDescriptor(destinationPath))) continue;
                progress.done();
                success = true;
                RuleDescriptorPairForMove ruleDescriptorPairForMove = desc;
                return ruleDescriptorPairForMove;
            }
            finally {
                if (success) continue;
                desc.endBatching(progress.newChild(1));
                continue;
            }
            break;
        }
    }

    public static AbstractLock beginBatching(AbstractLock resourceRule, IProgressMonitor monitor) {
        CopyFileAreaManager instance = CopyFileAreaManager.instance;
        return instance.batchingLock.acquire(resourceRule, instance, CopyFileAreaManager.NULL_PARTICIPANT, true, monitor);
    }

    public static AbstractLock beginBatchingWithLock(AbstractLock resourceRule, ILockParticipant participant, IProgressMonitor monitor) {
        CopyFileAreaManager instance = CopyFileAreaManager.instance;
        return instance.batchingLock.acquire(resourceRule, instance, participant, true, monitor);
    }

    public static AbstractLock beginBatchingNoWait(AbstractLock resourceRule) {
        CopyFileAreaManager instance = CopyFileAreaManager.instance;
        return instance.batchingLock.acquire(resourceRule, instance, CopyFileAreaManager.NULL_PARTICIPANT, false, null);
    }

    public static void endBatching(AbstractLock rule, IProgressMonitor monitor) throws FileSystemClientException {
        CopyFileAreaManager.instance.batchingLock.release(rule, monitor);
    }

    public void internalClear() throws FileSystemClientException {
        this.metadata.clear();
    }

    public boolean isConnectionShared(IContextHandle connection) throws FileSystemClientException {
        this.assertReadLocked();
        return this.internalIsConnectionShared(connection);
    }

    boolean internalIsConnectionShared(IContextHandle connection) throws FileSystemClientException {
        for (ISharingDescriptor descriptor : this.metadata.getSharingDescriptors().values()) {
            if (!descriptor.getConnectionHandle().sameItemId((IItemHandle)connection)) continue;
            return true;
        }
        return false;
    }

    public void accept(IRemoteVisitor metadataVisitor, IVersionableHandle item, IComponentHandle component, IContextHandle connection, AbstractLock rule, int depth, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (rule != null) {
                rule = CopyFileAreaStore.beginBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            this.metadata.accept(metadataVisitor, item, component, connection, depth, rule != null, (IProgressMonitor)progress.newChild(98));
        }
        finally {
            if (rule != null) {
                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
        }
    }

    public void accept(IVisitor metadataVisitor, IPath shareablePath, boolean mutable, int depth, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            this.metadata.accept(metadataVisitor, shareablePath, depth, mutable, (IProgressMonitor)progress.newChild(98));
        }
        finally {
            progress.done();
        }
    }

    public IPath[] allSharePaths() throws FileSystemClientException {
        this.assertReadLocked();
        return this.metadata.allShares();
    }

    public Collection<IPath> allSharePaths(IPath parent) throws FileSystemClientException {
        this.assertReadLocked();
        return this.metadata.allShares(parent);
    }

    public boolean deleteTreeInfo(IPath shareablePath, boolean removeRemoteInfo, IProgressMonitor monitor) throws FileSystemClientException {
        boolean bl;
        SubMonitor progress;
        block5: {
            this.assertReadLocked();
            AbstractLock rule = null;
            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            try {
                IContextHandle connection;
                IComponentHandle component;
                RuleDescriptorPair pair = this.beginBatching(shareablePath, (IProgressMonitor)progress.newChild(1));
                ISharingDescriptor desc = pair.desc;
                rule = pair.rule;
                if (desc != null) {
                    component = desc.getComponent();
                    connection = desc.getConnectionHandle();
                } else {
                    component = null;
                    connection = null;
                }
                bl = this.deleteTreeInfoInternal(shareablePath, component, connection, removeRemoteInfo, (IProgressMonitor)progress.newChild(98));
                if (rule == null) break block5;
            }
            catch (Throwable throwable) {
                if (rule != null) {
                    CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
                }
                progress.done();
                throw throwable;
            }
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
        return bl;
    }

    public void deleteTreeInfo(IVersionableHandle item, IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        InverseFileItemInfo info;
        SubMonitor progress;
        AbstractLock rule;
        block9: {
            block10: {
                this.assertReadLocked();
                rule = null;
                progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
                info = this.metadata.getFileItemInfo(item, component, connection);
                if (info != null) break block9;
                if (rule == null) break block10;
                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
            return;
        }
        try {
            if (info.getParent() != null && this.metadata.getPathForShareRoot(info.getVersionableHandle(), component, connection) == null) {
                this.updateParentInfoForRemoval(info, component, connection);
            }
            ArrayList<IVersionableHandle> toDelete = new ArrayList<IVersionableHandle>();
            toDelete.add(item);
            do {
                IVersionableHandle itemToDelete;
                IPath localPath;
                if ((localPath = this.getLocalPathInternal(info = this.metadata.setFileItemInfo(itemToDelete = (IVersionableHandle)toDelete.remove(toDelete.size() - 1), component, connection, null), component, connection)) != null) {
                    InverseFileItemInfo newInfo = new InverseFileItemInfo((IVersionableHandle)info.getVersionableHandle().getItemType().createItemHandle(UUID.generate(), null), false, -1L, null, null, info.isLoadedWithAnotherName(), Collections.EMPTY_MAP, info.getLocalParent(), info.getLocalName(), null, -1L, null, info.getLineDelimiter(), null, info.getContentType(), null, -1L, null, null, -1L, info.isExecutable(), false);
                    this.metadata.setFileItemInfo(newInfo.getVersionableHandle(), component, connection, newInfo);
                    this.metadata.setFileItemInfo(localPath, newInfo);
                    if (info.isFolder()) {
                        this.updateLocalParent(localPath, (IFolderHandle)newInfo.getVersionableHandle(), component, connection);
                    }
                }
                toDelete.addAll(info.getRemoteChildren().values());
            } while (!toDelete.isEmpty());
        }
        catch (Throwable throwable) {
            if (rule != null) {
                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
            throw throwable;
        }
        if (rule != null) {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
        }
        progress.done();
    }

    private boolean deleteTreeInfoInternal(final IPath startingPath, final IComponentHandle component, final IContextHandle connection, boolean removeRemoteInfo, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        final ArrayList exceptions = new ArrayList();
        final IVersionableHandle[] root = new IVersionableHandle[1];
        final boolean[] changed = new boolean[1];
        this.metadata.accept(new IVisitor(){

            public boolean visit(IPath path, FileItemInfo entry, IProgressMonitor monitor) {
                if (path.equals((Object)startingPath)) {
                    root[0] = entry.getVersionableHandle();
                }
                if (component != null) {
                    try {
                        InverseFileItemInfo info = CopyFileAreaStore.this.metadata.getFileItemInfo(entry.getVersionableHandle(), component, connection);
                        if (info.getVersionableHandle().hasStateId() != entry.getVersionableHandle().hasStateId() || info.getVersionableHandle().hasStateId() && !info.getVersionableHandle().sameStateId((IItemHandle)entry.getVersionableHandle())) {
                            throw new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_18, (Object)path));
                        }
                        if (info.getVersionableHandle().hasStateId()) {
                            InverseFileItemInfo newInfo = new InverseFileItemInfo(info.getVersionableHandle(), false, -1L, info.getParent(), info.getName(), info.isLoadedWithAnotherName(), info.getRemoteChildren(), null, null, info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredPredecessorHintHash(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredHash(), info.getStoredNumLineDelimiters(), info.isOriginalExecutable(), info.isOriginalExecutable());
                            CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), component, connection, newInfo);
                        } else {
                            CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), component, connection, null);
                        }
                        changed[0] = true;
                    }
                    catch (FileSystemClientException e) {
                        exceptions.add(e);
                    }
                }
                return true;
            }
        }, startingPath, Integer.MAX_VALUE, true, (IProgressMonitor)progress.newChild(33));
        if (component != null && removeRemoteInfo && root[0] != null && root[0].hasStateId()) {
            this.metadata.accept(new IRemoteVisitor(){

                public boolean visit(IPath path, InverseFileItemInfo entry, IProgressMonitor monitor) {
                    try {
                        if (entry.getVersionableHandle().sameItemId((IItemHandle)root[0]) && entry.getParent() != null && CopyFileAreaStore.this.metadata.getPathForShareRoot(entry.getVersionableHandle(), component, connection) == null) {
                            CopyFileAreaStore.this.updateParentInfoForRemoval(entry, component, connection);
                        }
                        if (entry.getLocalName() != null) {
                            InverseFileItemInfo newInfo = new InverseFileItemInfo((IVersionableHandle)entry.getVersionableHandle().getItemType().createItemHandle(UUID.generate(), null), false, -1L, null, null, false, Collections.EMPTY_MAP, entry.getLocalParent(), entry.getLocalName(), null, -1L, null, entry.getLineDelimiter(), null, entry.getContentType(), null, -1L, null, null, -1L, entry.isExecutable(), false);
                            IPath localPath = CopyFileAreaStore.this.getLocalPathInternal(entry, component, connection);
                            if (entry.getVersionableHandle() instanceof IFolderHandle) {
                                CopyFileAreaStore.this.updateLocalParent(localPath, (IFolderHandle)newInfo.getVersionableHandle(), component, connection);
                            }
                            CopyFileAreaStore.this.metadata.setFileItemInfo(localPath, newInfo);
                            CopyFileAreaStore.this.metadata.setFileItemInfo(newInfo.getVersionableHandle(), component, connection, newInfo);
                        }
                        CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), component, connection, null);
                        changed[0] = true;
                    }
                    catch (FileSystemClientException e) {
                        exceptions.add(e);
                    }
                    return true;
                }
            }, root[0], component, connection, Integer.MAX_VALUE, true, (IProgressMonitor)progress.newChild(34));
        } else {
            progress.setWorkRemaining(33);
        }
        this.metadata.deleteFileItemInfo(startingPath, (IProgressMonitor)progress.newChild(33));
        if (!exceptions.isEmpty()) {
            MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaStore_19, null);
            for (FileSystemClientException ex : exceptions) {
                multi.add(FileSystemStatus.getStatusFor((Throwable)((Object)ex)));
            }
            throw new FileSystemClientException((IStatus)multi);
        }
        return changed[0];
    }

    public void moveTreeInfo(IPath sourcePath, IPath destinationPath, boolean remoteMove, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        RuleDescriptorPairForMove pair = null;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            pair = this.beginBatching(sourcePath, destinationPath, progress.newChild(1));
            ISharingDescriptor sourceDesc = pair.sourceDesc;
            ISharingDescriptor destDesc = pair.destDesc;
            if (destDesc == null) {
                throw new AssertionFailedException(NLS.bind((String)"No sharing descriptor found for path ''{0}''", (Object)destinationPath.toString()));
            }
            FileItemInfo destInfo = this.metadata.getFileItemInfo(destinationPath);
            if (destInfo != null && !this.metadata.isSamePath(sourcePath, destinationPath)) {
                this.deleteTreeInfoInternal(destinationPath, sourceDesc.getComponent(), sourceDesc.getConnectionHandle(), false, (IProgressMonitor)progress.newChild(1));
            }
            if (this.sameWorkspaceComponent(sourceDesc, destDesc)) {
                this.moveSubtree(sourcePath, sourceDesc, destinationPath, remoteMove);
            } else {
                this.moveSubtreeToWC(sourcePath, sourceDesc, destinationPath, destDesc, progress.newChild(97));
            }
        }
        finally {
            if (pair != null) {
                pair.endBatching(progress.newChild(1));
            }
            progress.done();
        }
    }

    private void moveSubtreeToWC(IPath sourcePath, ISharingDescriptor sourceDesc, IPath destinationPath, ISharingDescriptor destDesc, SubMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        FileItemInfo sourceFileItemInfo = this.metadata.getFileItemInfo(sourcePath);
        if (sourceFileItemInfo == null) {
            throw new AssertionFailedException("File item info expected but not found at source path " + sourcePath.toOSString());
        }
        IVersionableHandle sourceVersionable = sourceFileItemInfo.getVersionableHandle();
        FileItemInfo destFileItemInfo = this.metadata.getFileItemInfo(destinationPath);
        if (destFileItemInfo != null) {
            throw new AssertionFailedException("File item info found but not expected at destination path " + destinationPath.toOSString());
        }
        FileItemInfo destinationParentInfo = this.metadata.getFileItemInfo(destinationPath.removeLastSegments(1));
        if (destinationParentInfo == null) {
            throw new AssertionFailedException("File item info not found but expected for parent of destination path " + destinationPath.toOSString());
        }
        this.removeLocalInfoFromInverseMetadata(sourcePath, sourceDesc.getComponent(), sourceDesc.getConnectionHandle(), progress.newChild(25));
        this.assignNewUUIDsToRemoteSharesWithNoLocal(sourceVersionable, sourceDesc.getComponent(), sourceDesc.getConnectionHandle(), progress.newChild(20));
        this.moveInverseMetadataToNewWC(sourceVersionable, sourceDesc, (IFolderHandle)destinationParentInfo.getVersionableHandle(), destDesc, progress.newChild(20));
        InverseFileItemInfo sourceParentInfo = this.metadata.getFileItemInfo((IVersionableHandle)sourceFileItemInfo.getParent(), sourceDesc.getComponent(), sourceDesc.getConnectionHandle());
        this.metadata.setFileItemInfo((IVersionableHandle)sourceFileItemInfo.getParent(), sourceDesc.getComponent(), sourceDesc.getConnectionHandle(), sourceParentInfo.removeRemoteChild(sourcePath.lastSegment()));
        this.fixInverseMetadataForLocalItems(sourcePath, sourceDesc, (IFolderHandle)destinationParentInfo.getVersionableHandle(), destDesc, progress.newChild(25));
        if (!sourcePath.equals((Object)destinationPath)) {
            this.metadata.moveFileItemInfo(sourcePath, destinationPath);
        }
        progress.done();
    }

    private void moveInverseMetadataToNewWC(final IVersionableHandle sourceRoot, final ISharingDescriptor sourceDesc, final IFolderHandle destinationParent, final ISharingDescriptor destinationDesc, SubMonitor progress) throws FileSystemClientException {
        final ArrayList<FileSystemClientException> exceptions = new ArrayList<FileSystemClientException>();
        this.metadata.accept(new IRemoteVisitor(){

            public boolean visit(IPath path, InverseFileItemInfo entry, IProgressMonitor monitor) {
                try {
                    IVersionableHandle versionableHandle = entry.getVersionableHandle();
                    CopyFileAreaStore.this.metadata.setFileItemInfo(versionableHandle, sourceDesc.getComponent(), sourceDesc.getConnectionHandle(), null);
                    IFolderHandle parentVersionable = sourceRoot.sameItemId((IItemHandle)entry.getVersionableHandle()) ? destinationParent : entry.getParent();
                    InverseFileItemInfo newFI = entry.forMoveToNewWC(parentVersionable, entry.getName());
                    InverseFileItemInfo oldFI = CopyFileAreaStore.this.metadata.setFileItemInfo(versionableHandle, destinationDesc.getComponent(), destinationDesc.getConnectionHandle(), newFI);
                    if (oldFI == null) {
                        String name = entry.getName();
                        InverseFileItemInfo parentFI = CopyFileAreaStore.this.metadata.getFileItemInfo((IVersionableHandle)parentVersionable, destinationDesc.getComponent(), destinationDesc.getConnectionHandle());
                        if (parentFI.getRemoteChildren().containsKey(name)) {
                            int cnt = 0;
                            do {
                                name = String.valueOf(entry.getName()) + Integer.toString(cnt);
                                ++cnt;
                            } while (parentFI.getRemoteChildren().containsKey(name));
                            newFI = entry.forMoveToNewWC(parentVersionable, name);
                            CopyFileAreaStore.this.metadata.setFileItemInfo(versionableHandle, destinationDesc.getComponent(), destinationDesc.getConnectionHandle(), newFI);
                        }
                        parentFI = parentFI.addRemoteChild(name, versionableHandle);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(parentFI.getVersionableHandle(), destinationDesc.getComponent(), destinationDesc.getConnectionHandle(), parentFI);
                    } else {
                        CopyFileAreaStore.this.metadata.setFileItemInfo(versionableHandle, destinationDesc.getComponent(), destinationDesc.getConnectionHandle(), oldFI);
                    }
                }
                catch (FileSystemClientException e) {
                    exceptions.add(e);
                }
                return true;
            }
        }, sourceRoot, sourceDesc.getComponent(), sourceDesc.getConnectionHandle(), Integer.MAX_VALUE, true, (IProgressMonitor)progress);
        this.handleExceptions(exceptions, Messages.CopyFileAreaStore_14);
    }

    private void fixInverseMetadataForLocalItems(final IPath sourcePath, final ISharingDescriptor sourceDesc, final IFolderHandle destinationParent, final ISharingDescriptor destinationDesc, SubMonitor progress) throws FileSystemClientException {
        final ArrayList<FileSystemClientException> exceptions = new ArrayList<FileSystemClientException>();
        this.metadata.accept(new IVisitor(){

            public boolean visit(IPath path, FileItemInfo entry, IProgressMonitor monitor) {
                try {
                    IFolderHandle parentHandle;
                    if (!entry.getVersionableHandle().hasStateId()) {
                        CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), sourceDesc.getComponent(), sourceDesc.getConnectionHandle(), null);
                    }
                    InverseFileItemInfo inverse = CopyFileAreaStore.this.metadata.getFileItemInfo(entry.getVersionableHandle(), destinationDesc.getComponent(), destinationDesc.getConnectionHandle());
                    String localName = path.lastSegment();
                    if (path.equals((Object)sourcePath)) {
                        parentHandle = destinationParent;
                    } else {
                        FileItemInfo parentInfo = CopyFileAreaStore.this.metadata.getFileItemInfo(path.removeLastSegments(1));
                        parentHandle = (IFolderHandle)parentInfo.getVersionableHandle();
                    }
                    if (inverse == null) {
                        inverse = entry.createInverseFileItemInfoForLocalItem(parentHandle, path.lastSegment());
                        CopyFileAreaStore.this.metadata.setFileItemInfo(inverse.getVersionableHandle(), destinationDesc.getComponent(), destinationDesc.getConnectionHandle(), inverse);
                    } else {
                        boolean modified;
                        long timeStamp;
                        if (inverse.isFolder()) {
                            timeStamp = -1L;
                            modified = false;
                        } else if (entry.getContentLength() == inverse.getContentLength() && inverse.getHash().equals((Object)entry.getHash())) {
                            timeStamp = entry.getLastContentChangeCheckStamp();
                            modified = entry.isContentChanged();
                        } else {
                            timeStamp = -1L;
                            modified = true;
                        }
                        inverse = inverse.updateLocalInfo(entry, modified, timeStamp, parentHandle, localName);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(path, inverse);
                        CopyFileAreaStore.this.metadata.setFileItemInfo(entry.getVersionableHandle(), destinationDesc.getComponent(), destinationDesc.getConnectionHandle(), inverse);
                    }
                }
                catch (FileSystemClientException e) {
                    exceptions.add(e);
                }
                return true;
            }
        }, sourcePath, Integer.MAX_VALUE, true, (IProgressMonitor)progress);
        this.handleExceptions(exceptions, Messages.CopyFileAreaStore_15);
    }

    private void moveSubtree(IPath sourcePath, ISharingDescriptor sourceDesc, IPath destinationPath, boolean remoteMove) throws FileSystemClientException {
        FileItemInfo info = this.metadata.getFileItemInfo(sourcePath);
        if (info != null) {
            String remoteName;
            IFolderHandle remoteParent;
            Assert.isTrue((!info.getVersionableHandle().sameItemId((IItemHandle)sourceDesc.getRootVersionable()) ? 1 : 0) != 0);
            FileItemInfo parentInfo = this.metadata.getFileItemInfo(destinationPath.removeLastSegments(1));
            IFolderHandle parent = (IFolderHandle)parentInfo.getVersionableHandle();
            String name = destinationPath.lastSegment();
            if (remoteMove) {
                remoteParent = parent;
                remoteName = name;
            } else {
                remoteParent = info.getParent();
                remoteName = info.getName();
            }
            InverseFileItemInfo oldInverseInfo = this.metadata.getFileItemInfo(info.getVersionableHandle(), sourceDesc.getComponent(), sourceDesc.getConnectionHandle());
            InverseFileItemInfo newInfo = new InverseFileItemInfo(info.getVersionableHandle(), info.isContentChanged(), info.getLastContentChangeCheckStamp(), remoteParent, remoteName, info.isLoadedWithAnotherName(), oldInverseInfo.getRemoteChildren(), parent, name, info.getHash(), info.getContentLength(), info.getOriginalLineDelimiter(), info.getLineDelimiter(), info.getOriginalContentType(), info.getContentType(), info.getStoredPredecessorHintHash(), info.getStoredSize(), info.getStoredEncoding(), info.getStoredHash(), info.getStoredNumLineDelimiters(), info.isExecutable(), info.isOriginalExecutable());
            this.updateParentInfoForChange(newInfo, info, sourceDesc.getComponent(), sourceDesc.getConnectionHandle());
            this.metadata.setFileItemInfo(info.getVersionableHandle(), sourceDesc.getComponent(), sourceDesc.getConnectionHandle(), newInfo);
            if (remoteMove) {
                this.metadata.setFileItemInfo(sourcePath, newInfo);
            }
        }
        this.metadata.moveFileItemInfo(sourcePath, destinationPath);
    }

    public void run(AbstractLock rule, IOperation operation, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            rule = CopyFileAreaStore.beginBatching(rule, (IProgressMonitor)progress.newChild(1));
            operation.execute((IProgressMonitor)progress.newChild(98));
        }
        finally {
            if (rule != null) {
                CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            }
            progress.done();
        }
    }

    public void run(final IOperation operation, final IProgressMonitor monitor) throws FileSystemClientException {
        this.metadata.run(new ISharingMetadata.ITransaction(){

            public void run() throws FileSystemClientException {
                operation.execute(monitor);
            }
        });
    }

    public String toDebugString() {
        this.assertReadLocked();
        return this.metadata.toDebugString();
    }

    public ISharingMetadata internalGetMetadata() {
        return this.metadata;
    }

    public void close() throws FileSystemClientException {
        CopyFileAreaManager.instance.deregister(this.getRoot(), false, null);
    }

    void internalClose() throws FileSystemClientException {
        this.metadata.close();
        LocalChangeManager.getInstance().clearPendingChanges(this.getRoot());
    }

    public void sync() throws FileSystemClientException {
        this.assertReadLocked();
        this.metadata.close();
    }

    public IPath getRoot() {
        return this.path;
    }

    public boolean isCaseSensitive() {
        return this.metadata.isCaseSensitive();
    }

    public void setConfigurationState(IContextHandle connectionHandle, IComponentHandle component, ISyncTime beforeConfigurationState, ISyncTime configurationState, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connectionHandle, component), (IProgressMonitor)progress.newChild(1));
        try {
            Map<IPath, ISharingDescriptor> sharingDescriptors = this.metadata.getSharingDescriptors(component, connectionHandle);
            SubMonitor subProgress = progress.newChild(98);
            subProgress.setWorkRemaining(sharingDescriptors.size());
            for (Map.Entry<IPath, ISharingDescriptor> entry : sharingDescriptors.entrySet()) {
                ISharingDescriptor descriptor = entry.getValue();
                IPath sharePath = entry.getKey();
                this.updateConfigurationState(sharePath, descriptor, beforeConfigurationState, configurationState, subProgress);
            }
            subProgress.done();
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    private void updateConfigurationState(IPath sharePath, ISharingDescriptor sharingDescriptor, ISyncTime beforeConfigurationState, ISyncTime configurationState, SubMonitor subProgress) throws FileSystemClientException {
        SharingDescriptor descriptor = (SharingDescriptor)sharingDescriptor;
        if (beforeConfigurationState == null || beforeConfigurationState.equals(descriptor.getConfigurationState())) {
            SharingDescriptor newDescriptor = new SharingDescriptor(descriptor, configurationState);
            this.metadata.setSharingDescriptor(sharePath, newDescriptor, (IProgressMonitor)subProgress.newChild(1));
            CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(newDescriptor.getRootVersionable(), this, sharePath, 6));
        } else if (configurationState.equals(descriptor.getConfigurationState())) {
            subProgress.worked(1);
        } else if (descriptor.isUnknownState()) {
            SharingDescriptor newDescriptor = new SharingDescriptor(descriptor, ISyncTime.TIME_NONE);
            this.metadata.setSharingDescriptor(sharePath, newDescriptor, (IProgressMonitor)subProgress.newChild(1));
            CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(newDescriptor.getRootVersionable(), this, sharePath, 6));
        }
    }

    private void setConfigurationState(IContextHandle connectionHandle, IComponentHandle component, IVersionableHandle shareRootItem, ISyncTime configurationState, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connectionHandle, component), (IProgressMonitor)progress.newChild(1));
        try {
            SharingDescriptor descriptor;
            IPath sharePath = this.getLocalPathInternal(shareRootItem, component, connectionHandle);
            if (sharePath != null && (descriptor = (SharingDescriptor)this.metadata.getSharingDescriptor(sharePath)) != null && !configurationState.equals(descriptor.getConfigurationState())) {
                SharingDescriptor newDescriptor = new SharingDescriptor(descriptor, configurationState);
                this.metadata.setSharingDescriptor(sharePath, newDescriptor, (IProgressMonitor)progress.newChild(98));
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(newDescriptor.getRootVersionable(), this, sharePath, 6));
            }
            progress.setWorkRemaining(1);
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public void setConfigurationState(IContextHandle connectionHandle, IComponentHandle component, IPath sharePath, ISyncTime beforeConfigurationState, ISyncTime configurationState, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connectionHandle, component), (IProgressMonitor)progress.newChild(1));
        try {
            ISharingDescriptor descriptor = this.metadata.getSharingDescriptor(sharePath);
            if (descriptor != null && descriptor.getComponent().sameItemId((IItemHandle)component) && descriptor.getConnectionHandle().sameItemId((IItemHandle)connectionHandle)) {
                this.updateConfigurationState(sharePath, descriptor, beforeConfigurationState, configurationState, progress.newChild(98));
            }
            progress.setWorkRemaining(1);
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public void setConfigurationState(IContextHandle connectionHandle, IComponentHandle component, IPath sharePath, ISyncTime configurationState, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connectionHandle, component), (IProgressMonitor)progress.newChild(1));
        try {
            SharingDescriptor descriptor = (SharingDescriptor)this.metadata.getSharingDescriptor(sharePath);
            if (descriptor != null && descriptor.getComponent().sameItemId((IItemHandle)component) && descriptor.getConnectionHandle().sameItemId((IItemHandle)connectionHandle) && !configurationState.equals(descriptor.getConfigurationState())) {
                SharingDescriptor newDescriptor = new SharingDescriptor(descriptor, configurationState);
                this.metadata.setSharingDescriptor(sharePath, newDescriptor, (IProgressMonitor)progress.newChild(98));
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(newDescriptor.getRootVersionable(), this, sharePath, 6));
            }
            progress.setWorkRemaining(1);
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public void setUnknownConfigurationState(IContextHandle connectionHandle, IComponentHandle component, IPath sharePath, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connectionHandle, component), (IProgressMonitor)progress.newChild(1));
        try {
            SharingDescriptor descriptor = (SharingDescriptor)this.metadata.getSharingDescriptor(sharePath);
            if (descriptor != null && descriptor.getComponent().sameItemId((IItemHandle)component) && descriptor.getConnectionHandle().sameItemId((IItemHandle)connectionHandle)) {
                SharingDescriptor newDescriptor = new SharingDescriptor(descriptor, ISyncTime.TIME_NONE);
                this.metadata.setSharingDescriptor(sharePath, newDescriptor, (IProgressMonitor)progress.newChild(98));
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(newDescriptor.getRootVersionable(), this, sharePath, 6));
            }
            progress.setWorkRemaining(1);
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public boolean isLoaded(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        return this.internalIsLoaded(component, connection, monitor);
    }

    boolean internalIsLoaded(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        return this.metadata.isLoaded(component, connection, monitor);
    }

    public Collection<LoadedConfigurationDescriptor> allLoadedComponents(IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        return this.internalAllLoadedComponents(monitor);
    }

    Collection<LoadedConfigurationDescriptor> internalAllLoadedComponents(IProgressMonitor monitor) throws FileSystemClientException {
        return this.metadata.allLoadedComponents(monitor);
    }

    public Collection<ConnectionDescriptor> allLoadedContexts(IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        return this.internalAllLoadedContexts(monitor);
    }

    Collection<ConnectionDescriptor> internalAllLoadedContexts(IProgressMonitor monitor) throws FileSystemClientException {
        return this.metadata.allLoadedContexts(monitor);
    }

    public void componentLoaded(LoadedConfigurationDescriptor desc, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), desc.connectionHandle, desc.componentHandle), (IProgressMonitor)progress.newChild(1));
        try {
            boolean alreadyLoaded;
            boolean bl = alreadyLoaded = this.metadata.componentLoaded(desc, (IProgressMonitor)progress.newChild(98)) != null;
            if (!alreadyLoaded) {
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(null, this, null, 7));
            }
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public void componentUnloaded(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), connection, component), (IProgressMonitor)progress.newChild(1));
        try {
            boolean wasLoaded;
            if (this.metadata.hasShares(component, connection, (IProgressMonitor)progress.newChild(49))) {
                throw new FileSystemClientException(new FileSystemStatus(Messages.CopyFileAreaStore_20));
            }
            boolean bl = wasLoaded = this.metadata.componentUnloaded(component, connection, (IProgressMonitor)progress.newChild(49)) != null;
            if (wasLoaded) {
                CopyFileAreaManager.instance.batchingLock.addChange(new CopyFileAreaEvent(null, this, null, 8));
            }
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    public boolean isCorrupted() {
        this.assertReadLocked();
        return this.metadata.isCorrupted();
    }

    public int getNumShares(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        return this.internalGetNumShares(component, connection, monitor);
    }

    int internalGetNumShares(IComponentHandle component, IContextHandle connection, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        int result = this.metadata.getSharingDescriptors(component, connection).size();
        progress.done();
        return result;
    }

    public Map<IPath, ISharingDescriptor> getShares(IContextHandle context, IComponentHandle component, IProgressMonitor monitor) throws FileSystemClientException {
        this.assertReadLocked();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        AbstractLock rule = CopyFileAreaStore.beginBatching(new ComponentLock(this.getRoot(), context, component), (IProgressMonitor)progress.newChild(1));
        try {
            Map<IPath, ISharingDescriptor> map = this.metadata.getSharingDescriptors(component, context);
            return map;
        }
        finally {
            CopyFileAreaStore.endBatching(rule, (IProgressMonitor)progress.newChild(1));
            progress.done();
        }
    }

    private void handleExceptions(List<FileSystemClientException> exceptions, String message) throws FileSystemClientException {
        if (!exceptions.isEmpty()) {
            MultiStatus multi = new MultiStatus("com.ibm.team.filesystem.client", 0, message, null);
            for (FileSystemClientException ex : exceptions) {
                multi.add(FileSystemStatus.getStatusFor((Throwable)((Object)ex)));
            }
            throw new FileSystemClientException((IStatus)multi);
        }
    }

    public static interface IOperation {
        public void execute(IProgressMonitor var1) throws FileSystemClientException;
    }

    protected static class RuleDescriptorPair {
        protected AbstractLock rule;
        protected ISharingDescriptor desc;

        protected RuleDescriptorPair() {
        }
    }

    protected static class RuleDescriptorPairForMove {
        protected AbstractLock rule;
        protected ISharingDescriptor sourceDesc;
        protected ISharingDescriptor destDesc;

        protected RuleDescriptorPairForMove() {
        }

        protected void beginBatching(IPath cfaRoot, ISharingDescriptor sourceDesc, ISharingDescriptor destDesc, SubMonitor monitor) {
            this.sourceDesc = sourceDesc;
            this.destDesc = destDesc;
            AbstractLock lock = sourceDesc == null && destDesc == null ? BatchingLock.NULL_SCHEDULING_RULE : (sourceDesc == null && destDesc != null ? new ComponentLock(cfaRoot, destDesc.getConnectionHandle(), destDesc.getComponent()) : (destDesc == null || this.sameWSC(sourceDesc, destDesc) ? new ComponentLock(cfaRoot, sourceDesc.getConnectionHandle(), sourceDesc.getComponent()) : MultiLock.combine(new ComponentLock(cfaRoot, sourceDesc.getConnectionHandle(), sourceDesc.getComponent()), new ComponentLock(cfaRoot, destDesc.getConnectionHandle(), destDesc.getComponent()))));
            this.rule = CopyFileAreaStore.beginBatching(lock, (IProgressMonitor)monitor);
        }

        protected boolean descriptorsInSameComponent(ISharingDescriptor currentSourceDesc, ISharingDescriptor currentDestDesc) {
            return this.sameWSC(this.sourceDesc, currentSourceDesc) && this.sameWSC(this.destDesc, currentDestDesc);
        }

        private boolean sameWSC(ISharingDescriptor desc1, ISharingDescriptor desc2) {
            if (desc1 == null) {
                return desc2 == null;
            }
            if (desc2 == null) {
                return false;
            }
            return desc1.getComponent().sameItemId((IItemHandle)desc2.getComponent()) && desc1.getConnectionHandle().sameItemId((IItemHandle)desc2.getConnectionHandle());
        }

        public void endBatching(SubMonitor monitor) throws FileSystemClientException {
            if (this.rule != null) {
                CopyFileAreaStore.endBatching(this.rule, (IProgressMonitor)monitor);
                this.rule = null;
            }
        }
    }
}

