/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaEvent;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CopyFileAreaNotifier
extends Job {
    private static final int SCHEDULING_DELAY = 1000;
    private final ArrayList<ICopyFileAreaEvent> collectedEvents = new ArrayList();
    private final ListenerList globalListeners = new ListenerList();
    private volatile long latestRequest;

    public CopyFileAreaNotifier() {
        super(Messages.CopyFileAreaNotifier_0);
        this.setSystem(true);
        this.setPriority(30);
    }

    public void addGlobalListener(ICopyFileAreaListener listener) {
        this.globalListeners.add((Object)listener);
    }

    public void removeGlobalListener(ICopyFileAreaListener listener) {
        this.globalListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvents(ICopyFileAreaEvent[] events) {
        if (events.length == 0) {
            return;
        }
        CopyFileAreaNotifier copyFileAreaNotifier = this;
        synchronized (copyFileAreaNotifier) {
            this.collectedEvents.addAll(Arrays.asList(events));
        }
        this.latestRequest = System.currentTimeMillis();
        this.schedule(1000L);
    }

    public void shutdown() {
        this.globalListeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor monitor) {
        ICopyFileAreaEvent[] events;
        if (System.currentTimeMillis() - this.latestRequest < 1000L) {
            this.schedule(1000L);
            return Status.CANCEL_STATUS;
        }
        CopyFileAreaNotifier copyFileAreaNotifier = this;
        synchronized (copyFileAreaNotifier) {
            events = this.collectedEvents.toArray(new ICopyFileAreaEvent[this.collectedEvents.size()]);
            this.collectedEvents.clear();
        }
        if (events.length == 0) {
            return Status.OK_STATUS;
        }
        MultiStatus result = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaNotifier_1, null);
        Object[] allListeners = this.globalListeners.getListeners();
        int i = allListeners.length;
        while (i != 0) {
            ICopyFileAreaListener listener = (ICopyFileAreaListener)allListeners[--i];
            try {
                listener.change(events);
            }
            catch (Exception e) {
                result.add(FileSystemStatus.getStatusFor(4, "com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaNotifier_2, e));
            }
        }
        ICopyFileAreaEvent[] single = new ICopyFileAreaEvent[1];
        int i2 = 0;
        while (i2 != events.length) {
            ICopyFileAreaEvent ev = events[i2];
            allListeners = ((CopyFileAreaEvent)events[i2]).getCFA().listeners.getListeners();
            single[0] = ev;
            int j = allListeners.length;
            while (j != 0) {
                ICopyFileAreaListener listener = (ICopyFileAreaListener)allListeners[--j];
                try {
                    listener.change(single);
                }
                catch (Exception e) {
                    result.add(FileSystemStatus.getStatusFor(4, "com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaNotifier_2, e));
                }
            }
            ++i2;
        }
        return result.isOK() ? Status.OK_STATUS : result;
    }
}

