/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.internal.copyfileareas.AbstractLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAListReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CFAReadLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalCFALock;
import com.ibm.team.filesystem.client.internal.copyfileareas.GlobalLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.MultiLock;
import org.eclipse.core.runtime.IPath;

public final class CFARemoveLock
extends AbstractLock {
    final IPath cfaPath;

    public CFARemoveLock(IPath path) {
        this.cfaPath = path;
    }

    public boolean contains(AbstractLock rule) {
        IPath otherPath;
        if (this == rule) {
            return true;
        }
        if (rule instanceof MultiLock) {
            MultiLock multi = (MultiLock)rule;
            AbstractLock[] children = multi.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.contains(children[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (rule instanceof CFAReadLock) {
            otherPath = ((CFAReadLock)rule).cfaPath;
        } else if (rule instanceof CFARemoveLock) {
            otherPath = ((CFARemoveLock)rule).cfaPath;
        } else if (rule instanceof ComponentLock) {
            otherPath = ((ComponentLock)rule).cfaPath;
        } else if (rule instanceof GlobalCFALock) {
            otherPath = ((GlobalCFALock)rule).cfaPath;
        } else {
            return false;
        }
        return this.cfaPath.equals((Object)otherPath);
    }

    public boolean isConflicting(AbstractLock rule) {
        IPath otherPath;
        if (rule instanceof MultiLock) {
            MultiLock multi = (MultiLock)rule;
            AbstractLock[] abstractLockArray = multi.getChildren();
            int n = abstractLockArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractLock child = abstractLockArray[n2];
                if (this.isConflicting(child)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (rule == CFAListReadLock.INSTANCE || rule == GlobalLock.INSTANCE) {
            return true;
        }
        if (rule instanceof CFAReadLock) {
            otherPath = ((CFAReadLock)rule).cfaPath;
        } else if (rule instanceof CFARemoveLock) {
            otherPath = ((CFARemoveLock)rule).cfaPath;
        } else if (rule instanceof ComponentLock) {
            otherPath = ((ComponentLock)rule).cfaPath;
        } else if (rule instanceof GlobalCFALock) {
            otherPath = ((GlobalCFALock)rule).cfaPath;
        } else {
            return false;
        }
        return this.cfaPath.equals((Object)otherPath);
    }

    public int hashCode() {
        return this.cfaPath.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CFARemoveLock)) {
            return false;
        }
        CFARemoveLock other = (CFARemoveLock)o;
        return this.cfaPath.equals((Object)other.cfaPath);
    }

    public boolean mayPromoteTo(AbstractLock rule) {
        if (rule instanceof MultiLock) {
            MultiLock multi = (MultiLock)rule;
            AbstractLock[] children = multi.getChildren();
            int i = 0;
            while (i < children.length) {
                if (!this.mayPromoteTo(children[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return this.contains(rule);
    }

    public String toString() {
        return "CFARemoveLock(" + this.cfaPath + ')';
    }
}

