/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.content;

import com.ibm.team.filesystem.client.IFileContentManager;
import com.ibm.team.filesystem.client.IFileContentManagerSession;
import com.ibm.team.filesystem.client.internal.content.AsyncFileContentManagerSession;
import com.ibm.team.filesystem.client.internal.content.SyncFileContentManagerSession;
import com.ibm.team.filesystem.common.FileLineDelimiter;
import com.ibm.team.filesystem.common.IFileContent;
import com.ibm.team.filesystem.common.IFileContentService;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.internal.FileContent;
import com.ibm.team.filesystem.common.internal.FilesystemFactory;
import com.ibm.team.filesystem.common.internal.util.FileContentProperties;
import com.ibm.team.filesystem.common.util.LineDelimiterUtil;
import com.ibm.team.filesystem.common.util.LineDelimiterVerifier;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToCRLFInputStream;
import com.ibm.team.filesystem.common.util.VerifyConvertToLFInputStream;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import com.ibm.team.scm.client.content.AbstractVersionedContentManagerInputStreamProvider;
import com.ibm.team.scm.client.content.BasicVersionedContentManager;
import com.ibm.team.scm.common.ContentHash;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IVersionedContent;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import org.apache.commons.httpclient.HttpMethod;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileContentManager
extends BasicVersionedContentManager<FileContentProperties, FileContentProperties, IFileContentManagerSession>
implements IFileContentManager {
    private static final FileLineDelimiter SERVER_PLATFORM_LINE_DELIMITER = FileLineDelimiter.LINE_DELIMITER_LF;
    private static final Method storeMethod;
    private final Object serviceDelegate = Proxy.newProxyInstance(this.getClassLoaderForProxy(IFileContentService.class), new Class[]{IFileContentService.class}, fakeInvocationHandler);

    static {
        try {
            storeMethod = IFileContentService.class.getDeclaredMethod("storeContent", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public FileContentManager(IClientLibraryContext ctx) {
        super(ctx);
    }

    protected Method getStoreMethodForStatistics(long length, ContentHash predecessorHintHash, ContentHash contentHashCode, FileContentProperties context) {
        return storeMethod;
    }

    protected Object getStoreDelegateForStatistics(long length, ContentHash predecessorHintHash, ContentHash contentHashCode, FileContentProperties context) {
        return this.serviceDelegate;
    }

    @Override
    public void retrieveContent(IFileItemHandle item, IFileContent content, OutputStream outStream, IProgressMonitor monitor) throws TeamRepositoryException {
        super.retrieveContent((IVersionableHandle)item, (IVersionedContent)content, outStream, null, monitor);
    }

    protected InputStream internalRetrieveContentStream(IVersionableHandle item, IVersionedContent content, FileContentProperties context, IProgressMonitor monitor) throws TeamRepositoryException {
        InputStream inputStream;
        block17: {
            InputStream rawIn = super.internalRetrieveContentStream(item, content, (Object)context, monitor);
            boolean success = false;
            try {
                InputStream in;
                if (context != null) {
                    FileLineDelimiter alternativeDelimiter = context.lineDelimiter;
                    if (alternativeDelimiter == FileLineDelimiter.LINE_DELIMITER_PLATFORM) {
                        alternativeDelimiter = FileLineDelimiter.getPlatformDelimiter();
                    }
                    if (alternativeDelimiter == FileLineDelimiter.LINE_DELIMITER_NONE) {
                        in = rawIn;
                    } else {
                        try {
                            in = new ReaderToInputStream((InputStreamReader)LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)rawIn, (String)context.encoding, (FileLineDelimiter)alternativeDelimiter));
                        }
                        catch (IOException e) {
                            throw new TeamRepositoryException((Object)this.teamRepository(), e.getMessage(), (Throwable)e);
                        }
                    }
                } else {
                    IFileContent fscontent = (IFileContent)content;
                    try {
                        in = this.getConversionStream(rawIn, fscontent.getCharacterEncoding(), fscontent.getLineDelimiter());
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new TeamRepositoryException((Object)this.teamRepository(), e.getMessage(), (Throwable)e);
                    }
                    catch (UnsupportedCharsetException e) {
                        throw new TeamRepositoryException((Object)this.teamRepository(), e.getMessage(), (Throwable)e);
                    }
                }
                success = true;
                inputStream = in;
                if (success) break block17;
            }
            catch (Throwable throwable) {
                if (!success) {
                    try {
                        rawIn.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                rawIn.close();
            }
            catch (IOException iOException) {}
        }
        return inputStream;
    }

    private InputStream getConversionStream(InputStream inStream, String encoding, FileLineDelimiter lineDelimiter) throws UnsupportedEncodingException {
        if (lineDelimiter == FileLineDelimiter.LINE_DELIMITER_PLATFORM && SERVER_PLATFORM_LINE_DELIMITER != FileLineDelimiter.getPlatformDelimiter()) {
            switch (FileLineDelimiter.getPlatformDelimiter()) {
                case LINE_DELIMITER_CRLF: {
                    return new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRLFInputStream(inStream, encoding));
                }
                case LINE_DELIMITER_CR: {
                    return new ReaderToInputStream((InputStreamReader)new VerifyConvertToCRInputStream(inStream, encoding));
                }
                case LINE_DELIMITER_LF: {
                    return new ReaderToInputStream((InputStreamReader)new VerifyConvertToLFInputStream(inStream, encoding));
                }
            }
            return inStream;
        }
        return inStream;
    }

    @Override
    public InputStream retrieveContentStream(IFileItemHandle item, IFileContent content, IProgressMonitor monitor) throws TeamRepositoryException {
        return super.retrieveContentStream((IVersionableHandle)item, (IVersionedContent)content, null, monitor);
    }

    @Override
    public InputStream retrieveContentStream(IFileItemHandle item, IFileContent content, String alternativeEncoding, FileLineDelimiter alternativeDelimiter, IProgressMonitor monitor) throws TeamRepositoryException {
        FileContentProperties prop = new FileContentProperties(alternativeEncoding, alternativeDelimiter);
        return super.retrieveContentStream((IVersionableHandle)item, (IVersionedContent)content, (Object)prop, monitor);
    }

    public static boolean validLineDelimiter(FileLineDelimiter lineDelimiter) {
        return lineDelimiter == FileLineDelimiter.LINE_DELIMITER_NONE || lineDelimiter == FileLineDelimiter.LINE_DELIMITER_LF || lineDelimiter == FileLineDelimiter.LINE_DELIMITER_CRLF || lineDelimiter == FileLineDelimiter.LINE_DELIMITER_CR || lineDelimiter == FileLineDelimiter.LINE_DELIMITER_PLATFORM;
    }

    private static boolean isTextType(String mediaType) {
        return mediaType != null && mediaType.trim().toLowerCase(Locale.ENGLISH).startsWith("text/");
    }

    protected InputStream wrapInputStreamForUpload(InputStream in, FileContentProperties context) throws TeamRepositoryException, IOException {
        in = super.wrapInputStreamForUpload(in, (Object)context);
        if (context.lineDelimiter != FileLineDelimiter.LINE_DELIMITER_NONE) {
            in = new LineDelimiterVerifyingStream(context, in);
        }
        return in;
    }

    private static FileLineDelimiter getTransmissionLineDelimiter(FileLineDelimiter lineDelimiter) {
        if (lineDelimiter == FileLineDelimiter.LINE_DELIMITER_PLATFORM) {
            return SERVER_PLATFORM_LINE_DELIMITER;
        }
        return lineDelimiter;
    }

    protected IVersionedContent createVersionedContent(ContentHash hash, ContentHash predecessorHintHash, long size, FileContentProperties context) {
        FileContent c = FilesystemFactory.eINSTANCE.createFileContent();
        c.setHash(hash);
        c.setPredecessorHint(predecessorHintHash);
        c.setSize(size);
        c.setCharacterEncoding(context.encoding);
        c.setLineDelimiterCount(context.getLineDelimiterCount());
        c.setLineDelimiterSetting(context.lineDelimiter.dbValue());
        return c;
    }

    @Override
    public IFileContent storeContent(String characterEncoding, FileLineDelimiter lineDelimiter, AbstractVersionedContentManagerInputStreamProvider streamProvider, ContentHash predecessorHintHash, IProgressMonitor monitor) throws TeamRepositoryException {
        if (streamProvider == null) {
            throw new IllegalArgumentException();
        }
        boolean success = false;
        FileContentProperties context = null;
        try {
            context = new FileContentProperties(characterEncoding, lineDelimiter);
            success = true;
        }
        catch (Throwable throwable) {
            if (!success) {
                try {
                    streamProvider.dispose();
                }
                catch (IOException iOException) {
                }
                catch (TeamRepositoryException teamRepositoryException) {}
            }
            throw throwable;
        }
        if (!success) {
            try {
                streamProvider.dispose();
            }
            catch (IOException iOException) {
            }
            catch (TeamRepositoryException teamRepositoryException) {}
        }
        return (IFileContent)super.storeContent(streamProvider, predecessorHintHash, (Object)context, monitor);
    }

    protected URI getStoreURI(AbstractVersionedContentManagerInputStreamProvider in, long length, ContentHash predecessorHintHash, ContentHash contentHashCode, FileContentProperties context) throws TeamRepositoryException {
        try {
            context.validateForStore();
            URI uri = new URI(this.server.getRepositoryURL());
            String queryParms = "hashcode=" + contentHashCode.toString();
            if (predecessorHintHash != null) {
                queryParms = String.valueOf(queryParms) + "&predecessorHintHash=" + predecessorHintHash.toString();
            }
            if (length > Integer.MAX_VALUE) {
                queryParms = String.valueOf(queryParms) + "&length=" + Long.toString(length);
            }
            queryParms = String.valueOf(queryParms) + "&lineDelimiter=" + FileContentManager.getTransmissionLineDelimiter(context.lineDelimiter).asQuery();
            if (context.encoding != null && context.encoding.trim().length() > 0) {
                queryParms = String.valueOf(queryParms) + "&encoding=" + context.encoding;
            }
            if (context.lineDelimiter != FileLineDelimiter.LINE_DELIMITER_NONE) {
                queryParms = String.valueOf(queryParms) + "&lineDelimiterCount=" + context.getLineDelimiterCount();
            }
            String path = String.valueOf(uri.getPath()) + "service" + "/" + IFileContentService.class.getName() + "/" + "content";
            String existingQuery = uri.getQuery();
            if (existingQuery != null && existingQuery.trim().length() != 0) {
                queryParms = String.valueOf(existingQuery.trim()) + '&' + queryParms;
            }
            uri = new URI(null, null, path, queryParms, uri.getFragment());
            return uri;
        }
        catch (URISyntaxException e1) {
            throw new TeamRepositoryException((Object)this.teamRepository(), e1.getMessage(), (Throwable)e1);
        }
    }

    protected void addServiceVersionHeaderForStore(HttpMethod method, FileContentProperties context) {
        super.addServiceVersionHeader(method, IFileContentService.class.getName());
    }

    @Override
    public ITeamRepository teamRepository() {
        return super.teamRepository();
    }

    public IFileContentManagerSession createSession(int threads, boolean allowFailures, String sessionName, long totalWork, IProgressMonitor monitor) {
        return (IFileContentManagerSession)super.createSession(threads, allowFailures, sessionName, totalWork, monitor);
    }

    @Override
    public IFileContentManagerSession createSession(String sessionName, boolean allowFailures, long totalWork, IProgressMonitor monitor) {
        return (IFileContentManagerSession)super.createSession(sessionName, allowFailures, totalWork, monitor);
    }

    protected IFileContentManagerSession createAsyncSession(int threads, boolean allowFailures, String sessionName, long totalWork, IProgressMonitor monitor) {
        return new AsyncFileContentManagerSession(threads, allowFailures, sessionName, totalWork, this, monitor);
    }

    protected IFileContentManagerSession createSyncSession(boolean allowFailures, String sessionName, long totalWork, IProgressMonitor monitor) {
        return new SyncFileContentManagerSession(sessionName, totalWork, this, monitor);
    }

    @Override
    public boolean convertDelimitersDuringRetrieval(IFileContent content) {
        return content.getLineDelimiter() == FileLineDelimiter.LINE_DELIMITER_PLATFORM && SERVER_PLATFORM_LINE_DELIMITER != FileLineDelimiter.getPlatformDelimiter();
    }

    public static void validateArgumentsForUpload(String contentType, FileContentProperties context) {
        if (FileContentManager.isTextType(contentType) && (context.encoding == null || context.encoding.trim().equals(""))) {
            throw new IllegalArgumentException("Character encoding must be supplied if media type is text");
        }
    }

    @Override
    public long getUnclaimedContentCleanupPeriod(IProgressMonitor monitor) throws TeamRepositoryException {
        return super.getCleanupPeriod(monitor);
    }

    protected static class LineDelimiterVerifyingStream
    extends InputStream {
        final LineDelimiterVerifier verifier;
        final InputStream in;
        final FileContentProperties properties;

        public LineDelimiterVerifyingStream(FileContentProperties p, InputStream is) throws IOException {
            this.properties = p;
            FileLineDelimiter lineDelimiter = FileContentManager.getTransmissionLineDelimiter(p.lineDelimiter);
            if (lineDelimiter == FileLineDelimiter.LINE_DELIMITER_LF) {
                this.verifier = new VerifyConvertToLFInputStream(is, p.encoding);
            } else if (lineDelimiter == FileLineDelimiter.LINE_DELIMITER_CRLF) {
                this.verifier = new VerifyConvertToCRLFInputStream(is, p.encoding);
            } else if (lineDelimiter == FileLineDelimiter.LINE_DELIMITER_CR) {
                this.verifier = new VerifyConvertToCRInputStream(is, p.encoding);
            } else {
                throw new IllegalArgumentException();
            }
            this.in = new ReaderToInputStream((InputStreamReader)this.verifier);
        }

        public int read() throws IOException {
            int result = this.in.read();
            if (result == -1) {
                this.properties.setLineDelimiterCount(this.verifier.getLineDelimiterCount());
            }
            return result;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.in.read(b, off, len);
            if (result == -1) {
                this.properties.setLineDelimiterCount(this.verifier.getLineDelimiterCount());
            }
            return result;
        }

        public long skip(long n) throws IOException {
            return this.in.skip(n);
        }

        public int available() throws IOException {
            return this.in.available();
        }

        public void close() throws IOException {
            this.in.close();
        }

        public void mark(int readlimit) {
            this.in.mark(readlimit);
        }

        public void reset() throws IOException {
            this.in.reset();
        }

        public boolean markSupported() {
            return this.in.markSupported();
        }
    }
}

