/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.PersistentHeapManager;
import com.ibm.team.internal.repository.rcp.dbhm.BadHeapException;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentBTreeHeap;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentDiskBackedHashMap;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Store<K, V>
extends PersistentDiskBackedHashMap<K, V> {
    private boolean doInit;
    private PersistentHeapManager mgr;

    public Store(File file, PersistentHeapManager mgr) {
        super(file);
        this.mgr = mgr;
        this.doInit = true;
        try {
            super.initFromFile(file);
        }
        catch (IOException e) {
            throw new DBHMException((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new DBHMException((Throwable)e);
        }
    }

    protected void initFromFile(File f) throws IOException {
        if (this.doInit) {
            super.initFromFile(f);
        }
    }

    protected PersistentBTreeHeap newPersistentBTreeHeap(File f) throws IOException {
        try {
            return this.mgr.getPersistentFileHeap(f);
        }
        catch (BadHeapException e) {
            throw new DBHMException((Throwable)e);
        }
    }

    public void close() throws IOException {
        boolean delete = this.isEmpty();
        super.close();
        if (delete) {
            ((PersistentHeapManager.AutoClosingPersistentFileHeap)this.heap).delete();
        }
    }
}

